/* pqueue.h -- Hybrid priority queue with some search functions
   Copyright (C) 2004 - 2005 Matas Aguirre - Gonzalo Saavedra

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

/*
 * Contributions and ideas
 *      2005 - Maximiliano Pin
 */

#ifndef PQUEUE_H
#define PQUEUE_H 1

#include <stdio.h>   /* required by stdlib.h on some systems */
#include <stdlib.h>

#define POK          0
#define PRIERR      -1
#define FULLERR     -2
#define EPTYERR     -3
#define PQERR       -4
#define NEPTYERR    -5
#define SZERR       -6
#define NFOUNDERR   -7

#define DEFAULT_SZ  127

#ifndef MAX
# define MAX(A,B) ((A) > (B) ? A : B)
#endif
#ifndef MIN
# define MIN(A,B) ((A) < (B) ? A : B)
#endif
#define PRI_EQ(A,B) ((A) == (B))
#define MAX_PRI(A,B) (MIN(A,B))
#define PRI_GREATER(A,B) ((A) < (B))

typedef long int prio_t;

/* Priority queue node */
/* Data structs added with pq_add() must have a prio_t as the first field */
typedef struct {
    prio_t pri;         /* priority */
} pq_node;

/* Priority queue struct */
typedef struct{
    pq_node ** heap;                /* heap */
    int size;                       /* heap's size */
    int csize;                      /* elements in the heap */
    int (*equals_f)(void*,void*);     /* an equals functions */
} pqueue;


extern int pq_new(pqueue *,int,int(*)(void*,void*));
extern prio_t pq_add(void *,pqueue *);
extern void * pq_min(pqueue *);
extern void * pq_del_min(pqueue *);
extern int pq_empty(pqueue *);
extern void * pq_del(prio_t, pqueue *);
extern void * pq_get(prio_t,pqueue *);
extern void * pq_del_func(void*,pqueue*);
extern void * pq_get_func(void*,pqueue*);
extern void * pq_del_ptr(void*,pqueue*);
extern pq_chpri_func(void*,prio_t,pqueue*); 
extern pq_chpri_ptr(void*,prio_t,pqueue*); 
extern int pq_delete(pqueue*);

#endif /* PQUEUE_H */
