/*
* ipv4_util.h

Copyright (C) 2008-2010 Alessandro Vesely

This file is part of Ipqbdb.

Ipqbdb is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Ipqbdb is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Ipqbdb.  If not, see <http://www.gnu.org/licenses/>.

*/

#if !defined IPV4_UTIL_H_INCLUDED
#include <stdint.h>

typedef struct ip4_range
{  // all addresses in network order
	uint32_t first;
	uint32_t last;
} ip4_range;

enum parse_ip_error
{
	parse_ip_ok = 0,
	parse_ip_invalid_too_high,
	parse_ip_invalid_too_long,
	parse_ip_invalid_separator,
	parse_ip_invalid_range,
	parse_ip_invalid_cidr
};

int parse_ip_address(char *in, ip4_range *out, char **term);
char const *parse_ip_invalid_what(int err);

#define IPV4_UTIL_H_INCLUDED
#endif
