/*
* report_error.c - separated from opendb.c on 14 feb 2011.

Copyright (C) 2008-2011 Alessandro Vesely

This file is part of Ipqbdb.

Ipqbdb is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Ipqbdb is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Ipqbdb.  If not, see <http://www.gnu.org/licenses/>.

*/
#define _GNU_SOURCE
#include <stdio.h>
#include <syslog.h>
#include <stdarg.h>

#include "report_error.h"

void report_error(app_private *ap, int pri, char const *fmt, ...)
{
	int mode = ap? ap->mode: error_report_stderr;
	va_list al;
	va_start(al, fmt);
	if (mode == error_report_stderr)
	{
		if (ap && ap->err_prefix)
			fprintf(stderr, "%s: ", ap->err_prefix);
		vfprintf(stderr, fmt, al);
	}
	else // prefix already set in openlog
		vsyslog(mode | pri, fmt, al);
	va_end(al);
}

