#! /bin/sh
#
# search the mail log for flunked passwords from known users.
# delete and report as needed

header="$(ibd-del -Lv -i 127.0.0.1 |head -3|tail -1)"

sed -rn -e '/imapd(-ssl)?: LOGIN, user/s/.*user=([^,]*), ip=\[([^]]*)\].*/\2 \1/p' \
	-e '/newmsg,id=[^,]*, auth/s/.*auth=([^:]*):[^\(]*\(.*\[([^]]*)\]\)/\2 \1/p' \
< /var/log/mail.log |sort |uniq |\
while read ip user; do
	rec=$(ibd-del --ls -i $ip)
	if [ -n "$rec" ]; then
		# $ip was caught
		# check whether it makes sense $user used it
		# if it is a good ip, remove it from block.db
		if [ -n "header" ]; then
			echo "$header"
			unset header
		fi
		echo "$rec $user"
	fi
done
