/*
* ipv4_util2.c - parse IPv4 address using inet_pton

Copyright (C) 2013 Alessandro Vesely

This file is part of Ipqbdb.

Ipqbdb is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Ipqbdb is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Ipqbdb.  If not, see <http://www.gnu.org/licenses/>.

*/

#include "ipv4_util2.h"
#include <arpa/inet.h>
#include <string.h>
#include <assert.h>

int my_inet_pton(char const *p, struct in_addr *n)
{
	unsigned char dst[sizeof(struct in6_addr)];
	int i;

	assert(p);

	if (strchr(p, ':') == NULL)
		return inet_pton(AF_INET, p, n);

	if (inet_pton(AF_INET6, p, dst) <= 0)
		return 0;

	for (i = 0; i < 10; ++i)
		if (dst[i] != 0)
			return 0;

	if (dst[10] != 0xffU || dst[11] != 0xffU)
		return 0;

	memcpy(n, dst, sizeof *n);
	return 1;
}

