/*
* percent_prob.h

Copyright (C) 2019 Alessandro Vesely

This file is part of Ipqbdb.

Ipqbdb is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Ipqbdb is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Ipqbdb.  If not, see <http://www.gnu.org/licenses/>.

*/

#if !defined LOGLINE_WRITTEN_BLOCK_H_INCLUDED

/*
This function references report_error() and ap.
Must be included after those definitions.

This is the line logging for ibd-parse -v and ibd-ban -l.
*/

static void logline_written_block(uint32_t ip_addr,
	ip_data_t *ip_data, ip_data_t *old_data, DB *db1)
{
	struct in_addr in;
	memcpy(&in, &ip_addr, sizeof in);

	char descr[IPQBDB_DESCR_MAX_LENGTH];
	get_descr(db1, ip_data->reason_id, 0, descr, sizeof descr);

	report_error(&ap, LOG_INFO,
		"%s record for %s, decay: %g, prob: %.2f%%, %s\n",
		old_data? "old": "new",
		inet_ntoa(in),
		ip_data->decay,
		percent_prob(ip_data->probability),
		descr);
}


#define LOGLINE_WRITTEN_BLOCK_H_INCLUDED
#endif
