/*
* rehabilitated_prob.h

Copyright (C) 2011-2019 Alessandro Vesely

This file is part of Ipqbdb.

Ipqbdb is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Ipqbdb is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Ipqbdb.  If not, see <http://www.gnu.org/licenses/>.

*/
#if ! defined REHABILITATED_PROB_H_INCLUDED

#include <sys/types.h>
#include <math.h>
#include "config_names.h"
#include <assert.h>

static inline unsigned int
rehabilitated_prob(unsigned int prob, time_t delta, double decay)
/*
* Return the new probability, rehabilitated according to arguments
*/
{
	assert(delta > IPQBDB_UPDATE_TICK_TIME);
	assert(decay > 0.0);

	double d = (double)prob * exp2(-(double)delta / decay);
	return isnormal(d)? (int)floor(0.5 + d): 0;
}


#define REHABILITATED_PROB_H_INCLUDED
#endif
