/*
* TESTrehabilitated_prob.c

Copyright (C) 2019 Alessandro Vesely

This file is part of Ipqbdb.

Ipqbdb is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Ipqbdb is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Ipqbdb.  If not, see <http://www.gnu.org/licenses/>.

*/

#include "config_names.h"
#include "dbstruct.h"

#include "percent_prob.h"
#include "rehabilitated_prob.h"
#include "initial_count.h"

#include <string.h>

int main(int argc, char *argv[])
{
	int count = 10, probability  = count2prob(IPQBDB_INITIAL_COUNT);
	double decay = IPQBDB_INITIAL_DECAY;
	time_t delta = IPQBDB_UPDATE_TICK_TIME + 1;

	probability += 1; // rounded

	// override
	if (argc > 1)
	{
		if (strcmp(argv[1], "-"))
			count = atoi(argv[1]);
		if (argc > 2)
		{
			if (strcmp(argv[2], "-"))
				probability = atoi(argv[2]);
			if (argc > 3)
			{
				if (strcmp(argv[3], "-"))
					decay = atof(argv[3]);
				if (argc > 4)
					delta = atoi(argv[4]);
			}
		}
	}

	printf("count = %d,  probability = %d,  decay = %g,  delta = %ld\n",
		count, probability, decay, delta);

	for (int i = 0; i < count; ++i)
	{
		unsigned int next_probability =
			rehabilitated_prob(probability, delta, decay);

		printf("%3d %10d=%6.2f%% -> %18d=%6.2f%%\n", i,
			probability, percent_prob(probability),
			next_probability, percent_prob(next_probability));
		probability = next_probability;
	}

	return 0;
}
