/*
* report_error.h


Copyright (C) 2008-2011 Alessandro Vesely

This file is part of Ipqbdb.

Ipqbdb is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Ipqbdb is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Ipqbdb.  If not, see <http://www.gnu.org/licenses/>.

*/

#if !defined REPORT_ERROR_H_INCLUDED

/*
* This is the private data available via DB_ENV app_private
*/
typedef struct app_private
{
	int mode; // report_error
	char const *err_prefix;
} app_private;

enum error_report_mode {error_report_stderr}; // or syslog facility

#if defined __GNUC__
__attribute__ ((format(printf, 3, 4)))
#endif
void report_error(app_private* ap, int priority, char const *fmt, ...);

#define REPORT_ERROR_H_INCLUDED
#endif

