/*
* initial_count.h

Copyright (C) 2011-2019 Alessandro Vesely

This file is part of Ipqbdb.

Ipqbdb is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Ipqbdb is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Ipqbdb.  If not, see <http://www.gnu.org/licenses/>.

*/

#if ! defined INITIAL_COUNT_H_INCLUDED

#include <limits.h> // CHAR_BIT
#include <stdlib.h> // RAND_MAX

//#if defined HAVE_CONFIG
#include <config.h>
//#endif


#if ! defined IPQBDB_INITIAL_COUNT
#define IPQBDB_INITIAL_COUNT 5
#endif

static inline int count2prob(unsigned initial_count)
// return a non-negative integer, 0 if count is too high
// the returned value should be always increased by one anyway, for rounding
// therefore 1 is subtracted from RAND_MAX when count=0
// note that rounding is slightly ambiguous (0.5) for count=1
{
	if (initial_count <= 0)
		return RAND_MAX - 1;
	if (initial_count < CHAR_BIT * sizeof(int))
		return RAND_MAX >> initial_count;
	return 0;
}

#if defined INITIAL_COUNT_H_BOTH || defined INITIAL_COUNT_H_ONE
static int max_initial_count(void)
{
	int initial_probability = RAND_MAX, initial_count = 0;

	while ((initial_probability >>= 1) > 0)
		++initial_count;

	return initial_count;
}
#endif

#if defined INITIAL_COUNT_H_BOTH
static int guess_initial_count(int prob, int max_count)
// max_count must have been initialized by the previous function
{
	if (prob <= 0)
		return 999;

	if (prob >= RAND_MAX)
		return 0;

	unsigned count = max_count;
	prob -= 1; // necessary to get count=1 rather than count=0
	while ((prob >>= 1) > 0)
		--count;

	return count;
}
#endif

#define INITIAL_COUNT_H_INCLUDED
#endif

