/*
 * Decompiled with CFR 0.152.
 */
package com.coyotegulch.jisp;

import com.coyotegulch.jisp.DatabaseException;
import com.coyotegulch.jisp.IndexIterator;
import com.coyotegulch.jisp.KeyNotFound;
import com.coyotegulch.jisp.KeyObject;
import com.coyotegulch.jisp.ObjectDatabaseFile;
import com.coyotegulch.jisp.ObjectIndex;
import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;

public class IndexedObjectDatabase
extends ObjectDatabaseFile {
    private Vector m_indexes = new Vector();
    private IndexedObjectDatabase m_this = this;
    private static final DatabaseException err_no_indexes = new DatabaseException("no indexes associated with this database");
    private static final DatabaseException err_invalid_index = new DatabaseException("given index is not associated with this database");

    public IndexedObjectDatabase(String string, boolean bl) throws IOException {
        super(string, bl);
    }

    public void attachIndex(ObjectIndex objectIndex) {
        this.m_indexes.addElement(objectIndex);
    }

    public void removeIndex(ObjectIndex objectIndex) {
        this.m_indexes.removeElement(objectIndex);
    }

    public void insert(KeyObject[] keyObjectArray, Serializable serializable) throws IOException, ClassNotFoundException {
        this.validateOperation(null);
        long l = this.writeObject(serializable);
        int n = 0;
        while (n < this.m_indexes.size()) {
            ObjectIndex objectIndex = (ObjectIndex)this.m_indexes.elementAt(n);
            objectIndex.insertKey(keyObjectArray[n], l);
            ++n;
        }
    }

    public void write(KeyObject[] keyObjectArray, Serializable serializable) throws IOException, ClassNotFoundException {
        this.validateOperation(null);
        try {
            ObjectIndex objectIndex = (ObjectIndex)this.m_indexes.elementAt(0);
            long l = objectIndex.findKey(keyObjectArray[0]);
            this.seek(l);
            this.delete();
        }
        catch (KeyNotFound keyNotFound) {
            // empty catch block
        }
        long l = this.writeObject(serializable);
        int n = 0;
        while (n < this.m_indexes.size()) {
            ObjectIndex objectIndex = (ObjectIndex)this.m_indexes.elementAt(n);
            objectIndex.insertKey(keyObjectArray[n], l);
            ++n;
        }
    }

    public Object read(KeyObject keyObject, ObjectIndex objectIndex) throws IOException, ClassNotFoundException {
        long l;
        this.validateOperation(objectIndex);
        try {
            l = objectIndex.findKey(keyObject);
        }
        catch (KeyNotFound keyNotFound) {
            return null;
        }
        try {
            this.seek(l);
            return this.readObject();
        }
        catch (Exception exception) {
            System.err.println("key = " + keyObject + ", pos = " + l);
            exception.printStackTrace();
            return null;
        }
    }

    public Object read(IndexIterator indexIterator) throws IOException, ClassNotFoundException {
        if (indexIterator.isValid()) {
            try {
                this.seek(indexIterator.getRecPtr());
                return this.readObject();
            }
            catch (Exception exception) {
                System.err.println("key = " + indexIterator.getKey() + ", recptr = " + indexIterator.getRecPtr());
                exception.printStackTrace();
            }
        }
        return null;
    }

    public void remove(KeyObject[] keyObjectArray) throws IOException, DatabaseException, ClassNotFoundException {
        this.validateOperation(null);
        ObjectIndex objectIndex = (ObjectIndex)this.m_indexes.elementAt(0);
        long l = objectIndex.findKey(keyObjectArray[0]);
        this.seek(l);
        this.delete();
        int n = 0;
        while (n < this.m_indexes.size()) {
            objectIndex = (ObjectIndex)this.m_indexes.elementAt(n);
            objectIndex.removeKey(keyObjectArray[n]);
            ++n;
        }
    }

    private void validateOperation(ObjectIndex objectIndex) throws DatabaseException, IOException, ClassNotFoundException {
        if (this.m_indexes.size() <= 0) {
            throw err_no_indexes;
        }
        if (objectIndex != null && !this.m_indexes.contains(objectIndex)) {
            throw err_invalid_index;
        }
    }
}

