/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.LengthBase;
import org.apache.fop.datatypes.LengthRange;
import org.apache.fop.datatypes.PercentBase;
import org.apache.fop.fo.EnumProperty;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.LengthProperty;
import org.apache.fop.fo.LengthRangeProperty;
import org.apache.fop.fo.Property;
import org.apache.fop.fo.PropertyList;

public class BlockProgressionDimensionMaker
extends LengthRangeProperty.Maker {
    private static final Property.Maker s_MinimumMaker = new SP_MinimumMaker("block-progression-dimension.minimum");
    private static final Property.Maker s_OptimumMaker = new SP_OptimumMaker("block-progression-dimension.optimum");
    private static final Property.Maker s_MaximumMaker = new SP_MaximumMaker("block-progression-dimension.maximum");
    Property.Maker m_shorthandMaker = this.getSubpropMaker("minimum");
    private Property m_defaultProp = null;

    public static Property.Maker maker(String propName) {
        return new BlockProgressionDimensionMaker(propName);
    }

    protected BlockProgressionDimensionMaker(String name) {
        super(name);
    }

    public Property checkEnumValues(String value) {
        return this.m_shorthandMaker.checkEnumValues(value);
    }

    protected boolean isCompoundMaker() {
        return true;
    }

    protected Property.Maker getSubpropMaker(String subprop) {
        if (subprop.equals("minimum")) {
            return s_MinimumMaker;
        }
        if (subprop.equals("optimum")) {
            return s_OptimumMaker;
        }
        if (subprop.equals("maximum")) {
            return s_MaximumMaker;
        }
        return super.getSubpropMaker(subprop);
    }

    protected Property setSubprop(Property baseProp, String subpropName, Property subProp) {
        LengthRange val = baseProp.getLengthRange();
        val.setComponent(subpropName, subProp, false);
        return baseProp;
    }

    public Property getSubpropValue(Property baseProp, String subpropName) {
        LengthRange val = baseProp.getLengthRange();
        return val.getComponent(subpropName);
    }

    public Property make(PropertyList propertyList) throws FOPException {
        if (this.m_defaultProp == null) {
            this.m_defaultProp = this.makeCompound(propertyList, propertyList.getParentFObj());
        }
        return this.m_defaultProp;
    }

    protected Property makeCompound(PropertyList pList, FObj fo) throws FOPException {
        LengthRange p = new LengthRange();
        Property subProp = this.getSubpropMaker("minimum").make(pList, this.getDefaultForMinimum(), fo);
        p.setComponent("minimum", subProp, true);
        subProp = this.getSubpropMaker("optimum").make(pList, this.getDefaultForOptimum(), fo);
        p.setComponent("optimum", subProp, true);
        subProp = this.getSubpropMaker("maximum").make(pList, this.getDefaultForMaximum(), fo);
        p.setComponent("maximum", subProp, true);
        return new LengthRangeProperty(p);
    }

    protected String getDefaultForMinimum() {
        return "auto";
    }

    protected String getDefaultForOptimum() {
        return "auto";
    }

    protected String getDefaultForMaximum() {
        return "auto";
    }

    public Property convertProperty(Property p, PropertyList pList, FObj fo) throws FOPException {
        if (p instanceof LengthRangeProperty) {
            return p;
        }
        if (!(p instanceof EnumProperty)) {
            p = this.m_shorthandMaker.convertProperty(p, pList, fo);
        }
        if (p != null) {
            Property prop = this.makeCompound(pList, fo);
            LengthRange pval = prop.getLengthRange();
            pval.setComponent("minimum", p, false);
            pval.setComponent("optimum", p, false);
            pval.setComponent("maximum", p, false);
            return prop;
        }
        return null;
    }

    public boolean isInherited() {
        return false;
    }

    public boolean isCorrespondingForced(PropertyList propertyList) {
        StringBuffer sbExpr = new StringBuffer();
        sbExpr.setLength(0);
        sbExpr.append(propertyList.wmRelToAbs(4));
        if (propertyList.getExplicit(sbExpr.toString()) != null) {
            return true;
        }
        sbExpr.setLength(0);
        sbExpr.append("min-");
        sbExpr.append(propertyList.wmRelToAbs(4));
        if (propertyList.getExplicit(sbExpr.toString()) != null) {
            return true;
        }
        sbExpr.setLength(0);
        sbExpr.append("max-");
        sbExpr.append(propertyList.wmRelToAbs(4));
        return propertyList.getExplicit(sbExpr.toString()) != null;
    }

    public Property compute(PropertyList propertyList) throws FOPException {
        FObj parentFO = propertyList.getParentFObj();
        StringBuffer sbExpr = new StringBuffer();
        Property p = null;
        sbExpr.append(propertyList.wmRelToAbs(4));
        p = propertyList.getExplicitOrShorthand(sbExpr.toString());
        p = p != null ? this.convertProperty(p, propertyList, parentFO) : this.makeCompound(propertyList, parentFO);
        sbExpr.setLength(0);
        sbExpr.append("min-");
        sbExpr.append(propertyList.wmRelToAbs(4));
        Property subprop = propertyList.getExplicitOrShorthand(sbExpr.toString());
        if (subprop != null) {
            this.setSubprop(p, "minimum", subprop);
        }
        sbExpr.setLength(0);
        sbExpr.append("max-");
        sbExpr.append(propertyList.wmRelToAbs(4));
        subprop = propertyList.getExplicitOrShorthand(sbExpr.toString());
        if (subprop != null) {
            this.setSubprop(p, "maximum", subprop);
        }
        return p;
    }

    private static class SP_MaximumMaker
    extends LengthProperty.Maker {
        SP_MaximumMaker(String sPropName) {
            super(sPropName);
        }

        protected boolean isAutoLengthAllowed() {
            return true;
        }

        public PercentBase getPercentBase(FObj fo, PropertyList propertyList) {
            return new LengthBase(fo, propertyList, 3);
        }
    }

    private static class SP_OptimumMaker
    extends LengthProperty.Maker {
        SP_OptimumMaker(String sPropName) {
            super(sPropName);
        }

        protected boolean isAutoLengthAllowed() {
            return true;
        }

        public PercentBase getPercentBase(FObj fo, PropertyList propertyList) {
            return new LengthBase(fo, propertyList, 3);
        }
    }

    private static class SP_MinimumMaker
    extends LengthProperty.Maker {
        SP_MinimumMaker(String sPropName) {
            super(sPropName);
        }

        protected boolean isAutoLengthAllowed() {
            return true;
        }

        public PercentBase getPercentBase(FObj fo, PropertyList propertyList) {
            return new LengthBase(fo, propertyList, 3);
        }
    }
}

