/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import org.eclipse.jdt.internal.compiler.ast.NumberLiteral;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class DoubleLiteral
extends NumberLiteral {
    double value;

    public DoubleLiteral(char[] token, int s, int e) {
        super(token, s, e);
    }

    public void computeConstant() {
        Double computedValue;
        try {
            computedValue = Double.valueOf(String.valueOf(this.source));
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        if (computedValue > Double.MAX_VALUE) {
            return;
        }
        if (computedValue < Double.MIN_VALUE) {
            int i = 0;
            block6: while (i < this.source.length) {
                switch (this.source[i]) {
                    case '.': 
                    case '0': 
                    case 'D': 
                    case 'd': {
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        break block6;
                    }
                    default: {
                        return;
                    }
                }
                ++i;
            }
        }
        this.value = computedValue;
        this.constant = Constant.fromValue(this.value);
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int pc = codeStream.position;
        if (valueRequired) {
            if (this.implicitConversion >> 4 == 8) {
                codeStream.generateInlinedValue(this.value);
            } else {
                codeStream.generateConstant(this.constant, this.implicitConversion);
            }
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public TypeBinding literalType(BlockScope scope) {
        return BaseTypes.DoubleBinding;
    }

    public void traverse(IAbstractSyntaxTreeVisitor visitor, BlockScope blockScope) {
        visitor.visit(this, blockScope);
        visitor.endVisit(this, blockScope);
    }
}

