/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.BinaryExpression;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.CompoundAssignment;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.IntLiteral;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.OperatorIds;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;

public class SingleNameReference
extends NameReference
implements OperatorIds {
    public char[] token;
    public MethodBinding[] syntheticAccessors;
    public static final int READ = 0;
    public static final int WRITE = 1;

    public SingleNameReference(char[] source, long pos) {
        this.token = source;
        this.sourceStart = (int)(pos >>> 32);
        this.sourceEnd = (int)pos;
    }

    public FlowInfo analyseAssignment(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo, Assignment assignment, boolean isCompound) {
        LocalVariableBinding localBinding;
        FieldBinding fieldBinding;
        if (isCompound) {
            switch (this.bits & 7) {
                case 1: {
                    fieldBinding = (FieldBinding)this.binding;
                    if (fieldBinding.isBlankFinal() && currentScope.allowBlankFinalFieldAssignment(fieldBinding) && !flowInfo.isDefinitelyAssigned(fieldBinding)) {
                        currentScope.problemReporter().uninitializedBlankFinalField(fieldBinding, this);
                    }
                    this.manageSyntheticReadAccessIfNecessary(currentScope);
                    break;
                }
                case 2: {
                    localBinding = (LocalVariableBinding)this.binding;
                    if (!flowInfo.isDefinitelyAssigned(localBinding)) {
                        currentScope.problemReporter().uninitializedLocalVariable(localBinding, this);
                    }
                    if (flowInfo.isReachable()) {
                        localBinding.useFlag = 1;
                        break;
                    }
                    if (localBinding.useFlag != 0) break;
                    localBinding.useFlag = 2;
                }
            }
        }
        if (assignment.expression != null) {
            flowInfo = assignment.expression.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
        }
        switch (this.bits & 7) {
            case 1: {
                this.manageSyntheticWriteAccessIfNecessary(currentScope);
                fieldBinding = (FieldBinding)this.binding;
                if (!fieldBinding.isFinal()) break;
                if (!isCompound && fieldBinding.isBlankFinal() && currentScope.allowBlankFinalFieldAssignment(fieldBinding)) {
                    if (flowInfo.isPotentiallyAssigned(fieldBinding)) {
                        currentScope.problemReporter().duplicateInitializationOfBlankFinalField(fieldBinding, this);
                    } else {
                        flowContext.recordSettingFinal(fieldBinding, this);
                    }
                    flowInfo.markAsDefinitelyAssigned(fieldBinding);
                    break;
                }
                currentScope.problemReporter().cannotAssignToFinalField(fieldBinding, this);
                break;
            }
            case 2: {
                localBinding = (LocalVariableBinding)this.binding;
                this.bits = !flowInfo.isDefinitelyAssigned(localBinding) ? (this.bits |= 8) : (this.bits &= 0xFFFFFFF7);
                if (localBinding.isFinal()) {
                    if ((this.bits & 0x1FE0) == 0) {
                        if (isCompound || !localBinding.isBlankFinal()) {
                            currentScope.problemReporter().cannotAssignToFinalLocal(localBinding, this);
                        } else if (flowInfo.isPotentiallyAssigned(localBinding)) {
                            currentScope.problemReporter().duplicateInitializationOfFinalLocal(localBinding, this);
                        } else {
                            flowContext.recordSettingFinal(localBinding, this);
                        }
                    } else {
                        currentScope.problemReporter().cannotAssignToFinalOuterLocal(localBinding, this);
                    }
                }
                flowInfo.markAsDefinitelyAssigned(localBinding);
            }
        }
        this.manageEnclosingInstanceAccessIfNecessary(currentScope);
        return flowInfo;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        return this.analyseCode(currentScope, flowContext, flowInfo, true);
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo, boolean valueRequired) {
        switch (this.bits & 7) {
            case 1: {
                FieldBinding fieldBinding;
                if (valueRequired) {
                    this.manageSyntheticReadAccessIfNecessary(currentScope);
                }
                if (!(fieldBinding = (FieldBinding)this.binding).isBlankFinal() || !currentScope.allowBlankFinalFieldAssignment(fieldBinding) || flowInfo.isDefinitelyAssigned(fieldBinding)) break;
                currentScope.problemReporter().uninitializedBlankFinalField(fieldBinding, this);
                break;
            }
            case 2: {
                LocalVariableBinding localBinding = (LocalVariableBinding)this.binding;
                if (!flowInfo.isDefinitelyAssigned(localBinding)) {
                    currentScope.problemReporter().uninitializedLocalVariable(localBinding, this);
                }
                if (flowInfo.isReachable()) {
                    localBinding.useFlag = 1;
                    break;
                }
                if (localBinding.useFlag != 0) break;
                localBinding.useFlag = 2;
            }
        }
        if (valueRequired) {
            this.manageEnclosingInstanceAccessIfNecessary(currentScope);
        }
        return flowInfo;
    }

    public TypeBinding checkFieldAccess(BlockScope scope) {
        FieldBinding fieldBinding = (FieldBinding)this.binding;
        this.bits &= 0xFFFFFFF8;
        this.bits |= 1;
        if (!((FieldBinding)this.binding).isStatic() && scope.methodScope().isStatic) {
            scope.problemReporter().staticFieldAccessToNonStaticVariable(this, fieldBinding);
            this.constant = AstNode.NotAConstant;
            return fieldBinding.type;
        }
        this.constant = FieldReference.getConstantFor(fieldBinding, this, true, scope);
        if (this.isFieldUseDeprecated(fieldBinding, scope)) {
            scope.problemReporter().deprecatedField(fieldBinding, this);
        }
        MethodScope ms = scope.methodScope();
        if ((this.bits & 0x2000) == 0 && ms.enclosingSourceType() == fieldBinding.declaringClass && ms.fieldDeclarationIndex != -1 && fieldBinding.id >= ms.fieldDeclarationIndex && (!fieldBinding.isStatic() || ms.isStatic)) {
            scope.problemReporter().forwardReference(this, 0, scope.enclosingSourceType());
        }
        return fieldBinding.type;
    }

    public void generateAssignment(BlockScope currentScope, CodeStream codeStream, Assignment assignment, boolean valueRequired) {
        if (assignment.expression.isCompactableOperation()) {
            SingleNameReference variableReference;
            BinaryExpression operation = (BinaryExpression)assignment.expression;
            if (operation.left instanceof SingleNameReference) {
                variableReference = (SingleNameReference)operation.left;
                if (variableReference.binding == this.binding) {
                    variableReference.generateCompoundAssignment(currentScope, codeStream, this.syntheticAccessors == null ? null : this.syntheticAccessors[1], operation.right, (operation.bits & 0xFC0) >> 6, operation.left.implicitConversion, valueRequired);
                    return;
                }
            }
            int operator = (operation.bits & 0xFC0) >> 6;
            if (operation.right instanceof SingleNameReference && (operator == 14 || operator == 15)) {
                variableReference = (SingleNameReference)operation.right;
                if (variableReference.binding == this.binding && operation.left.constant != AstNode.NotAConstant && operation.left.implicitConversion >> 4 != 11 && operation.right.implicitConversion >> 4 != 11) {
                    variableReference.generateCompoundAssignment(currentScope, codeStream, this.syntheticAccessors == null ? null : this.syntheticAccessors[1], operation.left, operator, operation.right.implicitConversion, valueRequired);
                    return;
                }
            }
        }
        switch (this.bits & 7) {
            case 1: {
                FieldBinding fieldBinding = (FieldBinding)this.codegenBinding;
                if (!fieldBinding.isStatic()) {
                    if ((this.bits & 0x1FE0) != 0) {
                        ReferenceBinding targetType = currentScope.enclosingSourceType().enclosingTypeAt((this.bits & 0x1FE0) >> 5);
                        Object[] emulationPath = currentScope.getEmulationPath(targetType, true, false);
                        codeStream.generateOuterAccess(emulationPath, this, targetType, currentScope);
                    } else {
                        this.generateReceiver(codeStream);
                    }
                }
                assignment.expression.generateCode(currentScope, codeStream, true);
                this.fieldStore(codeStream, fieldBinding, this.syntheticAccessors == null ? null : this.syntheticAccessors[1], valueRequired);
                if (valueRequired) {
                    codeStream.generateImplicitConversion(assignment.implicitConversion);
                }
                return;
            }
            case 2: {
                LocalVariableBinding localBinding = (LocalVariableBinding)this.codegenBinding;
                if (localBinding.resolvedPosition == -1) {
                    if (assignment.expression.constant != AstNode.NotAConstant) {
                        if (valueRequired) {
                            codeStream.generateConstant(assignment.expression.constant, assignment.implicitConversion);
                        }
                    } else {
                        assignment.expression.generateCode(currentScope, codeStream, true);
                        if (valueRequired) {
                            codeStream.generateImplicitConversion(assignment.implicitConversion);
                        } else if (localBinding.type == BaseTypes.LongBinding || localBinding.type == BaseTypes.DoubleBinding) {
                            codeStream.pop2();
                        } else {
                            codeStream.pop();
                        }
                    }
                    return;
                }
                assignment.expression.generateCode(currentScope, codeStream, true);
                if (localBinding.type.isArrayType() && (assignment.expression.resolvedType == BaseTypes.NullBinding || assignment.expression instanceof CastExpression && ((CastExpression)assignment.expression).innermostCastedExpression().resolvedType == BaseTypes.NullBinding)) {
                    codeStream.checkcast(localBinding.type);
                }
                codeStream.store(localBinding, valueRequired);
                if ((this.bits & 8) != 0) {
                    localBinding.recordInitializationStartPC(codeStream.position);
                }
                if (!valueRequired) break;
                codeStream.generateImplicitConversion(assignment.implicitConversion);
            }
        }
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int pc = codeStream.position;
        if (this.constant != AstNode.NotAConstant) {
            if (valueRequired) {
                codeStream.generateConstant(this.constant, this.implicitConversion);
            }
        } else {
            switch (this.bits & 7) {
                case 1: {
                    if (!valueRequired) break;
                    FieldBinding fieldBinding = (FieldBinding)this.codegenBinding;
                    if (fieldBinding.constant == AstNode.NotAConstant) {
                        boolean isStatic = fieldBinding.isStatic();
                        if (!isStatic) {
                            if ((this.bits & 0x1FE0) != 0) {
                                ReferenceBinding targetType = currentScope.enclosingSourceType().enclosingTypeAt((this.bits & 0x1FE0) >> 5);
                                Object[] emulationPath = currentScope.getEmulationPath(targetType, true, false);
                                codeStream.generateOuterAccess(emulationPath, this, targetType, currentScope);
                            } else {
                                this.generateReceiver(codeStream);
                            }
                        }
                        if (this.syntheticAccessors == null || this.syntheticAccessors[0] == null) {
                            if (isStatic) {
                                codeStream.getstatic(fieldBinding);
                            } else {
                                codeStream.getfield(fieldBinding);
                            }
                        } else {
                            codeStream.invokestatic(this.syntheticAccessors[0]);
                        }
                        codeStream.generateImplicitConversion(this.implicitConversion);
                        break;
                    }
                    codeStream.generateConstant(fieldBinding.constant, this.implicitConversion);
                    break;
                }
                case 2: {
                    LocalVariableBinding localBinding = (LocalVariableBinding)this.codegenBinding;
                    if (!valueRequired) break;
                    if ((this.bits & 0x1FE0) != 0) {
                        Object[] path = currentScope.getEmulationPath(localBinding);
                        codeStream.generateOuterAccess(path, this, localBinding, currentScope);
                    } else {
                        codeStream.load(localBinding);
                    }
                    codeStream.generateImplicitConversion(this.implicitConversion);
                }
            }
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public void generateCompoundAssignment(BlockScope currentScope, CodeStream codeStream, Expression expression, int operator, int assignmentImplicitConversion, boolean valueRequired) {
        this.generateCompoundAssignment(currentScope, codeStream, this.syntheticAccessors == null ? null : this.syntheticAccessors[1], expression, operator, assignmentImplicitConversion, valueRequired);
    }

    public void generateCompoundAssignment(BlockScope currentScope, CodeStream codeStream, MethodBinding writeAccessor, Expression expression, int operator, int assignmentImplicitConversion, boolean valueRequired) {
        LocalVariableBinding localBinding;
        switch (this.bits & 7) {
            case 1: {
                FieldBinding fieldBinding = (FieldBinding)this.codegenBinding;
                if (fieldBinding.isStatic()) {
                    if (this.syntheticAccessors == null || this.syntheticAccessors[0] == null) {
                        codeStream.getstatic(fieldBinding);
                        break;
                    }
                    codeStream.invokestatic(this.syntheticAccessors[0]);
                    break;
                }
                if ((this.bits & 0x1FE0) != 0) {
                    ReferenceBinding targetType = currentScope.enclosingSourceType().enclosingTypeAt((this.bits & 0x1FE0) >> 5);
                    Object[] emulationPath = currentScope.getEmulationPath(targetType, true, false);
                    codeStream.generateOuterAccess(emulationPath, this, targetType, currentScope);
                } else {
                    codeStream.aload_0();
                }
                codeStream.dup();
                if (this.syntheticAccessors == null || this.syntheticAccessors[0] == null) {
                    codeStream.getfield(fieldBinding);
                    break;
                }
                codeStream.invokestatic(this.syntheticAccessors[0]);
                break;
            }
            case 2: {
                localBinding = (LocalVariableBinding)this.codegenBinding;
                switch (localBinding.type.id) {
                    case 11: {
                        codeStream.generateStringAppend(currentScope, this, expression);
                        if (valueRequired) {
                            codeStream.dup();
                        }
                        codeStream.store(localBinding, false);
                        return;
                    }
                    case 10: {
                        int increment;
                        Constant assignConstant = expression.constant;
                        if (assignConstant == AstNode.NotAConstant || assignConstant.typeID() == 9 || assignConstant.typeID() == 8 || (increment = assignConstant.intValue()) != (short)increment) break;
                        switch (operator) {
                            case 14: {
                                codeStream.iinc(localBinding.resolvedPosition, increment);
                                if (valueRequired) {
                                    codeStream.load(localBinding);
                                }
                                return;
                            }
                            case 13: {
                                codeStream.iinc(localBinding.resolvedPosition, -increment);
                                if (valueRequired) {
                                    codeStream.load(localBinding);
                                }
                                return;
                            }
                        }
                    }
                }
                codeStream.load(localBinding);
            }
        }
        int operationTypeID = this.implicitConversion >> 4;
        if (operationTypeID == 11 || operationTypeID == 1) {
            codeStream.generateStringAppend(currentScope, null, expression);
        } else {
            codeStream.generateImplicitConversion(this.implicitConversion);
            if (expression == IntLiteral.One) {
                codeStream.generateConstant(expression.constant, this.implicitConversion);
            } else {
                expression.generateCode(currentScope, codeStream, true);
            }
            codeStream.sendOperator(operator, operationTypeID);
            codeStream.generateImplicitConversion(assignmentImplicitConversion);
        }
        switch (this.bits & 7) {
            case 1: {
                this.fieldStore(codeStream, (FieldBinding)this.codegenBinding, writeAccessor, valueRequired);
                return;
            }
            case 2: {
                localBinding = (LocalVariableBinding)this.codegenBinding;
                if (valueRequired) {
                    if (localBinding.type == BaseTypes.LongBinding || localBinding.type == BaseTypes.DoubleBinding) {
                        codeStream.dup2();
                    } else {
                        codeStream.dup();
                    }
                }
                codeStream.store(localBinding, false);
            }
        }
    }

    public void generatePostIncrement(BlockScope currentScope, CodeStream codeStream, CompoundAssignment postIncrement, boolean valueRequired) {
        switch (this.bits & 7) {
            case 1: {
                FieldBinding fieldBinding = (FieldBinding)this.codegenBinding;
                if (fieldBinding.isStatic()) {
                    if (this.syntheticAccessors == null || this.syntheticAccessors[0] == null) {
                        codeStream.getstatic(fieldBinding);
                    } else {
                        codeStream.invokestatic(this.syntheticAccessors[0]);
                    }
                } else {
                    if ((this.bits & 0x1FE0) != 0) {
                        ReferenceBinding targetType = currentScope.enclosingSourceType().enclosingTypeAt((this.bits & 0x1FE0) >> 5);
                        Object[] emulationPath = currentScope.getEmulationPath(targetType, true, false);
                        codeStream.generateOuterAccess(emulationPath, this, targetType, currentScope);
                    } else {
                        codeStream.aload_0();
                    }
                    codeStream.dup();
                    if (this.syntheticAccessors == null || this.syntheticAccessors[0] == null) {
                        codeStream.getfield(fieldBinding);
                    } else {
                        codeStream.invokestatic(this.syntheticAccessors[0]);
                    }
                }
                if (valueRequired) {
                    if (fieldBinding.isStatic()) {
                        if (fieldBinding.type == BaseTypes.LongBinding || fieldBinding.type == BaseTypes.DoubleBinding) {
                            codeStream.dup2();
                        } else {
                            codeStream.dup();
                        }
                    } else if (fieldBinding.type == BaseTypes.LongBinding || fieldBinding.type == BaseTypes.DoubleBinding) {
                        codeStream.dup2_x1();
                    } else {
                        codeStream.dup_x1();
                    }
                }
                codeStream.generateConstant(postIncrement.expression.constant, this.implicitConversion);
                codeStream.sendOperator(postIncrement.operator, fieldBinding.type.id);
                codeStream.generateImplicitConversion(postIncrement.assignmentImplicitConversion);
                this.fieldStore(codeStream, fieldBinding, this.syntheticAccessors == null ? null : this.syntheticAccessors[1], false);
                return;
            }
            case 2: {
                LocalVariableBinding localBinding = (LocalVariableBinding)this.codegenBinding;
                if (localBinding.type == BaseTypes.IntBinding) {
                    if (valueRequired) {
                        codeStream.load(localBinding);
                    }
                    if (postIncrement.operator == 14) {
                        codeStream.iinc(localBinding.resolvedPosition, 1);
                        break;
                    }
                    codeStream.iinc(localBinding.resolvedPosition, -1);
                    break;
                }
                codeStream.load(localBinding);
                if (valueRequired) {
                    if (localBinding.type == BaseTypes.LongBinding || localBinding.type == BaseTypes.DoubleBinding) {
                        codeStream.dup2();
                    } else {
                        codeStream.dup();
                    }
                }
                codeStream.generateConstant(postIncrement.expression.constant, this.implicitConversion);
                codeStream.sendOperator(postIncrement.operator, localBinding.type.id);
                codeStream.generateImplicitConversion(postIncrement.assignmentImplicitConversion);
                codeStream.store(localBinding, false);
            }
        }
    }

    public void generateReceiver(CodeStream codeStream) {
        codeStream.aload_0();
    }

    public void manageEnclosingInstanceAccessIfNecessary(BlockScope currentScope) {
        if ((this.bits & 0x1FE0) == 0 || this.constant != AstNode.NotAConstant) {
            return;
        }
        if ((this.bits & 7) == 2) {
            currentScope.emulateOuterAccess((LocalVariableBinding)this.binding);
        }
    }

    public void manageSyntheticReadAccessIfNecessary(BlockScope currentScope) {
        if (this.constant != AstNode.NotAConstant) {
            return;
        }
        if ((this.bits & 1) != 0) {
            FieldBinding fieldBinding = (FieldBinding)this.binding;
            if ((this.bits & 0x1FE0) != 0 && (fieldBinding.isPrivate() || fieldBinding.isProtected() && fieldBinding.declaringClass.getPackage() != currentScope.enclosingSourceType().getPackage())) {
                if (this.syntheticAccessors == null) {
                    this.syntheticAccessors = new MethodBinding[2];
                }
                this.syntheticAccessors[0] = ((SourceTypeBinding)currentScope.enclosingSourceType().enclosingTypeAt((this.bits & 0x1FE0) >> 5)).addSyntheticMethod(fieldBinding, true);
                currentScope.problemReporter().needToEmulateFieldReadAccess(fieldBinding, this);
                return;
            }
            if (!(fieldBinding.declaringClass == this.actualReceiverType || this.actualReceiverType.isArrayType() || fieldBinding.declaringClass == null || fieldBinding.constant != AstNode.NotAConstant || (currentScope.environment().options.targetJDK < 1 || fieldBinding.isStatic() || fieldBinding.declaringClass.id == 1) && fieldBinding.declaringClass.canBeSeenBy(currentScope))) {
                this.codegenBinding = currentScope.enclosingSourceType().getUpdatedFieldBinding(fieldBinding, (ReferenceBinding)this.actualReceiverType);
            }
        }
    }

    public void manageSyntheticWriteAccessIfNecessary(BlockScope currentScope) {
        if ((this.bits & 1) != 0) {
            FieldBinding fieldBinding = (FieldBinding)this.binding;
            if ((this.bits & 0x1FE0) != 0 && (fieldBinding.isPrivate() || fieldBinding.isProtected() && fieldBinding.declaringClass.getPackage() != currentScope.enclosingSourceType().getPackage())) {
                if (this.syntheticAccessors == null) {
                    this.syntheticAccessors = new MethodBinding[2];
                }
                this.syntheticAccessors[1] = ((SourceTypeBinding)currentScope.enclosingSourceType().enclosingTypeAt((this.bits & 0x1FE0) >> 5)).addSyntheticMethod(fieldBinding, false);
                currentScope.problemReporter().needToEmulateFieldWriteAccess(fieldBinding, this);
                return;
            }
            if (!(fieldBinding.declaringClass == this.actualReceiverType || this.actualReceiverType.isArrayType() || fieldBinding.declaringClass == null || fieldBinding.constant != AstNode.NotAConstant || (currentScope.environment().options.targetJDK < 1 || fieldBinding.isStatic() || fieldBinding.declaringClass.id == 1) && fieldBinding.declaringClass.canBeSeenBy(currentScope))) {
                this.codegenBinding = currentScope.enclosingSourceType().getUpdatedFieldBinding(fieldBinding, (ReferenceBinding)this.actualReceiverType);
            }
        }
    }

    public TypeBinding reportError(BlockScope scope) {
        this.constant = Constant.NotAConstant;
        if (this.binding instanceof ProblemFieldBinding) {
            scope.problemReporter().invalidField(this, (FieldBinding)this.binding);
        } else if (this.binding instanceof ProblemReferenceBinding) {
            scope.problemReporter().invalidType(this, (TypeBinding)this.binding);
        } else {
            scope.problemReporter().unresolvableReference(this, this.binding);
        }
        return null;
    }

    public TypeBinding resolveType(BlockScope scope) {
        this.actualReceiverType = this.receiverType = scope.enclosingSourceType();
        this.codegenBinding = this.binding = scope.getBinding(this.token, this.bits & 7, (InvocationSite)this);
        if (this.binding.isValidBinding()) {
            switch (this.bits & 7) {
                case 3: 
                case 7: {
                    if (this.binding instanceof VariableBinding) {
                        VariableBinding variable = (VariableBinding)this.binding;
                        if (this.binding instanceof LocalVariableBinding) {
                            this.bits &= 0xFFFFFFF8;
                            this.bits |= 2;
                            this.constant = (this.bits & 0x2000) == 0 ? variable.constant : AstNode.NotAConstant;
                            if (!variable.isFinal() && (this.bits & 0x1FE0) != 0) {
                                scope.problemReporter().cannotReferToNonFinalOuterLocal((LocalVariableBinding)variable, this);
                            }
                            this.resolvedType = variable.type;
                            return this.resolvedType;
                        }
                        this.resolvedType = this.checkFieldAccess(scope);
                        return this.resolvedType;
                    }
                    this.bits &= 0xFFFFFFF8;
                    this.bits |= 4;
                }
                case 4: {
                    this.constant = Constant.NotAConstant;
                    if (this.isTypeUseDeprecated((TypeBinding)this.binding, scope)) {
                        scope.problemReporter().deprecatedType((TypeBinding)this.binding, this);
                    }
                    this.resolvedType = (TypeBinding)this.binding;
                    return this.resolvedType;
                }
            }
        }
        this.resolvedType = this.reportError(scope);
        return this.resolvedType;
    }

    public String toStringExpression() {
        return new String(this.token);
    }

    public void traverse(IAbstractSyntaxTreeVisitor visitor, BlockScope scope) {
        visitor.visit(this, scope);
        visitor.endVisit(this, scope);
    }

    public String unboundReferenceErrorName() {
        return new String(this.token);
    }
}

