/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemPackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReasons;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.HashtableOfPackage;
import org.eclipse.jdt.internal.compiler.util.Util;

public class LookupEnvironment
implements BaseTypes,
ProblemReasons,
TypeConstants {
    public CompilerOptions options;
    public ProblemReporter problemReporter;
    public ITypeRequestor typeRequestor;
    PackageBinding defaultPackage;
    ImportBinding[] defaultImports;
    HashtableOfPackage knownPackages;
    static final ProblemPackageBinding TheNotFoundPackage = new ProblemPackageBinding(CharOperation.NO_CHAR, 1);
    static final ProblemReferenceBinding TheNotFoundType = new ProblemReferenceBinding(CharOperation.NO_CHAR, 1);
    private INameEnvironment nameEnvironment;
    private MethodVerifier verifier;
    private ArrayBinding[][] uniqueArrayBindings;
    private CompilationUnitDeclaration[] units = new CompilationUnitDeclaration[4];
    private int lastUnitIndex = -1;
    private int lastCompletedUnitIndex = -1;
    private int stepCompleted;
    static final int BUILD_TYPE_HIERARCHY = 1;
    static final int CHECK_AND_SET_IMPORTS = 2;
    static final int CONNECT_TYPE_HIERARCHY = 3;
    static final int BUILD_FIELDS_AND_METHODS = 4;

    public LookupEnvironment(ITypeRequestor typeRequestor, CompilerOptions options, ProblemReporter problemReporter, INameEnvironment nameEnvironment) {
        this.typeRequestor = typeRequestor;
        this.options = options;
        this.problemReporter = problemReporter;
        this.defaultPackage = new PackageBinding(this);
        this.defaultImports = null;
        this.nameEnvironment = nameEnvironment;
        this.knownPackages = new HashtableOfPackage();
        this.uniqueArrayBindings = new ArrayBinding[5][];
        this.uniqueArrayBindings[0] = new ArrayBinding[50];
    }

    public ReferenceBinding askForType(char[][] compoundName) {
        NameEnvironmentAnswer answer = this.nameEnvironment.findType(compoundName);
        if (answer == null) {
            return null;
        }
        if (answer.isBinaryType()) {
            this.typeRequestor.accept(answer.getBinaryType(), this.computePackageFrom(compoundName));
        } else if (answer.isCompilationUnit()) {
            this.typeRequestor.accept(answer.getCompilationUnit());
        } else if (answer.isSourceType()) {
            this.typeRequestor.accept(answer.getSourceTypes(), this.computePackageFrom(compoundName));
        }
        return this.getCachedType(compoundName);
    }

    ReferenceBinding askForType(PackageBinding packageBinding, char[] name) {
        NameEnvironmentAnswer answer;
        if (packageBinding == null) {
            if (this.defaultPackage == null) {
                return null;
            }
            packageBinding = this.defaultPackage;
        }
        if ((answer = this.nameEnvironment.findType(name, packageBinding.compoundName)) == null) {
            return null;
        }
        if (answer.isBinaryType()) {
            this.typeRequestor.accept(answer.getBinaryType(), packageBinding);
        } else if (answer.isCompilationUnit()) {
            this.typeRequestor.accept(answer.getCompilationUnit());
        } else if (answer.isSourceType()) {
            this.typeRequestor.accept(answer.getSourceTypes(), packageBinding);
        }
        return packageBinding.getType0(name);
    }

    public void buildTypeBindings(CompilationUnitDeclaration unit) {
        CompilationUnitScope scope = new CompilationUnitScope(unit, this);
        scope.buildTypeBindings();
        int unitsLength = this.units.length;
        if (++this.lastUnitIndex >= unitsLength) {
            this.units = new CompilationUnitDeclaration[2 * unitsLength];
            System.arraycopy(this.units, 0, this.units, 0, unitsLength);
        }
        this.units[this.lastUnitIndex] = unit;
    }

    public BinaryTypeBinding cacheBinaryType(IBinaryType binaryType) {
        return this.cacheBinaryType(binaryType, true);
    }

    public BinaryTypeBinding cacheBinaryType(IBinaryType binaryType, boolean needFieldsAndMethods) {
        char[][] compoundName = CharOperation.splitOn('/', binaryType.getName());
        ReferenceBinding existingType = this.getCachedType(compoundName);
        if (existingType == null || existingType instanceof UnresolvedReferenceBinding) {
            return this.createBinaryTypeFrom(binaryType, this.computePackageFrom(compoundName), needFieldsAndMethods);
        }
        return null;
    }

    public void completeTypeBindings() {
        this.stepCompleted = 1;
        int i = this.lastCompletedUnitIndex + 1;
        while (i <= this.lastUnitIndex) {
            this.units[i].scope.checkAndSetImports();
            ++i;
        }
        this.stepCompleted = 2;
        i = this.lastCompletedUnitIndex + 1;
        while (i <= this.lastUnitIndex) {
            this.units[i].scope.connectTypeHierarchy();
            ++i;
        }
        this.stepCompleted = 3;
        i = this.lastCompletedUnitIndex + 1;
        while (i <= this.lastUnitIndex) {
            this.units[i].scope.buildFieldsAndMethods();
            this.units[i] = null;
            ++i;
        }
        this.stepCompleted = 4;
        this.lastCompletedUnitIndex = this.lastUnitIndex;
    }

    public void completeTypeBindings(CompilationUnitDeclaration parsedUnit) {
        if (this.stepCompleted == 4) {
            this.completeTypeBindings();
        } else {
            if (parsedUnit.scope == null) {
                return;
            }
            if (this.stepCompleted >= 2) {
                parsedUnit.scope.checkAndSetImports();
            }
            if (this.stepCompleted >= 3) {
                parsedUnit.scope.connectTypeHierarchy();
            }
        }
    }

    public void completeTypeBindings(CompilationUnitDeclaration parsedUnit, boolean buildFieldsAndMethods) {
        if (parsedUnit.scope == null) {
            return;
        }
        parsedUnit.scope.checkAndSetImports();
        parsedUnit.scope.connectTypeHierarchy();
        if (buildFieldsAndMethods) {
            parsedUnit.scope.buildFieldsAndMethods();
        }
    }

    private PackageBinding computePackageFrom(char[][] constantPoolName) {
        if (constantPoolName.length == 1) {
            return this.defaultPackage;
        }
        PackageBinding packageBinding = this.getPackage0(constantPoolName[0]);
        if (packageBinding == null || packageBinding == TheNotFoundPackage) {
            packageBinding = new PackageBinding(constantPoolName[0], this);
            this.knownPackages.put(constantPoolName[0], packageBinding);
        }
        int i = 1;
        int length = constantPoolName.length - 1;
        while (i < length) {
            PackageBinding parent = packageBinding;
            if ((packageBinding = parent.getPackage0(constantPoolName[i])) == null || packageBinding == TheNotFoundPackage) {
                packageBinding = new PackageBinding(CharOperation.subarray(constantPoolName, 0, i + 1), parent, this);
                parent.addPackage(packageBinding);
            }
            ++i;
        }
        return packageBinding;
    }

    ArrayBinding createArrayType(TypeBinding type, int dimensionCount) {
        ArrayBinding[] arrayBindings;
        if (type instanceof LocalTypeBinding) {
            return ((LocalTypeBinding)type).createArrayType(dimensionCount);
        }
        int dimIndex = dimensionCount - 1;
        int length = this.uniqueArrayBindings.length;
        if (dimIndex < length) {
            arrayBindings = this.uniqueArrayBindings[dimIndex];
            if (arrayBindings == null) {
                arrayBindings = new ArrayBinding[10];
                this.uniqueArrayBindings[dimIndex] = arrayBindings;
            }
        } else {
            this.uniqueArrayBindings = new ArrayBinding[dimensionCount][];
            System.arraycopy(this.uniqueArrayBindings, 0, this.uniqueArrayBindings, 0, length);
            arrayBindings = new ArrayBinding[10];
            this.uniqueArrayBindings[dimIndex] = arrayBindings;
        }
        int index = -1;
        length = arrayBindings.length;
        while (++index < length) {
            ArrayBinding currentBinding = arrayBindings[index];
            if (currentBinding == null) {
                arrayBindings[index] = new ArrayBinding(type, dimensionCount);
                return arrayBindings[index];
            }
            if (currentBinding.leafComponentType != type) continue;
            return currentBinding;
        }
        ArrayBinding[] arrayBindingArray = arrayBindings;
        arrayBindings = new ArrayBinding[length * 2];
        System.arraycopy(arrayBindingArray, 0, arrayBindings, 0, length);
        this.uniqueArrayBindings[dimIndex] = arrayBindings;
        arrayBindings[length] = new ArrayBinding(type, dimensionCount);
        return arrayBindings[length];
    }

    public BinaryTypeBinding createBinaryTypeFrom(IBinaryType binaryType, PackageBinding packageBinding) {
        return this.createBinaryTypeFrom(binaryType, packageBinding, true);
    }

    public BinaryTypeBinding createBinaryTypeFrom(IBinaryType binaryType, PackageBinding packageBinding, boolean needFieldsAndMethods) {
        BinaryTypeBinding binaryBinding = new BinaryTypeBinding(packageBinding, binaryType, this);
        ReferenceBinding cachedType = packageBinding.getType0(binaryBinding.compoundName[binaryBinding.compoundName.length - 1]);
        if (cachedType != null) {
            if (cachedType.isBinaryBinding()) {
                return (BinaryTypeBinding)cachedType;
            }
            UnresolvedReferenceBinding unresolvedType = (UnresolvedReferenceBinding)cachedType;
            unresolvedType.resolvedType = binaryBinding;
            this.updateArrayCache(unresolvedType, binaryBinding);
        }
        packageBinding.addType(binaryBinding);
        binaryBinding.cachePartsFrom(binaryType, needFieldsAndMethods);
        return binaryBinding;
    }

    PackageBinding createPackage(char[][] compoundName) {
        PackageBinding packageBinding = this.getPackage0(compoundName[0]);
        if (packageBinding == null || packageBinding == TheNotFoundPackage) {
            packageBinding = new PackageBinding(compoundName[0], this);
            this.knownPackages.put(compoundName[0], packageBinding);
        }
        int i = 1;
        int length = compoundName.length;
        while (i < length) {
            ReferenceBinding type = packageBinding.getType0(compoundName[i]);
            if (type != null && type != TheNotFoundType && !(type instanceof UnresolvedReferenceBinding)) {
                return null;
            }
            PackageBinding parent = packageBinding;
            if ((packageBinding = parent.getPackage0(compoundName[i])) == null || packageBinding == TheNotFoundPackage) {
                if (this.nameEnvironment.findType(compoundName[i], parent.compoundName) != null) {
                    return null;
                }
                packageBinding = new PackageBinding(CharOperation.subarray(compoundName, 0, i + 1), parent, this);
                parent.addPackage(packageBinding);
            }
            ++i;
        }
        return packageBinding;
    }

    public ReferenceBinding getCachedType(char[][] compoundName) {
        if (compoundName.length == 1) {
            if (this.defaultPackage == null) {
                return null;
            }
            return this.defaultPackage.getType0(compoundName[0]);
        }
        PackageBinding packageBinding = this.getPackage0(compoundName[0]);
        if (packageBinding == null || packageBinding == TheNotFoundPackage) {
            return null;
        }
        int i = 1;
        int packageLength = compoundName.length - 1;
        while (i < packageLength) {
            if ((packageBinding = packageBinding.getPackage0(compoundName[i])) == null || packageBinding == TheNotFoundPackage) {
                return null;
            }
            ++i;
        }
        return packageBinding.getType0(compoundName[compoundName.length - 1]);
    }

    PackageBinding getPackage0(char[] name) {
        return this.knownPackages.get(name);
    }

    PackageBinding getTopLevelPackage(char[] name) {
        PackageBinding packageBinding = this.getPackage0(name);
        if (packageBinding != null) {
            if (packageBinding == TheNotFoundPackage) {
                return null;
            }
            return packageBinding;
        }
        if (this.nameEnvironment.isPackage(null, name)) {
            packageBinding = new PackageBinding(name, this);
            this.knownPackages.put(name, packageBinding);
            return packageBinding;
        }
        this.knownPackages.put(name, TheNotFoundPackage);
        return null;
    }

    public ReferenceBinding getType(char[][] compoundName) {
        ReferenceBinding referenceBinding;
        if (compoundName.length == 1) {
            if (this.defaultPackage == null) {
                return null;
            }
            referenceBinding = this.defaultPackage.getType0(compoundName[0]);
            if (referenceBinding == null) {
                PackageBinding packageBinding = this.getPackage0(compoundName[0]);
                if (packageBinding != null && packageBinding != TheNotFoundPackage) {
                    return null;
                }
                referenceBinding = this.askForType(this.defaultPackage, compoundName[0]);
            }
        } else {
            PackageBinding packageBinding = this.getPackage0(compoundName[0]);
            if (packageBinding == TheNotFoundPackage) {
                return null;
            }
            if (packageBinding != null) {
                int i = 1;
                int packageLength = compoundName.length - 1;
                while (i < packageLength) {
                    if ((packageBinding = packageBinding.getPackage0(compoundName[i])) == null) break;
                    if (packageBinding == TheNotFoundPackage) {
                        return null;
                    }
                    ++i;
                }
            }
            if (packageBinding == null) {
                referenceBinding = this.askForType(compoundName);
            } else {
                referenceBinding = packageBinding.getType0(compoundName[compoundName.length - 1]);
                if (referenceBinding == null) {
                    referenceBinding = this.askForType(packageBinding, compoundName[compoundName.length - 1]);
                }
            }
        }
        if (referenceBinding == null || referenceBinding == TheNotFoundType) {
            return null;
        }
        if (referenceBinding instanceof UnresolvedReferenceBinding) {
            referenceBinding = ((UnresolvedReferenceBinding)referenceBinding).resolve(this);
        }
        if (referenceBinding.isNestedType()) {
            return new ProblemReferenceBinding(compoundName, 4);
        }
        return referenceBinding;
    }

    ReferenceBinding getTypeFromConstantPoolName(char[] signature, int start, int end) {
        char[][] compoundName;
        ReferenceBinding binding;
        if (end == -1) {
            end = signature.length;
        }
        if ((binding = this.getCachedType(compoundName = CharOperation.splitOn('/', signature, start, end))) == null) {
            PackageBinding packageBinding = this.computePackageFrom(compoundName);
            binding = new UnresolvedReferenceBinding(compoundName, packageBinding);
            packageBinding.addType(binding);
        } else if (binding == TheNotFoundType) {
            this.problemReporter.isClassPathCorrect(compoundName, null);
            return null;
        }
        return binding;
    }

    TypeBinding getTypeFromSignature(char[] signature, int start, int end) {
        TypeBinding binding;
        int dimension;
        block15: {
            block14: {
                dimension = 0;
                while (signature[start] == '[') {
                    ++start;
                    ++dimension;
                }
                if (end == -1) {
                    end = signature.length - 1;
                }
                binding = null;
                if (start != end) break block14;
                switch (signature[start]) {
                    case 'I': {
                        binding = BaseTypes.IntBinding;
                        break block15;
                    }
                    case 'Z': {
                        binding = BaseTypes.BooleanBinding;
                        break block15;
                    }
                    case 'V': {
                        binding = BaseTypes.VoidBinding;
                        break block15;
                    }
                    case 'C': {
                        binding = BaseTypes.CharBinding;
                        break block15;
                    }
                    case 'D': {
                        binding = BaseTypes.DoubleBinding;
                        break block15;
                    }
                    case 'B': {
                        binding = BaseTypes.ByteBinding;
                        break block15;
                    }
                    case 'F': {
                        binding = BaseTypes.FloatBinding;
                        break block15;
                    }
                    case 'J': {
                        binding = BaseTypes.LongBinding;
                        break block15;
                    }
                    case 'S': {
                        binding = BaseTypes.ShortBinding;
                        break block15;
                    }
                    default: {
                        throw new Error(Util.bind("error.undefinedBaseType", String.valueOf(signature[start])));
                    }
                }
            }
            binding = this.getTypeFromConstantPoolName(signature, start + 1, end);
        }
        if (dimension == 0) {
            return binding;
        }
        return this.createArrayType(binding, dimension);
    }

    boolean isPackage(char[][] compoundName, char[] name) {
        if (compoundName == null || compoundName.length == 0) {
            return this.nameEnvironment.isPackage(null, name);
        }
        return this.nameEnvironment.isPackage(compoundName, name);
    }

    public MethodVerifier methodVerifier() {
        if (this.verifier == null) {
            this.verifier = new MethodVerifier(this);
        }
        return this.verifier;
    }

    public void reset() {
        this.defaultPackage = new PackageBinding(this);
        this.defaultImports = null;
        this.knownPackages = new HashtableOfPackage();
        this.verifier = null;
        int i = this.uniqueArrayBindings.length;
        while (--i >= 0) {
            this.uniqueArrayBindings[i] = null;
        }
        this.uniqueArrayBindings[0] = new ArrayBinding[50];
        i = this.units.length;
        while (--i >= 0) {
            this.units[i] = null;
        }
        this.lastUnitIndex = -1;
        this.lastCompletedUnitIndex = -1;
    }

    void updateArrayCache(UnresolvedReferenceBinding unresolvedType, ReferenceBinding resolvedType) {
        int i = 0;
        int length = this.uniqueArrayBindings.length;
        while (i < length) {
            ArrayBinding[] arrayBindings = this.uniqueArrayBindings[i];
            if (arrayBindings != null) {
                int j = 0;
                int max = arrayBindings.length;
                while (j < max) {
                    ArrayBinding currentBinding = arrayBindings[j];
                    if (currentBinding == null) break;
                    if (currentBinding.leafComponentType == unresolvedType) {
                        currentBinding.leafComponentType = resolvedType;
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }
}

