/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.component.servlet;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.avalon.excalibur.logger.LoggerManager;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.excalibur.instrument.CounterInstrument;
import org.apache.excalibur.instrument.Instrument;
import org.apache.excalibur.instrument.InstrumentManager;
import org.apache.excalibur.instrument.Instrumentable;
import org.apache.excalibur.instrument.ValueInstrument;

public abstract class AbstractServiceManagerServlet
extends HttpServlet
implements Instrumentable {
    private String m_referenceName;
    private ServiceManager m_serviceManager;
    private Logger m_logger;
    private String m_instrumentableName;
    private ArrayList m_instrumentList;
    private ArrayList m_childList;
    private boolean m_registered;
    private CounterInstrument m_instrumentRequests;
    private ValueInstrument m_instrumentTime;
    static /* synthetic */ Class class$org$apache$avalon$excalibur$logger$LoggerManager;
    static /* synthetic */ Class class$org$apache$avalon$framework$service$ServiceManager;
    static /* synthetic */ Class class$org$apache$excalibur$instrument$InstrumentManager;

    public AbstractServiceManagerServlet(String referenceName) {
        this.m_referenceName = referenceName;
        this.m_registered = false;
        this.m_instrumentList = new ArrayList();
        this.m_childList = new ArrayList();
        this.setInstrumentableName(referenceName);
        this.m_instrumentRequests = new CounterInstrument("requests");
        this.addInstrument((Instrument)this.m_instrumentRequests);
        this.m_instrumentTime = new ValueInstrument("time");
        this.addInstrument((Instrument)this.m_instrumentTime);
    }

    public void init(ServletConfig config) throws ServletException {
        ServletContext context = config.getServletContext();
        LoggerManager loggerManager = (LoggerManager)context.getAttribute((class$org$apache$avalon$excalibur$logger$LoggerManager == null ? (class$org$apache$avalon$excalibur$logger$LoggerManager = AbstractServiceManagerServlet.class$("org.apache.avalon.excalibur.logger.LoggerManager")) : class$org$apache$avalon$excalibur$logger$LoggerManager).getName());
        if (loggerManager == null) {
            throw new IllegalStateException("The ExcaliburComponentManagerServlet servlet was not correctly initialized.");
        }
        Logger logger = loggerManager.getLoggerForCategory("servlet");
        this.m_logger = logger.getChildLogger(this.m_referenceName);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("servlet.init( config )");
        }
        this.m_serviceManager = (ServiceManager)context.getAttribute((class$org$apache$avalon$framework$service$ServiceManager == null ? (class$org$apache$avalon$framework$service$ServiceManager = AbstractServiceManagerServlet.class$("org.apache.avalon.framework.service.ServiceManager")) : class$org$apache$avalon$framework$service$ServiceManager).getName());
        if (this.m_serviceManager == null) {
            throw new IllegalStateException("The ExcaliburComponentManagerServlet servlet was not correctly initialized.");
        }
        InstrumentManager instrumentManager = (InstrumentManager)context.getAttribute((class$org$apache$excalibur$instrument$InstrumentManager == null ? (class$org$apache$excalibur$instrument$InstrumentManager = AbstractServiceManagerServlet.class$("org.apache.excalibur.instrument.InstrumentManager")) : class$org$apache$excalibur$instrument$InstrumentManager).getName());
        if (instrumentManager != null) {
            try {
                instrumentManager.registerInstrumentable((Instrumentable)this, "servlets." + this.getInstrumentableName());
            }
            catch (Exception e) {
                throw new ServletException("Unable to register the servlet with the instrument manager.", (Throwable)e);
            }
        }
        super.init(config);
    }

    public void destroy() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("servlet.destroy()");
        }
        this.m_serviceManager = null;
        super.destroy();
        System.gc();
        try {
            Thread.sleep(250L);
        }
        catch (InterruptedException e) {}
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.getLogger().isDebugEnabled()) {
            StringBuffer sb = new StringBuffer(request.getRequestURI());
            String query = request.getQueryString();
            if (query != null) {
                sb.append("?");
                sb.append(query);
            }
            this.getLogger().debug("Request: " + sb.toString());
        }
        long start = System.currentTimeMillis();
        this.m_instrumentRequests.increment();
        super.service(request, response);
        if (this.m_instrumentTime.isActive()) {
            this.m_instrumentTime.setValue((int)(System.currentTimeMillis() - start));
        }
    }

    public final String getInstrumentableName() {
        return this.m_instrumentableName;
    }

    public final void setInstrumentableName(String name) {
        this.m_instrumentableName = name;
    }

    public final Instrumentable[] getChildInstrumentables() {
        this.m_registered = true;
        if (this.m_childList.size() == 0) {
            return Instrumentable.EMPTY_INSTRUMENTABLE_ARRAY;
        }
        Instrumentable[] children = new Instrumentable[this.m_childList.size()];
        this.m_childList.toArray(children);
        return children;
    }

    public final Instrument[] getInstruments() {
        this.m_registered = true;
        if (this.m_instrumentList.size() == 0) {
            return Instrumentable.EMPTY_INSTRUMENT_ARRAY;
        }
        Instrument[] instruments = new Instrument[this.m_instrumentList.size()];
        this.m_instrumentList.toArray(instruments);
        return instruments;
    }

    protected void addInstrument(Instrument instrument) {
        if (this.m_registered) {
            throw new IllegalStateException("Instruments can not be added after the Instrumentable is registered with the InstrumentManager.");
        }
        this.m_instrumentList.add(instrument);
    }

    protected void addChildInstrumentable(Instrumentable child) {
        if (this.m_registered) {
            throw new IllegalStateException("Child Instrumentables can not be added after the Instrumentable is registered with the InstrumentManager.");
        }
        this.m_childList.add(child);
    }

    protected Logger getLogger() {
        return this.m_logger;
    }

    public ServiceManager getServiceManager() {
        return this.m_serviceManager;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

