/*
 * Decompiled with CFR 0.152.
 */
package mx4j;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import mx4j.util.Utils;

public abstract class AbstractDynamicMBean
implements DynamicMBean {
    private MBeanInfo m_info;
    private Object m_resource;

    protected AbstractDynamicMBean() {
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new AttributeNotFoundException("Attribute " + attribute + " not found");
        }
        MBeanInfo info = this.getMBeanInfo();
        MBeanAttributeInfo[] attrs = info.getAttributes();
        if (attrs == null || attrs.length == 0) {
            throw new AttributeNotFoundException("No attributes defined for this MBean");
        }
        int i = 0;
        while (i < attrs.length) {
            MBeanAttributeInfo attr = attrs[i];
            if (attr != null && attribute.equals(attr.getName())) {
                if (!attr.isReadable()) {
                    throw new ReflectionException(new NoSuchMethodException("No getter defined for attribute: " + attribute));
                }
                String prefix = null;
                prefix = attr.isIs() ? "is" : "get";
                try {
                    return this.invoke(prefix + attr.getName(), new Class[0], new Object[0]);
                }
                catch (InvalidAttributeValueException x) {
                    throw new ReflectionException(x);
                }
            }
            ++i;
        }
        throw new AttributeNotFoundException("Attribute " + attribute + " not found");
    }

    public AttributeList getAttributes(String[] attributes) {
        AttributeList list = new AttributeList();
        if (attributes != null) {
            int i = 0;
            while (i < attributes.length) {
                String attribute = attributes[i];
                try {
                    Object result = this.getAttribute(attribute);
                    list.add(new Attribute(attribute, result));
                }
                catch (AttributeNotFoundException ignored) {
                }
                catch (MBeanException ignored) {
                }
                catch (ReflectionException ignored) {
                    // empty catch block
                }
                ++i;
            }
        }
        return list;
    }

    public synchronized MBeanInfo getMBeanInfo() {
        if (this.m_info == null) {
            this.setMBeanInfo(this.createMBeanInfo());
        }
        return this.m_info;
    }

    public Object invoke(String method, Object[] arguments, String[] params) throws MBeanException, ReflectionException {
        MBeanInfo info;
        MBeanOperationInfo[] opers;
        if (method == null) {
            throw new IllegalArgumentException("Method name cannot be null");
        }
        if (arguments == null) {
            arguments = new Object[]{};
        }
        if (params == null) {
            params = new String[]{};
        }
        if ((opers = (info = this.getMBeanInfo()).getOperations()) == null || opers.length == 0) {
            throw new ReflectionException(new NoSuchMethodException("No operations defined for this MBean"));
        }
        int i = 0;
        while (i < opers.length) {
            MBeanParameterInfo[] parameters;
            MBeanOperationInfo oper = opers[i];
            if (oper != null && method.equals(oper.getName()) && params.length == (parameters = oper.getSignature()).length) {
                Object[] signature = new String[parameters.length];
                int j = 0;
                while (j < signature.length) {
                    MBeanParameterInfo param = parameters[j];
                    signature[j] = param == null ? null : param.getType();
                    ++j;
                }
                if (Utils.arrayEquals(params, signature)) {
                    try {
                        Class[] classes = Utils.loadClasses(this.getClass().getClassLoader(), (String[])signature);
                        return this.invoke(method, classes, arguments);
                    }
                    catch (ClassNotFoundException x) {
                        throw new ReflectionException(x);
                    }
                    catch (InvalidAttributeValueException x) {
                        throw new ReflectionException(x);
                    }
                }
            }
            ++i;
        }
        throw new ReflectionException(new NoSuchMethodException("Operation " + method + " with signature " + Arrays.asList(params) + " is not defined for this MBean"));
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new AttributeNotFoundException("Attribute " + attribute + " not found");
        }
        MBeanInfo info = this.getMBeanInfo();
        MBeanAttributeInfo[] attrs = info.getAttributes();
        if (attrs == null || attrs.length == 0) {
            throw new AttributeNotFoundException("No attributes defined for this MBean");
        }
        int i = 0;
        while (i < attrs.length) {
            MBeanAttributeInfo attr = attrs[i];
            if (attr != null && attribute.getName().equals(attr.getName())) {
                if (!attr.isWritable()) {
                    throw new ReflectionException(new NoSuchMethodException("No setter defined for attribute: " + attribute));
                }
                try {
                    String signature = attr.getType();
                    Class cls = Utils.loadClass(this.getClass().getClassLoader(), signature);
                    this.invoke("set" + attr.getName(), new Class[]{cls}, new Object[]{attribute.getValue()});
                    return;
                }
                catch (ClassNotFoundException x) {
                    throw new ReflectionException(x);
                }
            }
            ++i;
        }
        throw new AttributeNotFoundException("Attribute " + attribute + " not found");
    }

    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList list = new AttributeList();
        if (attributes != null) {
            int i = 0;
            while (i < attributes.size()) {
                Attribute attribute = (Attribute)attributes.get(i);
                try {
                    this.setAttribute(attribute);
                    list.add(attribute);
                }
                catch (AttributeNotFoundException ignored) {
                }
                catch (InvalidAttributeValueException ignored) {
                }
                catch (MBeanException ignored) {
                }
                catch (ReflectionException ignored) {
                    // empty catch block
                }
                ++i;
            }
        }
        return list;
    }

    protected Object invoke(String name, Class[] params, Object[] args) throws InvalidAttributeValueException, MBeanException, ReflectionException {
        try {
            Object resource = this.getResource();
            if (resource == null) {
                resource = this;
            }
            Class<?> cls = resource.getClass();
            Method method = this.findMethod(cls, name, params);
            return this.invokeMethod(method, resource, args);
        }
        catch (NoSuchMethodException x) {
            throw new ReflectionException(x);
        }
        catch (IllegalAccessException x) {
            throw new ReflectionException(x);
        }
        catch (IllegalArgumentException x) {
            throw new InvalidAttributeValueException(x.toString());
        }
        catch (InvocationTargetException x) {
            Throwable t = x.getTargetException();
            if (t instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)t);
            }
            if (t instanceof Exception) {
                throw new MBeanException((Exception)t);
            }
            throw new RuntimeErrorException((Error)t);
        }
    }

    protected Method findMethod(Class cls, String name, Class[] params) throws NoSuchMethodException {
        return cls.getMethod(name, params);
    }

    protected Object invokeMethod(Method method, Object resource, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return method.invoke(resource, args);
    }

    protected Object getResource() {
        return this.m_resource;
    }

    public void setResource(Object resource) {
        this.m_resource = resource;
    }

    protected void setMBeanInfo(MBeanInfo info) {
        this.m_info = info;
    }

    protected MBeanInfo createMBeanInfo() {
        MBeanAttributeInfo[] attrs = this.createMBeanAttributeInfo();
        MBeanConstructorInfo[] ctors = this.createMBeanConstructorInfo();
        MBeanOperationInfo[] opers = this.createMBeanOperationInfo();
        MBeanNotificationInfo[] notifs = this.createMBeanNotificationInfo();
        String className = this.getMBeanClassName();
        String description = this.getMBeanDescription();
        return new MBeanInfo(className, description, attrs, ctors, opers, notifs);
    }

    protected MBeanAttributeInfo[] createMBeanAttributeInfo() {
        return new MBeanAttributeInfo[0];
    }

    protected MBeanConstructorInfo[] createMBeanConstructorInfo() {
        return new MBeanConstructorInfo[0];
    }

    protected MBeanOperationInfo[] createMBeanOperationInfo() {
        return new MBeanOperationInfo[0];
    }

    protected MBeanNotificationInfo[] createMBeanNotificationInfo() {
        return new MBeanNotificationInfo[0];
    }

    protected String getMBeanClassName() {
        return this.getClass().getName();
    }

    protected String getMBeanDescription() {
        return null;
    }
}

