/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.xml.xslt;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.AggregatedValidity;
import org.apache.excalibur.store.Store;
import org.apache.excalibur.xml.sax.XMLizable;
import org.apache.excalibur.xml.xslt.TraxErrorHandler;
import org.apache.excalibur.xml.xslt.XSLTProcessor;
import org.apache.excalibur.xml.xslt.XSLTProcessorException;
import org.apache.excalibur.xmlizer.XMLizer;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;

public class XSLTProcessorImpl
extends AbstractLogEnabled
implements XSLTProcessor,
Serviceable,
Initializable,
Disposable,
Parameterizable,
Recyclable,
URIResolver {
    protected Store m_store;
    protected String m_transformerFactory;
    protected SAXTransformerFactory m_factory;
    protected SAXTransformerFactory m_defaultFactory;
    protected boolean m_useStore;
    protected boolean m_incrementalProcessing;
    protected SourceResolver m_resolver;
    protected TraxErrorHandler m_errorHandler;
    protected boolean m_checkIncludes;
    protected Map m_includesMap = new HashMap();
    protected XMLizer m_xmlizer;
    protected ServiceManager m_manager;

    public void service(ServiceManager manager) throws ServiceException {
        this.m_manager = manager;
        this.m_xmlizer = (XMLizer)this.m_manager.lookup(XMLizer.ROLE);
        this.m_resolver = (SourceResolver)this.m_manager.lookup(SourceResolver.ROLE);
        if (this.m_manager.hasService(Store.TRANSIENT_STORE)) {
            this.m_store = (Store)this.m_manager.lookup(Store.TRANSIENT_STORE);
        }
    }

    public void initialize() throws Exception {
        this.m_errorHandler = new TraxErrorHandler(this.getLogger());
        this.m_defaultFactory = this.m_factory = this.getTransformerFactory(this.m_transformerFactory);
    }

    public void dispose() {
        if (null != this.m_manager) {
            this.m_manager.release((Object)this.m_store);
            this.m_manager.release((Object)this.m_resolver);
            this.m_manager.release((Object)this.m_xmlizer);
            this.m_manager = null;
        }
        this.m_xmlizer = null;
        this.m_store = null;
        this.m_resolver = null;
        this.m_errorHandler = null;
    }

    public void parameterize(Parameters params) throws ParameterException {
        this.m_useStore = params.getParameterAsBoolean("use-store", this.m_useStore);
        this.m_incrementalProcessing = params.getParameterAsBoolean("incremental-processing", this.m_incrementalProcessing);
        this.m_transformerFactory = params.getParameter("transformer-factory", null);
        this.m_checkIncludes = params.getParameterAsBoolean("check-includes", true);
        if (!this.m_useStore) {
            this.m_manager.release((Object)this.m_store);
            this.m_store = null;
        } else if (null == this.m_store) {
            String message = "XSLTProcessor: use-store is set to true, but unable to aquire the Store.";
            throw new ParameterException("XSLTProcessor: use-store is set to true, but unable to aquire the Store.");
        }
    }

    public void setTransformerFactory(String classname) {
        this.m_factory = this.getTransformerFactory(classname);
    }

    public TransformerHandler getTransformerHandler(Source stylesheet) throws XSLTProcessorException {
        return this.getTransformerHandler(stylesheet, null);
    }

    public TransformerHandler getTransformerHandler(Source stylesheet, XMLFilter filter) throws XSLTProcessorException {
        XSLTProcessor.TransformerHandlerAndValidity validity = this.getTransformerHandlerAndValidity(stylesheet, filter);
        return validity.getTransfomerHandler();
    }

    public XSLTProcessor.TransformerHandlerAndValidity getTransformerHandlerAndValidity(Source stylesheet) throws XSLTProcessorException {
        return this.getTransformerHandlerAndValidity(stylesheet, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XSLTProcessor.TransformerHandlerAndValidity getTransformerHandlerAndValidity(Source stylesheet, XMLFilter filter) throws XSLTProcessorException {
        try {
            XSLTProcessor.TransformerHandlerAndValidity handlerAndValidity;
            block16: {
                String id = stylesheet.getURI();
                handlerAndValidity = this.getTemplates(stylesheet, id);
                if (null == handlerAndValidity) {
                    SourceValidity validity;
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Creating new Templates for " + id);
                    }
                    TemplatesHandler templatesHandler = this.m_factory.newTemplatesHandler();
                    templatesHandler.setSystemId(id);
                    if (filter != null) {
                        filter.setContentHandler(templatesHandler);
                    }
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Source = " + stylesheet + ", templatesHandler = " + templatesHandler);
                    }
                    if ((validity = stylesheet.getValidity()) != null && this.m_checkIncludes) {
                        this.m_includesMap.put(id, new ArrayList());
                    }
                    try {
                        List includes;
                        this.sourceToSAX(stylesheet, filter != null ? (ContentHandler)((Object)filter) : templatesHandler);
                        Templates template = templatesHandler.getTemplates();
                        if (null == template) {
                            throw new XSLTProcessorException("Unable to create templates for stylesheet: " + stylesheet.getURI());
                        }
                        this.putTemplates(template, stylesheet, id);
                        TransformerHandler handler = this.m_factory.newTransformerHandler(template);
                        handler.getTransformer().setErrorListener(this.m_errorHandler);
                        handler.getTransformer().setURIResolver(this);
                        AggregatedValidity aggregated = null;
                        if (validity != null && this.m_checkIncludes && (includes = (List)this.m_includesMap.get(id)) != null) {
                            aggregated = new AggregatedValidity();
                            aggregated.add(validity);
                            int i = includes.size() - 1;
                            while (i >= 0) {
                                aggregated.add((SourceValidity)((Object[])includes.get(i))[1]);
                                --i;
                            }
                            validity = aggregated;
                        }
                        handlerAndValidity = new XSLTProcessor.TransformerHandlerAndValidity(handler, validity);
                        Object var13_14 = null;
                        if (!this.m_checkIncludes) break block16;
                        this.m_includesMap.remove(id);
                    }
                    catch (Throwable throwable) {
                        Object var13_15 = null;
                        if (this.m_checkIncludes) {
                            this.m_includesMap.remove(id);
                        }
                        throw throwable;
                    }
                    {
                        break block16;
                    }
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Reusing Templates for " + id);
                }
            }
            return handlerAndValidity;
        }
        catch (SAXException e) {
            if (e.getException() == null) {
                throw new XSLTProcessorException("Exception in creating Transform Handler", e);
            }
            this.getLogger().debug("Got SAXException. Rethrowing cause exception.", (Throwable)e);
            throw new XSLTProcessorException("Exception in creating Transform Handler", e.getException());
        }
        catch (Exception e) {
            throw new XSLTProcessorException("Exception in creating Transform Handler", e);
        }
    }

    private void sourceToSAX(Source source, ContentHandler handler) throws SAXException, IOException, ComponentException, SourceException {
        if (source instanceof XMLizable) {
            ((XMLizable)source).toSAX(handler);
        } else {
            InputStream inputStream = source.getInputStream();
            String mimeType = source.getMimeType();
            String systemId = source.getURI();
            this.m_xmlizer.toSAX(inputStream, mimeType, systemId, handler);
        }
    }

    public void transform(Source source, Source stylesheet, Parameters params, Result result) throws XSLTProcessorException {
        try {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Transform source = " + source + ", stylesheet = " + stylesheet + ", parameters = " + params + ", result = " + result);
            }
            TransformerHandler handler = this.getTransformerHandler(stylesheet);
            if (params != null) {
                Transformer transformer = handler.getTransformer();
                transformer.clearParameters();
                String[] names = params.getNames();
                int i = names.length - 1;
                while (i >= 0) {
                    transformer.setParameter(names[i], params.getParameter(names[i]));
                    --i;
                }
            }
            handler.setResult(result);
            this.sourceToSAX(source, handler);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Transform done");
            }
        }
        catch (SAXException e) {
            if (e.getException() == null) {
                String message = "Error in running Transformation";
                throw new XSLTProcessorException("Error in running Transformation", e);
            }
            String message = "Got SAXException. Rethrowing cause exception.";
            this.getLogger().debug("Got SAXException. Rethrowing cause exception.", (Throwable)e);
            throw new XSLTProcessorException("Error in running Transformation", e.getException());
        }
        catch (Exception e) {
            String message = "Error in running Transformation";
            throw new XSLTProcessorException("Error in running Transformation", e);
        }
    }

    private SAXTransformerFactory getTransformerFactory(String factoryName) {
        SAXTransformerFactory _factory;
        if (null == factoryName) {
            _factory = (SAXTransformerFactory)TransformerFactory.newInstance();
        } else {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                if (loader == null) {
                    loader = this.getClass().getClassLoader();
                }
                _factory = (SAXTransformerFactory)loader.loadClass(factoryName).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                this.getLogger().error("Cannot find the requested TrAX factory '" + factoryName + "'. Using default TrAX Transformer Factory instead.");
                if (this.m_factory != null) {
                    return this.m_factory;
                }
                _factory = (SAXTransformerFactory)TransformerFactory.newInstance();
            }
            catch (ClassCastException cce) {
                this.getLogger().error("The indicated class '" + factoryName + "' is not a TrAX Transformer Factory. Using default TrAX Transformer Factory instead.");
                if (this.m_factory != null) {
                    return this.m_factory;
                }
                _factory = (SAXTransformerFactory)TransformerFactory.newInstance();
            }
            catch (Exception e) {
                this.getLogger().error("Error found loading the requested TrAX Transformer Factory '" + factoryName + "'. Using default TrAX Transformer Factory instead.");
                if (this.m_factory != null) {
                    return this.m_factory;
                }
                _factory = (SAXTransformerFactory)TransformerFactory.newInstance();
            }
        }
        _factory.setErrorListener(this.m_errorHandler);
        _factory.setURIResolver(this);
        if (_factory.getClass().getName().equals("org.apache.xalan.processor.TransformerFactoryImpl")) {
            _factory.setAttribute("http://xml.apache.org/xalan/features/incremental", new Boolean(this.m_incrementalProcessing));
        }
        return _factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XSLTProcessor.TransformerHandlerAndValidity getTemplates(Source stylesheet, String id) throws IOException, SourceException, TransformerException {
        boolean isValid;
        SourceValidity newValidity;
        if (!this.m_useStore) {
            return null;
        }
        String key = id + this.m_factory.getClass().getName();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("getTemplates: stylesheet " + id);
        }
        if ((newValidity = stylesheet.getValidity()) == null) {
            this.m_store.remove((Object)key);
            return null;
        }
        Object[] templateAndValidityAndIncludes = (Object[])this.m_store.get((Object)key);
        if (templateAndValidityAndIncludes == null) {
            return null;
        }
        SourceValidity storedValidity = (SourceValidity)templateAndValidityAndIncludes[1];
        int valid = storedValidity.isValid();
        if (valid == 0) {
            valid = storedValidity.isValid(newValidity);
            isValid = valid == 1;
        } else {
            boolean bl = isValid = valid == 1;
        }
        if (!isValid) {
            this.m_store.remove((Object)key);
            return null;
        }
        if (this.m_checkIncludes) {
            AggregatedValidity aggregated = null;
            List includes = (List)templateAndValidityAndIncludes[2];
            if (includes != null) {
                aggregated = new AggregatedValidity();
                aggregated.add(storedValidity);
                int i = includes.size() - 1;
                while (i >= 0) {
                    block15: {
                        Object[] pair = (Object[])includes.get(i);
                        storedValidity = (SourceValidity)pair[1];
                        aggregated.add(storedValidity);
                        valid = storedValidity.isValid();
                        isValid = false;
                        if (valid == 0) {
                            Object var16_15;
                            Source includedSource = null;
                            try {
                                includedSource = this.m_resolver.resolveURI((String)pair[0]);
                                SourceValidity included = includedSource.getValidity();
                                if (included != null) {
                                    valid = storedValidity.isValid(included);
                                    isValid = valid == 1;
                                }
                                var16_15 = null;
                            }
                            catch (Throwable throwable) {
                                var16_15 = null;
                                this.m_resolver.release(includedSource);
                                throw throwable;
                            }
                            this.m_resolver.release(includedSource);
                            {
                                break block15;
                            }
                        }
                        boolean bl = isValid = valid == 1;
                    }
                    if (!isValid) {
                        this.m_store.remove((Object)key);
                        return null;
                    }
                    --i;
                }
                storedValidity = aggregated;
            }
        }
        TransformerHandler handler = this.m_factory.newTransformerHandler((Templates)templateAndValidityAndIncludes[0]);
        handler.getTransformer().setErrorListener(this.m_errorHandler);
        handler.getTransformer().setURIResolver(this);
        return new XSLTProcessor.TransformerHandlerAndValidity(handler, storedValidity);
    }

    private void putTemplates(Templates templates, Source stylesheet, String id) throws IOException {
        if (!this.m_useStore) {
            return;
        }
        String key = id + this.m_factory.getClass().getName();
        SourceValidity validity = stylesheet.getValidity();
        if (null != validity) {
            Object[] templateAndValidityAndIncludes = new Object[3];
            templateAndValidityAndIncludes[0] = templates;
            templateAndValidityAndIncludes[1] = validity;
            if (this.m_checkIncludes) {
                templateAndValidityAndIncludes[2] = this.m_includesMap.get(id);
            }
            this.m_store.store((Object)key, (Object)templateAndValidityAndIncludes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public javax.xml.transform.Source resolve(String href, String base) throws TransformerException {
        Object includes2;
        Source xslSource;
        block23: {
            javax.xml.transform.Source source;
            block22: {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("resolve(href = " + href + ", base = " + base + "); resolver = " + this.m_resolver);
                }
                xslSource = null;
                try {
                    try {
                        if (base == null || href.indexOf(":") > 1) {
                            xslSource = this.m_resolver.resolveURI(href);
                        } else if (href.length() == 0) {
                            xslSource = this.m_resolver.resolveURI(base);
                        } else if (!base.startsWith("file:")) {
                            int lastPathElementPos = base.lastIndexOf(47);
                            if (lastPathElementPos == -1) {
                                source = null;
                                Object var9_12 = null;
                                break block22;
                            }
                            xslSource = this.m_resolver.resolveURI(base.substring(0, lastPathElementPos) + "/" + href);
                        } else {
                            File parent = new File(base.substring(5));
                            File parent2 = new File(parent.getParentFile(), href);
                            xslSource = this.m_resolver.resolveURI(parent2.toURL().toExternalForm());
                        }
                        InputSource is = XSLTProcessorImpl.getInputSource(xslSource);
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("xslSource = " + xslSource + ", system id = " + xslSource.getURI());
                        }
                        if (this.m_checkIncludes && (includes2 = (List)this.m_includesMap.get(base)) != null) {
                            SourceValidity included = xslSource.getValidity();
                            if (included != null) {
                                includes2.add(new Object[]{xslSource.getURI(), xslSource.getValidity()});
                            } else {
                                this.m_includesMap.remove(base);
                            }
                        }
                        includes2 = new StreamSource(is.getByteStream(), is.getSystemId());
                        break block23;
                    }
                    catch (SourceException e) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Failed to resolve " + href + "(base = " + base + "), return null", (Throwable)e);
                        }
                        javax.xml.transform.Source includes2 = null;
                        Object var9_14 = null;
                        this.m_resolver.release(xslSource);
                        return includes2;
                    }
                    catch (MalformedURLException mue) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Failed to resolve " + href + "(base = " + base + "), return null", (Throwable)mue);
                        }
                        javax.xml.transform.Source included = null;
                        Object var9_15 = null;
                        this.m_resolver.release(xslSource);
                        return included;
                    }
                    catch (IOException ioe) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Failed to resolve " + href + "(base = " + base + "), return null", (Throwable)ioe);
                        }
                        javax.xml.transform.Source source2 = null;
                        Object var9_16 = null;
                        this.m_resolver.release(xslSource);
                        return source2;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_17 = null;
                    this.m_resolver.release(xslSource);
                    throw throwable;
                }
            }
            this.m_resolver.release(xslSource);
            return source;
        }
        Object var9_13 = null;
        this.m_resolver.release(xslSource);
        return includes2;
    }

    private static InputSource getInputSource(Source source) throws IOException, SourceException {
        InputSource newObject = new InputSource(source.getInputStream());
        newObject.setSystemId(source.getURI());
        return newObject;
    }

    public void recycle() {
        this.m_includesMap.clear();
        if (this.m_factory != this.m_defaultFactory) {
            this.m_factory = this.m_defaultFactory;
        }
    }
}

