/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.markup.xsp;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.language.markup.xsp.XSPGenerator;
import org.apache.cocoon.components.language.markup.xsp.XSPRequestHelper;
import org.apache.cocoon.components.language.markup.xsp.XSPResponseHelper;
import org.apache.cocoon.components.language.markup.xsp.XSPSessionHelper;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.SourceResolver;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class JSGenerator
extends XSPGenerator
implements Configurable,
Initializable {
    private File file;
    private Scriptable global;
    private Script script;
    private Exception compileError;

    public void configure(Configuration configuration) throws ConfigurationException {
        this.file = new File(configuration.getChild("file").getValue());
        Configuration[] dependencies = configuration.getChildren("dependency");
        this.dependencies = new File[dependencies.length];
        for (int i = 0; i < dependencies.length; ++i) {
            this.dependencies[i] = new File(dependencies[i].getValue());
        }
    }

    public boolean modifiedSince(long date) {
        if (this.file.lastModified() < date) {
            return true;
        }
        for (int i = 0; i < this.dependencies.length; ++i) {
            if (this.file.lastModified() >= this.dependencies[i].lastModified()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws Exception {
        Context context = Context.enter();
        try {
            this.global = new ImporterTopLevel(context);
            this.global.put("page", this.global, (Object)Context.toObject((Object)this, (Scriptable)this.global));
            this.global.put("logger", this.global, (Object)Context.toObject((Object)this.getLogger(), (Scriptable)this.global));
            this.global.put("xspAttr", this.global, (Object)Context.toObject((Object)new AttributesImpl(), (Scriptable)this.global));
            context.setOptimizationLevel(-1);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Compiling script " + this.file);
            }
            this.script = context.compileReader(this.global, (Reader)new FileReader(this.file), this.file.toString(), 1, null);
        }
        catch (Exception e) {
            this.compileError = e;
        }
        finally {
            Context.exit();
        }
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        if (this.compileError != null) {
            throw new ProcessingException("Failed to compile script", this.compileError);
        }
        Context.enter();
        try {
            this.global.put("objectModel", this.global, (Object)Context.toObject((Object)this.objectModel, (Scriptable)this.global));
            this.global.put("request", this.global, (Object)Context.toObject((Object)this.request, (Scriptable)this.global));
            this.global.put("response", this.global, (Object)Context.toObject((Object)this.response, (Scriptable)this.global));
            this.global.put("context", this.global, (Object)Context.toObject((Object)this.context, (Scriptable)this.global));
            this.global.put("resolver", this.global, (Object)Context.toObject((Object)this.resolver, (Scriptable)this.global));
            this.global.put("parameters", this.global, (Object)Context.toObject((Object)this.parameters, (Scriptable)this.global));
        }
        catch (Exception e) {
            throw new ProcessingException("setup: Got exception", e);
        }
        finally {
            Context.exit();
        }
    }

    public void generate() throws IOException, ProcessingException {
        Context context = Context.enter();
        try {
            this.global.put("contentHandler", this.global, (Object)Context.toObject((Object)this.contentHandler, (Scriptable)this.global));
            context.setOptimizationLevel(-1);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Executing script " + this.file);
            }
            this.script.exec(context, this.global);
        }
        catch (JavaScriptException e) {
            throw new ProcessingException("generate: Got Javascript exception", e);
        }
        finally {
            Context.exit();
        }
    }

    public void recycle() {
        this.global.delete("contentHandler");
        this.global.delete("objectModel");
        this.global.delete("request");
        this.global.delete("response");
        this.global.delete("context");
        this.global.delete("resolver");
        this.global.delete("parameters");
        super.recycle();
    }

    public void dispose() {
        this.global.delete("page");
        this.global.delete("logger");
        this.global.delete("xspAttr");
        this.global = null;
        this.script = null;
        this.compileError = null;
        super.dispose();
    }

    public void getLocale() throws SAXException {
        XSPRequestHelper.getLocale(this.objectModel, this.contentHandler);
    }

    public Locale[] getLocalesAsArray() {
        return XSPRequestHelper.getLocales(this.objectModel);
    }

    public void getLocalesAsXML() throws SAXException {
        XSPRequestHelper.getLocale(this.objectModel, this.contentHandler);
    }

    public String getParameter(String name, String defaultValue) {
        return XSPRequestHelper.getParameter(this.objectModel, name, defaultValue);
    }

    public String getParameter(String name, String defaultValue, String form_encoding, String container_encoding) {
        return XSPRequestHelper.getParameter(this.objectModel, name, defaultValue, form_encoding, container_encoding);
    }

    public void getParameterAsXML(String name, String defaultValue, String form_encoding, String container_encoding) throws SAXException {
        XSPRequestHelper.getParameter(this.objectModel, this.contentHandler, name, defaultValue, form_encoding, container_encoding);
    }

    public void getParameterValuesAsXML(String name, String form_encoding, String container_encoding) throws SAXException {
        XSPRequestHelper.getParameterValues(this.objectModel, this.contentHandler, name, form_encoding, container_encoding);
    }

    public String[] getParameterValues(String name, String form_encoding, String container_encoding) {
        return XSPRequestHelper.getParameterValues(this.objectModel, name, form_encoding, container_encoding);
    }

    public String[] getParameterNames() {
        return XSPRequestHelper.getParameterNames(this.objectModel);
    }

    public void getParameterNamesAsXML() throws SAXException {
        XSPRequestHelper.getParameterNames(this.objectModel, this.contentHandler);
    }

    public void getHeaderNamesAsXML() throws SAXException {
        XSPRequestHelper.getHeaderNames(this.objectModel, this.contentHandler);
    }

    public String[] getHeaderNames() {
        return XSPRequestHelper.getHeaderNames(this.objectModel);
    }

    public String[] getHeaders(String name) {
        return XSPRequestHelper.getHeaders(this.objectModel, name);
    }

    public void getHeadersAsXML(String name) throws SAXException {
        XSPRequestHelper.getHeaders(this.objectModel, name, this.contentHandler);
    }

    public Date getDateHeader(String name) {
        return XSPRequestHelper.getDateHeader(this.objectModel, name);
    }

    public String getDateHeader(String name, String format) {
        return XSPRequestHelper.getDateHeader(this.objectModel, name, format);
    }

    public void getAttributeNames(ContentHandler contentHandler) throws SAXException {
        XSPRequestHelper.getAttributeNames(this.objectModel, contentHandler);
    }

    public String[] getAttributeNames() {
        return XSPRequestHelper.getAttributeNames(this.objectModel);
    }

    public String getRequestedURL() {
        return XSPRequestHelper.getRequestedURL(this.objectModel);
    }

    public void responseGetLocale() throws SAXException {
        XSPResponseHelper.getLocale(this.response, this.contentHandler);
    }

    public void addDateHeader(String name, long date) {
        XSPResponseHelper.addDateHeader(this.response, name, date);
    }

    public void addDateHeader(String name, Date date) {
        XSPResponseHelper.addDateHeader(this.response, name, date);
    }

    public void addDateHeader(String name, String date) throws ParseException {
        XSPResponseHelper.addDateHeader(this.response, name, date);
    }

    public void addDateHeader(String name, String date, String format) throws ParseException {
        XSPResponseHelper.addDateHeader(this.response, name, date, format);
    }

    public void addDateHeader(String name, String date, DateFormat format) throws ParseException {
        XSPResponseHelper.addDateHeader(this.response, name, date, format);
    }

    public void setDateHeader(String name, long date) {
        XSPResponseHelper.setDateHeader(this.response, name, date);
    }

    public void setDateHeader(String name, Date date) {
        XSPResponseHelper.setDateHeader(this.response, name, date);
    }

    public void setDateHeader(String name, String date) throws ParseException {
        XSPResponseHelper.setDateHeader(this.response, name, date);
    }

    public void setDateHeader(String name, String date, String format) throws ParseException {
        XSPResponseHelper.setDateHeader(this.response, name, date, format);
    }

    public void setDateHeader(String name, String date, DateFormat format) throws ParseException {
        XSPResponseHelper.setDateHeader(this.response, name, date, format);
    }

    public Object getSessionAttribute(Session session, String name, Object defaultValue) {
        return XSPSessionHelper.getSessionAttribute(session, name, defaultValue);
    }

    public String[] getSessionAttributeNames(Session session) {
        List c = XSPSessionHelper.getSessionAttributeNames(session);
        return c.toArray(new String[c.size()]);
    }
}

