/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment.commandline;

import java.io.File;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.environment.commandline.AbstractCommandLineEnvironment;
import org.apache.cocoon.environment.commandline.CommandLineContext;
import org.apache.cocoon.environment.commandline.CommandLineRequest;
import org.apache.cocoon.environment.commandline.CommandLineResponse;

public class FileSavingEnvironment
extends AbstractCommandLineEnvironment {
    protected boolean modified = true;
    protected long sourceLastModified = 0L;

    public FileSavingEnvironment(String uri, long lastModified, File context, Map attributes, Map parameters, Map links, List gatheredLinks, CommandLineContext cliContext, OutputStream stream, Logger log) throws MalformedURLException {
        super(uri, null, context, stream, log);
        this.objectModel.put("request", new CommandLineRequest(this, null, uri, null, attributes, parameters));
        this.objectModel.put("response", new CommandLineResponse());
        this.objectModel.put("context", cliContext);
        this.sourceLastModified = lastModified;
        if (links != null) {
            this.objectModel.put("link", links);
        }
        if (gatheredLinks != null) {
            this.objectModel.put("link-collection", gatheredLinks);
        }
    }

    public FileSavingEnvironment(String uri, File context, Map attributes, Map parameters, Map links, List gatheredLinks, CommandLineContext cliContext, OutputStream stream, Logger log) throws MalformedURLException {
        this(uri, 0L, context, attributes, parameters, links, gatheredLinks, cliContext, stream, log);
    }

    public boolean isResponseModified(long cacheLastModified) {
        if (cacheLastModified != 0L) {
            return cacheLastModified / 1000L > this.sourceLastModified / 1000L;
        }
        return true;
    }

    public void setResponseIsNotModified() {
        this.modified = false;
    }

    public boolean isModified() {
        return this.modified;
    }
}

