/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value.svg;

import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.value.AbstractValueManager;
import org.apache.batik.css.engine.value.StringValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueConstants;
import org.apache.batik.css.engine.value.svg.SVGValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class ColorProfileManager
extends AbstractValueManager {
    public boolean isInheritedProperty() {
        return true;
    }

    public String getPropertyName() {
        return "color-profile";
    }

    public Value getDefaultValue() {
        return ValueConstants.AUTO_VALUE;
    }

    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case 12: {
                return ValueConstants.INHERIT_VALUE;
            }
            case 35: {
                String string = lexicalUnit.getStringValue().toLowerCase();
                if (string.equals("auto")) {
                    return ValueConstants.AUTO_VALUE;
                }
                if (string.equals("srgb")) {
                    return SVGValueConstants.SRGB_VALUE;
                }
                return new StringValue(21, string);
            }
            case 24: {
                return new StringValue(20, ColorProfileManager.resolveURI(cSSEngine.getCSSBaseURI(), lexicalUnit.getStringValue()));
            }
        }
        throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
    }

    public Value createStringValue(short s, String string, CSSEngine cSSEngine) throws DOMException {
        switch (s) {
            case 21: {
                String string2 = string.toLowerCase();
                if (string2.equals("auto")) {
                    return ValueConstants.AUTO_VALUE;
                }
                if (string2.equals("srgb")) {
                    return SVGValueConstants.SRGB_VALUE;
                }
                return new StringValue(21, string2);
            }
            case 20: {
                return new StringValue(20, ColorProfileManager.resolveURI(cSSEngine.getCSSBaseURI(), string));
            }
        }
        throw this.createInvalidStringTypeDOMException(s);
    }
}

