/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.logger.factory;

import javax.servlet.ServletContext;
import org.apache.avalon.excalibur.logger.factory.AbstractTargetFactory;
import org.apache.avalon.excalibur.logger.factory.FormatterFactory;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.ContextException;
import org.apache.log.LogTarget;
import org.apache.log.format.Formatter;
import org.apache.log.output.ServletOutputLogTarget;

public final class ServletTargetFactory
extends AbstractTargetFactory {
    public final LogTarget createTarget(Configuration configuration) throws ConfigurationException {
        ServletContext sctx;
        if (this.m_context == null) {
            throw new ConfigurationException("Context not available.");
        }
        String contextkey = this.m_configuration.getAttribute("context-key", "servlet-context");
        Configuration confFormat = configuration.getChild("format");
        Formatter formatter = this.getFormatter(confFormat);
        try {
            sctx = (ServletContext)this.m_context.get((Object)contextkey);
        }
        catch (ContextException ce) {
            throw new ConfigurationException("Cannot find ServletContext object in application context", (Throwable)ce);
        }
        return new ServletOutputLogTarget(sctx);
    }

    protected Formatter getFormatter(Configuration conf) {
        Formatter formatter = null;
        if (null != conf) {
            FormatterFactory formatterFactory = new FormatterFactory();
            formatter = formatterFactory.createFormatter(conf);
        }
        return formatter;
    }
}

