/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Map;
import org.apache.batik.ext.awt.g2d.AbstractGraphics2D;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.fop.datatypes.ColorSpace;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.FopImageException;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.FontState;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFFilter;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.render.ps.PSRenderer;

public class PSGraphics2D
extends AbstractGraphics2D {
    boolean standalone = false;
    protected PSRenderer psRenderer;
    protected FontState fontState;
    protected String currentFontName;
    protected int currentFontSize;
    protected int currentYPosition = 0;
    protected int currentXPosition = 0;
    PDFColor currentColour = new PDFColor(0, 0, 0);
    FontInfo fontInfo;
    private Graphics2D fmg;

    public PSGraphics2D(boolean textAsShapes, FontState fs, PSRenderer ren, String font, int size, int xpos, int ypos) {
        super(textAsShapes);
        BufferedImage bi = new BufferedImage(1, 1, 2);
        this.fmg = bi.createGraphics();
        this.psRenderer = ren;
        this.currentFontName = font;
        this.currentFontSize = size;
        this.currentYPosition = ypos;
        this.currentXPosition = xpos;
        this.fontState = fs;
    }

    public PSGraphics2D(boolean textAsShapes) {
        super(textAsShapes);
        BufferedImage bi = new BufferedImage(1, 1, 2);
        this.fmg = bi.createGraphics();
    }

    public void setGraphicContext(GraphicContext c) {
        this.gc = c;
    }

    public PSGraphics2D(PSGraphics2D g) {
        super((AbstractGraphics2D)g);
        BufferedImage bi = new BufferedImage(1, 1, 2);
        this.fmg = bi.createGraphics();
    }

    public Graphics create() {
        return new PSGraphics2D(this);
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        int width = img.getWidth(observer);
        int height = img.getHeight(observer);
        if (width == -1 || height == -1) {
            return false;
        }
        Dimension size = new Dimension(width, height);
        BufferedImage buf = this.buildBufferedImage(size);
        Graphics2D g = buf.createGraphics();
        g.setComposite(AlphaComposite.SrcOver);
        g.setBackground(new Color(1, 1, 1, 0));
        g.setPaint(new Color(1, 1, 1, 0));
        g.fillRect(0, 0, width, height);
        g.clip(new Rectangle(0, 0, buf.getWidth(), buf.getHeight()));
        if (!g.drawImage(img, 0, 0, observer)) {
            return false;
        }
        g.dispose();
        byte[] result = new byte[buf.getWidth() * buf.getHeight() * 3];
        byte[] mask = new byte[buf.getWidth() * buf.getHeight()];
        Raster raster = buf.getData();
        DataBuffer bd = raster.getDataBuffer();
        int count = 0;
        boolean maskpos = false;
        switch (bd.getDataType()) {
            case 3: {
                int[][] idata = ((DataBufferInt)bd).getBankData();
                int i = 0;
                while (i < idata.length) {
                    int j = 0;
                    while (j < idata[i].length) {
                        if ((idata[i][j] >> 24 & 0xFF) != 255) {
                            result[count++] = -1;
                            result[count++] = -1;
                            result[count++] = -1;
                        } else {
                            result[count++] = (byte)(idata[i][j] >> 16 & 0xFF);
                            result[count++] = (byte)(idata[i][j] >> 8 & 0xFF);
                            result[count++] = (byte)(idata[i][j] & 0xFF);
                        }
                        ++j;
                    }
                    ++i;
                }
                break;
            }
        }
        try {
            TempImage fopimg = new TempImage(width, height, result, mask);
            AffineTransform at = this.getTransform();
            double[] matrix = new double[6];
            at.getMatrix(matrix);
            this.psRenderer.write("gsave");
            Shape imclip = this.getClip();
            this.writeClip(imclip);
            this.psRenderer.write("1000 -1000 scale");
            this.psRenderer.renderBitmap(fopimg, x, -y, width, height);
            this.psRenderer.write("grestore");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public BufferedImage buildBufferedImage(Dimension size) {
        return new BufferedImage(size.width, size.height, 2);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        System.out.println("drawImage");
        return true;
    }

    public void dispose() {
        this.psRenderer = null;
        this.fontState = null;
        this.currentFontName = null;
        this.currentColour = null;
        this.fontInfo = null;
    }

    public void draw(Shape s) {
        this.psRenderer.write("gsave");
        Shape imclip = this.getClip();
        this.writeClip(imclip);
        Color c = this.getColor();
        this.psRenderer.write(c.getRed() + " " + c.getGreen() + " " + c.getBlue() + " setrgbcolor");
        this.applyPaint(this.getPaint(), false);
        this.applyStroke(this.getStroke());
        this.psRenderer.write("newpath");
        PathIterator iter = s.getPathIterator(this.getTransform());
        while (!iter.isDone()) {
            double[] vals = new double[6];
            int type = iter.currentSegment(vals);
            switch (type) {
                case 3: {
                    this.psRenderer.write(PDFNumber.doubleOut(1000.0 * vals[0]) + " " + PDFNumber.doubleOut(1000.0 * vals[1]) + " " + PDFNumber.doubleOut(1000.0 * vals[2]) + " " + PDFNumber.doubleOut(1000.0 * vals[3]) + " " + PDFNumber.doubleOut(1000.0 * vals[4]) + " " + PDFNumber.doubleOut(1000.0 * vals[5]) + " curveto");
                    break;
                }
                case 1: {
                    this.psRenderer.write(PDFNumber.doubleOut(1000.0 * vals[0]) + " " + PDFNumber.doubleOut(1000.0 * vals[1]) + " lineto");
                    break;
                }
                case 0: {
                    this.psRenderer.write(PDFNumber.doubleOut(1000.0 * vals[0]) + " " + PDFNumber.doubleOut(1000.0 * vals[1]) + " M");
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    this.psRenderer.write("closepath");
                    break;
                }
            }
            iter.next();
        }
        this.doDrawing(false, true, false);
        this.psRenderer.write("grestore");
    }

    protected void writeClip(Shape s) {
        PathIterator iter = s.getPathIterator(this.getTransform());
        this.psRenderer.write("newpath");
        while (!iter.isDone()) {
            double[] vals = new double[6];
            int type = iter.currentSegment(vals);
            switch (type) {
                case 3: {
                    this.psRenderer.write(PDFNumber.doubleOut(1000.0 * vals[0]) + " " + PDFNumber.doubleOut(1000.0 * vals[1]) + " " + PDFNumber.doubleOut(1000.0 * vals[2]) + " " + PDFNumber.doubleOut(1000.0 * vals[3]) + " " + PDFNumber.doubleOut(1000.0 * vals[4]) + " " + PDFNumber.doubleOut(1000.0 * vals[5]) + " curveto");
                    break;
                }
                case 1: {
                    this.psRenderer.write(PDFNumber.doubleOut(1000.0 * vals[0]) + " " + PDFNumber.doubleOut(1000.0 * vals[1]) + " lineto");
                    break;
                }
                case 0: {
                    this.psRenderer.write(PDFNumber.doubleOut(1000.0 * vals[0]) + " " + PDFNumber.doubleOut(1000.0 * vals[1]) + " M");
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    this.psRenderer.write("closepath");
                    break;
                }
            }
            iter.next();
        }
        this.psRenderer.write("clippath");
    }

    protected void applyPaint(Paint paint, boolean fill) {
        if (paint instanceof GradientPaint) {
            GradientPaint gp = (GradientPaint)paint;
            Color c1 = gp.getColor1();
            Color c2 = gp.getColor2();
            Point2D p1 = gp.getPoint1();
            Point2D p2 = gp.getPoint2();
            boolean cyclic = gp.isCyclic();
            ArrayList<Double> theCoords = new ArrayList<Double>();
            theCoords.add(new Double(p1.getX()));
            theCoords.add(new Double(p1.getY()));
            theCoords.add(new Double(p2.getX()));
            theCoords.add(new Double(p2.getY()));
            ArrayList<Boolean> theExtend = new ArrayList<Boolean>();
            theExtend.add(new Boolean(true));
            theExtend.add(new Boolean(true));
            ArrayList<Double> theDomain = new ArrayList<Double>();
            theDomain.add(new Double(0.0));
            theDomain.add(new Double(1.0));
            ArrayList<Double> theEncode = new ArrayList<Double>();
            theEncode.add(new Double(0.0));
            theEncode.add(new Double(1.0));
            theEncode.add(new Double(0.0));
            theEncode.add(new Double(1.0));
            ArrayList<Double> theBounds = new ArrayList<Double>();
            theBounds.add(new Double(0.0));
            theBounds.add(new Double(1.0));
            ArrayList theFunctions = new ArrayList();
            ArrayList<PDFColor> someColors = new ArrayList<PDFColor>();
            PDFColor color1 = new PDFColor(c1.getRed(), c1.getGreen(), c1.getBlue());
            someColors.add(color1);
            PDFColor color2 = new PDFColor(c2.getRed(), c2.getGreen(), c2.getBlue());
            someColors.add(color2);
            ColorSpace aColorSpace = new ColorSpace(2);
        } else if (paint instanceof TexturePaint) {
            // empty if block
        }
    }

    protected void applyStroke(Stroke stroke) {
        if (stroke instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)stroke;
            float[] da = bs.getDashArray();
            if (da != null) {
                this.psRenderer.write("[");
                int count = 0;
                while (count < da.length) {
                    this.psRenderer.write("" + 1000 * (int)da[count]);
                    if (count < da.length - 1) {
                        this.psRenderer.write(" ");
                    }
                    ++count;
                }
                this.psRenderer.write("] ");
                float offset = bs.getDashPhase();
                this.psRenderer.write(1000 * (int)offset + " setdash");
            }
            int ec = bs.getEndCap();
            switch (ec) {
                case 0: {
                    this.psRenderer.write("0 setlinecap");
                    break;
                }
                case 1: {
                    this.psRenderer.write("1 setlinecap");
                    break;
                }
                case 2: {
                    this.psRenderer.write("2 setlinecap");
                }
            }
            int lj = bs.getLineJoin();
            switch (lj) {
                case 0: {
                    this.psRenderer.write("0 setlinejoin");
                    break;
                }
                case 1: {
                    this.psRenderer.write("1 setlinejoin");
                    break;
                }
                case 2: {
                    this.psRenderer.write("2 setlinejoin");
                }
            }
            float lw = bs.getLineWidth();
            this.psRenderer.write(PDFNumber.doubleOut(1000.0f * lw) + " setlinewidth");
            float ml = bs.getMiterLimit();
            this.psRenderer.write(PDFNumber.doubleOut(1000.0f * ml) + " setmiterlimit");
        }
    }

    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        System.out.println("drawRenderedImage");
    }

    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        System.out.println("drawRenderableImage");
    }

    public void drawString(String s, float x, float y) {
        System.out.println("drawString(String)");
        this.psRenderer.write("BT");
        Shape imclip = this.getClip();
        this.writeClip(imclip);
        Color c = this.getColor();
        this.psRenderer.write(c.getRed() + " " + c.getGreen() + " " + c.getBlue() + " setrgbcolor");
        AffineTransform trans = this.getTransform();
        trans.translate(x, y);
        double[] vals = new double[6];
        trans.getMatrix(vals);
        this.psRenderer.write(PDFNumber.doubleOut(vals[0]) + " " + PDFNumber.doubleOut(vals[1]) + " " + PDFNumber.doubleOut(vals[2]) + " " + PDFNumber.doubleOut(vals[3]) + " " + PDFNumber.doubleOut(vals[4]) + " " + PDFNumber.doubleOut(vals[5]) + " " + PDFNumber.doubleOut(vals[6]) + " Tm [" + s + "]");
        this.psRenderer.write("ET");
    }

    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        System.err.println("drawString(AttributedCharacterIterator)");
        this.psRenderer.write("BT");
        Shape imclip = this.getClip();
        this.writeClip(imclip);
        Color c = this.getColor();
        this.currentColour = new PDFColor(c.getRed(), c.getGreen(), c.getBlue());
        this.psRenderer.write(this.currentColour.getColorSpaceOut(true));
        c = this.getBackground();
        PDFColor col = new PDFColor(c.getRed(), c.getGreen(), c.getBlue());
        this.psRenderer.write(col.getColorSpaceOut(false));
        AffineTransform trans = this.getTransform();
        trans.translate(x, y);
        double[] vals = new double[6];
        trans.getMatrix(vals);
        char ch = iterator.first();
        while (ch != '\uffff') {
            Map<AttributedCharacterIterator.Attribute, Object> attr = iterator.getAttributes();
            this.psRenderer.write(PDFNumber.doubleOut(vals[0]) + " " + PDFNumber.doubleOut(vals[1]) + " " + PDFNumber.doubleOut(vals[2]) + " " + PDFNumber.doubleOut(vals[3]) + " " + PDFNumber.doubleOut(vals[4]) + " " + PDFNumber.doubleOut(vals[5]) + " " + PDFNumber.doubleOut(vals[6]) + " Tm [" + ch + "]");
            ch = iterator.next();
        }
        this.psRenderer.write("ET");
    }

    public void fill(Shape s) {
        this.psRenderer.write("gsave");
        Shape imclip = this.getClip();
        this.writeClip(imclip);
        Color c = this.getColor();
        this.psRenderer.write(c.getRed() + " " + c.getGreen() + " " + c.getBlue() + " setrgbcolor");
        this.applyPaint(this.getPaint(), true);
        this.psRenderer.write("newpath");
        PathIterator iter = s.getPathIterator(this.getTransform());
        while (!iter.isDone()) {
            double[] vals = new double[6];
            int type = iter.currentSegment(vals);
            switch (type) {
                case 3: {
                    this.psRenderer.write(PDFNumber.doubleOut(1000.0 * vals[0]) + " " + PDFNumber.doubleOut(1000.0 * vals[1]) + " " + PDFNumber.doubleOut(1000.0 * vals[2]) + " " + PDFNumber.doubleOut(1000.0 * vals[3]) + " " + PDFNumber.doubleOut(1000.0 * vals[4]) + " " + PDFNumber.doubleOut(1000.0 * vals[5]) + " curveto");
                    break;
                }
                case 1: {
                    this.psRenderer.write(PDFNumber.doubleOut(1000.0 * vals[0]) + " " + PDFNumber.doubleOut(1000.0 * vals[1]) + " lineto");
                    break;
                }
                case 0: {
                    this.psRenderer.write(PDFNumber.doubleOut(1000.0 * vals[0]) + " " + PDFNumber.doubleOut(1000.0 * vals[1]) + " M");
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    this.psRenderer.write("closepath");
                    break;
                }
            }
            iter.next();
        }
        this.doDrawing(true, false, iter.getWindingRule() == 0);
        this.psRenderer.write("grestore");
    }

    protected void doDrawing(boolean fill, boolean stroke, boolean nonzero) {
        if (fill) {
            if (stroke) {
                if (!nonzero) {
                    this.psRenderer.write("stroke");
                } else {
                    this.psRenderer.write("stroke");
                }
            } else if (!nonzero) {
                this.psRenderer.write("fill");
            } else {
                this.psRenderer.write("fill");
            }
        } else {
            this.psRenderer.write("stroke");
        }
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    public FontMetrics getFontMetrics(Font f) {
        return this.fmg.getFontMetrics(f);
    }

    public void setXORMode(Color c1) {
        System.out.println("setXORMode");
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        System.out.println("copyArea");
    }

    class TempImage
    implements FopImage {
        int m_height;
        int m_width;
        int m_bitsPerPixel;
        ColorSpace m_colorSpace;
        int m_bitmapSiye;
        byte[] m_bitmaps;
        byte[] m_mask;
        PDFColor transparent = new PDFColor(255, 255, 255);

        TempImage(int width, int height, byte[] result, byte[] mask) throws FopImageException {
            this.m_height = height;
            this.m_width = width;
            this.m_bitsPerPixel = 8;
            this.m_colorSpace = new ColorSpace(2);
            this.m_bitmaps = result;
            this.m_mask = mask;
        }

        public boolean invertImage() {
            return false;
        }

        public String getURL() {
            return "" + this.m_bitmaps;
        }

        public int getWidth() throws FopImageException {
            return this.m_width;
        }

        public int getHeight() throws FopImageException {
            return this.m_height;
        }

        public ColorSpace getColorSpace() throws FopImageException {
            return this.m_colorSpace;
        }

        public int getBitsPerPixel() throws FopImageException {
            return this.m_bitsPerPixel;
        }

        public boolean isTransparent() throws FopImageException {
            return this.transparent != null;
        }

        public PDFColor getTransparentColor() throws FopImageException {
            return this.transparent;
        }

        public byte[] getMask() throws FopImageException {
            return this.m_mask;
        }

        public byte[] getBitmaps() throws FopImageException {
            return this.m_bitmaps;
        }

        public int getBitmapsSize() throws FopImageException {
            return this.m_width * this.m_height * 3;
        }

        public byte[] getRessourceBytes() throws FopImageException {
            return null;
        }

        public int getRessourceBytesSize() throws FopImageException {
            return 0;
        }

        public PDFFilter getPDFFilter() throws FopImageException {
            return null;
        }

        public void close() {
        }
    }
}

