/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.url.URLFactory;
import org.apache.cocoon.util.ClassUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceFactory;
import org.apache.excalibur.source.impl.URLSource;

public final class URLFactoryWrapper
extends AbstractLogEnabled
implements SourceFactory,
ThreadSafe,
Configurable,
Disposable,
Composable,
Contextualizable {
    private ComponentManager manager;
    private URLFactory urlFactory;
    private Context context;

    public void configure(Configuration conf) throws ConfigurationException {
        try {
            Configuration factoryConf = conf.getChild("url-factory");
            String className = factoryConf.getAttribute("class");
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Getting the URLFactory " + className);
            }
            this.urlFactory = (URLFactory)ClassUtils.newInstance((String)className);
            this.init(this.urlFactory, factoryConf);
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException("Could not get parameters because: " + e.getMessage(), (Throwable)e);
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
    }

    public void dispose() {
        if (this.urlFactory != null) {
            this.deinit(this.urlFactory);
        }
        this.urlFactory = null;
    }

    public Source getSource(String location, Map parameters) throws MalformedURLException, IOException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Creating source object for " + location);
        }
        int protocolPos = location.indexOf("://");
        URL url = this.urlFactory.getURL(location.substring(protocolPos + 3));
        URLSource source = new URLSource();
        source.init(url, parameters);
        return source;
    }

    private void init(URLFactory factory, Configuration config) throws ContextException, ComponentException, ConfigurationException {
        if (factory instanceof LogEnabled) {
            ((LogEnabled)factory).enableLogging(this.getLogger());
        }
        if (factory instanceof Contextualizable) {
            ((Contextualizable)factory).contextualize(this.context);
        }
        if (factory instanceof Composable) {
            ((Composable)factory).compose(this.manager);
        }
        if (config != null && factory instanceof Configurable) {
            ((Configurable)factory).configure(config);
        }
    }

    private void deinit(URLFactory factory) {
        if (factory instanceof Disposable) {
            ((Disposable)factory).dispose();
        }
    }

    public void release(Source source) {
        if (null != source && this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Releasing source " + source.getURI());
        }
    }
}

