/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.store;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.store.Store;
import org.apache.cocoon.components.store.StoreJanitor;
import org.apache.cocoon.util.ClassUtils;
import org.apache.cocoon.util.MRUBucketMap;

public final class MRUMemoryStore
extends AbstractLogEnabled
implements Store,
Parameterizable,
Composable,
Disposable,
ThreadSafe {
    private int maxobjects;
    private boolean persistent;
    protected MRUBucketMap cache;
    private Store persistentStore;
    private StoreJanitor storeJanitor;
    private ComponentManager manager;

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Looking up org.apache.cocoon.components.store.Store/PersistentCache");
            this.getLogger().debug("Looking up org.apache.cocoon.components.store.StoreJanitor");
        }
        this.persistentStore = (Store)manager.lookup("org.apache.cocoon.components.store.Store/PersistentCache");
        this.storeJanitor = (StoreJanitor)manager.lookup("org.apache.cocoon.components.store.StoreJanitor");
    }

    public void parameterize(Parameters params) throws ParameterException {
        this.maxobjects = params.getParameterAsInteger("maxobjects", 100);
        this.persistent = params.getParameterAsBoolean("use-persistent-cache", false);
        if (this.maxobjects < 1) {
            throw new ParameterException("MRUMemoryStore maxobjects must be at least 1!");
        }
        this.cache = new MRUBucketMap((int)((double)this.maxobjects * 1.2));
        this.storeJanitor.register(this);
    }

    public void dispose() {
        if (this.manager != null) {
            this.getLogger().debug("Disposing component!");
            if (this.storeJanitor != null) {
                this.storeJanitor.unregister(this);
            }
            this.manager.release((Component)this.storeJanitor);
            this.storeJanitor = null;
            if (this.persistent) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Final cache size: " + this.cache.size());
                }
                Iterator i = this.cache.keySet().iterator();
                while (i.hasNext()) {
                    Object key = i.next();
                    try {
                        Object value = this.cache.remove(key);
                        if (!this.checkSerializable(value)) continue;
                        this.persistentStore.store(this.getFileName(key.toString()), value);
                    }
                    catch (IOException ioe) {
                        this.getLogger().error("Error in dispose()", (Throwable)ioe);
                    }
                }
            }
            this.manager.release((Component)this.persistentStore);
            this.persistentStore = null;
        }
        this.manager = null;
    }

    public void store(Object key, Object value) {
        this.hold(key, value);
    }

    public void hold(Object key, Object value) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Holding object in memory:");
            this.getLogger().debug("  key: " + key);
            this.getLogger().debug("  value: " + value);
        }
        while (this.cache.size() >= this.maxobjects) {
            this.free();
        }
        this.cache.put(key, value);
    }

    public Object get(Object key) {
        Object value = this.cache.get(key);
        if (value != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Found key: " + key.toString());
            }
            return value;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("NOT Found key: " + key.toString());
        }
        if (this.persistent && (value = this.persistentStore.get(this.getFileName(key.toString()))) != null) {
            try {
                this.hold(key, value);
                return value;
            }
            catch (Exception e) {
                this.getLogger().error("Error in hold()!", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public void remove(Object key) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Removing object from store");
            this.getLogger().debug("  key: " + key);
        }
        this.cache.remove(key);
        if (this.persistent && key != null) {
            this.persistentStore.remove(this.getFileName(key.toString()));
        }
    }

    public boolean containsKey(Object key) {
        return this.cache.containsKey(key) || this.persistent && this.persistentStore.containsKey(key);
    }

    public Enumeration keys() {
        return new Enumeration(){
            private Iterator i;
            {
                this.i = MRUMemoryStore.this.cache.keySet().iterator();
            }

            public boolean hasMoreElements() {
                return this.i.hasNext();
            }

            public Object nextElement() {
                return this.i.next();
            }
        };
    }

    public int size() {
        return this.cache.size();
    }

    public void free() {
        try {
            if (this.cache.size() > 0) {
                Map.Entry node = this.cache.removeLast();
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Freeing cache.");
                    this.getLogger().debug("  key: " + node.getKey());
                    this.getLogger().debug("  value: " + node.getValue());
                }
                if (this.persistent && this.checkSerializable(node.getValue())) {
                    try {
                        this.persistentStore.store(this.getFileName(node.getKey().toString()), node.getValue());
                    }
                    catch (Exception e) {
                        this.getLogger().error("Error storing object on fs", (Throwable)e);
                    }
                }
            }
        }
        catch (NoSuchElementException e) {
            this.getLogger().warn("Concurrency error in free()", (Throwable)e);
        }
        catch (Exception e) {
            this.getLogger().error("Error in free()", (Throwable)e);
        }
    }

    private boolean checkSerializable(Object object) {
        if (object == null) {
            return false;
        }
        try {
            String clazz = object.getClass().getName();
            return clazz.equals("org.apache.cocoon.caching.CachedEventObject") || clazz.equals("org.apache.cocoon.caching.CachedStreamObject") || ClassUtils.implementsInterface((String)clazz, (String)"org.apache.cocoon.caching.CacheValidity");
        }
        catch (Exception e) {
            this.getLogger().error("Error in checkSerializable()!", (Throwable)e);
            return false;
        }
    }

    private String getFileName(String key) {
        return URLEncoder.encode(key.toString());
    }
}

