/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.event.impl;

import EDU.oswego.cs.dl.util.concurrent.ReentrantLock;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.UnboundedFifoBuffer;
import org.apache.excalibur.event.EnqueuePredicate;
import org.apache.excalibur.event.PreparedEnqueue;
import org.apache.excalibur.event.Sink;
import org.apache.excalibur.event.SinkException;
import org.apache.excalibur.event.SinkFullException;
import org.apache.excalibur.event.Source;
import org.apache.excalibur.event.impl.AbstractQueue;
import org.apache.excalibur.event.impl.NullEnqueuePredicate;
import org.apache.excalibur.event.impl.ThresholdEnqueuePredicate;

public final class DefaultQueue
extends AbstractQueue {
    private final Buffer m_elements;
    private final ReentrantLock m_mutex;
    protected int m_reserve;
    private final int m_maxSize;

    public DefaultQueue(int size) {
        this(new ThresholdEnqueuePredicate(size));
    }

    public DefaultQueue(EnqueuePredicate predicate) {
        this.setEnqueuePredicate(predicate);
        this.m_mutex = new ReentrantLock();
        this.m_elements = new UnboundedFifoBuffer();
        this.m_reserve = 0;
        this.m_maxSize = -1;
    }

    public DefaultQueue() {
        this(new NullEnqueuePredicate());
    }

    public int size() {
        return this.m_elements.size() + this.m_reserve;
    }

    public int maxSize() {
        return this.m_maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedEnqueue prepareEnqueue(Object[] elements) throws SinkException {
        DefaultPreparedEnqueue enqueue;
        block5: {
            enqueue = null;
            try {
                this.m_mutex.acquire();
                try {
                    if (!this.getEnqueuePredicate().accept(elements, (Sink)this)) {
                        throw new SinkFullException("Not enough room to enqueue these elements.");
                    }
                    enqueue = new DefaultPreparedEnqueue(this, elements);
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    this.m_mutex.release();
                    throw throwable;
                }
                this.m_mutex.release();
                {
                }
            }
            catch (InterruptedException ie) {
                if (null != enqueue) break block5;
                throw new SinkException("The mutex was interrupted before it could be released");
            }
        }
        return enqueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryEnqueue(Object element) {
        boolean success = false;
        try {
            this.m_mutex.acquire();
            try {
                success = this.getEnqueuePredicate().accept(element, (Sink)this);
                if (success) {
                    this.m_elements.add(element);
                }
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.m_mutex.release();
                throw throwable;
            }
            this.m_mutex.release();
            {
            }
        }
        catch (InterruptedException ie) {}
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Object[] elements) throws SinkException {
        int len = elements.length;
        try {
            this.m_mutex.acquire();
            try {
                if (!this.getEnqueuePredicate().accept(elements, (Sink)this)) {
                    throw new SinkFullException("Not enough room to enqueue these elements.");
                }
                int i = 0;
                while (i < len) {
                    this.m_elements.add(elements[i]);
                    ++i;
                }
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.m_mutex.release();
                throw throwable;
            }
            this.m_mutex.release();
            {
            }
        }
        catch (InterruptedException ie) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Object element) throws SinkException {
        try {
            this.m_mutex.acquire();
            try {
                if (!this.getEnqueuePredicate().accept(element, (Sink)this)) {
                    throw new SinkFullException("Not enough room to enqueue these elements.");
                }
                this.m_elements.add(element);
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.m_mutex.release();
                throw throwable;
            }
            this.m_mutex.release();
            {
            }
        }
        catch (InterruptedException ie) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] dequeue(int numElements) {
        Object[] elements;
        block4: {
            this.getDequeueInterceptor().before((Source)this);
            elements = AbstractQueue.EMPTY_ARRAY;
            try {
                if (!this.m_mutex.attempt(this.m_timeout)) break block4;
                try {
                    elements = DefaultQueue.retrieveElements(this.m_elements, Math.min(this.size(), numElements));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    this.m_mutex.release();
                    throw throwable;
                }
                this.m_mutex.release();
                {
                }
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        this.getDequeueInterceptor().after((Source)this);
        return elements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] dequeueAll() {
        Object[] elements;
        block4: {
            this.getDequeueInterceptor().before((Source)this);
            elements = AbstractQueue.EMPTY_ARRAY;
            try {
                if (!this.m_mutex.attempt(this.m_timeout)) break block4;
                try {
                    elements = DefaultQueue.retrieveElements(this.m_elements, this.size());
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.m_mutex.release();
                    throw throwable;
                }
                this.m_mutex.release();
                {
                }
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        this.getDequeueInterceptor().after((Source)this);
        return elements;
    }

    private static Object[] retrieveElements(Buffer buf, int count) {
        Object[] elements = new Object[count];
        int i = 0;
        while (i < count) {
            elements[i] = buf.remove();
            ++i;
        }
        return elements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object dequeue() {
        Object element;
        block5: {
            this.getDequeueInterceptor().before((Source)this);
            element = null;
            try {
                if (!this.m_mutex.attempt(this.m_timeout)) break block5;
                try {
                    if (this.size() > 0) {
                        element = this.m_elements.remove();
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.m_mutex.release();
                    throw throwable;
                }
                this.m_mutex.release();
                {
                }
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        this.getDequeueInterceptor().after((Source)this);
        return element;
    }

    private static final class DefaultPreparedEnqueue
    implements PreparedEnqueue {
        private final DefaultQueue m_parent;
        private Object[] m_elements;

        private DefaultPreparedEnqueue(DefaultQueue parent, Object[] elements) {
            this.m_parent = parent;
            this.m_elements = elements;
            this.m_parent.m_reserve += elements.length;
        }

        public void commit() {
            if (null == this.m_elements) {
                throw new IllegalStateException("This PreparedEnqueue has already been processed!");
            }
            try {
                this.m_parent.m_reserve -= this.m_elements.length;
                this.m_parent.enqueue(this.m_elements);
                this.m_elements = null;
            }
            catch (Exception e) {
                throw new IllegalStateException("Default enqueue did not happen--should be impossible");
            }
        }

        public void abort() {
            if (null == this.m_elements) {
                throw new IllegalStateException("This PreparedEnqueue has already been processed!");
            }
            this.m_parent.m_reserve -= this.m_elements.length;
            this.m_elements = null;
        }
    }
}

