/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.Member;
import org.eclipse.jdt.internal.core.Util;

class Initializer
extends Member
implements IInitializer {
    protected Initializer(IType parent, int occurrenceCount) {
        super(10, parent, "");
        if (occurrenceCount <= 0) {
            throw new IllegalArgumentException();
        }
        this.fOccurrenceCount = occurrenceCount;
    }

    protected boolean equalsDOMNode(IDOMNode node) throws JavaModelException {
        if (node.getNodeType() == 7) {
            return node.getContents().trim().equals(this.getSource());
        }
        return false;
    }

    public String getHandleMemento() {
        StringBuffer buff = new StringBuffer(((JavaElement)this.getParent()).getHandleMemento());
        buff.append(this.getHandleMementoDelimiter());
        buff.append(this.fOccurrenceCount);
        return buff.toString();
    }

    protected char getHandleMementoDelimiter() {
        return '|';
    }

    public int hashCode() {
        return Util.combineHashCodes(this.fParent.hashCode(), this.fOccurrenceCount);
    }

    public String readableName() {
        return ((JavaElement)((Object)this.getDeclaringType())).readableName();
    }

    public void rename(String name, boolean force, IProgressMonitor monitor) throws JavaModelException {
        throw new JavaModelException(new JavaModelStatus(967, this));
    }

    public ISourceRange getNameRange() throws JavaModelException {
        return null;
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info) {
        buffer.append(this.tabString(tab));
        if (info == null) {
            buffer.append("<initializer>");
            buffer.append(" (not open)");
        } else if (info == JavaElement.NO_INFO) {
            buffer.append(this.getElementName());
        } else {
            try {
                if (Flags.isStatic(this.getFlags())) {
                    buffer.append("static ");
                }
                buffer.append("initializer");
            }
            catch (JavaModelException javaModelException) {
                buffer.append("<JavaModelException in toString of " + this.getElementName());
            }
        }
    }
}

