/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.core.index.IEntryResult;
import org.eclipse.jdt.internal.core.index.impl.IndexInput;
import org.eclipse.jdt.internal.core.index.impl.IndexedFile;
import org.eclipse.jdt.internal.core.search.IIndexSearchRequestor;
import org.eclipse.jdt.internal.core.search.indexing.AbstractIndexer;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.jdt.internal.core.search.matching.MethodDeclarationPattern;

public class ConstructorDeclarationPattern
extends MethodDeclarationPattern {
    private char[] decodedTypeName;

    public ConstructorDeclarationPattern(char[] declaringSimpleName, int matchMode, boolean isCaseSensitive, char[] declaringQualification, char[][] parameterQualifications, char[][] parameterSimpleNames) {
        super(null, matchMode, isCaseSensitive, declaringQualification, declaringSimpleName, null, null, parameterQualifications, parameterSimpleNames);
    }

    public void decodeIndexEntry(IEntryResult entryResult) {
        char[] word = entryResult.getWord();
        int size = word.length;
        int lastSeparatorIndex = CharOperation.lastIndexOf('/', word);
        this.decodedParameterCount = Integer.parseInt(new String(word, lastSeparatorIndex + 1, size - lastSeparatorIndex - 1));
        this.decodedTypeName = CharOperation.subarray(word, IIndexConstants.CONSTRUCTOR_DECL.length, lastSeparatorIndex);
    }

    public void feedIndexRequestor(IIndexSearchRequestor requestor, int detailLevel, int[] references, IndexInput input, IJavaSearchScope scope) throws IOException {
        int i = 0;
        int max = references.length;
        while (i < max) {
            String path;
            IndexedFile file = input.getIndexedFile(references[i]);
            if (file != null && scope.encloses(path = IndexedFile.convertPath(file.getPath()))) {
                requestor.acceptConstructorDeclaration(path, this.decodedTypeName, this.decodedParameterCount);
            }
            ++i;
        }
    }

    public char[] indexEntryPrefix() {
        return AbstractIndexer.bestConstructorDeclarationPrefix(this.declaringSimpleName, this.parameterSimpleNames == null ? -1 : this.parameterSimpleNames.length, this.matchMode, this.isCaseSensitive);
    }

    public boolean matchesBinary(Object binaryInfo, Object enclosingBinaryInfo) {
        int parameterCount;
        if (!(binaryInfo instanceof IBinaryMethod)) {
            return false;
        }
        IBinaryMethod method = (IBinaryMethod)binaryInfo;
        if (!method.isConstructor()) {
            return false;
        }
        IBinaryType declaringType = (IBinaryType)enclosingBinaryInfo;
        if (declaringType != null) {
            char[] declaringTypeName = (char[])declaringType.getName().clone();
            CharOperation.replace(declaringTypeName, '/', '.');
            if (!this.matchesType(this.declaringSimpleName, this.declaringQualification, declaringTypeName)) {
                return false;
            }
        }
        int n = parameterCount = this.parameterSimpleNames == null ? -1 : this.parameterSimpleNames.length;
        if (parameterCount > -1) {
            String methodDescriptor = new String(method.getMethodDescriptor()).replace('/', '.');
            String[] arguments = Signature.getParameterTypes(methodDescriptor);
            int argumentCount = arguments.length;
            if (parameterCount != argumentCount) {
                return false;
            }
            int i = 0;
            while (i < parameterCount) {
                char[] type = this.parameterSimpleNames[i];
                char[] qualification = this.parameterQualifications[i];
                if (!this.matchesType(type, qualification, Signature.toString(arguments[i]).toCharArray())) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    protected boolean matchIndexEntry() {
        if (this.declaringSimpleName != null) {
            switch (this.matchMode) {
                case 0: {
                    if (CharOperation.equals(this.declaringSimpleName, this.decodedTypeName, this.isCaseSensitive)) break;
                    return false;
                }
                case 1: {
                    if (CharOperation.prefixEquals(this.declaringSimpleName, this.decodedTypeName, this.isCaseSensitive)) break;
                    return false;
                }
                case 2: {
                    if (CharOperation.match(this.declaringSimpleName, this.decodedTypeName, this.isCaseSensitive)) break;
                    return false;
                }
            }
        }
        return this.parameterSimpleNames == null || this.parameterSimpleNames.length == this.decodedParameterCount;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        buffer.append("ConstructorDeclarationPattern: ");
        if (this.declaringQualification != null) {
            buffer.append(this.declaringQualification).append('.');
        }
        if (this.declaringSimpleName != null) {
            buffer.append(this.declaringSimpleName);
        } else if (this.declaringQualification != null) {
            buffer.append("*");
        }
        buffer.append('(');
        if (this.parameterSimpleNames == null) {
            buffer.append("...");
        } else {
            int i = 0;
            int max = this.parameterSimpleNames.length;
            while (i < max) {
                if (i > 0) {
                    buffer.append(", ");
                }
                if (this.parameterQualifications[i] != null) {
                    buffer.append(this.parameterQualifications[i]).append('.');
                }
                if (this.parameterSimpleNames[i] == null) {
                    buffer.append('*');
                } else {
                    buffer.append(this.parameterSimpleNames[i]);
                }
                ++i;
            }
        }
        buffer.append(')');
        buffer.append(", ");
        switch (this.matchMode) {
            case 0: {
                buffer.append("exact match, ");
                break;
            }
            case 1: {
                buffer.append("prefix match, ");
                break;
            }
            case 2: {
                buffer.append("pattern match, ");
            }
        }
        if (this.isCaseSensitive) {
            buffer.append("case sensitive");
        } else {
            buffer.append("case insensitive");
        }
        return buffer.toString();
    }

    public int matchLevel(AstNode node, boolean resolve) {
        int parameterCount;
        if (!(node instanceof ConstructorDeclaration)) {
            return 0;
        }
        ConstructorDeclaration constructor = (ConstructorDeclaration)node;
        if (resolve) {
            return this.matchLevel(constructor.binding);
        }
        if (this.declaringSimpleName != null && !this.matchesName(this.declaringSimpleName, constructor.selector)) {
            return 0;
        }
        int n = parameterCount = this.parameterSimpleNames == null ? -1 : this.parameterSimpleNames.length;
        if (parameterCount > -1) {
            int argumentCount;
            int n2 = argumentCount = constructor.arguments == null ? 0 : constructor.arguments.length;
            if (parameterCount != argumentCount) {
                return 0;
            }
        }
        return this.needsResolve ? 1 : 2;
    }

    public int matchLevel(Binding binding) {
        int parameterCount;
        if (binding == null) {
            return 3;
        }
        if (!(binding instanceof MethodBinding)) {
            return 0;
        }
        MethodBinding constructor = (MethodBinding)binding;
        if (!constructor.isConstructor()) {
            return 0;
        }
        ReferenceBinding declaringType = constructor.declaringClass;
        int level = !constructor.isStatic() && !constructor.isPrivate() ? this.matchLevelAsSubtype(declaringType, this.declaringSimpleName, this.declaringQualification) : this.matchLevelForType(this.declaringSimpleName, this.declaringQualification, declaringType);
        if (level == 0) {
            return 0;
        }
        int n = parameterCount = this.parameterSimpleNames == null ? -1 : this.parameterSimpleNames.length;
        if (parameterCount > -1) {
            int argumentCount;
            int n2 = argumentCount = constructor.parameters == null ? 0 : constructor.parameters.length;
            if (parameterCount != argumentCount) {
                return 0;
            }
            int i = 0;
            while (i < parameterCount) {
                char[] qualification = this.parameterQualifications[i];
                char[] type = this.parameterSimpleNames[i];
                int newLevel = this.matchLevelForType(type, qualification, constructor.parameters[i]);
                switch (newLevel) {
                    case 0: {
                        return 0;
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        level = newLevel;
                    }
                }
                ++i;
            }
        }
        return level;
    }
}

