/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import org.apache.batik.bridge.AbstractSVGBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.gvt.text.TextPath;
import org.apache.batik.parser.AWTPathProducer;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PathHandler;
import org.apache.batik.parser.PathParser;
import org.apache.batik.parser.UnitProcessor;
import org.w3c.dom.Element;

public class SVGTextPathElementBridge
extends AbstractSVGBridge
implements ErrorConstants {
    public String getLocalName() {
        return "textPath";
    }

    public TextPath createTextPath(BridgeContext bridgeContext, Element element) {
        Object object;
        String string = XLinkSupport.getXLinkHref(element);
        Element element2 = bridgeContext.getReferencedElement(element, string);
        if (element2 == null || !element2.getTagName().equals("path")) {
            throw new BridgeException(element, "uri.badTarget", new Object[]{string});
        }
        String string2 = element2.getAttributeNS(null, "d");
        Shape shape = null;
        if (string2.length() != 0) {
            object = new AWTPathProducer();
            ((AWTPathProducer)object).setWindingRule(CSSUtilities.convertFillRule(element2));
            try {
                PathParser pathParser = new PathParser();
                pathParser.setPathHandler((PathHandler)object);
                pathParser.parse(string2);
            }
            catch (ParseException parseException) {
                throw new BridgeException(element2, "attribute.malformed", new Object[]{"d"});
            }
            finally {
                shape = ((AWTPathProducer)object).getShape();
            }
        } else {
            throw new BridgeException(element2, "attribute.missing", new Object[]{"d"});
        }
        string2 = element2.getAttributeNS(null, "transform");
        if (string2.length() != 0) {
            object = SVGUtilities.convertTransform(element2, "transform", string2);
            shape = ((AffineTransform)object).createTransformedShape(shape);
        }
        object = new TextPath(new GeneralPath(shape));
        string2 = element.getAttributeNS(null, "startOffset");
        if (string2.length() > 0) {
            float f = 0.0f;
            int n = string2.indexOf("%");
            if (n != -1) {
                float f2 = ((TextPath)object).lengthOfPath();
                String string3 = string2.substring(0, n);
                float f3 = 0.0f;
                try {
                    f3 = SVGUtilities.convertSVGNumber(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    f3 = -1.0f;
                }
                if (f3 < 0.0f) {
                    throw new BridgeException(element, "attribute.malformed", new Object[]{"startOffset", string2});
                }
                f = (float)((double)(f3 * f2) / 100.0);
            } else {
                UnitProcessor.Context context = UnitProcessor.createContext(bridgeContext, element);
                f = UnitProcessor.svgOtherLengthToUserSpace(string2, "startOffset", context);
            }
            ((TextPath)object).setStartOffset(f);
        }
        return object;
    }
}

