/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.xml.xpath;

import java.util.ArrayList;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.xpath.StandaloneContext;
import net.sf.saxon.xpath.XPathException;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.excalibur.xml.xpath.AbstractProcessorImpl;
import org.apache.excalibur.xml.xpath.NodeListImpl;
import org.apache.excalibur.xml.xpath.PrefixResolver;
import org.apache.excalibur.xml.xpath.XPathProcessor;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Saxon7ProcessorImpl
extends AbstractProcessorImpl
implements XPathProcessor,
Component,
ThreadSafe {
    private static final TransformerFactory factory = new TransformerFactoryImpl();

    public boolean evaluateAsBoolean(Node contextNode, String str, PrefixResolver resolver) {
        try {
            Item item = this.evaluateSingle(contextNode, str, resolver);
            if (item == null) {
                return false;
            }
            if (item.getItemType() == 102) {
                return ((BooleanValue)item).getValue();
            }
            return Boolean.valueOf(item.getStringValue());
        }
        catch (Exception e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Failed to evaluate '" + str + "'", (Throwable)e);
            }
            return false;
        }
    }

    public Number evaluateAsNumber(Node contextNode, String str, PrefixResolver resolver) {
        try {
            Item item = this.evaluateSingle(contextNode, str, resolver);
            if (item == null) {
                return null;
            }
            if (item.getItemType() == 91) {
                return new Double(((DoubleValue)item).getValue());
            }
            return Double.valueOf(item.getStringValue());
        }
        catch (Exception e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Failed to evaluate '" + str + "'", (Throwable)e);
            }
            return null;
        }
    }

    public String evaluateAsString(Node contextNode, String str, PrefixResolver resolver) {
        try {
            Item item = this.evaluateSingle(contextNode, str, resolver);
            if (item == null) {
                return null;
            }
            return item.getStringValue();
        }
        catch (Exception e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Failed to evaluate '" + str + "'", (Throwable)e);
            }
            return null;
        }
    }

    public Node selectSingleNode(Node contextNode, String str, PrefixResolver resolver) {
        try {
            Item item = this.evaluateSingle(contextNode, str, resolver);
            return (Node)item;
        }
        catch (Exception e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Failed to evaluate '" + str + "'", (Throwable)e);
            }
            return null;
        }
    }

    public NodeList selectNodeList(Node contextNode, String str, PrefixResolver resolver) {
        try {
            SequenceIterator iterator = this.evaluate(contextNode, str, resolver);
            ArrayList<Node> nodes = new ArrayList<Node>();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.current();
                nodes.add(node);
            }
            return new NodeListImpl((Node[])nodes.toArray());
        }
        catch (Exception e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Failed to evaluate '" + str + "'", (Throwable)e);
            }
            return null;
        }
    }

    private Item evaluateSingle(Node contextNode, String str, PrefixResolver resolver) {
        try {
            SequenceIterator iterator = this.evaluate(contextNode, str, resolver);
            if (iterator == null) {
                return null;
            }
            return iterator.current();
        }
        catch (Exception e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Failed to evaluate '" + str + "'", (Throwable)e);
            }
            return null;
        }
    }

    private SequenceIterator evaluate(Node contextNode, String str, PrefixResolver resolver) {
        try {
            if (!(contextNode instanceof NodeInfo)) {
                this.getLogger().debug("Input tree is not SAXON TinyTree, converting");
                DOMSource source = new DOMSource(contextNode);
                TinyBuilder result = new TinyBuilder();
                factory.newTransformer().transform(source, (Result)result);
                contextNode = (Node)result.getCurrentDocument();
            }
            Expression expression = ExpressionTool.make((String)str, (StaticContext)new Saxon7Context((NodeInfo)contextNode, resolver));
            XPathContext context = new XPathContext((NodeInfo)contextNode);
            return expression.iterate(context);
        }
        catch (Exception e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Failed to evaluate '" + str + "'", (Throwable)e);
            }
            return null;
        }
    }

    private class Saxon7Context
    extends StandaloneContext {
        private final PrefixResolver resolver;

        public Saxon7Context(NodeInfo node, PrefixResolver resolver) {
            super(node);
            this.resolver = resolver;
        }

        public String getURIForPrefix(String prefix) throws XPathException {
            return this.resolver.prefixToNamespace(prefix);
        }
    }
}

