/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.markup;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.language.markup.Logicsheet;
import org.apache.cocoon.components.language.markup.LogicsheetCodeGenerator;
import org.apache.cocoon.components.language.markup.MarkupLanguage;
import org.apache.cocoon.components.language.markup.NamedLogicsheet;
import org.apache.cocoon.components.language.programming.ProgrammingLanguage;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.util.HashMap;
import org.apache.cocoon.xml.AbstractXMLPipe;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.store.Store;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class AbstractMarkupLanguage
extends AbstractLogEnabled
implements MarkupLanguage,
Composable,
Configurable,
Parameterizable,
Recyclable,
Disposable {
    private static final String FILE = "file:";
    private static final String CACHE_PREFIX = "logicsheet:";
    protected String name;
    protected HashMap languages;
    protected Store logicsheetCache;
    protected String uri;
    protected String prefix;
    protected ComponentManager manager;
    private SourceResolver resolver;
    private final LinkedList logicSheetList = new LinkedList();

    public AbstractMarkupLanguage() {
        this.languages = new HashMap();
    }

    public void configure(Configuration conf) throws ConfigurationException {
        try {
            this.name = conf.getAttribute("name");
            Configuration[] l = conf.getChildren("target-language");
            for (int i = 0; i < l.length; ++i) {
                LanguageDescriptor language = new LanguageDescriptor();
                language.setName(l[i].getAttribute("name"));
                Logicsheet logicsheet = this.createLogicsheet(l[i], false);
                language.setLogicsheet(logicsheet.getSystemId());
                Configuration[] n = l[i].getChildren("builtin-logicsheet");
                for (int j = 0; j < n.length; ++j) {
                    NamedLogicsheet namedLogicsheet = (NamedLogicsheet)this.createLogicsheet(n[j], true);
                    language.addNamedLogicsheet(namedLogicsheet.getURI(), namedLogicsheet.getPrefix(), namedLogicsheet.getSystemId());
                }
                this.languages.put(language.getName(), language);
            }
        }
        catch (Exception e) {
            this.getLogger().warn("Configuration Error: " + e.getMessage(), (Throwable)e);
            throw new ConfigurationException("AbstractMarkupLanguage: " + e.getMessage(), (Throwable)e);
        }
    }

    private Logicsheet createLogicsheet(Configuration configuration, boolean named) throws Exception {
        Logicsheet logicsheet;
        String location;
        Parameters params = Parameters.fromConfiguration((Configuration)configuration);
        if (named) {
            location = params.getParameter("href", null);
            String uri = params.getParameter("uri", null);
            String prefix = params.getParameter("prefix", null);
            NamedLogicsheet namedLogicsheet = new NamedLogicsheet(location, this.manager, this.resolver);
            namedLogicsheet.enableLogging(this.getLogger());
            namedLogicsheet.setURI(uri);
            namedLogicsheet.setPrefix(prefix);
            logicsheet = namedLogicsheet;
        } else {
            location = params.getParameter("core-logicsheet", null);
            logicsheet = new Logicsheet(location, this.manager, this.resolver);
            logicsheet.enableLogging(this.getLogger());
        }
        String logicsheetName = logicsheet.getSystemId();
        this.logicsheetCache.store((Object)(CACHE_PREFIX + logicsheetName), (Object)logicsheet);
        return logicsheet;
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
        this.logicsheetCache = (Store)manager.lookup(Store.TRANSIENT_STORE);
        this.resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
    }

    public void recycle() {
        this.logicSheetList.clear();
    }

    public void dispose() {
        this.manager.release((Component)this.logicsheetCache);
        this.logicsheetCache = null;
        this.manager.release((Component)this.resolver);
        this.resolver = null;
        this.manager = null;
        this.languages.clear();
    }

    public void parameterize(Parameters params) throws ParameterException {
        this.uri = params.getParameter("uri");
        this.prefix = params.getParameter("prefix", null);
    }

    public String getName() {
        return this.name;
    }

    public String getEncoding() {
        return null;
    }

    protected TransformerChainBuilderFilter getTransformerChainBuilder(LogicsheetCodeGenerator logicsheetMarkupGenerator) {
        return new TransformerChainBuilderFilter(logicsheetMarkupGenerator);
    }

    protected AbstractXMLPipe getPreprocessFilter(String filename, AbstractXMLPipe filter, ProgrammingLanguage language) {
        return filter;
    }

    protected abstract void addDependency(String var1);

    public String generateCode(Source source, String filename, ProgrammingLanguage programmingLanguage) throws Exception {
        String languageName = programmingLanguage.getLanguageName();
        LanguageDescriptor language = (LanguageDescriptor)this.languages.get(languageName);
        if (language == null) {
            throw new IllegalArgumentException("Unsupported programming language: " + languageName);
        }
        LogicsheetCodeGenerator codeGenerator = new LogicsheetCodeGenerator();
        codeGenerator.enableLogging(this.getLogger());
        codeGenerator.initialize();
        TransformerChainBuilderFilter tranBuilder = this.getTransformerChainBuilder(codeGenerator);
        tranBuilder.setLanguageDescriptor(language);
        AbstractXMLPipe preprocessor = this.getPreprocessFilter(filename, tranBuilder, programmingLanguage);
        return codeGenerator.generateCode(source, preprocessor);
    }

    protected void addLogicsheetsToGenerator(LogicsheetCodeGenerator codeGenerator) throws MalformedURLException, IOException, SAXException, ProcessingException {
        Logicsheet logicsheet;
        if (codeGenerator == null) {
            this.getLogger().debug("This should never happen: codeGenerator is null");
            throw new SAXException("codeGenerator must never be null.");
        }
        LinkedList<Logicsheet> newLogicSheetList = new LinkedList<Logicsheet>();
        for (int i = this.logicSheetList.size() - 1; i >= 0; --i) {
            logicsheet = (Logicsheet)((Object)this.logicSheetList.get(i));
            if (newLogicSheetList.indexOf((Object)logicsheet) != -1) continue;
            newLogicSheetList.addFirst(logicsheet);
        }
        Iterator iterator = newLogicSheetList.iterator();
        while (iterator.hasNext()) {
            logicsheet = (Logicsheet)((Object)iterator.next());
            codeGenerator.addLogicsheet(logicsheet);
        }
    }

    protected void addLogicsheetToList(LanguageDescriptor language, String logicsheetLocation) throws IOException, SAXException, ProcessingException {
        Logicsheet logicsheet = (Logicsheet)((Object)this.logicsheetCache.get((Object)(CACHE_PREFIX + logicsheetLocation)));
        if (logicsheet == null) {
            Source inputSource = null;
            try {
                inputSource = this.resolver.resolveURI(logicsheetLocation);
                logicsheet = new Logicsheet(inputSource, this.manager, this.resolver);
                this.logicsheetCache.store((Object)(CACHE_PREFIX + logicsheet.getSystemId()), (Object)logicsheet);
            }
            catch (SourceException se) {
                throw SourceUtil.handle(se);
            }
            finally {
                this.resolver.release(inputSource);
            }
        }
        String logicsheetName = logicsheet.getSystemId();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("addLogicsheetToList: name: " + logicsheetName + ", location: " + logicsheetLocation + ", instance: " + (Object)((Object)logicsheet));
        }
        if (logicsheetName.startsWith(FILE)) {
            String filename = logicsheetName.substring(FILE.length());
            this.addDependency(filename);
            this.getLogger().debug("addLogicsheetToList: adding dependency on file " + filename);
        }
        this.logicSheetList.add(logicsheet);
        Map namespaces = logicsheet.getNamespaceURIs();
        if (!logicsheetLocation.equals(language.getLogicsheet()) && namespaces != null && namespaces.size() > 0) {
            Iterator iter = namespaces.keySet().iterator();
            while (iter.hasNext()) {
                String namespace = (String)iter.next();
                String namedLogicsheetName = language.getNamedLogicsheetByURI(namespace);
                if (namedLogicsheetName == null || logicsheetLocation.equals(namedLogicsheetName)) continue;
                this.getLogger().debug("Adding embedded logic sheet for " + namespace + ": " + namedLogicsheetName);
                this.addLogicsheetToList(language, namedLogicsheetName);
            }
        }
    }

    public class TransformerChainBuilderFilter
    extends AbstractXMLPipe {
        protected LogicsheetCodeGenerator logicsheetMarkupGenerator;
        protected LanguageDescriptor language;
        private boolean isRootElem;
        private List startPrefixes;

        protected TransformerChainBuilderFilter(LogicsheetCodeGenerator logicsheetMarkupGenerator) {
            this.logicsheetMarkupGenerator = logicsheetMarkupGenerator;
        }

        protected void setLanguageDescriptor(LanguageDescriptor language) {
            this.language = language;
        }

        public void startDocument() throws SAXException {
            this.isRootElem = true;
            this.startPrefixes = new ArrayList();
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            if (!this.isRootElem) {
                super.startPrefixMapping(prefix, uri);
            } else {
                String[] prefixNamingArray = new String[]{prefix, uri};
                this.startPrefixes.add(prefixNamingArray);
            }
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (this.isRootElem) {
                String[] prefixNamingArray;
                int i;
                int prefixesCount;
                this.isRootElem = false;
                try {
                    prefixesCount = this.startPrefixes.size();
                    for (i = 0; i < prefixesCount; ++i) {
                        prefixNamingArray = (String[])this.startPrefixes.get(i);
                        String namedLogicsheetName = this.language.getNamedLogicsheetByURI(prefixNamingArray[1]);
                        if (namedLogicsheetName == null) continue;
                        AbstractMarkupLanguage.this.addLogicsheetToList(this.language, namedLogicsheetName);
                    }
                    AbstractMarkupLanguage.this.addLogicsheetToList(this.language, this.language.getLogicsheet());
                    AbstractMarkupLanguage.this.addLogicsheetsToGenerator(this.logicsheetMarkupGenerator);
                }
                catch (ProcessingException pe) {
                    throw new SAXException((Exception)((Object)pe));
                }
                catch (IOException ioe) {
                    throw new SAXException(ioe);
                }
                super.startDocument();
                prefixesCount = this.startPrefixes.size();
                for (i = 0; i < prefixesCount; ++i) {
                    prefixNamingArray = (String[])this.startPrefixes.get(i);
                    super.startPrefixMapping(prefixNamingArray[0], prefixNamingArray[1]);
                }
            }
            super.startElement(namespaceURI, localName, qName, atts);
        }
    }

    protected class LanguageDescriptor {
        protected String name;
        protected String logicsheet;
        protected HashMap namedLogicsheets = new HashMap();

        protected LanguageDescriptor() {
        }

        protected void setName(String name) {
            this.name = name;
        }

        protected String getName() {
            return this.name;
        }

        protected void setLogicsheet(String logicsheet) {
            this.logicsheet = logicsheet;
        }

        protected String getLogicsheet() {
            return this.logicsheet;
        }

        protected void addNamedLogicsheet(String uri, String prefix, String namedLogicsheet) {
            this.namedLogicsheets.put(uri, namedLogicsheet);
        }

        protected String getNamedLogicsheetByURI(String uri) {
            return (String)this.namedLogicsheets.get(uri);
        }
    }
}

