/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.markup.xsp;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.cocoon.components.language.markup.xsp.XSPObjectHelper;
import org.apache.cocoon.components.modules.input.InputModule;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XSPModuleHelper {
    protected static final String INPUT_MODULE_SELECTOR = InputModule.ROLE + "Selector";
    private static final String PREFIX = "input";
    private static final String URI = "http://apache.org/cocoon/xsp/input/1.0";
    private static final int OP_GET = 0;
    private static final int OP_VALUES = 1;
    private static final int OP_NAMES = 2;
    private Map inputModules;
    private ComponentManager componentManager;
    private ComponentSelector componentInputSelector;
    private ServiceManager serviceManager;
    private ServiceSelector serviceInputSelector;

    private InputModule getInputModule(String name) throws CascadingRuntimeException {
        if (this.inputModules == null) {
            throw new RuntimeException("ModuleHelper is not setup correctly.");
        }
        InputModule module = (InputModule)this.inputModules.get(name);
        if (module == null) {
            try {
                if (this.componentManager != null) {
                    if (this.componentInputSelector.hasComponent((Object)name)) {
                        module = (InputModule)this.componentInputSelector.select((Object)name);
                    }
                } else if (this.serviceInputSelector.isSelectable((Object)name)) {
                    module = (InputModule)this.serviceInputSelector.select((Object)name);
                }
            }
            catch (Exception e) {
                throw new CascadingRuntimeException("Unable to lookup input module " + name, (Throwable)e);
            }
            if (module == null) {
                throw new RuntimeException("No such InputModule: " + name);
            }
            this.inputModules.put(name, module);
        }
        return module;
    }

    private Object get(int op, String name, String attr, Map objectModel, Configuration conf) throws CascadingRuntimeException {
        Object[] value = null;
        InputModule input = this.getInputModule(name);
        try {
            switch (op) {
                case 0: {
                    value = input.getAttribute(attr, conf, objectModel);
                    break;
                }
                case 1: {
                    value = input.getAttributeValues(attr, conf, objectModel);
                    break;
                }
                case 2: {
                    value = input.getAttributeNames(conf, objectModel);
                }
            }
        }
        catch (Exception e) {
            throw new CascadingRuntimeException("Error accessing attribute '" + attr + "' from input module '" + name + "'. " + e.getMessage(), (Throwable)e);
        }
        return value;
    }

    private Object get(int op, String name, String attr, Map objectModel) throws RuntimeException {
        return this.get(op, name, attr, objectModel, null);
    }

    public void setup(ComponentManager manager) throws RuntimeException {
        this.inputModules = new HashMap();
        this.componentManager = manager;
        try {
            this.componentInputSelector = (ComponentSelector)this.componentManager.lookup(INPUT_MODULE_SELECTOR);
        }
        catch (Exception e) {
            throw new CascadingRuntimeException("Could not obtain selector for InputModule.", (Throwable)e);
        }
    }

    public void setup(ServiceManager manager) throws RuntimeException {
        this.inputModules = new HashMap();
        this.serviceManager = manager;
        try {
            this.serviceInputSelector = (ServiceSelector)this.serviceManager.lookup(INPUT_MODULE_SELECTOR);
        }
        catch (Exception e) {
            throw new CascadingRuntimeException("Could not obtain selector for InputModule.", (Throwable)e);
        }
    }

    public Object getAttribute(Map objectModel, Configuration conf, String module, String name, Object deflt) throws RuntimeException {
        Object result = this.get(0, module, name, objectModel, conf);
        if (result == null) {
            result = deflt;
        }
        return result;
    }

    public Object getAttribute(Map objectModel, String module, String name, Object deflt) throws RuntimeException {
        return this.getAttribute(objectModel, null, module, name, deflt);
    }

    public Object[] getAttributeValues(Map objectModel, Configuration conf, String module, String name, Object[] deflt) throws RuntimeException {
        Object[] result = (Object[])this.get(1, module, name, objectModel, conf);
        if (result == null) {
            result = deflt;
        }
        return result;
    }

    public Object[] getAttributeValues(Map objectModel, String module, String name, Object[] deflt) throws RuntimeException {
        return this.getAttributeValues(objectModel, null, module, name, deflt);
    }

    public void getAttributeValues(Map objectModel, ContentHandler contentHandler, String module, String name) throws SAXException, RuntimeException {
        AttributesImpl attr = new AttributesImpl();
        XSPObjectHelper.addAttribute(attr, "name", name);
        XSPObjectHelper.start(URI, PREFIX, contentHandler, "attribute-values", attr);
        Object[] values = this.getAttributeValues(objectModel, module, name, null);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                XSPObjectHelper.elementData(URI, PREFIX, contentHandler, "value", String.valueOf(values[i]));
            }
        }
        XSPObjectHelper.end(URI, PREFIX, contentHandler, "attribute-values");
    }

    public Iterator getAttributeNames(Map objectModel, Configuration conf, String module) throws RuntimeException {
        return (Iterator)this.get(2, module, null, objectModel);
    }

    public Iterator getAttributeNames(Map objectModel, String module) throws RuntimeException {
        return this.getAttributeNames(objectModel, (Configuration)null, module);
    }

    public void getAttributeNames(Map objectModel, ContentHandler contentHandler, String module) throws SAXException, RuntimeException {
        XSPObjectHelper.start(URI, PREFIX, contentHandler, "attribute-names");
        Iterator iter = this.getAttributeNames(objectModel, module);
        while (iter.hasNext()) {
            String name = (String)iter.next();
            XSPObjectHelper.elementData(URI, PREFIX, contentHandler, "name", name);
        }
        XSPObjectHelper.end(URI, PREFIX, contentHandler, "attribute-names");
    }

    public void releaseAll() throws RuntimeException {
        if (this.inputModules != null) {
            Iterator iter;
            if (this.componentManager != null) {
                try {
                    iter = this.inputModules.keySet().iterator();
                    while (iter.hasNext()) {
                        this.componentInputSelector.release((Component)((InputModule)this.inputModules.get(iter.next())));
                    }
                    this.inputModules = null;
                    this.componentManager.release((Component)this.componentInputSelector);
                    this.componentManager = null;
                    this.inputModules = null;
                }
                catch (Exception e) {
                    throw new CascadingRuntimeException("Could not release InputModules.", (Throwable)e);
                }
            }
            if (this.serviceManager != null) {
                try {
                    iter = this.inputModules.keySet().iterator();
                    while (iter.hasNext()) {
                        this.serviceInputSelector.release(this.inputModules.get(iter.next()));
                    }
                    this.inputModules = null;
                    this.serviceManager.release((Object)this.serviceInputSelector);
                    this.serviceManager = null;
                    this.inputModules = null;
                }
                catch (Exception e) {
                    throw new CascadingRuntimeException("Could not release InputModules.", (Throwable)e);
                }
            }
        }
    }
}

