/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.modules.input;

import java.beans.PropertyDescriptor;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.modules.input.AbstractMetaModule;
import org.apache.commons.jxpath.ClassFunctions;
import org.apache.commons.jxpath.FunctionLibrary;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.JXPathBeanInfo;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathIntrospector;
import org.apache.commons.jxpath.PackageFunctions;

public class JXPathMetaModule
extends AbstractMetaModule
implements Configurable,
ThreadSafe {
    protected FunctionLibrary library = null;
    protected boolean lenient = true;
    protected String parameter = "";

    public JXPathMetaModule() {
        this.defaultInput = "request-attr";
    }

    public void configure(Configuration config) throws ConfigurationException {
        this.inputConf = config.getChild("input-module");
        this.defaultInput = this.inputConf.getAttribute("name", this.defaultInput);
        this.parameter = config.getChild("parameter").getValue(this.parameter);
        this.lenient = config.getChild("lenient").getValueAsBoolean(this.lenient);
        this.library = new FunctionLibrary();
        this.getFunctions(this.library, config);
        this.getPackages(this.library, config);
    }

    protected void getFunctions(FunctionLibrary lib, Configuration conf) {
        Configuration[] children = conf.getChildren("function");
        int i = children.length;
        while (i-- > 0) {
            String clazzName = children[i].getAttribute("name", null);
            String prefix = children[i].getAttribute("prefix", null);
            if (clazzName != null && prefix != null) {
                try {
                    Class<?> clazz = Class.forName(clazzName);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("adding Class " + clazzName + " to functions");
                    }
                    lib.addFunctions((Functions)new ClassFunctions(clazz, prefix));
                }
                catch (ClassNotFoundException cnf) {
                    if (!this.getLogger().isWarnEnabled()) continue;
                    this.getLogger().warn("Class not found: " + clazzName);
                }
                continue;
            }
            if (!this.getLogger().isWarnEnabled()) continue;
            this.getLogger().warn("Class name or prefix null: " + clazzName + " / " + prefix);
        }
    }

    protected void getPackages(FunctionLibrary lib, Configuration conf) {
        Configuration[] children = conf.getChildren("package");
        int i = children.length;
        while (i-- > 0) {
            String packageName = children[i].getAttribute("name", null);
            String prefix = children[i].getAttribute("prefix", null);
            if (packageName != null && prefix != null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("adding Package " + packageName + " to functions");
                }
                lib.addFunctions((Functions)new PackageFunctions(packageName, prefix));
                continue;
            }
            if (!this.getLogger().isWarnEnabled()) continue;
            this.getLogger().warn("Package name or prefix null: " + packageName + " / " + prefix);
        }
    }

    protected void setupExtensions(JXPathContext context, Configuration conf) {
        FunctionLibrary localLib = null;
        if (conf != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("adding local Classes and Packages to functions");
            }
            localLib = new FunctionLibrary();
            localLib.addFunctions((Functions)this.library);
            this.getPackages(localLib, conf);
            this.getFunctions(localLib, conf);
        } else {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("no local Classes or Packages");
            }
            localLib = this.library;
        }
        context.setFunctions((Functions)localLib);
    }

    public Object getAttribute(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        Object contextObj = this.getContextObject(modeConf, objectModel);
        if (contextObj == null) {
            return null;
        }
        if (modeConf != null) {
            name = modeConf.getChild("parameter").getValue(name);
        }
        try {
            JXPathContext jxContext = JXPathContext.newContext((Object)contextObj);
            this.setupExtensions(jxContext, modeConf);
            if (this.lenient) {
                jxContext.setLenient(true);
            }
            Object obj = jxContext.getValue(name);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("for " + name + " returning an " + (obj == null ? "null" : obj.getClass().getName()) + " as " + obj);
            }
            return obj;
        }
        catch (Exception e) {
            throw new ConfigurationException("Module does not support <" + name + ">" + "attribute.", (Throwable)e);
        }
    }

    public Iterator getAttributeNames(Configuration modeConf, Map objectModel) throws ConfigurationException {
        Object contextObj = this.getContextObject(modeConf, objectModel);
        if (contextObj == null) {
            return null;
        }
        try {
            JXPathBeanInfo info = JXPathIntrospector.getBeanInfo(contextObj.getClass());
            PropertyDescriptor[] properties = info.getPropertyDescriptors();
            LinkedList<String> names = new LinkedList<String>();
            for (int i = 0; i < properties.length; ++i) {
                names.add(properties[i].getName());
            }
            return names.listIterator();
        }
        catch (Exception e) {
            throw new ConfigurationException("Error retrieving attribute names for class: " + contextObj.getClass(), (Throwable)e);
        }
    }

    public Object[] getAttributeValues(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        Object contextObj = this.getContextObject(modeConf, objectModel);
        if (contextObj == null) {
            return null;
        }
        if (modeConf != null) {
            name = modeConf.getChild("parameter").getValue(name);
        }
        try {
            Iterator i;
            JXPathContext jxContext = JXPathContext.newContext((Object)contextObj);
            LinkedList values = null;
            this.setupExtensions(jxContext, modeConf);
            if (this.lenient) {
                jxContext.setLenient(true);
            }
            if ((i = jxContext.iterate(name)).hasNext()) {
                values = new LinkedList();
            }
            while (i.hasNext()) {
                values.add(i.next());
            }
            Object[] obj = values.toArray();
            if (obj.length == 0) {
                obj = null;
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("for " + name + " returning an " + (obj == null ? "null" : obj.getClass().getName()) + " as " + obj);
            }
            return obj;
        }
        catch (Exception e) {
            throw new ConfigurationException("Module does not support <" + name + ">" + "attribute.", (Throwable)e);
        }
    }

    protected Object getContextObject(Configuration modeConf, Map objectModel) throws ConfigurationException {
        if (!this.initialized) {
            this.lazy_initialize();
        }
        Configuration mConf = null;
        String inputName = null;
        String parameter = this.parameter;
        if (modeConf != null) {
            mConf = modeConf.getChild("input-module");
            inputName = mConf.getAttribute("name", null);
            parameter = modeConf.getChild("from-parameter").getValue(parameter);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("modeConf is " + modeConf + " this.inputConf is " + this.inputConf + " mConf is " + mConf + " this.input is " + this.input + " this.defaultInput is " + this.defaultInput + " inputName is " + inputName + " parameter is " + parameter);
        }
        Object obj = this.getValue(parameter, objectModel, this.input, this.defaultInput, this.inputConf, null, inputName, mConf);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("returning an " + (obj == null ? "null" : obj.getClass().getName()) + " as " + obj);
        }
        return obj;
    }
}

