(* 
    This file is a part of IsarMathLib - 
    a library of formalized mathematics written for Isabelle/Isar.

    Copyright (C) 2005  Slawomir Kolodynski

    This program is free software; Redistribution and use in source and binary forms, 
    with or without modification, are permitted provided that the following conditions are met:

   1. Redistributions of source code must retain the above copyright notice, 
   this list of conditions and the following disclaimer.
   2. Redistributions in binary form must reproduce the above copyright notice, 
   this list of conditions and the following disclaimer in the documentation and/or 
   other materials provided with the distribution.
   3. The name of the author may not be used to endorse or promote products 
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*)

header {*\isaheader{ZF1.thy}*}
theory ZF1 = pair:

section{*Some lemmas in Zermelo-Fraenkel set theory*}

text{*Here we put lemmas from the set theory that we could not find in 
the standard Isabelle distribution.*}

text{*If all sets a nonempty collection are the same, then its union 
  is the same.*}

lemma ZF1_1_L1: assumes A1:"C\<noteq>0" and A2:"\<forall>y\<in>C. b(y) = A" 
  shows "(\<Union>y\<in>C. b(y)) = A"
proof -;
  from A1 A2 show ?thesis by blast;
qed;
  
text{*The union af all values of a constant meta-function belongs to the same set
  as the constant.*}

lemma ZF1_1_L2: assumes A1:"C\<noteq>0" and A2:"\<forall>x\<in>C. b(x) \<in> A" 
  and A3:"\<forall>x y. x\<in>C \<and> y\<in>C \<longrightarrow> b(x) = b(y)"
  shows "(\<Union>x\<in>C. b(x))\<in>A"
proof -;
  from A1 obtain x where D1:"x\<in>C" by auto;
  with A3 have "\<forall>y\<in>C. b(y) = b(x)" by blast;
  with A1 have "(\<Union>y\<in>C. b(y)) = b(x)" 
    using ZF1_1_L1 by simp;
  with D1 A2 show ?thesis by simp;
qed;
end
      
      

