(* 
    This file is a part of IsarMathLib - 
    a library of formalized mathematics written for Isabelle/Isar.

    Copyright (C) 2005  Slawomir Kolodynski

    This program is free software; Redistribution and use in source and binary forms, 
    with or without modification, are permitted provided that the following conditions are met:

   1. Redistributions of source code must retain the above copyright notice, 
   this list of conditions and the following disclaimer.
   2. Redistributions in binary form must reproduce the above copyright notice, 
   this list of conditions and the following disclaimer in the documentation and/or 
   other materials provided with the distribution.
   3. The name of the author may not be used to endorse or promote products 
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*)

header {*\isaheader{Topology\_ZF\_2.thy}*}

theory Topology_ZF_2 = Topology_ZF_1 + func1 + Fol1:

section{*Continuous functions.*}

text{*We will work with a pair of topological spaces. The following 
locale sets up our context. It also defines continuity. 
It is this rare case when we feel it is apriopriate to define a notion in 
a locale. This is because the notion of continuity is just the notion 
of preserving collection of sets, defined in func1.thy, applied in our 
context.*}

locale two_top_spaces0 =
  fixes X :: "i"
  fixes T :: "i"
  assumes TtopSpace: "T {is a topology on} X"
 
  fixes Y :: "i"
  fixes S :: "i"
  assumes StopSpace: "S {is a topology on} Y"
  
  fixes f :: "i"
  assumes fmapAssum: "f\<in>X\<rightarrow>Y"
  
  fixes isXClosed :: "i\<Rightarrow>o" ("_ {is X-closed}" [50] 50)
  defines isTClosed_def [simp]: "D {is X-closed} == IsClosed(D,X,T)"
   
  fixes isYClosed :: "i\<Rightarrow>o" ("_ {is Y-closed}" [50] 50)
  defines isYClosed_def [simp]: "D {is Y-closed} == IsClosed(D,Y,S)"

  fixes isContinuous :: "i\<Rightarrow>o" ("_ {is continuous}" [50] 50)
  defines isContinuous_def [simp]: 
  "g {is continuous} == PresColl(g,T,S)";

text{*First show that we can use theorems proven in some other 
contexts (locales)*}
lemma (in two_top_spaces0) top_ZF_2_1_L1: 
  shows "top_space0(X,T) & top_space0(Y,S)"
proof -
  from TtopSpace StopSpace show ?thesis 
    using top_space0_def by simp;
qed;

lemma (in two_top_spaces0) top_ZF_2_1_L2: 
  shows "top_space1(X,T) & top_space1(Y,S)"
proof -
  from TtopSpace StopSpace  show ?thesis 
    using  top_ZF_2_1_L1 top_space1_def by simp;
qed;

text{*We want to show some equivalent conditions for continuity. 
First we will show a loop of implications and then we will use Fol1\_L1 
to convert those to equivalences.*}

text{*For continuous functions the inverse image of a closed set is closed.*}

lemma (in two_top_spaces0) top_ZF_2_1_L3: 
  assumes A:"f {is continuous}" 
  shows "\<forall>D. ((D {is Y-closed}) \<longrightarrow> f-``(D) {is X-closed})"
proof;
  fix D
  show  "D {is Y-closed} \<longrightarrow> f-`` D {is X-closed}";
  proof -;
    from fmapAssum have  "f-``(D)\<subseteq> X" using func1_1_L3 by simp;
    moreover from fmapAssum  have "f-``(Y-D) =   X-f-``(D)" 
      using Pi_iff function_vimage_Diff func1_1_L4 by auto;
    ultimately have "X-f-``(Y-D) = f-``(D)" by auto;
    moreover from A have "D {is Y-closed} \<longrightarrow> X-f-``(Y-D) {is X-closed}"
      using IsClosed_def PresColl_def top_ZF_2_1_L2 top_space1.topZF_3_L8
      by auto;
    ultimately show "D {is Y-closed} \<longrightarrow> f-`` D {is X-closed}" by simp;
  qed;
qed;

text{*If the inverse image of a closed set is closed, the
image of a closure is contained in the closure of the image.*}

lemma (in two_top_spaces0) top_ZF_2_1_L4: 
assumes A1:"\<forall>D. ((D {is Y-closed}) \<longrightarrow> f-``(D) {is X-closed})"
shows "\<forall> A\<in> Pow(X). f``(Closure(A,X,T)) \<subseteq> Closure(f``(A),Y,S)";
proof;
  fix A
  assume A2:"A \<in> Pow(X)" 
  show "f``(Closure(A, X, T)) \<subseteq> Closure(f ``(A), Y, S)"
  proof -;
    have "f``(A) \<subseteq> Closure(f ``(A), Y, S)" 
      using  top_space1.topZF_3_L9 top_ZF_2_1_L2 fmapAssum func1_1_L6
      by simp;
    then have "f-``(f``(A)) \<subseteq> f-``(Closure(f ``(A), Y, S))" 
      using fmapAssum func1_1_L7 by auto
    moreover from A2 have "A\<subseteq>f-``(f``(A))" 
      using fmapAssum  func1_1_L9 by simp;
    ultimately have "A\<subseteq> f-``(Closure(f ``(A), Y, S))" by auto;
    with A1 have 
      "f``(Closure(A,X,T)) \<subseteq> f``(f-``(Closure(f ``(A), Y, S)))"
       using fmapAssum func1_1_L6 top_space1.topZF_3_L4 
	 top_ZF_2_1_L2 top_space1.topZF_3_L13 top_ZF_2_1_L2 
	 IsClosed_def func1_1_L8
       by simp;
    moreover have 
      "f``(f-``(Closure(f ``(A), Y, S))) \<subseteq> Closure(f ``(A), Y, S)"
      using fun_is_function function_image_vimage fmapAssum by simp;
    ultimately show "f``(Closure(A, X, T)) \<subseteq> Closure(f ``(A), Y, S)"
      by auto;
  qed;
qed;

text{*If the image of a closure is contained in the closure of the image, 
then the inverse image of a closure is contains the closure of the 
inverse image.*}

lemma (in two_top_spaces0) top_ZF_2_1_L5:
  assumes A1:  "\<forall> A\<in> Pow(X). f``(Closure(A,X,T)) \<subseteq> Closure(f``(A),Y,S)"
  shows "\<forall>B\<in> Pow(Y). Closure(f-``(B),X,T)\<subseteq>f-``(Closure(B,Y,S))"
proof
  fix B
  assume A2: "B \<in> Pow(Y)"
  show "Closure(f-``(B),X,T)\<subseteq>f-``(Closure(B,Y,S))"
  proof -;
    from A1 have 
      "f``(Closure(f-``(B),X,T)) \<subseteq> Closure(f``(f-``(B)),Y,S)"
      using  fmapAssum func1_1_L3 by simp;
    moreover from A2 have "Closure(f``(f-``(B)),Y,S)\<subseteq> Closure(B,Y,S)"
      using fun_is_function function_image_vimage fmapAssum
	top_ZF_2_1_L2 top_space1.topZF_3_L5 func1_1_L6
      by simp;
    ultimately have "f-``(f``(Closure(f-``(B),X,T))) \<subseteq> f-``(Closure(B,Y,S))"
      using fmapAssum fun_is_function func1_1_L7 by auto;
    moreover from A2 have 
      "Closure(f-``(B),X,T)\<subseteq>f-``(f``(Closure(f-``(B),X,T)))"
      using fmapAssum func1_1_L3 top_ZF_2_1_L2 top_space1.topZF_3_L4
	IsClosed_def func1_1_L9 by simp;
    ultimately show "Closure(f-``(B),X,T)\<subseteq>f-``(Closure(B,Y,S))" by auto;
  qed;
qed;

text{*If the inverse image of a closure contains the closure of the 
inverse image, then the function is continuous.*}

lemma (in two_top_spaces0) top_ZF_2_1_L6:
  assumes A1:"\<forall>B\<in> Pow(Y). Closure(f-``(B),X,T)\<subseteq>f-``(Closure(B,Y,S))"
  shows "f {is continuous}"
proof-;
  have "\<forall>U\<in> S. f-``(U)\<in> T"
  proof;
    fix U
    assume A2:"U\<in>S" show "f -`` U \<in> T"
    proof -;
      from A2 have "Y-U\<in> Pow(Y)" 
	using StopSpace isAtopologyOn_def by auto;
      with A1 have 
	T1:"Closure(f-``(Y-U),X,T)\<subseteq>f-``(Closure(Y-U,Y,S))" by simp;
      from A2 have "Y-U {is Y-closed}" 
	using top_ZF_2_1_L2 top_space1.topZF_3_L8 by simp;
      then have "Y-U = Closure(Y-U,Y,S)" 
	using top_ZF_2_1_L2 top_space1.topZF_3_L7 IsClosed_def by auto
      with T1 have "Closure(f-``(Y-U),X,T)\<subseteq> f-``(Y-U)" by simp;
      moreover have "f-``(Y-U)\<subseteq> Closure(f-``(Y-U),X,T)" 
	using fmapAssum func1_1_L3 top_ZF_2_1_L2 top_space1.topZF_3_L9
	by simp;
      ultimately have "f-``(Y-U) {is X-closed}"
	using fmapAssum func1_1_L3 top_ZF_2_1_L2 top_space1.topZF_3_L7
	by auto;
      then show "f -`` U \<in> T" 
	using fmapAssum fun_is_function function_vimage_Diff func1_1_L4
	  func1_1_L3 IsClosed_def double_complement by simp;
    qed;
  qed;
  then show "f {is continuous}" using PresColl_def by simp;
qed;

text{*This theorem summarizes lemmas top\_ZF\_2\_1\_L3-L6 providing
equivalent conditions for continuity. The All4areEquivalent idiom is defined
in Fol1.thy.*}

theorem (in two_top_spaces0) top_ZF_2_1_T1: 
  shows "All4areEquivalent(
  f {is continuous},
  \<forall>D. (D {is Y-closed}) \<longrightarrow> f-``(D) {is X-closed},
  \<forall> A\<in> Pow(X). f``(Closure(A,X,T)) \<subseteq> Closure(f``(A),Y,S),
  \<forall>B\<in> Pow(Y). Closure(f-``(B),X,T)\<subseteq>f-``(Closure(B,Y,S)))"
proof -;
  let ?p = "f {is continuous}"
  let ?q = "\<forall>D. (D {is Y-closed}) \<longrightarrow> f-``(D) {is X-closed}"
  let ?r = "\<forall> A\<in> Pow(X). f``(Closure(A,X,T)) \<subseteq> Closure(f``(A),Y,S)"
  let ?s = "\<forall>B\<in> Pow(Y). Closure(f-``(B),X,T)\<subseteq>f-``(Closure(B,Y,S))"
  have "?p \<longrightarrow> ?q" using top_ZF_2_1_L3 by simp;
  moreover have "?q \<longrightarrow>?r" using top_ZF_2_1_L4 by auto;
  moreover have "?r\<longrightarrow>?s" using top_ZF_2_1_L5 by auto;
  moreover have "?s\<longrightarrow>?p" using top_ZF_2_1_L6 by auto;
  ultimately show ?thesis by (rule Fol1_L1);
qed;

text{*Another condition for continuity: it is sufficient to check if the 
inverse image of every set in a base is open.*}

lemma (in two_top_spaces0) top_ZF_2_1_L7: 
  assumes A1:"B {is a base for} S" and A2:"\<forall>U\<in>B. f-``(U)\<in>T" 
  shows "f {is continuous}"
proof -;
  have "\<forall>V\<in>S. f-``(V)\<in>T" 
  proof;
    fix V assume A3:"V\<in>S"
    from A1 A3 obtain A where D1:"A\<in>Pow(B) & V = \<Union>A" 
      using IsAbaseFor_def by auto;
    from A2 D1 have "{f-``(U). U\<in>A} \<subseteq> T " by auto;
    with TtopSpace have "\<Union>{f-``(U). U\<in>A} \<in> T" 
      using isAtopologyOn_def by simp;  
    moreover from D1 have "f-``(V) = \<Union>{f-``(U). U\<in>A}" by auto;
    ultimately show "f-``(V)\<in>T" by simp
  qed
  then show ?thesis using PresColl_def by simp
qed;

text{*We can strenghten the previous lemma: it is sufficient to check if the 
inverse image of every set in a subbase is open. The proof is rather awkward,
as usual when we deal with general intersections. We have to keep track of 
the case when the collection is empty.*}

lemma (in two_top_spaces0) top_ZF_2_1_L8:
  assumes A1:"B {is a subbase for} S" and A2:"\<forall>U\<in>B. f-``(U)\<in>T" 
  shows "f {is continuous}"
proof -;
  let ?C = "{\<Inter>A. A\<in>Fin(B)}";
  from A1 have "?C {is a base for} S"
    using IsAsubBaseFor_def by simp;
  moreover have "\<forall>U\<in>?C. f-``(U) \<in> T"
  proof;
    fix U 
    assume A3:"U\<in>?C" show "f-``(U)\<in>T";
    proof (cases "f-``(U)=0");
      assume "f-``(U)=0" with  TtopSpace show "f -``(U) \<in> T" 
	using isAtopologyOn_def by simp;
    next;
      assume A4:"f-``(U)\<noteq>0" 
      from A3 obtain A where D1:"A \<in> Fin(B)" and D2:"U = \<Inter>A" by auto;
      have "{f-``(W). W\<in>A} \<noteq> 0" 
      proof -;
	from A4 have "U\<noteq>0" by (rule func1_1_L13);
	with D2 have "\<Inter>A\<noteq>0" by simp;
	hence "A\<noteq>0"  by (rule Finite1_L9);
	then show "{f-``(W). W\<in>A} \<noteq> 0" by simp;
      qed;
      moreover from A2 D1 have "{f-``(W). W\<in>A} \<in> Fin(T)"
	by (rule Finite1_L6);
      ultimately have "\<Inter>{f-``(W). W\<in>A} \<in> T"
	using top_ZF_2_1_L1 top_space0.TopZF_1_L2 by auto;
      moreover have "f-``(U) = \<Inter>{f-``(W). W\<in>A}"
      proof -;
	from D1 A1 have "A \<subseteq> S"
	  using FinD IsAsubBaseFor_def by auto;
	with StopSpace have T1:"A \<subseteq> Pow(Y)"
	  using isAtopologyOn_def by auto;
	from A4 have "U\<noteq>0" by (rule func1_1_L13);
	with D2 have "\<Inter>A\<noteq>0" by simp;
	hence "A\<noteq>0"  by (rule Finite1_L9);
	with T1 fmapAssum have "f-``(\<Inter>A) =  \<Inter>{f-``(W). W\<in>A}"
	  using func1_1_L12 by simp;
	with D2 show ?thesis by simp;
      qed;
      ultimately show "f-``(U) \<in> T" by simp;
    qed;
  qed;
  ultimately show ?thesis using top_ZF_2_1_L7 by simp;
qed;
  
end;    
      
 
     