(* 
    This file is a part of IsarMathLib - 
    a library of formalized mathematics for Isabelle/Isar.

    Copyright (C) 2005  Slawomir Kolodynski

    This program is free software; Redistribution and use in source and binary forms, 
    with or without modification, are permitted provided that the following conditions are met:

   1. Redistributions of source code must retain the above copyright notice, 
   this list of conditions and the following disclaimer.
   2. Redistributions in binary form must reproduce the above copyright notice, 
   this list of conditions and the following disclaimer in the documentation and/or 
   other materials provided with the distribution.
   3. The name of the author may not be used to endorse or promote products 
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED 
WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*)

header {*\isaheader{Fol1.thy}*}

theory Fol1 imports Trancl 

begin

section{*Mission statement*}

text{*Until we come up with soemthing better let's just say
that writing formalized proofs protects from Alzheimer's disease
better than solving crossword puzzles.*}

section{*Release notes*}

text{* This release requires Isabelle 2005.*}

section{*Overview of the project*}

text{* 
  The theory files @{text "Fo11"}, @{text " ZF1"}, @{text "Nat_ZF"}, 
  @{text "func1"}, @{text "func_ZF"}, @{text "EquivClass1"}, 
  @{text "Finite1"}, @{text "Finite_ZF"}, @{text "Order_ZF"} contain some 
  background material that is needed for the remaning theories. 
  
  @{text "Group_ZF"}, @{text "Group_ZF_1"}, and @{text "Group_ZF_2"}
  provide basic facts of the group theory.@{text "Group_ZF_3"} 
  considers the notion
  of almost homomorphisms that is nedeed for the real numbers construction
  in @{text "Real_ZF"}. 
  
  @{text "Ring_ZF"} defines rings.  @{text "Ring_ZF_1"} covers 
  the properties of 
  rings that are specific to the real numbers construction in @{text "Real_ZF_x"}. 
  
  @{text "Int_ZF"} theory considers the integers as a monoid (multiplication) and 
  an abelian ordered group (addition). 
  In @{text "Int_ZF_1"} we show that integers form a commutative ring.
  @{text "Int_ZF_2"} contains some facts about slopes (almost homomorphisms on integers) 
  needed for real numbers construction.
  
  The @{text "Real_ZF"} and @{text "Real_ZF_1"} theories start the construction of 
  real numbers based on the paper \cite{Arthan2004}
  by R. D. Arthan (not Cauchy sequences, not Dedekind sections).
  
  The @{text "Topology_ZF"} series covers basics of general topology: 
  interior, closure, boundary, compact sets, separation axioms and 
  continuous functions.*}

section{*Notions and lemmas in FOL*}

text{*This section is not interesting and should not be read. Contains 
  mostly shortcuts and workarounds that allow to use more 
  readable coding style.*}

(*temporarily removed bc. it takes too long to check
text{*The definition and lemma below implement a common idiom used in 
romantic mathematics when the author states some assumptions, says
"then the following are equivalent" and proceeds with the proof that shows 
implications between the statements. The usefulness of theorems stated this 
way is rather limited in Isar as the simp and auto methods may take a really 
long time to infer anything from equivalences if there is more than one. 
Still, we believe that being able to formulate a theorem like this 
is good for readibility.*}

constdefs
  All4areEquivalent :: "[o,o,o,o]\<Rightarrow>o"
  "All4areEquivalent(p,q,r,s) \<equiv> 
  (p\<longleftrightarrow>q) & (p\<longleftrightarrow>r) & (p\<longleftrightarrow>s) & (q\<longleftrightarrow>r) & (q\<longleftrightarrow>s) & (r\<longleftrightarrow>s)";

lemma Fol1_L1: assumes A1: "p\<longrightarrow>q" and A2: "q\<longrightarrow>r" 
  and A3: "r\<longrightarrow>s" and A4: "s\<longrightarrow>p" 
  shows "All4areEquivalent(p,q,r,s)"
proof-;  
  from A1 A2 A3 A4 have "p\<longleftrightarrow>q"by auto;
  moreover from A1 A2 A3 A4 have "p\<longleftrightarrow>r" by auto;
  moreover from A1 A2 A3 A4 have "p\<longleftrightarrow>s" by auto;
  moreover from A1 A2 A3 A4 have "q\<longleftrightarrow>r" by auto;
  moreover from A1 A2 A3 A4 have "q\<longleftrightarrow>s" by auto;
  moreover from A1 A2 A3 A4 have "r\<longleftrightarrow>s" by auto;
  ultimately show ?thesis using All4areEquivalent_def by simp;
qed; 

text{*It happens quite often that we need to prove a statement of the form
$\forall x y. P(x,y) \rightarrow Q(x,y)$. The next lemma provides a shortcut 
for proving this type of statements. To apply this shortcut we can say 
"(rule double\_forall\_implies)" after the "proof" keyword and we are free to
show the statement by doing "fix x y assume P(x,y) show Q(x,y).*}

lemma double_forall_implies: 
  assumes A1:" \<And>x y. P(x,y) \<Longrightarrow> R(x,y)"
  shows "\<forall>x y. (P(x,y) \<longrightarrow> R(x,y))"
proof -;
  from A1 show ?thesis by simp;
qed;

*)

text{*The next lemma serves as a workaround to problems with applying 
  the definition of transitivity (of a relation) in our coding style 
  (any attempt to do
  something like @{text "using trans_def"} results up Isabelle in an 
  infinite loop). We reluctantly use @{text "(unfold trans_def)"} after the 
  @{text "proof"} keyword  to workaround this.*}

lemma Fol1_L2: assumes 
  A1: "\<forall> x y z. \<langle>x, y\<rangle> \<in> r \<and> \<langle>y, z\<rangle> \<in> r \<longrightarrow> \<langle>x, z\<rangle> \<in> r"
  shows "trans(r)"
proof (unfold trans_def)
  from A1 show
    "\<forall> x y z. \<langle>x, y\<rangle> \<in> r \<longrightarrow> \<langle>y, z\<rangle> \<in> r \<longrightarrow> \<langle>x, z\<rangle> \<in> r"
    using imp_conj by blast;
qed;

text{*Another workaround for the problem of Isabelle simplifier looping when 
  the transitivity definition is used. *}

lemma Fol1_L3: assumes A1: "trans(r)" and A2: "<a,b> \<in> r  \<and> <b,c> \<in> r"
  shows "<a,c> \<in> r"
proof -;
  from A1 have  "\<forall>x y z. \<langle>x, y\<rangle> \<in> r \<longrightarrow> \<langle>y, z\<rangle> \<in> r \<longrightarrow> \<langle>x, z\<rangle> \<in> r"
    by (unfold trans_def);
  with A2 show ?thesis using imp_conj by fast;
qed;
  
text{*There is a problem with application of the definition of asymetry for
  relations. The next lemma is a workaround.*}

lemma Fol1_L4: 
  assumes A1: "antisym(r)" and A2: "<a,b> \<in> r"   "<b,a> \<in> r"  
  shows "a=b"
proof -;
  from A1 have "\<forall> x y. <x,y> \<in> r \<longrightarrow> <y,x> \<in> r \<longrightarrow> x=y"
    by (unfold antisym_def);
  with A2 show "a=b" using imp_conj by fast;
qed;

text{*The definition below implements a common idiom that states that 
  (perhaps under some assumptions) exactly one of give three statements 
  is true.*}

constdefs
  "Exactly_1_of_3_holds(p,q,r) \<equiv> 
  (p\<or>q\<or>r) \<and> (p \<longrightarrow> \<not>q \<and> \<not>r) \<and> (q \<longrightarrow> \<not>p \<and> \<not>r) \<and> (r \<longrightarrow> \<not>p \<and> \<not>q)";

text{*The next lemma allows to prove statements of the form 
  @{text "Exactly_1_of_3_holds (p,q,r)"}.*}

lemma Fol1_L5:
  assumes "p\<or>q\<or>r"
  and "p \<longrightarrow> \<not>q \<and> \<not>r"
  and "q \<longrightarrow> \<not>p \<and> \<not>r"
  and "r \<longrightarrow> \<not>p \<and> \<not>q"
  shows "Exactly_1_of_3_holds (p,q,r)"
proof -;
  from prems have
    "(p\<or>q\<or>r) \<and> (p \<longrightarrow> \<not>q \<and> \<not>r) \<and> (q \<longrightarrow> \<not>p \<and> \<not>r) \<and> (r \<longrightarrow> \<not>p \<and> \<not>q)"
    by blast;
  then show "Exactly_1_of_3_holds (p,q,r)"
    by (unfold Exactly_1_of_3_holds_def);
qed;

text{*Exclusive or definition. There is one also defined in the standard 
  Isabelle, denoted @{text "xor"}, but it relates to boolean values, 
  which are set.s Here we define a logical functor.*}

constdefs
  Xor (infixl "Xor" 66)
  "p Xor q \<equiv> (p\<or>q) \<and> \<not>(p \<and> q)"  

(*
text{*This is an example how we can show a statement of the form 
  @{text "p Xor q"}.*}

lemma Fol1_L6: assumes "p\<or>q" and "\<not>p \<or> \<not>q"
  shows "p Xor q"
proof -
  from prems show "p Xor q" using Xor_def by simp;
qed;*)

end


