(*
    This file is a part of IsarMathLib - 
    a library of formalized mathematics for Isabelle/Isar.

    Copyright (C) 2005, 2006  Slawomir Kolodynski

    This program is free software; Redistribution and use in source and binary forms, 
    with or without modification, are permitted provided that the following conditions are met:

   1. Redistributions of source code must retain the above copyright notice, 
   this list of conditions and the following disclaimer.
   2. Redistributions in binary form must reproduce the above copyright notice, 
   this list of conditions and the following disclaimer in the documentation and/or 
   other materials provided with the distribution.
   3. The name of the author may not be used to endorse or promote products 
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED 
WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*)

header {*\isaheader{Field\_ZF.thy}*}

theory Field_ZF imports Ring_ZF

begin

text{*This theory covers basic facts about fields.*}

section{*Definition and basic properties*}

text{*In this section we define what is a field and list the basic properties
  of fields. *}

text{*Field is a notrivial commutative ring such that all 
  non-zero elements have an inverse. We define the notion of being a field as
  a statement about three sets. The first set, denoted @{text "K"} is the 
  carrier of the field. The second set, denoted @{text "A"} represents the 
  additive operation on @{text "K"} (recall that in ZF set theory functions 
  are sets). The third set @{text "M"} represents the multiplicative operation 
  on @{text "K"}.*}

constdefs
  "IsAfield(K,A,M) \<equiv> 
  (IsAring(K,A,M) \<and> (M {is commutative on} K) \<and>
  TheNeutralElement(K,A) \<noteq> TheNeutralElement(K,M) \<and> 
  (\<forall>a\<in>K. a\<noteq>TheNeutralElement(K,A)\<longrightarrow>
  (\<exists>b\<in>K. M`\<langle>a,b\<rangle> = TheNeutralElement(K,M))))"

text{*The @{text "field0"} context extends the @{text "ring0"}
  context adding field-related assumptions and notation related to the 
  multiplicative inverse. *}

locale field0 = ring0 K +
  assumes mult_commute: "M {is commutative on} K"
  
  assumes not_triv: "\<zero> \<noteq> \<one>"

  assumes inv_exists: "\<forall>a\<in>K. a\<noteq>\<zero> \<longrightarrow> (\<exists>b\<in>K. a\<cdot>b = \<one>)"

  fixes non_zero ("K\<^isub>0")
  defines non_zero_def[simp]: "K\<^isub>0 \<equiv> K-{\<zero>}"

  fixes inv ("_\<inverse> " [90] 91)
  defines inv_def[simp]: "a\<inverse> \<equiv> GroupInv(K\<^isub>0,restrict(M,K\<^isub>0\<times>K\<^isub>0))`(a)";

text{*The next lemma assures us that we are talking fields 
  in the @{text "field0"} context.*}

lemma (in field0) Field_ZF_1_L1: shows "IsAfield(K,A,M)"
  using ringAssum mult_commute not_triv inv_exists IsAfield_def
  by simp;

text{*We can use theorems proven in the @{text "field0"} context whenever we
  talk about a field.*}

lemma Field_ZF_1_L2: assumes "IsAfield(K,A,M)"
  shows "field0(K,A,M)"
  using prems IsAfield_def field0_axioms.intro ring0_def field0_def 
  by simp;

end