(*
    This file is a part of IsarMathLib - 
    a library of formalized mathematics for Isabelle/Isar.

    Copyright (C) 2005  Slawomir Kolodynski

    This program is free software; Redistribution and use in source and binary forms, 
    with or without modification, are permitted provided that the following conditions are met:

   1. Redistributions of source code must retain the above copyright notice, 
   this list of conditions and the following disclaimer.
   2. Redistributions in binary form must reproduce the above copyright notice, 
   this list of conditions and the following disclaimer in the documentation and/or 
   other materials provided with the distribution.
   3. The name of the author may not be used to endorse or promote products 
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED 
WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*)

header {*\isaheader{Finite\_ZF.thy}*}

theory Finite_ZF_1 = Finite1 + Order_ZF:

text{*This theory file contains properties of finite sets related to order 
  relations.*}

section{*Finite vs. bounded sets*}

text{*The goal of this section is to show that finite sets are bounded.*}

text{*For transitive and total relations finite sets are bounded - 
  the induction step.*}

lemma Finite_ZF_1_L1: assumes A1: "r {is total on} X" and A2: "trans(r)"
  and A3: "r \<subseteq> X\<times>X" and A4: "A\<in>Fin(X)" and A5:"x\<in>X" 
  and A6: "x\<notin>A" and A7: "IsBounded(A,r)"
  shows "IsBounded(A\<union>{x},r)"
proof -;
  from A1 A2 A7 A5 A3 show ?thesis using Order_ZF_3_L8 by simp;
qed;

text{*For transitive and total relations finite sets are bounded.*}

theorem Finite_ZF_1_T1: assumes A1: "r {is total on} X" and A2: "trans(r)"
  and A3: "r \<subseteq> X\<times>X" and A4: "B\<in>Fin(X)"
  shows "IsBounded(B,r)"
proof -;
  have "IsBounded(0,r)" using 
    IsBounded_def IsBoundedAbove_def IsBoundedBelow_def by simp;
  moreover from A4 have "B\<in>Fin(X)" .;
  moreover from A1 A2 A3 have 
    "\<forall>A\<in>Fin(X). \<forall>x\<in>X. x\<notin>A \<and> IsBounded(A,r) \<longrightarrow> IsBounded(A\<union>{x},r)"
    using Finite_ZF_1_L1 by simp;
  ultimately show "IsBounded(B,r)" by (rule Finite1_L16B);
qed;

end;