(* 
    This file is a part of IsarMathLib - 
    a library of formalized mathematics for Isabelle/Isar.

    Copyright (C) 2005  Slawomir Kolodynski

    This program is free software; Redistribution and use in source and binary forms, 
    with or without modification, are permitted provided that the following conditions are met:

   1. Redistributions of source code must retain the above copyright notice, 
   this list of conditions and the following disclaimer.
   2. Redistributions in binary form must reproduce the above copyright notice, 
   this list of conditions and the following disclaimer in the documentation and/or 
   other materials provided with the distribution.
   3. The name of the author may not be used to endorse or promote products 
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED 
WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*)

header {*\isaheader{Nat\_ZF.thy}*}

theory Nat_ZF = Nat:

text{*This theory contains lemmas that are missing from the standard 
  Isabelle's Nat.thy file.*}

section{*Induction*}

text{*The induction lemmas in the standard Isabelle's Nat.thy file like 
  for example nat\_induct require the induction step to be a higher order 
  statement (the one that uses the $\Longrightarrow$ sign). I found it 
  difficult to apply from Isar, which is perhaps more of an indication of 
  my Isar skills than anything else. Anyway, here we provide a first order
  version that is easier to reference in Isar declarative style proofs.*}

text{*The induction step for the first order induction.*}

lemma Nat_ZF_1_L1: assumes A1: "x\<in>nat" "P(x)" 
  and A2: "\<forall>k\<in>nat. P(k)\<longrightarrow>P(succ(k))"
  shows "P(succ(x))"
proof -;
  from A1 A2 show ?thesis by simp;
qed;

text{*The actual first order induction on natural numbers.*}

lemma Nat_ZF_1_L2: 
  assumes A1: "n\<in>nat" and A2: "P(0)" and A3: "\<forall>k\<in>nat. P(k)\<longrightarrow>P(succ(k))"
  shows "P(n)"
proof -;
  from A1 A2 have "n\<in>nat" "P(0)" by auto
  then show "P(n)" using Nat_ZF_1_L1 by (rule nat_induct);
qed;

text{*A nonzero natural number has a predecessor.*}

lemma Nat_ZF_1_L3: assumes A1: "n\<in>nat" and A2: "n\<noteq>0"
  shows "\<exists>k\<in>nat. n = succ(k)"
proof -
  from A1 have "n \<in> {0} \<union> {succ(k). k\<in>nat}"
    using nat_unfold by simp;
  with A2 show ?thesis by simp
qed;

end;