(* 
    This file is a part of IsarMathLib - 
    a library of formalized mathematics for Isabelle/Isar.

    Copyright (C) 2005  Slawomir Kolodynski

    This program is free software; Redistribution and use in source and binary forms, 
    with or without modification, are permitted provided that the following conditions are met:

   1. Redistributions of source code must retain the above copyright notice, 
   this list of conditions and the following disclaimer.
   2. Redistributions in binary form must reproduce the above copyright notice, 
   this list of conditions and the following disclaimer in the documentation and/or 
   other materials provided with the distribution.
   3. The name of the author may not be used to endorse or promote products 
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED 
WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*)

header {*\isaheader{Fol1.thy}*}

theory Fol1 = Trancl:

section{*Mission statement*}

text{*Until we come up with soemthing better let's just say
that writing formalized proofs protects from Alzheimer's disease
better than solving crossword puzzles.*}

section{*Release notes*}

text{*This is the last release of IsaMathLib project based on Isabelle 2004. The next release will 
  require Isabelle 2005.*}

section{*Overview of the project*}

text{* 
  The theory files Fo11, ZF1, Nat\_ZF, func1, func\_ZF, EquivClass1, 
  Finite1, Finite\_ZF and Order\_ZF contain some 
  background material that is needed for the remaning theories. 
  
  Group\_ZF, Group\_ZF\_1 and Group\_ZF\_2 
  provide basic facts of the group theory. Group\_ZF\_3 considers the notion
  of almost homomorphisms that is nedeed for the real numbers construction
  in Real\_ZF. 
  
  Ring\_ZF defines rings.  Ring\_ZF\_1 covers the properties of 
  rings that are specific to the real numbers construction in Real\_ZF.
  
  Int\_ZF theory considers the integers as a monoid (multiplication) and 
  an abelian ordered group (addition). 
  In Int\_ZF\_1 we show that integers form a commutative ring.
  Int\_ZF\_2 contains some facts about slopes (almost homomorphisms on integers) 
  needed for real numbers construction.
  
  The Real\_ZF theory starts the construction of 
  real numbers using Norbert A'Campo's approach (not Cauchy sequences,
  not Dedekind sections).
  
  The Topology\_ZF series covers basics of general topology: 
  interior, closure, boundary, compact sets, separation axioms and 
  continuous functions.*}

section{*Notions and lemmas in FOL*}

text{*This section is not interesting and should not be read. Contains 
  mostly shortcuts and workarounds that allow to use more 
  readable coding style.*}

(*temporarily removed bc. it takes too long to check
text{*The definition and lemma below implement a common idiom used in 
romantic mathematics when the author states some assumptions, says
"then the following are equivalent" and proceeds with the proof that shows 
implications between the statements. The usefulness of theorems stated this 
way is rather limited in Isar as the simp and auto methods may take a really 
long time to infer anything from equivalences if there is more than one. 
Still, we believe that being able to formulate a theorem like this 
is good for readibility.*}

constdefs
  All4areEquivalent :: "[o,o,o,o]\<Rightarrow>o"
  "All4areEquivalent(p,q,r,s) == 
  (p\<longleftrightarrow>q) & (p\<longleftrightarrow>r) & (p\<longleftrightarrow>s) & (q\<longleftrightarrow>r) & (q\<longleftrightarrow>s) & (r\<longleftrightarrow>s)";

lemma Fol1_L1: assumes A1: "p\<longrightarrow>q" and A2: "q\<longrightarrow>r" 
  and A3: "r\<longrightarrow>s" and A4: "s\<longrightarrow>p" 
  shows "All4areEquivalent(p,q,r,s)"
proof-;  
  from A1 A2 A3 A4 have "p\<longleftrightarrow>q"by auto;
  moreover from A1 A2 A3 A4 have "p\<longleftrightarrow>r" by auto;
  moreover from A1 A2 A3 A4 have "p\<longleftrightarrow>s" by auto;
  moreover from A1 A2 A3 A4 have "q\<longleftrightarrow>r" by auto;
  moreover from A1 A2 A3 A4 have "q\<longleftrightarrow>s" by auto;
  moreover from A1 A2 A3 A4 have "r\<longleftrightarrow>s" by auto;
  ultimately show ?thesis using All4areEquivalent_def by simp;
qed; 
*)
text{*It happens quite often that we need to prove a statement of the form
$\forall x y. P(x,y) \rightarrow Q(x,y)$. The next lemma provides a shortcut 
for proving this type of statements. To apply this shortcut we can say 
"(rule double\_forall\_implies)" after the "proof" keyword and we are free to
show the statement by doing "fix x y assume P(x,y) show Q(x,y).*}

lemma double_forall_implies: 
  assumes A1:" \<And>x y. P(x,y) \<Longrightarrow> R(x,y)"
  shows "\<forall>x y. (P(x,y) \<longrightarrow> R(x,y))"
proof -;
  from A1 show ?thesis by simp;
qed;

text{*The next lemma serves as a workaround to problems with applying 
  the definition of transitivity (of a relation) in our coding style 
  (any attempt to do
  something like "using trans\_def by simp" results up Isabelle in an 
  infinite loop). We reluctantly use "(unfold trans\_def)" after the "proof"
  keyword  to workaround this.*}

lemma Fol1_L2: assumes 
  A1:"\<forall> x y z. (\<langle>x, y\<rangle> \<in> r \<and> \<langle>y, z\<rangle> \<in> r \<longrightarrow> \<langle>x, z\<rangle> \<in> r)"
  shows "trans(r)"
proof (unfold trans_def);
  show 
    "\<forall>x y z. \<langle>x, y\<rangle> \<in> r \<longrightarrow> \<langle>y, z\<rangle> \<in> r \<longrightarrow> \<langle>x, z\<rangle> \<in> r"
  proof;
    fix x show 
      "\<forall>y z. \<langle>x, y\<rangle> \<in> r \<longrightarrow> \<langle>y, z\<rangle> \<in> r \<longrightarrow> \<langle>x, z\<rangle> \<in> r"
    proof;
      fix y show 
	"\<forall>z. \<langle>x, y\<rangle> \<in> r \<longrightarrow> \<langle>y, z\<rangle> \<in> r \<longrightarrow> \<langle>x, z\<rangle> \<in> r"
      proof;
	fix z
	from A1 have 
	  "\<langle>x, y\<rangle> \<in> r \<and> \<langle>y, z\<rangle> \<in> r \<longrightarrow> \<langle>x, z\<rangle> \<in> r"
	  by blast;
	then show 
	  "\<langle>x, y\<rangle> \<in> r \<longrightarrow> \<langle>y, z\<rangle> \<in> r \<longrightarrow> \<langle>x, z\<rangle> \<in> r"
	  by simp;
      qed;
    qed;
  qed;
qed;

text{*Another workaround for the problem of Isabelle simplifier looping when 
  the transitivity definition is used. *}

lemma Fol1_L3: assumes A1: "trans(r)" and A2: "<a,b> \<in> r  \<and> <b,c> \<in> r"
  shows "<a,c> \<in> r"
proof -;
  from A1 have  "\<forall>x y z. \<langle>x, y\<rangle> \<in> r \<longrightarrow> \<langle>y, z\<rangle> \<in> r \<longrightarrow> \<langle>x, z\<rangle> \<in> r"
    by (unfold trans_def);
  with A2 show ?thesis using imp_conj by fast;
qed;
  
text{*There is a problem with application of the definition of asymetry for
  relations. The next lemma is a workaround.*}

lemma Fol1_L4: assumes A1: "antisym(r)" and A2: "<a,b> \<in> r" "<b,a> \<in> r"  
  shows "a=b"
proof -;
  from A1 have "\<forall> x y. <x,y> \<in> r \<longrightarrow> <y,x> \<in> r \<longrightarrow> x=y"
    by (unfold antisym_def);
  with A2 show "a=b" using imp_conj by fast;
qed;

end


