(*
    This file is a part of IsarMathLib - 
    a library of formalized mathematics for Isabelle/Isar.

    Copyright (C) 2005  Slawomir Kolodynski

    This program is free software; Redistribution and use in source and binary forms, 
    with or without modification, are permitted provided that the following conditions are met:

   1. Redistributions of source code must retain the above copyright notice, 
   this list of conditions and the following disclaimer.
   2. Redistributions in binary form must reproduce the above copyright notice, 
   this list of conditions and the following disclaimer in the documentation and/or 
   other materials provided with the distribution.
   3. The name of the author may not be used to endorse or promote products 
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED 
WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*)

header {*\isaheader{Int\_ZF\_1.thy}*}

theory Int_ZF_1 = Int_ZF + Ring_ZF:;

text{*This theory file considers the set of integers as a ring.*}

section{*Integers as a ring*}

text{*In this section we show that integers form a commutative ring. We also 
  define notation used for the ring of integers.*}

text{*The locale we define next extends the int0 locale
  with notation specific to rings (similar to the one defined in 
  ring0 locale). Unfortunately the absolute value symbol $|\cdot|$ has been 
  hogged by Isabelle, so we will use abs$(m)$ to denote the absolute value of
  $m$.*}

locale int1 = int0 + 

  fixes ints :: "i" ("\<int>")
  defines ints_def [simp]: "\<int> == int"

  fixes ia :: "[i,i]\<Rightarrow>i" (infix "\<ra>" 69)
  defines ia_def [simp]: "a\<ra> b == IntegerAddition`<a,b>"

  fixes iminus :: "i\<Rightarrow>i" ("\<rm> _" 71)
  defines rminus_def [simp]:"\<rm> a == GroupInv(\<int>,IntegerAddition)`(a)"

  fixes isub :: "[i,i]\<Rightarrow>i" (infixl "\<rs>" 69)
  defines isub_def [simp]: "a\<rs>b == a\<ra> (\<rm> b)"

  fixes imult :: "[i,i]\<Rightarrow>i" (infix "\<cdot>" 70)
  defines imult_def [simp]: "a\<cdot>b == IntegerMultiplication`<a,b>"

  fixes izero :: "i" ("\<zero>")
  defines izero_def [simp]: "\<zero> == TheNeutralElement(\<int>,IntegerAddition)"

  fixes ione :: "i" ("\<one>")
  defines ione_def [simp]: "\<one> == TheNeutralElement(\<int>,IntegerMultiplication)"

  fixes nonnegative :: "i" ("\<int>\<^sup>+")
  defines nonnegative_def [simp]: 
  "\<int>\<^sup>+ == Nonnegative(\<int>,IntegerAddition,IntegerOrder)"
  
  fixes abs :: "i\<Rightarrow>i" 
  defines abs_def [simp]: 
  "abs(m) == AbsoluteValue(\<int>,IntegerAddition,IntegerOrder)`(m)"


text{*The essential condition to show that addition is distributive with 
  respect to multiplication.*}

lemma (in int1) Int_ZF_1_1_L1: assumes A1: "a\<in>\<int>" "b\<in>\<int>" "c\<in>\<int>" 
  shows "a\<cdot>(b\<ra>c) = a\<cdot>b \<ra> a\<cdot>c" "(b\<ra>c)\<cdot>a = b\<cdot>a \<ra> c\<cdot>a"
proof -
  from A1 show 
    "a\<cdot>(b\<ra>c) = a\<cdot>b \<ra> a\<cdot>c" "(b\<ra>c)\<cdot>a = b\<cdot>a \<ra> c\<cdot>a"
    using Int_ZF_1_L2 zadd_zmult_distrib zadd_zmult_distrib2
    by auto;
qed;

text{*Integers form a commutative ring, hence we can use theorems proven 
  in ring0 contex (locale).*}

lemma (in int1) Int_ZF_1_1_L2: 
  "IsAring(\<int>,IntegerAddition,IntegerMultiplication)"
  "IntegerMultiplication {is commutative on} \<int>"
  "ring0(\<int>,IntegerAddition,IntegerMultiplication)"
proof -
  have "\<forall>a\<in>\<int>.\<forall>b\<in>\<int>.\<forall>c\<in>\<int>. 
    a\<cdot>(b\<ra>c) = a\<cdot>b \<ra> a\<cdot>c \<and> (b\<ra>c)\<cdot>a = b\<cdot>a \<ra> c\<cdot>a"
    using Int_ZF_1_1_L1 by simp;
  then have "IsDistributive(\<int>,IntegerAddition,IntegerMultiplication)"
    using IsDistributive_def by simp;
  then show "IsAring(\<int>,IntegerAddition,IntegerMultiplication)"
    "ring0(\<int>,IntegerAddition,IntegerMultiplication)"
    using Int_ZF_1_T1 Int_ZF_1_T2 IsAring_def ring0_def 
    by auto;
  have "\<forall>a\<in>\<int>.\<forall>b\<in>\<int>. a\<cdot>b = b\<cdot>a" using Int_ZF_1_L4 by simp;
  then show "IntegerMultiplication {is commutative on} \<int>"
    using IsCommutative_def by simp;
qed;

text{*Zero and one are integers.*}

lemma (in int1) Int_ZF_1_1_L3: "\<zero>\<in>\<int>" "\<one>\<in>\<int>"
proof -
  show "\<zero>\<in>\<int>" "\<one>\<in>\<int>" using Int_ZF_1_1_L2 ring0.Ring_ZF_1_L2
    by auto;
qed;

text{*Properties with one integer.*}

lemma (in int1) Ring_ZF_1_L4: assumes A1: "a \<in> \<int>"
  shows "a\<ra>\<zero> = a" "\<zero>\<ra>a = a" "a\<cdot>\<one> = a" "\<one>\<cdot>a = a"
  "\<zero>\<cdot>a = \<zero>" "a\<cdot>\<zero> = \<zero>" "(\<rm>a) \<in> \<int>"
proof -;
  from A1 show 
    "a\<ra>\<zero> = a" "\<zero>\<ra>a = a" "a\<cdot>\<one> = a" "\<one>\<cdot>a = a" "(\<rm>a) \<in> \<int>"
    using Int_ZF_1_1_L2 ring0.Ring_ZF_1_L3 by auto;
  from A1 show "\<zero>\<cdot>a = \<zero>" "a\<cdot>\<zero> = \<zero>"
    using Int_ZF_1_1_L2 ring0.Ring_ZF_1_L6 by auto;
qed;

text{*Properties that require two integers.*}

lemma (in int1) Ring_ZF_1_L4: assumes A1: "a\<in>\<int>" "b\<in>\<int>"
  shows "a\<ra>b \<in> \<int>" "a\<rs>b \<in> \<int>" "a\<cdot>b \<in> \<int>"
  "a\<ra>b = b\<ra>a" "a\<cdot>b = b\<cdot>a"  
proof -;
  from A1 show "a\<ra>b \<in> \<int>" "a\<rs>b \<in> \<int>" "a\<cdot>b \<in> \<int>" "a\<ra>b = b\<ra>a"
    using Int_ZF_1_1_L2 ring0.Ring_ZF_1_L4 by auto;
  from A1 show "a\<cdot>b = b\<cdot>a" using Int_ZF_1_L4 by simp;
qed;
end
    

