(*
    This file is a part of IsarMathLib - 
    a library of formalized mathematics for Isabelle/Isar.

    Copyright (C) 2005  Slawomir Kolodynski

    This program is free software; Redistribution and use in source and binary forms, 
    with or without modification, are permitted provided that the following conditions are met:

   1. Redistributions of source code must retain the above copyright notice, 
   this list of conditions and the following disclaimer.
   2. Redistributions in binary form must reproduce the above copyright notice, 
   this list of conditions and the following disclaimer in the documentation and/or 
   other materials provided with the distribution.
   3. The name of the author may not be used to endorse or promote products 
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED 
WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*)

header {*\isaheader{Int\_ZF\_2.thy}*}

theory Int_ZF_2 = Int_ZF_1 + Group_ZF_3:;

text{*This theory file we consider the properties of integers that are 
  specific to the real numbers construction in Real\_ZF\_x.thy series. *}

section{*Slopes*}

text{*In this section we study basic properties of slopes - the integer 
  almost homomorphisms. 
  The general definition of an almost homomorphism requires the set 
  $\{f(m+n) - f(m) - f(n): m,n\in Z\}$ to be finite. 
  The goal of this section is
  to establish a definition that is equivalent for integers: 
  that for all integer $m,n$ we have $|f(m+n) - f(m) - f(n)| \leq L$ for
  some $L$. The notation used in this section is the one defined by the int1
  context in Int\_ZF\_1.thy *}

text{*We define slopes as almost homomorphisms on the additive group of
  integers.*}

constdefs

  Slopes :: "i"
  "Slopes == AlmostHoms(int,IntegerAddition)"

text{*We can use theorems proven in group1 context.*}

lemma (in int1) Int_ZF_2_1_L1: "group1(\<int>,IntegerAddition)"
proof -;
  show ?thesis using 
    Int_ZF_1_T2 group1_axioms.intro group1_def by simp;
qed;

text{*Type information related to the homomorphism difference expression.*}

lemma (in int1) Int_ZF_2_1_L2: assumes A1: "f \<in> Slopes"
  and A2: "n\<in>\<int>" "m\<in>\<int>"
  shows "m\<ra>n \<in> \<int>" "f`(m\<ra>n) \<in> \<int>" "f`(m) \<in> \<int>" "f`(n) \<in> \<int>"
  "f`(m) \<ra> f`(n) \<in> \<int>" "HomDiff(\<int>,IntegerAddition,f,<m,n>) \<in> \<int>" 
proof -;
  from A1 A2 show 
    "m\<ra>n \<in> \<int>" "f`(m\<ra>n) \<in> \<int>" "f`(m) \<in> \<int>" "f`(n) \<in> \<int>"
    "f`(m) \<ra> f`(n) \<in> \<int>" "HomDiff(\<int>,IntegerAddition,f,<m,n>) \<in> \<int>" 
    using Slopes_def Int_ZF_2_1_L1 group1.Group_ZF_3_2_L4A
    by auto;
qed;

text{*Type information related to the homomorphism difference expression.*}

lemma (in int1) Int_ZF_2_1_L2A: assumes A1: "f:\<int>\<rightarrow>\<int>"
  and A2: "n\<in>\<int>" "m\<in>\<int>"
  shows "m\<ra>n \<in> \<int>" "f`(m\<ra>n) \<in> \<int>" "f`(m) \<in> \<int>" "f`(n) \<in> \<int>"
  "f`(m) \<ra> f`(n) \<in> \<int>" "HomDiff(\<int>,IntegerAddition,f,<m,n>) \<in> \<int>"
proof -; 
  from A1 A2 show "m\<ra>n \<in> \<int>" "f`(m\<ra>n) \<in> \<int>" "f`(m) \<in> \<int>" "f`(n) \<in> \<int>"
    "f`(m) \<ra> f`(n) \<in> \<int>" "HomDiff(\<int>,IntegerAddition,f,<m,n>) \<in> \<int>" 
    using Int_ZF_1_1_L2 Ring_ZF_1_L4 apply_funtype HomDiff_def by auto;
qed;
  
text{*Slopes map integers into integers.*}

lemma (in int1) Int_ZF_2_1_L2B: assumes A1: "f \<in> Slopes"
  shows "f:\<int>\<rightarrow>\<int>"
proof-; 
  from A1 have "f \<in> AlmostHoms(\<int>,IntegerAddition)"
    using Slopes_def by simp;
  then show ?thesis using AlmostHoms_def by simp;
qed;

text{*The homomorphism difference in multiplicative notation is defined as
  the expression $s(m\cdot n)\cdot(s(m)\cdot s(n))^{-1}$. The next lemma 
  shows that 
  in the additive notation used for integers the homomorphism 
  difference is $f(m+n) - f(m) - f(n)$.*}

lemma (in int1) Int_ZF_2_1_L3: 
  assumes A1: "f:\<int>\<rightarrow>\<int>" and A2: "m\<in>\<int>" "n\<in>\<int>"
  shows "HomDiff(\<int>,IntegerAddition,f,<m,n>) = f`(m\<ra>n)\<rs>f`(m)\<rs>f`(n)"
proof -
  from A1 A2 show ?thesis using Int_ZF_2_1_L2A Int_ZF_1_T2 
    group0.group0_4_L4A HomDiff_def by auto;
qed;

text{*The homomorphism difference in multiplicative notation is defined as
  the expression $s(m\cdot n)\cdot(s(m)\cdot s(n))^{-1}$. The next lemma 
  shows that 
  in the additive notation used for integers the homomorphism 
  difference is $f(m+n) - f(n) - f(m)$.*}

lemma (in int1) Int_ZF_2_1_L3A: 
  assumes A1: "f:\<int>\<rightarrow>\<int>" and A2: "m\<in>\<int>" "n\<in>\<int>"
  shows "HomDiff(\<int>,IntegerAddition,f,<m,n>) = f`(m\<ra>n)\<rs>f`(n)\<rs>f`(m)"
proof -
  from A1 A2 show ?thesis using Int_ZF_2_1_L2A Int_ZF_1_T2 
    group0.group0_4_L4A HomDiff_def by auto;
qed;
 
text{*If $f$ is an almost homomorphism then we have 
  $|f(m+n) - f(m) - f(n)| \leq L$ for some $L$*}

lemma (in int1) Int_ZF_2_1_L4: assumes A1: "f \<in> Slopes"
  shows "\<exists>L. \<forall>m\<in>\<int>.\<forall>n\<in>\<int>. abs(f`(m\<ra>n)\<rs>f`(m)\<rs>f`(n)) \<lsq> L"
  "\<exists>L. \<forall>m\<in>\<int>.\<forall>n\<in>\<int>. abs(f`(m\<ra>n)\<rs>f`(n)\<rs>f`(m)) \<lsq> L"
proof -
  from A1 have "f \<in> AlmostHoms(\<int>,IntegerAddition)" and T1: "f:\<int>\<rightarrow>\<int>"
    using Slopes_def Int_ZF_2_1_L2B by auto;
  then have "\<exists>L.\<forall>x\<in>\<int>\<times>\<int>. abs(HomDiff(\<int>,IntegerAddition,f,x))\<lsq> L"
    using AlmostHoms_def Int_ZF_4_T1 Int_ZF_2_T1 group3.OrderedGroup_ZF_3_L11
    by simp;
  then have T2: 
    "\<exists>L. \<forall>m\<in>\<int>.\<forall>n\<in>\<int>. abs(HomDiff(\<int>,IntegerAddition,f,<m,n>))\<lsq> L"
    by auto;
  with A1 T1 show 
    "\<exists>L. \<forall>m\<in>\<int>.\<forall>n\<in>\<int>. abs(f`(m\<ra>n)\<rs>f`(m)\<rs>f`(n)) \<lsq> L"
    using Int_ZF_2_1_L3 by simp;
  from A1 T1 T2 show
    "\<exists>L. \<forall>m\<in>\<int>.\<forall>n\<in>\<int>. abs(f`(m\<ra>n)\<rs>f`(n)\<rs>f`(m)) \<lsq> L"
    using Int_ZF_2_1_L3A by simp;
qed;

text{*If $f$ maps integers into integers and 
  for all $m,n\in Z$ we have $|f(m+n) - f(m) - f(n)| \leq L$ for some $L$,
  then $f$ is a slope.*}

lemma (in int1) Int_ZF_2_1_L5: assumes A1: "f:\<int>\<rightarrow>\<int>"
  and A2: "\<forall>m\<in>\<int>.\<forall>n\<in>\<int>. abs(f`(m\<ra>n)\<rs>f`(m)\<rs>f`(n)) \<lsq> L"
  shows "f \<in> Slopes"
proof -;
  let ?Abs = "AbsoluteValue(\<int>,IntegerAddition,IntegerOrder)"
  have "group3(\<int>,IntegerAddition,IntegerOrder)" 
    "IntegerOrder {is total on} \<int>"
    using Int_ZF_2_T1 by auto
  moreover from A1 A2 have 
    "\<forall>x\<in>\<int>\<times>\<int>. HomDiff(\<int>,IntegerAddition,f,x) \<in> \<int> \<and>
    \<langle>?Abs`(HomDiff(\<int>,IntegerAddition,f,x)),L \<rangle> \<in> IntegerOrder"
    using Int_ZF_2_1_L2A Int_ZF_2_1_L3 by auto;
  ultimately have 
    "IsBounded({HomDiff(\<int>,IntegerAddition,f,x). x\<in>\<int>\<times>\<int>},IntegerOrder)"
    by (rule group3.OrderedGroup_ZF_3_L9A);
  with A1 have "f \<in> AlmostHoms(\<int>,IntegerAddition)"
    using Int_ZF_4_T1 AlmostHoms_def by simp;
  then show "f \<in> Slopes" using Slopes_def by simp;
qed;

text{*A similar statement as above, but with $|f(m+n) - f(n) - f(m)| \leq L$.*}

lemma (in int1) Int_ZF_2_1_L6: assumes A1: "f:\<int>\<rightarrow>\<int>"
  and A2: "\<forall>m\<in>\<int>.\<forall>n\<in>\<int>. abs(f`(m\<ra>n)\<rs>f`(n)\<rs>f`(m)) \<lsq> L"
  shows "f \<in> Slopes"
proof -;
  from A1 have "\<forall>m\<in>\<int>.\<forall>n\<in>\<int>. 
    f`(m\<ra>n)\<rs>f`(n)\<rs>f`(m) = HomDiff(\<int>,IntegerAddition,f,<m,n>)"
    using Int_ZF_2_1_L3A by simp;
  with A1 A2 have "\<forall>m\<in>\<int>.\<forall>n\<in>\<int>. abs(f`(m\<ra>n)\<rs>f`(m)\<rs>f`(n)) \<lsq> L"
    using Int_ZF_2_1_L3 by simp;
  with A1 show "f \<in> Slopes" by (rule Int_ZF_2_1_L5);
qed;
  
end