(* 
    This file is a part of MMIsar - a translation of Metamath's set.mm to Isabelle 2005 (ZF logic).

    Copyright (C) 2006  Slawomir Kolodynski

    This program is free software; Redistribution and use in source and binary forms, 
    with or without modification, are permitted provided that the following conditions are met:

   1. Redistributions of source code must retain the above copyright notice, 
   this list of conditions and the following disclaimer.
   2. Redistributions in binary form must reproduce the above copyright notice, 
   this list of conditions and the following disclaimer in the documentation and/or 
   other materials provided with the distribution.
   3. The name of the author may not be used to endorse or promote products 
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*)

header {*\isaheader{MMI\_Complex\_ZF\_1.thy}*} 

theory MMI_Complex_ZF_1 imports MMI_examples

begin  

text{*This theory contains theorems (with proofs) about complex numbers
  imported from the Metamath's set.mm database. 
  The original Metamath proofs were mostly written by Norman Megill, 
  see the Metamath Proof Explorer pages for full atribution.
  This theory contains about 200 theorems.
*}

(********211-220*************************)

lemma (in MMIsar0) MMI_recrect: 
   shows "( A \<in> \<complex> \<and> A \<noteq> \<zero> ) \<longrightarrow> 
 ( \<one> \<cdiv> ( \<one> \<cdiv> A ) ) = A"
proof -
   have S1: "A = 
 if ( ( A \<in> \<complex> \<and> A \<noteq> \<zero> ) , A , \<one> ) \<longrightarrow> 
 ( \<one> \<cdiv> A ) = 
 ( \<one> \<cdiv> if ( ( A \<in> \<complex> \<and> A \<noteq> \<zero> ) , A , \<one> ) )" by (rule MMI_opreq2)
   from S1 have S2: "A = 
 if ( ( A \<in> \<complex> \<and> A \<noteq> \<zero> ) , A , \<one> ) \<longrightarrow> 
 ( \<one> \<cdiv> ( \<one> \<cdiv> A ) ) = 
 ( \<one> \<cdiv> ( \<one> \<cdiv> if ( ( A \<in> \<complex> \<and> A \<noteq> \<zero> ) , A , \<one> ) ) )" 
     by (rule MMI_opreq2d)
   have S3: "A = 
 if ( ( A \<in> \<complex> \<and> A \<noteq> \<zero> ) , A , \<one> ) \<longrightarrow> 
 A = if ( ( A \<in> \<complex> \<and> A \<noteq> \<zero> ) , A , \<one> )" by (rule MMI_id)
   from S2 S3 have S4: "A = 
 if ( ( A \<in> \<complex> \<and> A \<noteq> \<zero> ) , A , \<one> ) \<longrightarrow> 
 ( ( \<one> \<cdiv> ( \<one> \<cdiv> A ) ) = 
 A \<longleftrightarrow> 
 ( \<one> \<cdiv> ( \<one> \<cdiv> if ( ( A \<in> \<complex> \<and> A \<noteq> \<zero> ) , A , \<one> ) ) ) = 
 if ( ( A \<in> \<complex> \<and> A \<noteq> \<zero> ) , A , \<one> ) )" by (rule MMI_eqeq12d)
   have S5: "A = 
 if ( ( A \<in> \<complex> \<and> A \<noteq> \<zero> ) , A , \<one> ) \<longrightarrow> 
 ( A \<in> \<complex> \<longleftrightarrow> 
 if ( ( A \<in> \<complex> \<and> A \<noteq> \<zero> ) , A , \<one> ) \<in> \<complex> )" by (rule MMI_eleq1)
   have S6: "A = 
 if ( ( A \<in> \<complex> \<and> A \<noteq> \<zero> ) , A , \<one> ) \<longrightarrow> 
 ( A \<noteq> \<zero> \<longleftrightarrow> 
 if ( ( A \<in> \<complex> \<and> A \<noteq> \<zero> ) , A , \<one> ) \<noteq> \<zero> )" by (rule MMI_neeq1)
   from S5 S6 have S7: "A = 
 if ( ( A \<in> \<complex> \<and> A \<noteq> \<zero> ) , A , \<one> ) \<longrightarrow> 
 ( ( A \<in> \<complex> \<and> A \<noteq> \<zero> ) \<longleftrightarrow> 
 ( if ( ( A \<in> \<complex> \<and> A \<noteq> \<zero> ) , A , \<one> ) \<in> \<complex> \<and> if ( ( A \<in> \<complex> \<and> A \<noteq> \<zero> ) , A , \<one> ) \<noteq> \<zero> ) )" by (rule MMI_anbi12d)
   have S8: "\<one> = 
 if ( ( A \<in> \<complex> \<and> A \<noteq> \<zero> ) , A , \<one> ) \<longrightarrow> 
 ( \<one> \<in> \<complex> \<longleftrightarrow> 
 if ( ( A \<in> \<complex> \<and> A \<noteq> \<zero> ) , A , \<one> ) \<in> \<complex> )" by (rule MMI_eleq1)
   have S9: "\<one> = 
 if ( ( A \<in> \<complex> \<and> A \<noteq> \<zero> ) , A , \<one> ) \<longrightarrow> 
 ( \<one> \<noteq> \<zero> \<longleftrightarrow> 
 if ( ( A \<in> \<complex> \<and> A \<noteq> \<zero> ) , A , \<one> ) \<noteq> \<zero> )" by (rule MMI_neeq1)
   from S8 S9 have S10: "\<one> = 
 if ( ( A \<in> \<complex> \<and> A \<noteq> \<zero> ) , A , \<one> ) \<longrightarrow> 
 ( ( \<one> \<in> \<complex> \<and> \<one> \<noteq> \<zero> ) \<longleftrightarrow> 
 ( if ( ( A \<in> \<complex> \<and> A \<noteq> \<zero> ) , A , \<one> ) \<in> \<complex> \<and> if ( ( A \<in> \<complex> \<and> A \<noteq> \<zero> ) , A , \<one> ) \<noteq> \<zero> ) )" by (rule MMI_anbi12d)
   have S11: "\<one> \<in> \<complex>" by (rule MMI_1cn)
   have S12: "\<one> \<noteq> \<zero>" by (rule MMI_ax1ne0)
   from S11 S12 have S13: "\<one> \<in> \<complex> \<and> \<one> \<noteq> \<zero>" by (rule MMI_pm3_2i)
   from S7 S10 S13 have S14: "if ( ( A \<in> \<complex> \<and> A \<noteq> \<zero> ) , A , \<one> ) \<in> \<complex> \<and> if ( ( A \<in> \<complex> \<and> A \<noteq> \<zero> ) , A , \<one> ) \<noteq> \<zero>" by (rule MMI_elimhyp)
   from S14 have S15: "if ( ( A \<in> \<complex> \<and> A \<noteq> \<zero> ) , A , \<one> ) \<in> \<complex>" by (rule MMI_pm3_26i)
   from S14 have S16: "if ( ( A \<in> \<complex> \<and> A \<noteq> \<zero> ) , A , \<one> ) \<in> \<complex> \<and> if ( ( A \<in> \<complex> \<and> A \<noteq> \<zero> ) , A , \<one> ) \<noteq> \<zero>" .
   from S16 have S17: "if ( ( A \<in> \<complex> \<and> A \<noteq> \<zero> ) , A , \<one> ) \<noteq> \<zero>" by (rule MMI_pm3_27i)
   from S15 S17 have S18: "( \<one> \<cdiv> ( \<one> \<cdiv> if ( ( A \<in> \<complex> \<and> A \<noteq> \<zero> ) , A , \<one> ) ) ) = 
 if ( ( A \<in> \<complex> \<and> A \<noteq> \<zero> ) , A , \<one> )" by (rule MMI_recrec)
   from S4 S18 show "( A \<in> \<complex> \<and> A \<noteq> \<zero> ) \<longrightarrow> 
 ( \<one> \<cdiv> ( \<one> \<cdiv> A ) ) = A" by (rule MMI_dedth)
qed

lemma (in MMIsar0) MMI_rec11i: assumes A1: "A \<in> \<complex>" and
    A2: "B \<in> \<complex>" and
    A3: "A \<noteq> \<zero>" and
    A4: "B \<noteq> \<zero>"   
   shows "( \<one> \<cdiv> A ) = ( \<one> \<cdiv> B ) \<longleftrightarrow> A = B"
proof -
   have S1: "( \<one> \<cdiv> A ) = 
 ( \<one> \<cdiv> B ) \<longrightarrow> 
 ( ( A \<cdot> B ) \<cdot> ( \<one> \<cdiv> A ) ) = 
 ( ( A \<cdot> B ) \<cdot> ( \<one> \<cdiv> B ) )" by (rule MMI_opreq2)
   from A1 have S2: "A \<in> \<complex>".
   from A2 have S3: "B \<in> \<complex>".
   from A1 have S4: "A \<in> \<complex>".
   from A3 have S5: "A \<noteq> \<zero>".
   from S4 S5 have S6: "( \<one> \<cdiv> A ) \<in> \<complex>" by (rule MMI_reccl)
   from S2 S3 S6 have S7: "( ( A \<cdot> B ) \<cdot> ( \<one> \<cdiv> A ) ) = 
 ( ( A \<cdot> ( \<one> \<cdiv> A ) ) \<cdot> B )" by (rule MMI_mul23)
   from A1 have S8: "A \<in> \<complex>".
   from A3 have S9: "A \<noteq> \<zero>".
   from S8 S9 have S10: "( A \<cdot> ( \<one> \<cdiv> A ) ) = \<one>" by (rule MMI_recid)
   from S10 have S11: "( ( A \<cdot> ( \<one> \<cdiv> A ) ) \<cdot> B ) = ( \<one> \<cdot> B )" by (rule MMI_opreq1i)
   from A2 have S12: "B \<in> \<complex>".
   from S12 have S13: "( \<one> \<cdot> B ) = B" by (rule MMI_mulid2)
   from S7 S11 S13 have S14: "( ( A \<cdot> B ) \<cdot> ( \<one> \<cdiv> A ) ) = B" by (rule MMI_3eqtr)
   from A1 have S15: "A \<in> \<complex>".
   from A2 have S16: "B \<in> \<complex>".
   from A2 have S17: "B \<in> \<complex>".
   from A4 have S18: "B \<noteq> \<zero>".
   from S17 S18 have S19: "( \<one> \<cdiv> B ) \<in> \<complex>" by (rule MMI_reccl)
   from S15 S16 S19 have S20: "( ( A \<cdot> B ) \<cdot> ( \<one> \<cdiv> B ) ) = 
 ( A \<cdot> ( B \<cdot> ( \<one> \<cdiv> B ) ) )" by (rule MMI_mulass)
   from A2 have S21: "B \<in> \<complex>".
   from A4 have S22: "B \<noteq> \<zero>".
   from S21 S22 have S23: "( B \<cdot> ( \<one> \<cdiv> B ) ) = \<one>" by (rule MMI_recid)
   from S23 have S24: "( A \<cdot> ( B \<cdot> ( \<one> \<cdiv> B ) ) ) = ( A \<cdot> \<one> )" by (rule MMI_opreq2i)
   from A1 have S25: "A \<in> \<complex>".
   from S25 have S26: "( A \<cdot> \<one> ) = A" by (rule MMI_mulid1)
   from S20 S24 S26 have S27: "( ( A \<cdot> B ) \<cdot> ( \<one> \<cdiv> B ) ) = A" by (rule MMI_3eqtr)
   from S14 S27 have S28: "( ( A \<cdot> B ) \<cdot> ( \<one> \<cdiv> A ) ) = 
 ( ( A \<cdot> B ) \<cdot> ( \<one> \<cdiv> B ) ) \<longleftrightarrow> B = A" by (rule MMI_eqeq12i)
   have S29: "B = A \<longleftrightarrow> A = B" by (rule MMI_eqcom)
   from S28 S29 have S30: "( ( A \<cdot> B ) \<cdot> ( \<one> \<cdiv> A ) ) = 
 ( ( A \<cdot> B ) \<cdot> ( \<one> \<cdiv> B ) ) \<longleftrightarrow> A = B" by (rule MMI_bitr)
   from S1 S30 have S31: "( \<one> \<cdiv> A ) = ( \<one> \<cdiv> B ) \<longrightarrow> A = B" by (rule MMI_sylib)
   have S32: "A = B \<longrightarrow> ( \<one> \<cdiv> A ) = ( \<one> \<cdiv> B )" by (rule MMI_opreq2)
   from S31 S32 show "( \<one> \<cdiv> A ) = ( \<one> \<cdiv> B ) \<longleftrightarrow> A = B" by (rule MMI_impbi)
qed

lemma (in MMIsar0) MMI_rec11: assumes A1: "A \<in> \<complex>" and
    A2: "B \<in> \<complex>"   
   shows "( A \<noteq> \<zero> \<and> B \<noteq> \<zero> ) \<longrightarrow> 
 ( ( \<one> \<cdiv> A ) = ( \<one> \<cdiv> B ) \<longleftrightarrow> A = B )"
proof -
   have S1: "A = 
 if ( A \<noteq> \<zero> , A , \<one> ) \<longrightarrow> 
 ( \<one> \<cdiv> A ) = 
 ( \<one> \<cdiv> if ( A \<noteq> \<zero> , A , \<one> ) )" by (rule MMI_opreq2)
   from S1 have S2: "A = 
 if ( A \<noteq> \<zero> , A , \<one> ) \<longrightarrow> 
 ( ( \<one> \<cdiv> A ) = 
 ( \<one> \<cdiv> B ) \<longleftrightarrow> 
 ( \<one> \<cdiv> if ( A \<noteq> \<zero> , A , \<one> ) ) = 
 ( \<one> \<cdiv> B ) )" by (rule MMI_eqeq1d)
   have S3: "A = 
 if ( A \<noteq> \<zero> , A , \<one> ) \<longrightarrow> 
 ( A = B \<longleftrightarrow> if ( A \<noteq> \<zero> , A , \<one> ) = B )" by (rule MMI_eqeq1)
   from S2 S3 have S4: "A = 
 if ( A \<noteq> \<zero> , A , \<one> ) \<longrightarrow> 
 ( ( ( \<one> \<cdiv> A ) = ( \<one> \<cdiv> B ) \<longleftrightarrow> A = B ) \<longleftrightarrow> 
 ( ( \<one> \<cdiv> if ( A \<noteq> \<zero> , A , \<one> ) ) = 
 ( \<one> \<cdiv> B ) \<longleftrightarrow> 
 if ( A \<noteq> \<zero> , A , \<one> ) = B ) )" by (rule MMI_bibi12d)
   have S5: "B = 
 if ( B \<noteq> \<zero> , B , \<one> ) \<longrightarrow> 
 ( \<one> \<cdiv> B ) = 
 ( \<one> \<cdiv> if ( B \<noteq> \<zero> , B , \<one> ) )" by (rule MMI_opreq2)
   from S5 have S6: "B = 
 if ( B \<noteq> \<zero> , B , \<one> ) \<longrightarrow> 
 ( ( \<one> \<cdiv> if ( A \<noteq> \<zero> , A , \<one> ) ) = 
 ( \<one> \<cdiv> B ) \<longleftrightarrow> 
 ( \<one> \<cdiv> if ( A \<noteq> \<zero> , A , \<one> ) ) = 
 ( \<one> \<cdiv> if ( B \<noteq> \<zero> , B , \<one> ) ) )" by (rule MMI_eqeq2d)
   have S7: "B = 
 if ( B \<noteq> \<zero> , B , \<one> ) \<longrightarrow> 
 ( if ( A \<noteq> \<zero> , A , \<one> ) = 
 B \<longleftrightarrow> 
 if ( A \<noteq> \<zero> , A , \<one> ) = 
 if ( B \<noteq> \<zero> , B , \<one> ) )" by (rule MMI_eqeq2)
   from S6 S7 have S8: "B = 
 if ( B \<noteq> \<zero> , B , \<one> ) \<longrightarrow> 
 ( ( ( \<one> \<cdiv> if ( A \<noteq> \<zero> , A , \<one> ) ) = ( \<one> \<cdiv> B ) \<longleftrightarrow> if ( A \<noteq> \<zero> , A , \<one> ) = B ) \<longleftrightarrow> 
 ( ( \<one> \<cdiv> if ( A \<noteq> \<zero> , A , \<one> ) ) = 
 ( \<one> \<cdiv> if ( B \<noteq> \<zero> , B , \<one> ) ) \<longleftrightarrow> 
 if ( A \<noteq> \<zero> , A , \<one> ) = 
 if ( B \<noteq> \<zero> , B , \<one> ) ) )" by (rule MMI_bibi12d)
   from A1 have S9: "A \<in> \<complex>".
   have S10: "\<one> \<in> \<complex>" by (rule MMI_1cn)
   from S9 S10 have S11: "if ( A \<noteq> \<zero> , A , \<one> ) \<in> \<complex>" by (rule MMI_keepel)
   from A2 have S12: "B \<in> \<complex>".
   have S13: "\<one> \<in> \<complex>" by (rule MMI_1cn)
   from S12 S13 have S14: "if ( B \<noteq> \<zero> , B , \<one> ) \<in> \<complex>" by (rule MMI_keepel)
   have S15: "if ( A \<noteq> \<zero> , A , \<one> ) \<noteq> \<zero>" by (rule MMI_elimne0)
   have S16: "if ( B \<noteq> \<zero> , B , \<one> ) \<noteq> \<zero>" by (rule MMI_elimne0)
   from S11 S14 S15 S16 have S17: "( \<one> \<cdiv> if ( A \<noteq> \<zero> , A , \<one> ) ) = 
 ( \<one> \<cdiv> if ( B \<noteq> \<zero> , B , \<one> ) ) \<longleftrightarrow> 
 if ( A \<noteq> \<zero> , A , \<one> ) = 
 if ( B \<noteq> \<zero> , B , \<one> )" by (rule MMI_rec11i)
   from S4 S8 S17 show "( A \<noteq> \<zero> \<and> B \<noteq> \<zero> ) \<longrightarrow> 
 ( ( \<one> \<cdiv> A ) = ( \<one> \<cdiv> B ) \<longleftrightarrow> A = B )" by (rule MMI_dedth2h)
qed

lemma (in MMIsar0) MMI_divmuldivt: 
   shows "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( A \<cdiv> B ) \<cdot> ( C \<cdiv> D ) ) = 
 ( ( A \<cdot> C ) \<cdiv> ( B \<cdot> D ) )"
proof -
   have S1: "( ( B \<cdot> D ) \<in> \<complex> \<and> ( ( A \<cdiv> B ) \<cdot> ( C \<cdiv> D ) ) \<in> \<complex> \<and> ( B \<cdot> D ) \<noteq> \<zero> ) \<longrightarrow> 
 ( ( ( B \<cdot> D ) \<cdot> ( ( A \<cdiv> B ) \<cdot> ( C \<cdiv> D ) ) ) \<cdiv> ( B \<cdot> D ) ) = 
 ( ( A \<cdiv> B ) \<cdot> ( C \<cdiv> D ) )" by (rule MMI_divcan3t)
   have S2: "( B \<in> \<complex> \<and> D \<in> \<complex> ) \<longrightarrow> ( B \<cdot> D ) \<in> \<complex>" by (rule MMI_axmulcl)
   from S2 have S3: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
 ( B \<cdot> D ) \<in> \<complex>" by (rule MMI_ad2ant2l)
   from S3 have S4: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( B \<cdot> D ) \<in> \<complex>" by (rule MMI_adantr)
   have S5: "( ( A \<cdiv> B ) \<in> \<complex> \<and> ( C \<cdiv> D ) \<in> \<complex> ) \<longrightarrow> 
 ( ( A \<cdiv> B ) \<cdot> ( C \<cdiv> D ) ) \<in> \<complex>" by (rule MMI_axmulcl)
   have S6: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> B \<noteq> \<zero> ) \<longrightarrow> 
 ( A \<cdiv> B ) \<in> \<complex>" by (rule MMI_divclt)
   from S6 have S7: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> B \<noteq> \<zero> ) \<longrightarrow> 
 ( A \<cdiv> B ) \<in> \<complex>" by (rule MMI_3expa)
   have S8: "( C \<in> \<complex> \<and> D \<in> \<complex> \<and> D \<noteq> \<zero> ) \<longrightarrow> 
 ( C \<cdiv> D ) \<in> \<complex>" by (rule MMI_divclt)
   from S8 have S9: "( ( C \<in> \<complex> \<and> D \<in> \<complex> ) \<and> D \<noteq> \<zero> ) \<longrightarrow> 
 ( C \<cdiv> D ) \<in> \<complex>" by (rule MMI_3expa)
   from S5 S7 S9 have S10: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> B \<noteq> \<zero> ) \<and> ( ( C \<in> \<complex> \<and> D \<in> \<complex> ) \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( A \<cdiv> B ) \<cdot> ( C \<cdiv> D ) ) \<in> \<complex>" by (rule MMI_syl2an)
   from S10 have S11: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( A \<cdiv> B ) \<cdot> ( C \<cdiv> D ) ) \<in> \<complex>" by (rule MMI_an4s)
   have S12: "( B \<in> \<complex> \<and> D \<in> \<complex> ) \<longrightarrow> 
 ( ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) \<longleftrightarrow> ( B \<cdot> D ) \<noteq> \<zero> )" by (rule MMI_muln0bt)
   from S12 have S13: "( B \<in> \<complex> \<and> D \<in> \<complex> ) \<longrightarrow> 
 ( ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) \<longrightarrow> ( B \<cdot> D ) \<noteq> \<zero> )" by (rule MMI_biimpd)
   from S13 have S14: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
 ( ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) \<longrightarrow> ( B \<cdot> D ) \<noteq> \<zero> )" by (rule MMI_ad2ant2l)
   from S14 have S15: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( B \<cdot> D ) \<noteq> \<zero>" by (rule MMI_imp)
   from S1 S4 S11 S15 have S16: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( ( B \<cdot> D ) \<cdot> ( ( A \<cdiv> B ) \<cdot> ( C \<cdiv> D ) ) ) \<cdiv> ( B \<cdot> D ) ) = 
 ( ( A \<cdiv> B ) \<cdot> ( C \<cdiv> D ) )" by (rule MMI_syl3anc)
   have S17: "( ( B \<in> \<complex> \<and> ( A \<cdiv> B ) \<in> \<complex> ) \<and> ( D \<in> \<complex> \<and> ( C \<cdiv> D ) \<in> \<complex> ) ) \<longrightarrow> 
 ( ( B \<cdot> ( A \<cdiv> B ) ) \<cdot> ( D \<cdot> ( C \<cdiv> D ) ) ) = 
 ( ( B \<cdot> D ) \<cdot> ( ( A \<cdiv> B ) \<cdot> ( C \<cdiv> D ) ) )" by (rule MMI_mul4t)
   have S18: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> B \<noteq> \<zero> ) \<longrightarrow> B \<in> \<complex>" by (rule MMI_3simp2)
   from S6 have S19: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> B \<noteq> \<zero> ) \<longrightarrow> 
 ( A \<cdiv> B ) \<in> \<complex>" .
   from S18 S19 have S20: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> B \<noteq> \<zero> ) \<longrightarrow> 
 ( B \<in> \<complex> \<and> ( A \<cdiv> B ) \<in> \<complex> )" by (rule MMI_jca)
   from S20 have S21: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> B \<noteq> \<zero> ) \<longrightarrow> 
 ( B \<in> \<complex> \<and> ( A \<cdiv> B ) \<in> \<complex> )" by (rule MMI_3expa)
   have S22: "( C \<in> \<complex> \<and> D \<in> \<complex> ) \<longrightarrow> D \<in> \<complex>" by (rule MMI_pm3_27)
   from S22 have S23: "( ( C \<in> \<complex> \<and> D \<in> \<complex> ) \<and> D \<noteq> \<zero> ) \<longrightarrow> D \<in> \<complex>" by (rule MMI_adantr)
   from S9 have S24: "( ( C \<in> \<complex> \<and> D \<in> \<complex> ) \<and> D \<noteq> \<zero> ) \<longrightarrow> 
 ( C \<cdiv> D ) \<in> \<complex>" .
   from S23 S24 have S25: "( ( C \<in> \<complex> \<and> D \<in> \<complex> ) \<and> D \<noteq> \<zero> ) \<longrightarrow> 
 ( D \<in> \<complex> \<and> ( C \<cdiv> D ) \<in> \<complex> )" by (rule MMI_jca)
   from S17 S21 S25 have S26: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> B \<noteq> \<zero> ) \<and> ( ( C \<in> \<complex> \<and> D \<in> \<complex> ) \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( B \<cdot> ( A \<cdiv> B ) ) \<cdot> ( D \<cdot> ( C \<cdiv> D ) ) ) = 
 ( ( B \<cdot> D ) \<cdot> ( ( A \<cdiv> B ) \<cdot> ( C \<cdiv> D ) ) )" by (rule MMI_syl2an)
   have S27: "( B \<in> \<complex> \<and> A \<in> \<complex> \<and> B \<noteq> \<zero> ) \<longrightarrow> 
 ( B \<cdot> ( A \<cdiv> B ) ) = A" by (rule MMI_divcan2t)
   from S27 have S28: "B \<in> \<complex> \<longrightarrow> 
 ( A \<in> \<complex> \<longrightarrow> 
 ( B \<noteq> \<zero> \<longrightarrow> ( B \<cdot> ( A \<cdiv> B ) ) = A ) )" by (rule MMI_3exp)
   from S28 have S29: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> 
 ( B \<noteq> \<zero> \<longrightarrow> ( B \<cdot> ( A \<cdiv> B ) ) = A )" by (rule MMI_impcom)
   from S29 have S30: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> B \<noteq> \<zero> ) \<longrightarrow> 
 ( B \<cdot> ( A \<cdiv> B ) ) = A" by (rule MMI_imp)
   have S31: "( D \<in> \<complex> \<and> C \<in> \<complex> \<and> D \<noteq> \<zero> ) \<longrightarrow> 
 ( D \<cdot> ( C \<cdiv> D ) ) = C" by (rule MMI_divcan2t)
   from S31 have S32: "( C \<in> \<complex> \<and> D \<in> \<complex> \<and> D \<noteq> \<zero> ) \<longrightarrow> 
 ( D \<cdot> ( C \<cdiv> D ) ) = C" by (rule MMI_3com12)
   from S32 have S33: "( ( C \<in> \<complex> \<and> D \<in> \<complex> ) \<and> D \<noteq> \<zero> ) \<longrightarrow> 
 ( D \<cdot> ( C \<cdiv> D ) ) = C" by (rule MMI_3expa)
   from S30 S33 have S34: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> B \<noteq> \<zero> ) \<and> ( ( C \<in> \<complex> \<and> D \<in> \<complex> ) \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( B \<cdot> ( A \<cdiv> B ) ) \<cdot> ( D \<cdot> ( C \<cdiv> D ) ) ) = 
 ( A \<cdot> C )" by (rule MMI_opreqan12d)
   from S26 S34 have S35: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> B \<noteq> \<zero> ) \<and> ( ( C \<in> \<complex> \<and> D \<in> \<complex> ) \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( B \<cdot> D ) \<cdot> ( ( A \<cdiv> B ) \<cdot> ( C \<cdiv> D ) ) ) = 
 ( A \<cdot> C )" by (rule MMI_eqtr3d)
   from S35 have S36: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( B \<cdot> D ) \<cdot> ( ( A \<cdiv> B ) \<cdot> ( C \<cdiv> D ) ) ) = 
 ( A \<cdot> C )" by (rule MMI_an4s)
   from S36 have S37: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( ( B \<cdot> D ) \<cdot> ( ( A \<cdiv> B ) \<cdot> ( C \<cdiv> D ) ) ) \<cdiv> ( B \<cdot> D ) ) = 
 ( ( A \<cdot> C ) \<cdiv> ( B \<cdot> D ) )" by (rule MMI_opreq1d)
   from S16 S37 show "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( A \<cdiv> B ) \<cdot> ( C \<cdiv> D ) ) = 
 ( ( A \<cdot> C ) \<cdiv> ( B \<cdot> D ) )" by (rule MMI_eqtr3d)
qed

lemma (in MMIsar0) MMI_divcan5t: 
   shows "( A \<in> \<complex> \<and> ( B \<in> \<complex> \<and> B \<noteq> \<zero> ) \<and> ( C \<in> \<complex> \<and> C \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( C \<cdot> A ) \<cdiv> ( C \<cdot> B ) ) = ( A \<cdiv> B )"
proof -
   have S1: "( C \<in> \<complex> \<and> C \<noteq> \<zero> ) \<longrightarrow> ( C \<cdiv> C ) = \<one>" by (rule MMI_dividt)
   from S1 have S2: "( C \<in> \<complex> \<and> C \<noteq> \<zero> ) \<longrightarrow> 
 ( ( C \<cdiv> C ) \<cdot> ( A \<cdiv> B ) ) = 
 ( \<one> \<cdot> ( A \<cdiv> B ) )" by (rule MMI_opreq1d)
   from S2 have S3: "( A \<in> \<complex> \<and> ( B \<in> \<complex> \<and> B \<noteq> \<zero> ) \<and> ( C \<in> \<complex> \<and> C \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( C \<cdiv> C ) \<cdot> ( A \<cdiv> B ) ) = 
 ( \<one> \<cdot> ( A \<cdiv> B ) )" by (rule MMI_3ad2ant3)
   have S4: "( ( ( C \<in> \<complex> \<and> C \<in> \<complex> ) \<and> ( A \<in> \<complex> \<and> B \<in> \<complex> ) ) \<and> ( C \<noteq> \<zero> \<and> B \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( C \<cdiv> C ) \<cdot> ( A \<cdiv> B ) ) = 
 ( ( C \<cdot> A ) \<cdiv> ( C \<cdot> B ) )" by (rule MMI_divmuldivt)
   have S5: "( C \<in> \<complex> \<and> C \<noteq> \<zero> ) \<longrightarrow> C \<in> \<complex>" by (rule MMI_pm3_26)
   from S5 have S6: "( C \<in> \<complex> \<and> C \<noteq> \<zero> ) \<longrightarrow> C \<in> \<complex>" .
   from S5 S6 have S7: "( C \<in> \<complex> \<and> C \<noteq> \<zero> ) \<longrightarrow> ( C \<in> \<complex> \<and> C \<in> \<complex> )" by (rule MMI_jca)
   have S8: "( B \<in> \<complex> \<and> B \<noteq> \<zero> ) \<longrightarrow> B \<in> \<complex>" by (rule MMI_pm3_26)
   from S8 have S9: "( A \<in> \<complex> \<and> ( B \<in> \<complex> \<and> B \<noteq> \<zero> ) ) \<longrightarrow> 
 ( A \<in> \<complex> \<and> B \<in> \<complex> )" by (rule MMI_anim2i)
   from S7 S9 have S10: "( ( C \<in> \<complex> \<and> C \<noteq> \<zero> ) \<and> ( A \<in> \<complex> \<and> ( B \<in> \<complex> \<and> B \<noteq> \<zero> ) ) ) \<longrightarrow> 
 ( ( C \<in> \<complex> \<and> C \<in> \<complex> ) \<and> ( A \<in> \<complex> \<and> B \<in> \<complex> ) )" by (rule MMI_anim12i)
   from S10 have S11: "( ( C \<in> \<complex> \<and> C \<noteq> \<zero> ) \<and> A \<in> \<complex> \<and> ( B \<in> \<complex> \<and> B \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( C \<in> \<complex> \<and> C \<in> \<complex> ) \<and> ( A \<in> \<complex> \<and> B \<in> \<complex> ) )" by (rule MMI_3impb)
   from S11 have S12: "( A \<in> \<complex> \<and> ( B \<in> \<complex> \<and> B \<noteq> \<zero> ) \<and> ( C \<in> \<complex> \<and> C \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( C \<in> \<complex> \<and> C \<in> \<complex> ) \<and> ( A \<in> \<complex> \<and> B \<in> \<complex> ) )" by (rule MMI_3coml)
   have S13: "( C \<in> \<complex> \<and> C \<noteq> \<zero> ) \<longrightarrow> C \<noteq> \<zero>" by (rule MMI_pm3_27)
   have S14: "( B \<in> \<complex> \<and> B \<noteq> \<zero> ) \<longrightarrow> B \<noteq> \<zero>" by (rule MMI_pm3_27)
   from S13 S14 have S15: "( ( C \<in> \<complex> \<and> C \<noteq> \<zero> ) \<and> ( B \<in> \<complex> \<and> B \<noteq> \<zero> ) ) \<longrightarrow> 
 ( C \<noteq> \<zero> \<and> B \<noteq> \<zero> )" by (rule MMI_anim12i)
   from S15 have S16: "( ( B \<in> \<complex> \<and> B \<noteq> \<zero> ) \<and> ( C \<in> \<complex> \<and> C \<noteq> \<zero> ) ) \<longrightarrow> 
 ( C \<noteq> \<zero> \<and> B \<noteq> \<zero> )" by (rule MMI_ancoms)
   from S16 have S17: "( A \<in> \<complex> \<and> ( B \<in> \<complex> \<and> B \<noteq> \<zero> ) \<and> ( C \<in> \<complex> \<and> C \<noteq> \<zero> ) ) \<longrightarrow> 
 ( C \<noteq> \<zero> \<and> B \<noteq> \<zero> )" by (rule MMI_3adant1)
   from S4 S12 S17 have S18: "( A \<in> \<complex> \<and> ( B \<in> \<complex> \<and> B \<noteq> \<zero> ) \<and> ( C \<in> \<complex> \<and> C \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( C \<cdiv> C ) \<cdot> ( A \<cdiv> B ) ) = 
 ( ( C \<cdot> A ) \<cdiv> ( C \<cdot> B ) )" by (rule MMI_sylanc)
   have S19: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> B \<noteq> \<zero> ) \<longrightarrow> 
 ( A \<cdiv> B ) \<in> \<complex>" by (rule MMI_divclt)
   from S19 have S20: "( A \<in> \<complex> \<and> ( B \<in> \<complex> \<and> B \<noteq> \<zero> ) ) \<longrightarrow> 
 ( A \<cdiv> B ) \<in> \<complex>" by (rule MMI_3expb)
   have S21: "( A \<cdiv> B ) \<in> \<complex> \<longrightarrow> 
 ( \<one> \<cdot> ( A \<cdiv> B ) ) = ( A \<cdiv> B )" by (rule MMI_mulid2t)
   from S20 S21 have S22: "( A \<in> \<complex> \<and> ( B \<in> \<complex> \<and> B \<noteq> \<zero> ) ) \<longrightarrow> 
 ( \<one> \<cdot> ( A \<cdiv> B ) ) = ( A \<cdiv> B )" by (rule MMI_syl)
   from S22 have S23: "( A \<in> \<complex> \<and> ( B \<in> \<complex> \<and> B \<noteq> \<zero> ) \<and> ( C \<in> \<complex> \<and> C \<noteq> \<zero> ) ) \<longrightarrow> 
 ( \<one> \<cdot> ( A \<cdiv> B ) ) = ( A \<cdiv> B )" by (rule MMI_3adant3)
   from S3 S18 S23 show "( A \<in> \<complex> \<and> ( B \<in> \<complex> \<and> B \<noteq> \<zero> ) \<and> ( C \<in> \<complex> \<and> C \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( C \<cdot> A ) \<cdiv> ( C \<cdot> B ) ) = ( A \<cdiv> B )" by (rule MMI_3eqtr3d)
qed

lemma (in MMIsar0) MMI_divmul13t: 
   shows "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( A \<cdiv> B ) \<cdot> ( C \<cdiv> D ) ) = 
 ( ( C \<cdiv> B ) \<cdot> ( A \<cdiv> D ) )"
proof -
   have S1: "( A \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
 ( A \<cdot> C ) = ( C \<cdot> A )" by (rule MMI_axmulcom)
   from S1 have S2: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
 ( A \<cdot> C ) = ( C \<cdot> A )" by (rule MMI_ad2ant2r)
   from S2 have S3: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
 ( ( A \<cdot> C ) \<cdiv> ( B \<cdot> D ) ) = 
 ( ( C \<cdot> A ) \<cdiv> ( B \<cdot> D ) )" by (rule MMI_opreq1d)
   from S3 have S4: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( A \<cdot> C ) \<cdiv> ( B \<cdot> D ) ) = 
 ( ( C \<cdot> A ) \<cdiv> ( B \<cdot> D ) )" by (rule MMI_adantr)
   have S5: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( A \<cdiv> B ) \<cdot> ( C \<cdiv> D ) ) = 
 ( ( A \<cdot> C ) \<cdiv> ( B \<cdot> D ) )" by (rule MMI_divmuldivt)
   have S6: "( ( ( C \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( A \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( C \<cdiv> B ) \<cdot> ( A \<cdiv> D ) ) = 
 ( ( C \<cdot> A ) \<cdiv> ( B \<cdot> D ) )" by (rule MMI_divmuldivt)
   have S7: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longleftrightarrow> ( B \<in> \<complex> \<and> A \<in> \<complex> )" by (rule MMI_ancom)
   from S7 have S8: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longleftrightarrow> 
 ( ( B \<in> \<complex> \<and> A \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) )" by (rule MMI_anbi1i)
   have S9: "( ( B \<in> \<complex> \<and> A \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longleftrightarrow> 
 ( ( C \<in> \<complex> \<and> D \<in> \<complex> ) \<and> ( B \<in> \<complex> \<and> A \<in> \<complex> ) )" by (rule MMI_ancom)
   have S10: "( ( C \<in> \<complex> \<and> D \<in> \<complex> ) \<and> ( B \<in> \<complex> \<and> A \<in> \<complex> ) ) \<longleftrightarrow> 
 ( ( C \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( A \<in> \<complex> \<and> D \<in> \<complex> ) )" by (rule MMI_an42)
   from S8 S9 S10 have S11: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longleftrightarrow> 
 ( ( C \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( A \<in> \<complex> \<and> D \<in> \<complex> ) )" by (rule MMI_3bitr)
   from S6 S11 have S12: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( C \<cdiv> B ) \<cdot> ( A \<cdiv> D ) ) = 
 ( ( C \<cdot> A ) \<cdiv> ( B \<cdot> D ) )" by (rule MMI_sylanb)
   from S4 S5 S12 show "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( A \<cdiv> B ) \<cdot> ( C \<cdiv> D ) ) = 
 ( ( C \<cdiv> B ) \<cdot> ( A \<cdiv> D ) )" by (rule MMI_3eqtr4d)
qed

lemma (in MMIsar0) MMI_divmul24t: 
   shows "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( A \<cdiv> B ) \<cdot> ( C \<cdiv> D ) ) = 
 ( ( A \<cdiv> D ) \<cdot> ( C \<cdiv> B ) )"
proof -
   have S1: "( B \<in> \<complex> \<and> D \<in> \<complex> ) \<longrightarrow> 
 ( B \<cdot> D ) = ( D \<cdot> B )" by (rule MMI_axmulcom)
   from S1 have S2: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
 ( B \<cdot> D ) = ( D \<cdot> B )" by (rule MMI_ad2ant2l)
   from S2 have S3: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
 ( ( A \<cdot> C ) \<cdiv> ( B \<cdot> D ) ) = 
 ( ( A \<cdot> C ) \<cdiv> ( D \<cdot> B ) )" by (rule MMI_opreq2d)
   from S3 have S4: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( A \<cdot> C ) \<cdiv> ( B \<cdot> D ) ) = 
 ( ( A \<cdot> C ) \<cdiv> ( D \<cdot> B ) )" by (rule MMI_adantr)
   have S5: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( A \<cdiv> B ) \<cdot> ( C \<cdiv> D ) ) = 
 ( ( A \<cdot> C ) \<cdiv> ( B \<cdot> D ) )" by (rule MMI_divmuldivt)
   have S6: "( ( ( A \<in> \<complex> \<and> D \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> B \<in> \<complex> ) ) \<and> ( D \<noteq> \<zero> \<and> B \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( A \<cdiv> D ) \<cdot> ( C \<cdiv> B ) ) = 
 ( ( A \<cdot> C ) \<cdiv> ( D \<cdot> B ) )" by (rule MMI_divmuldivt)
   have S7: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longleftrightarrow> 
 ( ( A \<in> \<complex> \<and> C \<in> \<complex> ) \<and> ( D \<in> \<complex> \<and> B \<in> \<complex> ) )" by (rule MMI_an42)
   have S8: "( ( A \<in> \<complex> \<and> C \<in> \<complex> ) \<and> ( D \<in> \<complex> \<and> B \<in> \<complex> ) ) \<longleftrightarrow> 
 ( ( A \<in> \<complex> \<and> D \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> B \<in> \<complex> ) )" by (rule MMI_an4)
   from S7 S8 have S9: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longleftrightarrow> 
 ( ( A \<in> \<complex> \<and> D \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> B \<in> \<complex> ) )" by (rule MMI_bitr)
   have S10: "( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) \<longleftrightarrow> ( D \<noteq> \<zero> \<and> B \<noteq> \<zero> )" by (rule MMI_ancom)
   from S6 S9 S10 have S11: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( A \<cdiv> D ) \<cdot> ( C \<cdiv> B ) ) = 
 ( ( A \<cdot> C ) \<cdiv> ( D \<cdot> B ) )" by (rule MMI_syl2anb)
   from S4 S5 S11 show "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( A \<cdiv> B ) \<cdot> ( C \<cdiv> D ) ) = 
 ( ( A \<cdiv> D ) \<cdot> ( C \<cdiv> B ) )" by (rule MMI_3eqtr4d)
qed

lemma (in MMIsar0) MMI_divadddivt: 
   shows "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( A \<cdiv> B ) \<ca> ( C \<cdiv> D ) ) = 
 ( ( ( A \<cdot> D ) \<ca> ( B \<cdot> C ) ) \<cdiv> ( B \<cdot> D ) )"
proof -
   have S1: "( B \<in> \<complex> \<and> D \<in> \<complex> ) \<longrightarrow> 
 ( ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) \<longleftrightarrow> ( B \<cdot> D ) \<noteq> \<zero> )" by (rule MMI_muln0bt)
   from S1 have S2: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
 ( ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) \<longleftrightarrow> ( B \<cdot> D ) \<noteq> \<zero> )" by (rule MMI_ad2ant2l)
   have S3: "( ( ( A \<cdot> D ) \<in> \<complex> \<and> ( B \<cdot> C ) \<in> \<complex> \<and> ( B \<cdot> D ) \<in> \<complex> ) \<and> ( B \<cdot> D ) \<noteq> \<zero> ) \<longrightarrow> 
 ( ( ( A \<cdot> D ) \<ca> ( B \<cdot> C ) ) \<cdiv> ( B \<cdot> D ) ) = 
 ( ( ( A \<cdot> D ) \<cdiv> ( B \<cdot> D ) ) \<ca> ( ( B \<cdot> C ) \<cdiv> ( B \<cdot> D ) ) )" by (rule MMI_divdirt)
   from S3 have S4: "( ( A \<cdot> D ) \<in> \<complex> \<and> ( B \<cdot> C ) \<in> \<complex> \<and> ( B \<cdot> D ) \<in> \<complex> ) \<longrightarrow> 
 ( ( B \<cdot> D ) \<noteq> \<zero> \<longrightarrow> 
 ( ( ( A \<cdot> D ) \<ca> ( B \<cdot> C ) ) \<cdiv> ( B \<cdot> D ) ) = 
 ( ( ( A \<cdot> D ) \<cdiv> ( B \<cdot> D ) ) \<ca> ( ( B \<cdot> C ) \<cdiv> ( B \<cdot> D ) ) ) )" by (rule MMI_ex)
   have S5: "( A \<in> \<complex> \<and> D \<in> \<complex> ) \<longrightarrow> ( A \<cdot> D ) \<in> \<complex>" by (rule MMI_axmulcl)
   from S5 have S6: "( A \<in> \<complex> \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
 ( A \<cdot> D ) \<in> \<complex>" by (rule MMI_adantrl)
   from S6 have S7: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
 ( A \<cdot> D ) \<in> \<complex>" by (rule MMI_adantlr)
   have S8: "( B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( B \<cdot> C ) \<in> \<complex>" by (rule MMI_axmulcl)
   from S8 have S9: "( B \<in> \<complex> \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
 ( B \<cdot> C ) \<in> \<complex>" by (rule MMI_adantrr)
   from S9 have S10: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
 ( B \<cdot> C ) \<in> \<complex>" by (rule MMI_adantll)
   have S11: "( B \<in> \<complex> \<and> D \<in> \<complex> ) \<longrightarrow> ( B \<cdot> D ) \<in> \<complex>" by (rule MMI_axmulcl)
   from S11 have S12: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
 ( B \<cdot> D ) \<in> \<complex>" by (rule MMI_ad2ant2l)
   from S4 S7 S10 S12 have S13: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
 ( ( B \<cdot> D ) \<noteq> \<zero> \<longrightarrow> 
 ( ( ( A \<cdot> D ) \<ca> ( B \<cdot> C ) ) \<cdiv> ( B \<cdot> D ) ) = 
 ( ( ( A \<cdot> D ) \<cdiv> ( B \<cdot> D ) ) \<ca> ( ( B \<cdot> C ) \<cdiv> ( B \<cdot> D ) ) ) )" by (rule MMI_syl3anc)
   from S2 S13 have S14: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
 ( ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) \<longrightarrow> 
 ( ( ( A \<cdot> D ) \<ca> ( B \<cdot> C ) ) \<cdiv> ( B \<cdot> D ) ) = 
 ( ( ( A \<cdot> D ) \<cdiv> ( B \<cdot> D ) ) \<ca> ( ( B \<cdot> C ) \<cdiv> ( B \<cdot> D ) ) ) )" by (rule MMI_sylbid)
   from S14 have S15: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( ( A \<cdot> D ) \<ca> ( B \<cdot> C ) ) \<cdiv> ( B \<cdot> D ) ) = 
 ( ( ( A \<cdot> D ) \<cdiv> ( B \<cdot> D ) ) \<ca> ( ( B \<cdot> C ) \<cdiv> ( B \<cdot> D ) ) )" by (rule MMI_imp)
   have S16: "( D \<in> \<complex> \<and> D \<noteq> \<zero> ) \<longrightarrow> ( D \<cdiv> D ) = \<one>" by (rule MMI_dividt)
   from S16 have S17: "( ( C \<in> \<complex> \<and> D \<in> \<complex> ) \<and> ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( D \<cdiv> D ) = \<one>" by (rule MMI_ad2ant2l)
   from S17 have S18: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( D \<cdiv> D ) = \<one>" by (rule MMI_adantll)
   from S18 have S19: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( A \<cdiv> B ) \<cdot> ( D \<cdiv> D ) ) = 
 ( ( A \<cdiv> B ) \<cdot> \<one> )" by (rule MMI_opreq2d)
   have S20: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( D \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( A \<cdiv> B ) \<cdot> ( D \<cdiv> D ) ) = 
 ( ( A \<cdot> D ) \<cdiv> ( B \<cdot> D ) )" by (rule MMI_divmuldivt)
   have S21: "( C \<in> \<complex> \<and> D \<in> \<complex> ) \<longrightarrow> D \<in> \<complex>" by (rule MMI_pm3_27)
   from S21 have S22: "( C \<in> \<complex> \<and> D \<in> \<complex> ) \<longrightarrow> D \<in> \<complex>" .
   from S21 S22 have S23: "( C \<in> \<complex> \<and> D \<in> \<complex> ) \<longrightarrow> ( D \<in> \<complex> \<and> D \<in> \<complex> )" by (rule MMI_jca)
   from S20 S23 have S24: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( A \<cdiv> B ) \<cdot> ( D \<cdiv> D ) ) = 
 ( ( A \<cdot> D ) \<cdiv> ( B \<cdot> D ) )" by (rule MMI_sylanl2)
   have S25: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> B \<noteq> \<zero> ) \<longrightarrow> 
 ( A \<cdiv> B ) \<in> \<complex>" by (rule MMI_divclt)
   from S25 have S26: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> B \<noteq> \<zero> ) \<longrightarrow> 
 ( A \<cdiv> B ) \<in> \<complex>" by (rule MMI_3expa)
   have S27: "( A \<cdiv> B ) \<in> \<complex> \<longrightarrow> 
 ( ( A \<cdiv> B ) \<cdot> \<one> ) = ( A \<cdiv> B )" by (rule MMI_ax1id)
   from S26 S27 have S28: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> B \<noteq> \<zero> ) \<longrightarrow> 
 ( ( A \<cdiv> B ) \<cdot> \<one> ) = ( A \<cdiv> B )" by (rule MMI_syl)
   from S28 have S29: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( A \<cdiv> B ) \<cdot> \<one> ) = ( A \<cdiv> B )" by (rule MMI_ad2ant2r)
   from S19 S24 S29 have S30: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( A \<cdot> D ) \<cdiv> ( B \<cdot> D ) ) = ( A \<cdiv> B )" by (rule MMI_3eqtr3d)
   have S31: "( B \<in> \<complex> \<and> B \<noteq> \<zero> ) \<longrightarrow> ( B \<cdiv> B ) = \<one>" by (rule MMI_dividt)
   from S31 have S32: "( B \<in> \<complex> \<and> ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( B \<cdiv> B ) = \<one>" by (rule MMI_adantrr)
   from S32 have S33: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( B \<cdiv> B ) = \<one>" by (rule MMI_adantll)
   from S33 have S34: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( B \<cdiv> B ) = \<one>" by (rule MMI_adantlr)
   from S34 have S35: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( B \<cdiv> B ) \<cdot> ( C \<cdiv> D ) ) = 
 ( \<one> \<cdot> ( C \<cdiv> D ) )" by (rule MMI_opreq1d)
   have S36: "( ( ( B \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( B \<cdiv> B ) \<cdot> ( C \<cdiv> D ) ) = 
 ( ( B \<cdot> C ) \<cdiv> ( B \<cdot> D ) )" by (rule MMI_divmuldivt)
   have S37: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> B \<in> \<complex>" by (rule MMI_pm3_27)
   from S37 have S38: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> B \<in> \<complex>" .
   from S37 S38 have S39: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> ( B \<in> \<complex> \<and> B \<in> \<complex> )" by (rule MMI_jca)
   from S36 S39 have S40: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( B \<cdiv> B ) \<cdot> ( C \<cdiv> D ) ) = 
 ( ( B \<cdot> C ) \<cdiv> ( B \<cdot> D ) )" by (rule MMI_sylanl1)
   have S41: "( C \<in> \<complex> \<and> D \<in> \<complex> \<and> D \<noteq> \<zero> ) \<longrightarrow> 
 ( C \<cdiv> D ) \<in> \<complex>" by (rule MMI_divclt)
   from S41 have S42: "( ( C \<in> \<complex> \<and> D \<in> \<complex> ) \<and> D \<noteq> \<zero> ) \<longrightarrow> 
 ( C \<cdiv> D ) \<in> \<complex>" by (rule MMI_3expa)
   have S43: "( C \<cdiv> D ) \<in> \<complex> \<longrightarrow> 
 ( \<one> \<cdot> ( C \<cdiv> D ) ) = ( C \<cdiv> D )" by (rule MMI_mulid2t)
   from S42 S43 have S44: "( ( C \<in> \<complex> \<and> D \<in> \<complex> ) \<and> D \<noteq> \<zero> ) \<longrightarrow> 
 ( \<one> \<cdot> ( C \<cdiv> D ) ) = ( C \<cdiv> D )" by (rule MMI_syl)
   from S44 have S45: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( \<one> \<cdot> ( C \<cdiv> D ) ) = ( C \<cdiv> D )" by (rule MMI_ad2ant2l)
   from S35 S40 S45 have S46: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( B \<cdot> C ) \<cdiv> ( B \<cdot> D ) ) = ( C \<cdiv> D )" by (rule MMI_3eqtr3d)
   from S30 S46 have S47: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( ( A \<cdot> D ) \<cdiv> ( B \<cdot> D ) ) \<ca> ( ( B \<cdot> C ) \<cdiv> ( B \<cdot> D ) ) ) = 
 ( ( A \<cdiv> B ) \<ca> ( C \<cdiv> D ) )" by (rule MMI_opreq12d)
   from S15 S47 show "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( A \<cdiv> B ) \<ca> ( C \<cdiv> D ) ) = 
 ( ( ( A \<cdot> D ) \<ca> ( B \<cdot> C ) ) \<cdiv> ( B \<cdot> D ) )" by (rule MMI_eqtr2d)
qed

lemma (in MMIsar0) MMI_divdivdivt: 
   shows "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( A \<cdiv> B ) \<cdiv> ( C \<cdiv> D ) ) = 
 ( ( A \<cdot> D ) \<cdiv> ( B \<cdot> C ) )"
proof -
   have S1: "( ( D \<cdiv> C ) \<in> \<complex> \<and> ( A \<cdiv> B ) \<in> \<complex> ) \<longrightarrow> 
 ( ( D \<cdiv> C ) \<cdot> ( A \<cdiv> B ) ) = 
 ( ( A \<cdiv> B ) \<cdot> ( D \<cdiv> C ) )" by (rule MMI_axmulcom)
   have S2: "( D \<in> \<complex> \<and> C \<in> \<complex> \<and> C \<noteq> \<zero> ) \<longrightarrow> 
 ( D \<cdiv> C ) \<in> \<complex>" by (rule MMI_divclt)
   from S2 have S3: "( C \<in> \<complex> \<and> D \<in> \<complex> \<and> C \<noteq> \<zero> ) \<longrightarrow> 
 ( D \<cdiv> C ) \<in> \<complex>" by (rule MMI_3com12)
   from S3 have S4: "( ( C \<in> \<complex> \<and> D \<in> \<complex> ) \<and> C \<noteq> \<zero> ) \<longrightarrow> 
 ( D \<cdiv> C ) \<in> \<complex>" by (rule MMI_3expa)
   from S4 have S5: "( ( C \<in> \<complex> \<and> D \<in> \<complex> ) \<and> ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( D \<cdiv> C ) \<in> \<complex>" by (rule MMI_adantrr)
   from S5 have S6: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) ) \<longrightarrow> 
 ( D \<cdiv> C ) \<in> \<complex>" by (rule MMI_ad2ant2l)
   have S7: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> B \<noteq> \<zero> ) \<longrightarrow> 
 ( A \<cdiv> B ) \<in> \<complex>" by (rule MMI_divclt)
   from S7 have S8: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> B \<noteq> \<zero> ) \<longrightarrow> 
 ( A \<cdiv> B ) \<in> \<complex>" by (rule MMI_3expa)
   from S8 have S9: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) ) \<longrightarrow> 
 ( A \<cdiv> B ) \<in> \<complex>" by (rule MMI_ad2ant2r)
   from S1 S6 S9 have S10: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) ) \<longrightarrow> 
 ( ( D \<cdiv> C ) \<cdot> ( A \<cdiv> B ) ) = 
 ( ( A \<cdiv> B ) \<cdot> ( D \<cdiv> C ) )" by (rule MMI_sylanc)
   have S11: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( D \<in> \<complex> \<and> C \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> C \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( A \<cdiv> B ) \<cdot> ( D \<cdiv> C ) ) = 
 ( ( A \<cdot> D ) \<cdiv> ( B \<cdot> C ) )" by (rule MMI_divmuldivt)
   have S12: "( C \<in> \<complex> \<and> D \<in> \<complex> ) \<longrightarrow> ( D \<in> \<complex> \<and> C \<in> \<complex> )" by (rule MMI_pm3_22)
   from S12 have S13: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
 ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( D \<in> \<complex> \<and> C \<in> \<complex> ) )" by (rule MMI_anim2i)
   have S14: "( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) \<longrightarrow> C \<noteq> \<zero>" by (rule MMI_pm3_26)
   from S14 have S15: "( B \<noteq> \<zero> \<and> ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( B \<noteq> \<zero> \<and> C \<noteq> \<zero> )" by (rule MMI_anim2i)
   from S11 S13 S15 have S16: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) ) \<longrightarrow> 
 ( ( A \<cdiv> B ) \<cdot> ( D \<cdiv> C ) ) = 
 ( ( A \<cdot> D ) \<cdiv> ( B \<cdot> C ) )" by (rule MMI_syl2an)
   from S10 S16 have S17: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) ) \<longrightarrow> 
 ( ( D \<cdiv> C ) \<cdot> ( A \<cdiv> B ) ) = 
 ( ( A \<cdot> D ) \<cdiv> ( B \<cdot> C ) )" by (rule MMI_eqtrd)
   from S17 have S18: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) ) \<longrightarrow> 
 ( ( C \<cdiv> D ) \<cdot> ( ( D \<cdiv> C ) \<cdot> ( A \<cdiv> B ) ) ) = 
 ( ( C \<cdiv> D ) \<cdot> ( ( A \<cdot> D ) \<cdiv> ( B \<cdot> C ) ) )" by (rule MMI_opreq2d)
   from S12 have S19: "( C \<in> \<complex> \<and> D \<in> \<complex> ) \<longrightarrow> ( D \<in> \<complex> \<and> C \<in> \<complex> )" .
   from S19 have S20: "( C \<in> \<complex> \<and> D \<in> \<complex> ) \<longrightarrow> 
 ( ( C \<in> \<complex> \<and> D \<in> \<complex> ) \<and> ( D \<in> \<complex> \<and> C \<in> \<complex> ) )" by (rule MMI_ancli)
   have S21: "( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) \<longrightarrow> ( D \<noteq> \<zero> \<and> C \<noteq> \<zero> )" by (rule MMI_pm3_22)
   from S21 have S22: "( B \<noteq> \<zero> \<and> ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( D \<noteq> \<zero> \<and> C \<noteq> \<zero> )" by (rule MMI_adantl)
   from S20 S22 have S23: "( ( C \<in> \<complex> \<and> D \<in> \<complex> ) \<and> ( B \<noteq> \<zero> \<and> ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) ) \<longrightarrow> 
 ( ( ( C \<in> \<complex> \<and> D \<in> \<complex> ) \<and> ( D \<in> \<complex> \<and> C \<in> \<complex> ) ) \<and> ( D \<noteq> \<zero> \<and> C \<noteq> \<zero> ) )" by (rule MMI_anim12i)
   from S23 have S24: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) ) \<longrightarrow> 
 ( ( ( C \<in> \<complex> \<and> D \<in> \<complex> ) \<and> ( D \<in> \<complex> \<and> C \<in> \<complex> ) ) \<and> ( D \<noteq> \<zero> \<and> C \<noteq> \<zero> ) )" by (rule MMI_adantll)
   have S25: "( ( ( C \<in> \<complex> \<and> D \<in> \<complex> ) \<and> ( D \<in> \<complex> \<and> C \<in> \<complex> ) ) \<and> ( D \<noteq> \<zero> \<and> C \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( C \<cdiv> D ) \<cdot> ( D \<cdiv> C ) ) = 
 ( ( C \<cdot> D ) \<cdiv> ( D \<cdot> C ) )" by (rule MMI_divmuldivt)
   from S24 S25 have S26: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) ) \<longrightarrow> 
 ( ( C \<cdiv> D ) \<cdot> ( D \<cdiv> C ) ) = 
 ( ( C \<cdot> D ) \<cdiv> ( D \<cdot> C ) )" by (rule MMI_syl)
   have S27: "( C \<in> \<complex> \<and> D \<in> \<complex> ) \<longrightarrow> 
 ( C \<cdot> D ) = ( D \<cdot> C )" by (rule MMI_axmulcom)
   from S27 have S28: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) ) \<longrightarrow> 
 ( C \<cdot> D ) = ( D \<cdot> C )" by (rule MMI_ad2antlr)
   from S28 have S29: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) ) \<longrightarrow> 
 ( ( C \<cdot> D ) \<cdiv> ( D \<cdot> C ) ) = 
 ( ( D \<cdot> C ) \<cdiv> ( D \<cdot> C ) )" by (rule MMI_opreq1d)
   have S30: "( ( D \<cdot> C ) \<in> \<complex> \<and> ( D \<cdot> C ) \<noteq> \<zero> ) \<longrightarrow> 
 ( ( D \<cdot> C ) \<cdiv> ( D \<cdot> C ) ) = \<one>" by (rule MMI_dividt)
   have S31: "( D \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( D \<cdot> C ) \<in> \<complex>" by (rule MMI_axmulcl)
   from S31 have S32: "( C \<in> \<complex> \<and> D \<in> \<complex> ) \<longrightarrow> ( D \<cdot> C ) \<in> \<complex>" by (rule MMI_ancoms)
   from S32 have S33: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) ) \<longrightarrow> 
 ( D \<cdot> C ) \<in> \<complex>" by (rule MMI_ad2antlr)
   have S34: "( D \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
 ( ( D \<noteq> \<zero> \<and> C \<noteq> \<zero> ) \<longleftrightarrow> ( D \<cdot> C ) \<noteq> \<zero> )" by (rule MMI_muln0bt)
   have S35: "( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) \<longleftrightarrow> ( D \<noteq> \<zero> \<and> C \<noteq> \<zero> )" by (rule MMI_ancom)
   from S34 S35 have S36: "( D \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
 ( ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) \<longleftrightarrow> ( D \<cdot> C ) \<noteq> \<zero> )" by (rule MMI_syl5bb)
   from S36 have S37: "( C \<in> \<complex> \<and> D \<in> \<complex> ) \<longrightarrow> 
 ( ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) \<longleftrightarrow> ( D \<cdot> C ) \<noteq> \<zero> )" by (rule MMI_ancoms)
   from S37 have S38: "( ( C \<in> \<complex> \<and> D \<in> \<complex> ) \<and> ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( D \<cdot> C ) \<noteq> \<zero>" by (rule MMI_biimpa)
   from S38 have S39: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) ) \<longrightarrow> 
 ( D \<cdot> C ) \<noteq> \<zero>" by (rule MMI_ad2ant2l)
   from S30 S33 S39 have S40: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) ) \<longrightarrow> 
 ( ( D \<cdot> C ) \<cdiv> ( D \<cdot> C ) ) = \<one>" by (rule MMI_sylanc)
   from S26 S29 S40 have S41: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) ) \<longrightarrow> 
 ( ( C \<cdiv> D ) \<cdot> ( D \<cdiv> C ) ) = \<one>" by (rule MMI_3eqtrd)
   from S41 have S42: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) ) \<longrightarrow> 
 ( ( ( C \<cdiv> D ) \<cdot> ( D \<cdiv> C ) ) \<cdot> ( A \<cdiv> B ) ) = 
 ( \<one> \<cdot> ( A \<cdiv> B ) )" by (rule MMI_opreq1d)
   have S43: "( ( C \<cdiv> D ) \<in> \<complex> \<and> ( D \<cdiv> C ) \<in> \<complex> \<and> ( A \<cdiv> B ) \<in> \<complex> ) \<longrightarrow> 
 ( ( ( C \<cdiv> D ) \<cdot> ( D \<cdiv> C ) ) \<cdot> ( A \<cdiv> B ) ) = 
 ( ( C \<cdiv> D ) \<cdot> ( ( D \<cdiv> C ) \<cdot> ( A \<cdiv> B ) ) )" by (rule MMI_axmulass)
   have S44: "( C \<in> \<complex> \<and> D \<in> \<complex> \<and> D \<noteq> \<zero> ) \<longrightarrow> 
 ( C \<cdiv> D ) \<in> \<complex>" by (rule MMI_divclt)
   from S44 have S45: "( ( C \<in> \<complex> \<and> D \<in> \<complex> ) \<and> D \<noteq> \<zero> ) \<longrightarrow> 
 ( C \<cdiv> D ) \<in> \<complex>" by (rule MMI_3expa)
   from S45 have S46: "( ( C \<in> \<complex> \<and> D \<in> \<complex> ) \<and> ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( C \<cdiv> D ) \<in> \<complex>" by (rule MMI_adantrl)
   from S46 have S47: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) ) \<longrightarrow> 
 ( C \<cdiv> D ) \<in> \<complex>" by (rule MMI_ad2ant2l)
   from S6 have S48: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) ) \<longrightarrow> 
 ( D \<cdiv> C ) \<in> \<complex>" .
   from S9 have S49: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) ) \<longrightarrow> 
 ( A \<cdiv> B ) \<in> \<complex>" .
   from S43 S47 S48 S49 have S50: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) ) \<longrightarrow> 
 ( ( ( C \<cdiv> D ) \<cdot> ( D \<cdiv> C ) ) \<cdot> ( A \<cdiv> B ) ) = 
 ( ( C \<cdiv> D ) \<cdot> ( ( D \<cdiv> C ) \<cdot> ( A \<cdiv> B ) ) )" by (rule MMI_syl3anc)
   from S9 have S51: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) ) \<longrightarrow> 
 ( A \<cdiv> B ) \<in> \<complex>" .
   have S52: "( A \<cdiv> B ) \<in> \<complex> \<longrightarrow> 
 ( \<one> \<cdot> ( A \<cdiv> B ) ) = ( A \<cdiv> B )" by (rule MMI_mulid2t)
   from S51 S52 have S53: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) ) \<longrightarrow> 
 ( \<one> \<cdot> ( A \<cdiv> B ) ) = ( A \<cdiv> B )" by (rule MMI_syl)
   from S42 S50 S53 have S54: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) ) \<longrightarrow> 
 ( ( C \<cdiv> D ) \<cdot> ( ( D \<cdiv> C ) \<cdot> ( A \<cdiv> B ) ) ) = 
 ( A \<cdiv> B )" by (rule MMI_3eqtr3d)
   from S18 S54 have S55: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) ) \<longrightarrow> 
 ( ( C \<cdiv> D ) \<cdot> ( ( A \<cdot> D ) \<cdiv> ( B \<cdot> C ) ) ) = 
 ( A \<cdiv> B )" by (rule MMI_eqtr3d)
   have S56: "( ( ( A \<cdiv> B ) \<in> \<complex> \<and> ( C \<cdiv> D ) \<in> \<complex> \<and> ( ( A \<cdot> D ) \<cdiv> ( B \<cdot> C ) ) \<in> \<complex> ) \<and> ( C \<cdiv> D ) \<noteq> \<zero> ) \<longrightarrow> 
 ( ( ( A \<cdiv> B ) \<cdiv> ( C \<cdiv> D ) ) = 
 ( ( A \<cdot> D ) \<cdiv> ( B \<cdot> C ) ) \<longleftrightarrow> 
 ( ( C \<cdiv> D ) \<cdot> ( ( A \<cdot> D ) \<cdiv> ( B \<cdot> C ) ) ) = 
 ( A \<cdiv> B ) )" by (rule MMI_divmult)
   from S9 have S57: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) ) \<longrightarrow> 
 ( A \<cdiv> B ) \<in> \<complex>" .
   from S47 have S58: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) ) \<longrightarrow> 
 ( C \<cdiv> D ) \<in> \<complex>" .
   have S59: "( ( A \<cdot> D ) \<in> \<complex> \<and> ( B \<cdot> C ) \<in> \<complex> \<and> ( B \<cdot> C ) \<noteq> \<zero> ) \<longrightarrow> 
 ( ( A \<cdot> D ) \<cdiv> ( B \<cdot> C ) ) \<in> \<complex>" by (rule MMI_divclt)
   have S60: "( A \<in> \<complex> \<and> D \<in> \<complex> ) \<longrightarrow> ( A \<cdot> D ) \<in> \<complex>" by (rule MMI_axmulcl)
   from S60 have S61: "( A \<in> \<complex> \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
 ( A \<cdot> D ) \<in> \<complex>" by (rule MMI_adantrl)
   from S61 have S62: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
 ( A \<cdot> D ) \<in> \<complex>" by (rule MMI_adantlr)
   from S62 have S63: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) ) \<longrightarrow> 
 ( A \<cdot> D ) \<in> \<complex>" by (rule MMI_adantr)
   have S64: "( B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> ( B \<cdot> C ) \<in> \<complex>" by (rule MMI_axmulcl)
   from S64 have S65: "( B \<in> \<complex> \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
 ( B \<cdot> C ) \<in> \<complex>" by (rule MMI_adantrr)
   from S65 have S66: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
 ( B \<cdot> C ) \<in> \<complex>" by (rule MMI_adantll)
   from S66 have S67: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) ) \<longrightarrow> 
 ( B \<cdot> C ) \<in> \<complex>" by (rule MMI_adantr)
   have S68: "( B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
 ( ( B \<noteq> \<zero> \<and> C \<noteq> \<zero> ) \<longleftrightarrow> ( B \<cdot> C ) \<noteq> \<zero> )" by (rule MMI_muln0bt)
   from S68 have S69: "( B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
 ( ( B \<noteq> \<zero> \<and> C \<noteq> \<zero> ) \<longrightarrow> ( B \<cdot> C ) \<noteq> \<zero> )" by (rule MMI_biimpd)
   from S14 have S70: "( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) \<longrightarrow> C \<noteq> \<zero>" .
   from S69 S70 have S71: "( B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> 
 ( ( B \<noteq> \<zero> \<and> ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( B \<cdot> C ) \<noteq> \<zero> )" by (rule MMI_sylan2i)
   from S71 have S72: "( B \<in> \<complex> \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
 ( ( B \<noteq> \<zero> \<and> ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( B \<cdot> C ) \<noteq> \<zero> )" by (rule MMI_adantrr)
   from S72 have S73: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<longrightarrow> 
 ( ( B \<noteq> \<zero> \<and> ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( B \<cdot> C ) \<noteq> \<zero> )" by (rule MMI_adantll)
   from S73 have S74: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) ) \<longrightarrow> 
 ( B \<cdot> C ) \<noteq> \<zero>" by (rule MMI_imp)
   from S59 S63 S67 S74 have S75: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) ) \<longrightarrow> 
 ( ( A \<cdot> D ) \<cdiv> ( B \<cdot> C ) ) \<in> \<complex>" by (rule MMI_syl3anc)
   from S57 S58 S75 have S76: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) ) \<longrightarrow> 
 ( ( A \<cdiv> B ) \<in> \<complex> \<and> ( C \<cdiv> D ) \<in> \<complex> \<and> ( ( A \<cdot> D ) \<cdiv> ( B \<cdot> C ) ) \<in> \<complex> )" by (rule MMI_3jca)
   have S77: "( C \<in> \<complex> \<and> D \<in> \<complex> \<and> D \<noteq> \<zero> ) \<longrightarrow> 
 ( C \<noteq> \<zero> \<longleftrightarrow> ( C \<cdiv> D ) \<noteq> \<zero> )" by (rule MMI_divne0bt)
   from S77 have S78: "( C \<in> \<complex> \<and> D \<in> \<complex> \<and> D \<noteq> \<zero> ) \<longrightarrow> 
 ( C \<noteq> \<zero> \<longrightarrow> ( C \<cdiv> D ) \<noteq> \<zero> )" by (rule MMI_biimpd)
   from S78 have S79: "C \<in> \<complex> \<longrightarrow> 
 ( D \<in> \<complex> \<longrightarrow> 
 ( D \<noteq> \<zero> \<longrightarrow> 
 ( C \<noteq> \<zero> \<longrightarrow> ( C \<cdiv> D ) \<noteq> \<zero> ) ) )" by (rule MMI_3exp)
   from S79 have S80: "C \<in> \<complex> \<longrightarrow> 
 ( D \<in> \<complex> \<longrightarrow> 
 ( C \<noteq> \<zero> \<longrightarrow> 
 ( D \<noteq> \<zero> \<longrightarrow> ( C \<cdiv> D ) \<noteq> \<zero> ) ) )" by (rule MMI_com34)
   from S80 have S81: "( ( C \<in> \<complex> \<and> D \<in> \<complex> ) \<and> ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( C \<cdiv> D ) \<noteq> \<zero>" by (rule MMI_imp43)
   from S81 have S82: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) ) \<longrightarrow> 
 ( C \<cdiv> D ) \<noteq> \<zero>" by (rule MMI_ad2ant2l)
   from S56 S76 S82 have S83: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) ) \<longrightarrow> 
 ( ( ( A \<cdiv> B ) \<cdiv> ( C \<cdiv> D ) ) = 
 ( ( A \<cdot> D ) \<cdiv> ( B \<cdot> C ) ) \<longleftrightarrow> 
 ( ( C \<cdiv> D ) \<cdot> ( ( A \<cdot> D ) \<cdiv> ( B \<cdot> C ) ) ) = 
 ( A \<cdiv> B ) )" by (rule MMI_sylanc)
   from S55 S83 have S84: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) ) \<longrightarrow> 
 ( ( A \<cdiv> B ) \<cdiv> ( C \<cdiv> D ) ) = 
 ( ( A \<cdot> D ) \<cdiv> ( B \<cdot> C ) )" by (rule MMI_mpbird)
   have S85: "( B \<noteq> \<zero> \<and> C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) \<longleftrightarrow> 
 ( B \<noteq> \<zero> \<and> ( C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) )" by (rule MMI_3anass)
   from S84 S85 show "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( A \<cdiv> B ) \<cdiv> ( C \<cdiv> D ) ) = 
 ( ( A \<cdot> D ) \<cdiv> ( B \<cdot> C ) )" by (rule MMI_sylan2b)
qed

lemma (in MMIsar0) MMI_divmuldiv: assumes A1: "A \<in> \<complex>" and
    A2: "B \<in> \<complex>" and
    A3: "C \<in> \<complex>" and
    A4: "D \<in> \<complex>" and
    A5: "B \<noteq> \<zero>" and
    A6: "D \<noteq> \<zero>"   
   shows "( ( A \<cdiv> B ) \<cdot> ( C \<cdiv> D ) ) = 
 ( ( A \<cdot> C ) \<cdiv> ( B \<cdot> D ) )"
proof -
   from A1 have S1: "A \<in> \<complex>".
   from A2 have S2: "B \<in> \<complex>".
   from S1 S2 have S3: "A \<in> \<complex> \<and> B \<in> \<complex>" by (rule MMI_pm3_2i)
   from A3 have S4: "C \<in> \<complex>".
   from A4 have S5: "D \<in> \<complex>".
   from S4 S5 have S6: "C \<in> \<complex> \<and> D \<in> \<complex>" by (rule MMI_pm3_2i)
   from S3 S6 have S7: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> )" by (rule MMI_pm3_2i)
   from A5 have S8: "B \<noteq> \<zero>".
   from A6 have S9: "D \<noteq> \<zero>".
   from S8 S9 have S10: "B \<noteq> \<zero> \<and> D \<noteq> \<zero>" by (rule MMI_pm3_2i)
   have S11: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( A \<cdiv> B ) \<cdot> ( C \<cdiv> D ) ) = 
 ( ( A \<cdot> C ) \<cdiv> ( B \<cdot> D ) )" by (rule MMI_divmuldivt)
   from S7 S10 S11 show "( ( A \<cdiv> B ) \<cdot> ( C \<cdiv> D ) ) = 
 ( ( A \<cdot> C ) \<cdiv> ( B \<cdot> D ) )" by (rule MMI_mp2an)
qed;

(************221-230********************)

lemma (in MMIsar0) MMI_divmul13: assumes A1: "A \<in> \<complex>" and
    A2: "B \<in> \<complex>" and
    A3: "C \<in> \<complex>" and
    A4: "D \<in> \<complex>" and
    A5: "B \<noteq> \<zero>" and
    A6: "D \<noteq> \<zero>"   
   shows "( ( A \<cdiv> B ) \<cdot> ( C \<cdiv> D ) ) = 
 ( ( C \<cdiv> B ) \<cdot> ( A \<cdiv> D ) )"
proof -
   from A3 have S1: "C \<in> \<complex>".
   from A1 have S2: "A \<in> \<complex>".
   from S1 S2 have S3: "( C \<cdot> A ) = ( A \<cdot> C )" by (rule MMI_mulcom)
   from S3 have S4: "( ( C \<cdot> A ) \<cdiv> ( B \<cdot> D ) ) = 
 ( ( A \<cdot> C ) \<cdiv> ( B \<cdot> D ) )" by (rule MMI_opreq1i)
   from A3 have S5: "C \<in> \<complex>".
   from A2 have S6: "B \<in> \<complex>".
   from A1 have S7: "A \<in> \<complex>".
   from A4 have S8: "D \<in> \<complex>".
   from A5 have S9: "B \<noteq> \<zero>".
   from A6 have S10: "D \<noteq> \<zero>".
   from S5 S6 S7 S8 S9 S10 have S11: "( ( C \<cdiv> B ) \<cdot> ( A \<cdiv> D ) ) = 
 ( ( C \<cdot> A ) \<cdiv> ( B \<cdot> D ) )" by (rule MMI_divmuldiv)
   from A1 have S12: "A \<in> \<complex>".
   from A2 have S13: "B \<in> \<complex>".
   from A3 have S14: "C \<in> \<complex>".
   from A4 have S15: "D \<in> \<complex>".
   from A5 have S16: "B \<noteq> \<zero>".
   from A6 have S17: "D \<noteq> \<zero>".
   from S12 S13 S14 S15 S16 S17 have S18: "( ( A \<cdiv> B ) \<cdot> ( C \<cdiv> D ) ) = 
 ( ( A \<cdot> C ) \<cdiv> ( B \<cdot> D ) )" by (rule MMI_divmuldiv)
   from S4 S11 S18 show "( ( A \<cdiv> B ) \<cdot> ( C \<cdiv> D ) ) = 
 ( ( C \<cdiv> B ) \<cdot> ( A \<cdiv> D ) )" by (rule MMI_3eqtr4r)
qed

lemma (in MMIsar0) MMI_divadddiv: assumes A1: "A \<in> \<complex>" and
    A2: "B \<in> \<complex>" and
    A3: "C \<in> \<complex>" and
    A4: "D \<in> \<complex>" and
    A5: "B \<noteq> \<zero>" and
    A6: "D \<noteq> \<zero>"   
   shows "( ( A \<cdiv> B ) \<ca> ( C \<cdiv> D ) ) = 
 ( ( ( A \<cdot> D ) \<ca> ( B \<cdot> C ) ) \<cdiv> ( B \<cdot> D ) )"
proof -
   from A1 have S1: "A \<in> \<complex>".
   from A2 have S2: "B \<in> \<complex>".
   from S1 S2 have S3: "A \<in> \<complex> \<and> B \<in> \<complex>" by (rule MMI_pm3_2i)
   from A3 have S4: "C \<in> \<complex>".
   from A4 have S5: "D \<in> \<complex>".
   from S4 S5 have S6: "C \<in> \<complex> \<and> D \<in> \<complex>" by (rule MMI_pm3_2i)
   from S3 S6 have S7: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> )" by (rule MMI_pm3_2i)
   from A5 have S8: "B \<noteq> \<zero>".
   from A6 have S9: "D \<noteq> \<zero>".
   from S8 S9 have S10: "B \<noteq> \<zero> \<and> D \<noteq> \<zero>" by (rule MMI_pm3_2i)
   have S11: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( A \<cdiv> B ) \<ca> ( C \<cdiv> D ) ) = 
 ( ( ( A \<cdot> D ) \<ca> ( B \<cdot> C ) ) \<cdiv> ( B \<cdot> D ) )" by (rule MMI_divadddivt)
   from S7 S10 S11 show "( ( A \<cdiv> B ) \<ca> ( C \<cdiv> D ) ) = 
 ( ( ( A \<cdot> D ) \<ca> ( B \<cdot> C ) ) \<cdiv> ( B \<cdot> D ) )" by (rule MMI_mp2an)
qed

lemma (in MMIsar0) MMI_divdivdiv: assumes A1: "A \<in> \<complex>" and
    A2: "B \<in> \<complex>" and
    A3: "C \<in> \<complex>" and
    A4: "D \<in> \<complex>" and
    A5: "B \<noteq> \<zero>" and
    A6: "D \<noteq> \<zero>" and
    A7: "C \<noteq> \<zero>"   
   shows "( ( A \<cdiv> B ) \<cdiv> ( C \<cdiv> D ) ) = 
 ( ( A \<cdot> D ) \<cdiv> ( B \<cdot> C ) )"
proof -
   from A1 have S1: "A \<in> \<complex>".
   from A2 have S2: "B \<in> \<complex>".
   from S1 S2 have S3: "A \<in> \<complex> \<and> B \<in> \<complex>" by (rule MMI_pm3_2i)
   from A3 have S4: "C \<in> \<complex>".
   from A4 have S5: "D \<in> \<complex>".
   from S4 S5 have S6: "C \<in> \<complex> \<and> D \<in> \<complex>" by (rule MMI_pm3_2i)
   from S3 S6 have S7: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> )" by (rule MMI_pm3_2i)
   from A5 have S8: "B \<noteq> \<zero>".
   from A7 have S9: "C \<noteq> \<zero>".
   from A6 have S10: "D \<noteq> \<zero>".
   from S8 S9 S10 have S11: "B \<noteq> \<zero> \<and> C \<noteq> \<zero> \<and> D \<noteq> \<zero>" by (rule MMI_3pm3_2i)
   have S12: "( ( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( C \<in> \<complex> \<and> D \<in> \<complex> ) ) \<and> ( B \<noteq> \<zero> \<and> C \<noteq> \<zero> \<and> D \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( A \<cdiv> B ) \<cdiv> ( C \<cdiv> D ) ) = 
 ( ( A \<cdot> D ) \<cdiv> ( B \<cdot> C ) )" by (rule MMI_divdivdivt)
   from S7 S11 S12 show "( ( A \<cdiv> B ) \<cdiv> ( C \<cdiv> D ) ) = 
 ( ( A \<cdot> D ) \<cdiv> ( B \<cdot> C ) )" by (rule MMI_mp2an)
qed

lemma (in MMIsar0) MMI_recdivt: 
   shows "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( A \<noteq> \<zero> \<and> B \<noteq> \<zero> ) ) \<longrightarrow> 
 ( \<one> \<cdiv> ( A \<cdiv> B ) ) = ( B \<cdiv> A )"
proof -
   have S1: "\<one> \<in> \<complex>" by (rule MMI_1cn)
   have S2: "\<one> \<in> \<complex>" by (rule MMI_1cn)
   from S1 S2 have S3: "\<one> \<in> \<complex> \<and> \<one> \<in> \<complex>" by (rule MMI_pm3_2i)
   have S4: "( ( ( \<one> \<in> \<complex> \<and> \<one> \<in> \<complex> ) \<and> ( A \<in> \<complex> \<and> B \<in> \<complex> ) ) \<and> ( \<one> \<noteq> \<zero> \<and> A \<noteq> \<zero> \<and> B \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( \<one> \<cdiv> \<one> ) \<cdiv> ( A \<cdiv> B ) ) = 
 ( ( \<one> \<cdot> B ) \<cdiv> ( \<one> \<cdot> A ) )" by (rule MMI_divdivdivt)
   have S5: "\<one> \<noteq> \<zero>" by (rule MMI_ax1ne0)
   from S5 have S6: "( A \<noteq> \<zero> \<and> B \<noteq> \<zero> ) \<longrightarrow> 
 ( \<one> \<noteq> \<zero> \<and> ( A \<noteq> \<zero> \<and> B \<noteq> \<zero> ) )" by (rule MMI_jctl)
   have S7: "( \<one> \<noteq> \<zero> \<and> A \<noteq> \<zero> \<and> B \<noteq> \<zero> ) \<longleftrightarrow> 
 ( \<one> \<noteq> \<zero> \<and> ( A \<noteq> \<zero> \<and> B \<noteq> \<zero> ) )" by (rule MMI_3anass)
   from S6 S7 have S8: "( A \<noteq> \<zero> \<and> B \<noteq> \<zero> ) \<longrightarrow> 
 ( \<one> \<noteq> \<zero> \<and> A \<noteq> \<zero> \<and> B \<noteq> \<zero> )" by (rule MMI_sylibr)
   from S4 S8 have S9: "( ( ( \<one> \<in> \<complex> \<and> \<one> \<in> \<complex> ) \<and> ( A \<in> \<complex> \<and> B \<in> \<complex> ) ) \<and> ( A \<noteq> \<zero> \<and> B \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( \<one> \<cdiv> \<one> ) \<cdiv> ( A \<cdiv> B ) ) = 
 ( ( \<one> \<cdot> B ) \<cdiv> ( \<one> \<cdot> A ) )" by (rule MMI_sylan2)
   from S3 S9 have S10: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( A \<noteq> \<zero> \<and> B \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( \<one> \<cdiv> \<one> ) \<cdiv> ( A \<cdiv> B ) ) = 
 ( ( \<one> \<cdot> B ) \<cdiv> ( \<one> \<cdot> A ) )" by (rule MMI_mpanl1)
   have S11: "\<one> \<in> \<complex>" by (rule MMI_1cn)
   from S11 have S12: "( \<one> \<cdiv> \<one> ) = \<one>" by (rule MMI_div1)
   from S12 have S13: "( ( \<one> \<cdiv> \<one> ) \<cdiv> ( A \<cdiv> B ) ) = 
 ( \<one> \<cdiv> ( A \<cdiv> B ) )" by (rule MMI_opreq1i)
   from S13 have S14: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( A \<noteq> \<zero> \<and> B \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( \<one> \<cdiv> \<one> ) \<cdiv> ( A \<cdiv> B ) ) = 
 ( \<one> \<cdiv> ( A \<cdiv> B ) )" by (rule MMI_a1i)
   have S15: "B \<in> \<complex> \<longrightarrow> ( \<one> \<cdot> B ) = B" by (rule MMI_mulid2t)
   have S16: "A \<in> \<complex> \<longrightarrow> ( \<one> \<cdot> A ) = A" by (rule MMI_mulid2t)
   from S15 S16 have S17: "( A \<in> \<complex> \<and> B \<in> \<complex> ) \<longrightarrow> 
 ( ( \<one> \<cdot> B ) \<cdiv> ( \<one> \<cdot> A ) ) = ( B \<cdiv> A )" by (rule MMI_opreqan12rd)
   from S17 have S18: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( A \<noteq> \<zero> \<and> B \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( \<one> \<cdot> B ) \<cdiv> ( \<one> \<cdot> A ) ) = ( B \<cdiv> A )" by (rule MMI_adantr)
   from S10 S14 S18 show "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> ( A \<noteq> \<zero> \<and> B \<noteq> \<zero> ) ) \<longrightarrow> 
 ( \<one> \<cdiv> ( A \<cdiv> B ) ) = ( B \<cdiv> A )" by (rule MMI_3eqtr3d)
qed

lemma (in MMIsar0) MMI_divdiv23t: 
   shows "( ( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<and> ( B \<noteq> \<zero> \<and> C \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( A \<cdiv> B ) \<cdiv> C ) = ( ( A \<cdiv> C ) \<cdiv> B )"
proof -
   have S1: "( ( A \<in> \<complex> \<and> ( \<one> \<cdiv> B ) \<in> \<complex> \<and> C \<in> \<complex> ) \<and> C \<noteq> \<zero> ) \<longrightarrow> 
 ( ( A \<cdot> ( \<one> \<cdiv> B ) ) \<cdiv> C ) = 
 ( ( A \<cdiv> C ) \<cdot> ( \<one> \<cdiv> B ) )" by (rule MMI_div23t)
   have S2: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> A \<in> \<complex>" by (rule MMI_3simp1)
   from S2 have S3: "( ( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<and> ( B \<noteq> \<zero> \<and> C \<noteq> \<zero> ) ) \<longrightarrow> 
 A \<in> \<complex>" by (rule MMI_adantr)
   have S4: "( B \<in> \<complex> \<and> B \<noteq> \<zero> ) \<longrightarrow> ( \<one> \<cdiv> B ) \<in> \<complex>" by (rule MMI_recclt)
   have S5: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> B \<in> \<complex>" by (rule MMI_3simp2)
   from S4 S5 have S6: "( ( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<and> B \<noteq> \<zero> ) \<longrightarrow> 
 ( \<one> \<cdiv> B ) \<in> \<complex>" by (rule MMI_sylan)
   from S6 have S7: "( ( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<and> ( B \<noteq> \<zero> \<and> C \<noteq> \<zero> ) ) \<longrightarrow> 
 ( \<one> \<cdiv> B ) \<in> \<complex>" by (rule MMI_adantrr)
   have S8: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> C \<in> \<complex>" by (rule MMI_3simp3)
   from S8 have S9: "( ( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<and> ( B \<noteq> \<zero> \<and> C \<noteq> \<zero> ) ) \<longrightarrow> 
 C \<in> \<complex>" by (rule MMI_adantr)
   from S3 S7 S9 have S10: "( ( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<and> ( B \<noteq> \<zero> \<and> C \<noteq> \<zero> ) ) \<longrightarrow> 
 ( A \<in> \<complex> \<and> ( \<one> \<cdiv> B ) \<in> \<complex> \<and> C \<in> \<complex> )" by (rule MMI_3jca)
   have S11: "( B \<noteq> \<zero> \<and> C \<noteq> \<zero> ) \<longrightarrow> C \<noteq> \<zero>" by (rule MMI_pm3_27)
   from S11 have S12: "( ( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<and> ( B \<noteq> \<zero> \<and> C \<noteq> \<zero> ) ) \<longrightarrow> 
 C \<noteq> \<zero>" by (rule MMI_adantl)
   from S1 S10 S12 have S13: "( ( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<and> ( B \<noteq> \<zero> \<and> C \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( A \<cdot> ( \<one> \<cdiv> B ) ) \<cdiv> C ) = 
 ( ( A \<cdiv> C ) \<cdot> ( \<one> \<cdiv> B ) )" by (rule MMI_sylanc)
   have S14: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> B \<noteq> \<zero> ) \<longrightarrow> 
 ( A \<cdiv> B ) = ( A \<cdot> ( \<one> \<cdiv> B ) )" by (rule MMI_divrect)
   from S14 have S15: "( ( A \<in> \<complex> \<and> B \<in> \<complex> ) \<and> B \<noteq> \<zero> ) \<longrightarrow> 
 ( A \<cdiv> B ) = ( A \<cdot> ( \<one> \<cdiv> B ) )" by (rule MMI_3expa)
   from S15 have S16: "( ( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<and> B \<noteq> \<zero> ) \<longrightarrow> 
 ( A \<cdiv> B ) = ( A \<cdot> ( \<one> \<cdiv> B ) )" by (rule MMI_3adantl3)
   from S16 have S17: "( ( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<and> ( B \<noteq> \<zero> \<and> C \<noteq> \<zero> ) ) \<longrightarrow> 
 ( A \<cdiv> B ) = ( A \<cdot> ( \<one> \<cdiv> B ) )" by (rule MMI_adantrr)
   from S17 have S18: "( ( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<and> ( B \<noteq> \<zero> \<and> C \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( A \<cdiv> B ) \<cdiv> C ) = 
 ( ( A \<cdot> ( \<one> \<cdiv> B ) ) \<cdiv> C )" by (rule MMI_opreq1d)
   have S19: "( ( A \<cdiv> C ) \<in> \<complex> \<and> B \<in> \<complex> \<and> B \<noteq> \<zero> ) \<longrightarrow> 
 ( ( A \<cdiv> C ) \<cdiv> B ) = 
 ( ( A \<cdiv> C ) \<cdot> ( \<one> \<cdiv> B ) )" by (rule MMI_divrect)
   have S20: "( A \<in> \<complex> \<and> C \<in> \<complex> \<and> C \<noteq> \<zero> ) \<longrightarrow> 
 ( A \<cdiv> C ) \<in> \<complex>" by (rule MMI_divclt)
   from S20 have S21: "( ( A \<in> \<complex> \<and> C \<in> \<complex> ) \<and> C \<noteq> \<zero> ) \<longrightarrow> 
 ( A \<cdiv> C ) \<in> \<complex>" by (rule MMI_3expa)
   from S21 have S22: "( ( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<and> C \<noteq> \<zero> ) \<longrightarrow> 
 ( A \<cdiv> C ) \<in> \<complex>" by (rule MMI_3adantl2)
   from S22 have S23: "( ( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<and> ( B \<noteq> \<zero> \<and> C \<noteq> \<zero> ) ) \<longrightarrow> 
 ( A \<cdiv> C ) \<in> \<complex>" by (rule MMI_adantrl)
   from S5 have S24: "( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<longrightarrow> B \<in> \<complex>" .
   from S24 have S25: "( ( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<and> ( B \<noteq> \<zero> \<and> C \<noteq> \<zero> ) ) \<longrightarrow> 
 B \<in> \<complex>" by (rule MMI_adantr)
   have S26: "( B \<noteq> \<zero> \<and> C \<noteq> \<zero> ) \<longrightarrow> B \<noteq> \<zero>" by (rule MMI_pm3_26)
   from S26 have S27: "( ( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<and> ( B \<noteq> \<zero> \<and> C \<noteq> \<zero> ) ) \<longrightarrow> 
 B \<noteq> \<zero>" by (rule MMI_adantl)
   from S19 S23 S25 S27 have S28: "( ( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<and> ( B \<noteq> \<zero> \<and> C \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( A \<cdiv> C ) \<cdiv> B ) = 
 ( ( A \<cdiv> C ) \<cdot> ( \<one> \<cdiv> B ) )" by (rule MMI_syl3anc)
   from S13 S18 S28 show "( ( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<and> ( B \<noteq> \<zero> \<and> C \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( A \<cdiv> B ) \<cdiv> C ) = ( ( A \<cdiv> C ) \<cdiv> B )" by (rule MMI_3eqtr4d)
qed

lemma (in MMIsar0) MMI_divdiv23: assumes A1: "A \<in> \<complex>" and
    A2: "B \<in> \<complex>" and
    A3: "C \<in> \<complex>" and
    A4: "B \<noteq> \<zero>" and
    A5: "C \<noteq> \<zero>"   
   shows "( ( A \<cdiv> B ) \<cdiv> C ) = ( ( A \<cdiv> C ) \<cdiv> B )"
proof -
   from A1 have S1: "A \<in> \<complex>".
   from A2 have S2: "B \<in> \<complex>".
   from A4 have S3: "B \<noteq> \<zero>".
   from S2 S3 have S4: "( \<one> \<cdiv> B ) \<in> \<complex>" by (rule MMI_reccl)
   from A3 have S5: "C \<in> \<complex>".
   from A5 have S6: "C \<noteq> \<zero>".
   from S1 S4 S5 S6 have S7: "( ( A \<cdot> ( \<one> \<cdiv> B ) ) \<cdiv> C ) = 
 ( ( A \<cdiv> C ) \<cdot> ( \<one> \<cdiv> B ) )" by (rule MMI_div23)
   from A1 have S8: "A \<in> \<complex>".
   from A2 have S9: "B \<in> \<complex>".
   from A4 have S10: "B \<noteq> \<zero>".
   from S8 S9 S10 have S11: "( A \<cdiv> B ) = ( A \<cdot> ( \<one> \<cdiv> B ) )" by (rule MMI_divrec)
   from S11 have S12: "( ( A \<cdiv> B ) \<cdiv> C ) = 
 ( ( A \<cdot> ( \<one> \<cdiv> B ) ) \<cdiv> C )" by (rule MMI_opreq1i)
   from A1 have S13: "A \<in> \<complex>".
   from A3 have S14: "C \<in> \<complex>".
   from A5 have S15: "C \<noteq> \<zero>".
   from S13 S14 S15 have S16: "( A \<cdiv> C ) \<in> \<complex>" by (rule MMI_divcl)
   from A2 have S17: "B \<in> \<complex>".
   from A4 have S18: "B \<noteq> \<zero>".
   from S16 S17 S18 have S19: "( ( A \<cdiv> C ) \<cdiv> B ) = 
 ( ( A \<cdiv> C ) \<cdot> ( \<one> \<cdiv> B ) )" by (rule MMI_divrec)
   from S7 S12 S19 show "( ( A \<cdiv> B ) \<cdiv> C ) = ( ( A \<cdiv> C ) \<cdiv> B )" by (rule MMI_3eqtr4)
qed

lemma (in MMIsar0) MMI_divdiv23z: assumes A1: "A \<in> \<complex>" and
    A2: "B \<in> \<complex>" and
    A3: "C \<in> \<complex>"   
   shows "( B \<noteq> \<zero> \<and> C \<noteq> \<zero> ) \<longrightarrow> 
 ( ( A \<cdiv> B ) \<cdiv> C ) = ( ( A \<cdiv> C ) \<cdiv> B )"
proof -
   from A1 have S1: "A \<in> \<complex>".
   from A2 have S2: "B \<in> \<complex>".
   from A3 have S3: "C \<in> \<complex>".
   from S1 S2 S3 have S4: "A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex>" by (rule MMI_3pm3_2i)
   have S5: "( ( A \<in> \<complex> \<and> B \<in> \<complex> \<and> C \<in> \<complex> ) \<and> ( B \<noteq> \<zero> \<and> C \<noteq> \<zero> ) ) \<longrightarrow> 
 ( ( A \<cdiv> B ) \<cdiv> C ) = ( ( A \<cdiv> C ) \<cdiv> B )" by (rule MMI_divdiv23t)
   from S4 S5 show "( B \<noteq> \<zero> \<and> C \<noteq> \<zero> ) \<longrightarrow> 
 ( ( A \<cdiv> B ) \<cdiv> C ) = ( ( A \<cdiv> C ) \<cdiv> B )" by (rule MMI_mpan)
qed

lemma (in MMIsar0) MMI_redivcl: assumes A1: "A \<in> \<real>" and
    A2: "B \<in> \<real>" and
    A3: "B \<noteq> \<zero>"   
   shows "( A \<cdiv> B ) \<in> \<real>"
proof -
   from A1 have S1: "A \<in> \<real>".
   from S1 have S2: "A \<in> \<complex>" by (rule MMI_recn)
   from A2 have S3: "B \<in> \<real>".
   from S3 have S4: "B \<in> \<complex>" by (rule MMI_recn)
   from A3 have S5: "B \<noteq> \<zero>".
   from S2 S4 S5 have S6: "( A \<cdiv> B ) = ( A \<cdot> ( \<one> \<cdiv> B ) )" by (rule MMI_divrec)
   from A1 have S7: "A \<in> \<real>".
   from A2 have S8: "B \<in> \<real>".
   from A3 have S9: "B \<noteq> \<zero>".
   have S10: "( B \<in> \<real> \<and> B \<noteq> \<zero> ) \<longrightarrow> 
 ( \<exists> x \<in> \<real> . ( B \<cdot> x ) = \<one> )" by (rule MMI_axrrecex)
   from S8 S9 S10 have S11: "\<exists> x \<in> \<real> . ( B \<cdot> x ) = \<one>" by (rule MMI_mp2an)
   have S12: "( \<exists> x \<in> \<real> . ( B \<cdot> x ) = 
 \<one> ) \<longleftrightarrow> 
 ( \<exists> x . ( x \<in> \<real> \<and> ( B \<cdot> x ) = \<one> ) )" by (rule MMI_df_rex)
   { fix x
     have S13: "x \<in> \<real> \<longrightarrow> x \<in> \<complex>" by (rule MMI_recnt)
     have S14: "x = if ( x \<in> \<complex> , x , \<one> ) \<longrightarrow>  ( ( \<one> \<cdiv> B ) =  x \<longleftrightarrow> 
       ( \<one> \<cdiv> B ) = if ( x \<in> \<complex> , x , \<one> ) )" by (rule MMI_eqeq2)
     have S15: "x = if ( x \<in> \<complex> , x , \<one> ) \<longrightarrow>  
       ( B \<cdot> x ) = ( B \<cdot> if ( x \<in> \<complex> , x , \<one> ) )" by (rule MMI_opreq2)
     from S15 have S16: "x = if ( x \<in> \<complex> , x , \<one> ) \<longrightarrow> 
       ( ( B \<cdot> x ) =  \<one> \<longleftrightarrow> ( B \<cdot> if ( x \<in> \<complex> , x , \<one> ) ) = \<one> )" by (rule MMI_eqeq1d)
     from S14 S16 have S17: "x =  if ( x \<in> \<complex> , x , \<one> ) \<longrightarrow> 
       ( ( ( \<one> \<cdiv> B ) = x \<longleftrightarrow> ( B \<cdot> x ) = \<one> ) \<longleftrightarrow> 
       ( ( \<one> \<cdiv> B ) = if ( x \<in> \<complex> , x , \<one> ) \<longleftrightarrow> 
       ( B \<cdot> if ( x \<in> \<complex> , x , \<one> ) ) = \<one> ) )" by (rule MMI_bibi12d)
     have S18: "\<one> \<in> \<complex>" by (rule MMI_1cn)
     from S4 have S19: "B \<in> \<complex>" .
     have S20: "\<one> \<in> \<complex>" by (rule MMI_1cn)
     from S20 have S21: "if ( x \<in> \<complex> , x , \<one> ) \<in> \<complex>" by (rule MMI_elimel)
     from A3 have S22: "B \<noteq> \<zero>".
     from S18 S19 S21 S22 have S23: "( \<one> \<cdiv> B ) = 
       if ( x \<in> \<complex> , x , \<one> ) \<longleftrightarrow> 
       ( B \<cdot> if ( x \<in> \<complex> , x , \<one> ) ) = \<one>" by (rule MMI_divmul)
     from S17 S23 have S24: "x \<in> \<complex> \<longrightarrow> 
       ( ( \<one> \<cdiv> B ) = x \<longleftrightarrow> ( B \<cdot> x ) = \<one> )" by (rule MMI_dedth)
     from S13 S24 have S25: "x \<in> \<real> \<longrightarrow> 
       ( ( \<one> \<cdiv> B ) = x \<longleftrightarrow> ( B \<cdot> x ) = \<one> )" by (rule MMI_syl)
     have S26: "x \<in> \<real> \<longrightarrow> 
       ( ( \<one> \<cdiv> B ) = x \<longrightarrow> ( \<one> \<cdiv> B ) \<in> \<real> )" by (rule MMI_eleq1a)
     from S25 S26 have S27: "x \<in> \<real> \<longrightarrow> 
       ( ( B \<cdot> x ) = \<one> \<longrightarrow> ( \<one> \<cdiv> B ) \<in> \<real> )" by (rule MMI_sylbird)
     from S27 have  "( x \<in> \<real> \<and> ( B \<cdot> x ) = 
       \<one> ) \<longrightarrow> ( \<one> \<cdiv> B ) \<in> \<real>" by (rule MMI_imp)
   } then have S28: 
       "\<forall>x. ( x \<in> \<real> \<and> ( B \<cdot> x ) = \<one> ) \<longrightarrow> ( \<one> \<cdiv> B ) \<in> \<real>"
     by auto;
     from S28 have S29: "( \<exists> x . ( x \<in> \<real> \<and> ( B \<cdot> x ) = \<one> ) ) \<longrightarrow> 
       ( \<one> \<cdiv> B ) \<in> \<real>" by (rule MMI_19_23aiv);
   from S12 S29 have S30: "( \<exists> x \<in> \<real> . ( B \<cdot> x ) = 
 \<one> ) \<longrightarrow> ( \<one> \<cdiv> B ) \<in> \<real>" by (rule MMI_sylbi)
   from S11 S30 have S31: "( \<one> \<cdiv> B ) \<in> \<real>" by (rule MMI_ax_mp)
   from S7 S31 have S32: "( A \<cdot> ( \<one> \<cdiv> B ) ) \<in> \<real>" by (rule MMI_remulcl)
   from S6 S32 show "( A \<cdiv> B ) \<in> \<real>" by (rule MMI_eqeltr)
qed;

lemma (in MMIsar0) MMI_redivclz: assumes A1: "A \<in> \<real>" and
    A2: "B \<in> \<real>"   
   shows "B \<noteq> \<zero> \<longrightarrow> ( A \<cdiv> B ) \<in> \<real>"
proof -
   have S1: "B = 
 if ( B \<noteq> \<zero> , B , \<one> ) \<longrightarrow> 
 ( A \<cdiv> B ) = 
 ( A \<cdiv> if ( B \<noteq> \<zero> , B , \<one> ) )" by (rule MMI_opreq2)
   from S1 have S2: "B = 
 if ( B \<noteq> \<zero> , B , \<one> ) \<longrightarrow> 
 ( ( A \<cdiv> B ) \<in> \<real> \<longleftrightarrow> 
 ( A \<cdiv> if ( B \<noteq> \<zero> , B , \<one> ) ) \<in> \<real> )" by (rule MMI_eleq1d)
   from A1 have S3: "A \<in> \<real>".
   from A2 have S4: "B \<in> \<real>".
   have S5: "\<one> \<in> \<real>" by (rule MMI_ax1re)
   from S4 S5 have S6: "if ( B \<noteq> \<zero> , B , \<one> ) \<in> \<real>" by (rule MMI_keepel)
   have S7: "if ( B \<noteq> \<zero> , B , \<one> ) \<noteq> \<zero>" by (rule MMI_elimne0)
   from S3 S6 S7 have S8: "( A \<cdiv> if ( B \<noteq> \<zero> , B , \<one> ) ) \<in> \<real>" by (rule MMI_redivcl)
   from S2 S8 show "B \<noteq> \<zero> \<longrightarrow> ( A \<cdiv> B ) \<in> \<real>" by (rule MMI_dedth)
qed

lemma (in MMIsar0) MMI_redivclt: 
   shows "( A \<in> \<real> \<and> B \<in> \<real> \<and> B \<noteq> \<zero> ) \<longrightarrow> 
 ( A \<cdiv> B ) \<in> \<real>"
proof -
   have S1: "A = 
 if ( A \<in> \<real> , A , \<zero> ) \<longrightarrow> 
 ( A \<cdiv> B ) = 
 ( if ( A \<in> \<real> , A , \<zero> ) \<cdiv> B )" by (rule MMI_opreq1)
   from S1 have S2: "A = 
 if ( A \<in> \<real> , A , \<zero> ) \<longrightarrow> 
 ( ( A \<cdiv> B ) \<in> \<real> \<longleftrightarrow> 
 ( if ( A \<in> \<real> , A , \<zero> ) \<cdiv> B ) \<in> \<real> )" by (rule MMI_eleq1d)
   from S2 have S3: "A = 
 if ( A \<in> \<real> , A , \<zero> ) \<longrightarrow> 
 ( ( B \<noteq> \<zero> \<longrightarrow> ( A \<cdiv> B ) \<in> \<real> ) \<longleftrightarrow> 
 ( B \<noteq> \<zero> \<longrightarrow> 
 ( if ( A \<in> \<real> , A , \<zero> ) \<cdiv> B ) \<in> \<real> ) )" by (rule MMI_imbi2d)
   have S4: "B = 
 if ( B \<in> \<real> , B , \<zero> ) \<longrightarrow> 
 ( B \<noteq> \<zero> \<longleftrightarrow> if ( B \<in> \<real> , B , \<zero> ) \<noteq> \<zero> )" by (rule MMI_neeq1)
   have S5: "B = 
 if ( B \<in> \<real> , B , \<zero> ) \<longrightarrow> 
 ( if ( A \<in> \<real> , A , \<zero> ) \<cdiv> B ) = 
 ( if ( A \<in> \<real> , A , \<zero> ) \<cdiv> if ( B \<in> \<real> , B , \<zero> ) )" by (rule MMI_opreq2)
   from S5 have S6: "B = 
 if ( B \<in> \<real> , B , \<zero> ) \<longrightarrow> 
 ( ( if ( A \<in> \<real> , A , \<zero> ) \<cdiv> B ) \<in> \<real> \<longleftrightarrow> 
 ( if ( A \<in> \<real> , A , \<zero> ) \<cdiv> if ( B \<in> \<real> , B , \<zero> ) ) \<in> \<real> )" by (rule MMI_eleq1d)
   from S4 S6 have S7: "B = 
 if ( B \<in> \<real> , B , \<zero> ) \<longrightarrow> 
 ( ( B \<noteq> \<zero> \<longrightarrow> ( if ( A \<in> \<real> , A , \<zero> ) \<cdiv> B ) \<in> \<real> ) \<longleftrightarrow> 
 ( if ( B \<in> \<real> , B , \<zero> ) \<noteq> \<zero> \<longrightarrow> 
 ( if ( A \<in> \<real> , A , \<zero> ) \<cdiv> if ( B \<in> \<real> , B , \<zero> ) ) \<in> \<real> ) )" by (rule MMI_imbi12d)
   have S8: "\<zero> \<in> \<real>" by (rule MMI_0re)
   from S8 have S9: "if ( A \<in> \<real> , A , \<zero> ) \<in> \<real>" by (rule MMI_elimel)
   have S10: "\<zero> \<in> \<real>" by (rule MMI_0re)
   from S10 have S11: "if ( B \<in> \<real> , B , \<zero> ) \<in> \<real>" by (rule MMI_elimel)
   from S9 S11 have S12: "if ( B \<in> \<real> , B , \<zero> ) \<noteq> \<zero> \<longrightarrow> 
 ( if ( A \<in> \<real> , A , \<zero> ) \<cdiv> if ( B \<in> \<real> , B , \<zero> ) ) \<in> \<real>" by (rule MMI_redivclz)
   from S3 S7 S12 have S13: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow> 
 ( B \<noteq> \<zero> \<longrightarrow> ( A \<cdiv> B ) \<in> \<real> )" by (rule MMI_dedth2h)
   from S13 show "( A \<in> \<real> \<and> B \<in> \<real> \<and> B \<noteq> \<zero> ) \<longrightarrow> 
 ( A \<cdiv> B ) \<in> \<real>" by (rule MMI_3impia)
qed;

(*********221-223*******************************************)

lemma (in MMIsar0) MMI_rereccl: assumes A1: "A \<in> \<real>" and
    A2: "A \<noteq> \<zero>"   
   shows "( \<one> \<cdiv> A ) \<in> \<real>"
proof -
   have S1: "\<one> \<in> \<real>" by (rule MMI_ax1re)
   from A1 have S2: "A \<in> \<real>".
   from A2 have S3: "A \<noteq> \<zero>".
   from S1 S2 S3 show "( \<one> \<cdiv> A ) \<in> \<real>" by (rule MMI_redivcl)
qed

lemma (in MMIsar0) MMI_rerecclz: assumes A1: "A \<in> \<real>"   
   shows "A \<noteq> \<zero> \<longrightarrow> ( \<one> \<cdiv> A ) \<in> \<real>"
proof -
   have S1: "\<one> \<in> \<real>" by (rule MMI_ax1re)
   from A1 have S2: "A \<in> \<real>".
   from S1 S2 show "A \<noteq> \<zero> \<longrightarrow> ( \<one> \<cdiv> A ) \<in> \<real>" by (rule MMI_redivclz)
qed

lemma (in MMIsar0) MMI_rerecclt: 
   shows "( A \<in> \<real> \<and> A \<noteq> \<zero> ) \<longrightarrow> ( \<one> \<cdiv> A ) \<in> \<real>"
proof -
   have S1: "\<one> \<in> \<real>" by (rule MMI_ax1re)
   have S2: "( \<one> \<in> \<real> \<and> A \<in> \<real> \<and> A \<noteq> \<zero> ) \<longrightarrow> 
 ( \<one> \<cdiv> A ) \<in> \<real>" by (rule MMI_redivclt)
   from S1 S2 show "( A \<in> \<real> \<and> A \<noteq> \<zero> ) \<longrightarrow> ( \<one> \<cdiv> A ) \<in> \<real>" 
     by (rule MMI_mp3an1)
qed;

(*********** a couple of definitions translated by hand ****)

lemma (in MMIsar0) MMI_df_pnf: shows "\<cpnf> = \<complex>"
  using cpnf_def by simp;

lemma (in MMIsar0) MMI_df_mnf: shows "\<cmnf> = {\<complex>}"
  using cmnf_def by simp;

lemma (in MMIsar0) MMI_df_xr: shows "\<real>\<^isup>* = \<real> \<union> {\<cpnf>,\<cmnf>}"
  using cxr_def by simp;

lemma (in MMIsar0) MMI_ltxrt: shows "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* ) \<longrightarrow>   
  ( A \<ls> B \<longleftrightarrow>   
  ( ( ( ( A \<in> \<real> \<and> B \<in> \<real> ) \<and> A \<lsr> B ) \<or> ( A = \<cmnf> \<and> B = \<cpnf> ) ) \<or> 
  ( ( A \<in> \<real> \<and> B = \<cpnf> ) \<or> ( A = \<cmnf> \<and> B \<in> \<real> ) ) ) )"
  using cxr_def lessr_def cxr_def cltrrset_def cltrr_def by auto;

(***223-225***************************************)

lemma (in MMIsar0) MMI_pnfnre: 
   shows "\<cpnf> \<notin> \<real>"
proof -
   have S1: "\<not> ( \<complex> \<in> \<complex> )" by (rule MMI_eirr)
   have S2: "\<cpnf> = \<complex>" by (rule MMI_df_pnf)
   from S2 have S3: "\<cpnf> \<in> \<complex> \<longleftrightarrow> \<complex> \<in> \<complex>" by (rule MMI_eleq1i)
   from S1 S3 have S4: "\<not> ( \<cpnf> \<in> \<complex> )" by (rule MMI_mtbir)
   have S5: "\<cpnf> \<in> \<real> \<longrightarrow> \<cpnf> \<in> \<complex>" by (rule MMI_recnt)
   from S4 S5 have S6: "\<not> ( \<cpnf> \<in> \<real> )" by (rule MMI_mto)
   have S7: "\<cpnf> \<notin> \<real> \<longleftrightarrow> \<not> ( \<cpnf> \<in> \<real> )" by (rule MMI_df_nel)
   from S6 S7 show "\<cpnf> \<notin> \<real>" by (rule MMI_mpbir)
qed

lemma (in MMIsar0) MMI_minfnre: 
   shows "\<cmnf> \<notin> \<real>"
proof -
   have S1: "\<complex> isASet" by (rule MMI_axcnex)
   from S1 have S2: "\<complex> \<in> { \<complex> }" by (rule MMI_snid)
   have S3: "\<not> ( ( \<complex> \<in> { \<complex> } \<and> { \<complex> } \<in> \<complex> ) )" by (rule MMI_en2lp)
   have S4: "( \<complex> \<in> { \<complex> } \<longrightarrow> 
 \<not> ( { \<complex> } \<in> \<complex> ) ) \<longleftrightarrow> 
 \<not> ( ( \<complex> \<in> { \<complex> } \<and> { \<complex> } \<in> \<complex> ) )" by (rule MMI_imnan)
   from S3 S4 have S5: "\<complex> \<in> { \<complex> } \<longrightarrow> \<not> ( { \<complex> } \<in> \<complex> )" by (rule MMI_mpbir)
   from S2 S5 have S6: "\<not> ( { \<complex> } \<in> \<complex> )" by (rule MMI_ax_mp)
   have S7: "\<cmnf> = { \<complex> }" by (rule MMI_df_mnf)
   from S7 have S8: "\<cmnf> \<in> \<complex> \<longleftrightarrow> { \<complex> } \<in> \<complex>" by (rule MMI_eleq1i)
   from S6 S8 have S9: "\<not> ( \<cmnf> \<in> \<complex> )" by (rule MMI_mtbir)
   have S10: "\<cmnf> \<in> \<real> \<longrightarrow> \<cmnf> \<in> \<complex>" by (rule MMI_recnt)
   from S9 S10 have S11: "\<not> ( \<cmnf> \<in> \<real> )" by (rule MMI_mto)
   have S12: "\<cmnf> \<notin> \<real> \<longleftrightarrow> \<not> ( \<cmnf> \<in> \<real> )" by (rule MMI_df_nel)
   from S11 S12 show "\<cmnf> \<notin> \<real>" by (rule MMI_mpbir)
qed;

(***********226-228*********************************)

lemma (in MMIsar0) MMI_ressxr: 
   shows "\<real> \<subseteq> \<real>\<^isup>*"
proof -
   have S1: "\<real> \<subseteq> ( \<real> \<union> { \<cpnf> , \<cmnf> } )" by (rule MMI_ssun1)
   have S2: "\<real>\<^isup>* = ( \<real> \<union> { \<cpnf> , \<cmnf> } )" by (rule MMI_df_xr)
   from S1 S2 show "\<real> \<subseteq> \<real>\<^isup>*" by (rule MMI_sseqtr4)
qed

lemma (in MMIsar0) MMI_rexrt: 
   shows "A \<in> \<real> \<longrightarrow> A \<in> \<real>\<^isup>*"
proof -
   have S1: "\<real> \<subseteq> \<real>\<^isup>*" by (rule MMI_ressxr)
   from S1 show "A \<in> \<real> \<longrightarrow> A \<in> \<real>\<^isup>*" by (rule MMI_sseli)
qed

lemma (in MMIsar0) MMI_ltxrltt: 
   shows "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow> ( A \<ls> B \<longleftrightarrow> A \<lsr> B )"
proof -
   have S1: "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* ) \<longrightarrow>   
     ( A \<ls> B \<longleftrightarrow>   
     ( ( ( ( A \<in> \<real> \<and> B \<in> \<real> ) \<and> A \<lsr> B ) \<or> ( A = \<cmnf> \<and> B = \<cpnf> ) ) \<or> 
     ( ( A \<in> \<real> \<and> B = \<cpnf> ) \<or> ( A = \<cmnf> \<and> B \<in> \<real> ) ) ) )" by (rule MMI_ltxrt)
   have S2: "A \<in> \<real> \<longrightarrow> A \<in> \<real>\<^isup>*" by (rule MMI_rexrt)
   have S3: "B \<in> \<real> \<longrightarrow> B \<in> \<real>\<^isup>*" by (rule MMI_rexrt)
   from S1 S2 S3 have S4: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A \<ls> B \<longleftrightarrow>   
 ( ( ( ( A \<in> \<real> \<and> B \<in> \<real> ) \<and> A \<lsr> B ) \<or> ( A = \<cmnf> \<and> B = \<cpnf> ) ) \<or> 
     ( ( A \<in> \<real> \<and> B = \<cpnf> ) \<or> ( A = \<cmnf> \<and> B \<in> \<real> ) ) ) )" by (rule MMI_syl2an)
   have S5: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A \<lsr> B \<longleftrightarrow>   
 ( ( A \<in> \<real> \<and> B \<in> \<real> ) \<and> A \<lsr> B ) )" by (rule MMI_ibar)
   have S6: "\<cpnf> \<notin> \<real>" by (rule MMI_pnfnre)
   have S7: "\<cpnf> \<notin> \<real> \<longleftrightarrow> \<not> ( \<cpnf> \<in> \<real> )" by (rule MMI_df_nel)
   from S6 S7 have S8: "\<not> ( \<cpnf> \<in> \<real> )" by (rule MMI_mpbi)
   have S9: "B = \<cpnf> \<longrightarrow> ( B \<in> \<real> \<longleftrightarrow> \<cpnf> \<in> \<real> )" by (rule MMI_eleq1)
   from S8 S9 have S10: "B = \<cpnf> \<longrightarrow> \<not> ( B \<in> \<real> )" by (rule MMI_mtbiri)
   from S10 have S11: "B \<in> \<real> \<longrightarrow> \<not> ( B = \<cpnf> )" by (rule MMI_con2i)
   from S11 have S12: "B \<in> \<real> \<longrightarrow> \<not> ( ( A = \<cmnf> \<and> B = \<cpnf> ) )" by (rule MMI_intnand)
   from S12 have S13: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 \<not> ( ( A = \<cmnf> \<and> B = \<cpnf> ) )" by (rule MMI_adantl)
   from S11 have S14: "B \<in> \<real> \<longrightarrow> \<not> ( B = \<cpnf> )" .
   from S14 have S15: "B \<in> \<real> \<longrightarrow> \<not> ( ( A \<in> \<real> \<and> B = \<cpnf> ) )" by (rule MMI_intnand)
   have S16: "\<cmnf> \<notin> \<real>" by (rule MMI_minfnre)
   have S17: "\<cmnf> \<notin> \<real> \<longleftrightarrow> \<not> ( \<cmnf> \<in> \<real> )" by (rule MMI_df_nel)
   from S16 S17 have S18: "\<not> ( \<cmnf> \<in> \<real> )" by (rule MMI_mpbi)
   have S19: "A = \<cmnf> \<longrightarrow> ( A \<in> \<real> \<longleftrightarrow> \<cmnf> \<in> \<real> )" by (rule MMI_eleq1)
   from S18 S19 have S20: "A = \<cmnf> \<longrightarrow> \<not> ( A \<in> \<real> )" by (rule MMI_mtbiri)
   from S20 have S21: "A \<in> \<real> \<longrightarrow> \<not> ( A = \<cmnf> )" by (rule MMI_con2i)
   from S21 have S22: "A \<in> \<real> \<longrightarrow> \<not> ( ( A = \<cmnf> \<and> B \<in> \<real> ) )" by (rule MMI_intnanrd)
   from S15 S22 have S23: "( B \<in> \<real> \<and> A \<in> \<real> ) \<longrightarrow>   
 ( \<not> ( ( A \<in> \<real> \<and> B = \<cpnf> ) ) \<and> \<not> ( ( A = \<cmnf> \<and> B \<in> \<real> ) ) )" by (rule MMI_anim12i)
   have S24: "\<not> ( ( ( A \<in> \<real> \<and> B = \<cpnf> ) \<or> ( A = \<cmnf> \<and> B \<in> \<real> ) ) ) \<longleftrightarrow>   
 ( \<not> ( ( A \<in> \<real> \<and> B = \<cpnf> ) ) \<and> \<not> ( ( A = \<cmnf> \<and> B \<in> \<real> ) ) )" by (rule MMI_ioran)
   from S23 S24 have S25: "( B \<in> \<real> \<and> A \<in> \<real> ) \<longrightarrow>   
 \<not> ( ( ( A \<in> \<real> \<and> B = \<cpnf> ) \<or> ( A = \<cmnf> \<and> B \<in> \<real> ) ) )" by (rule MMI_sylibr)
   from S25 have S26: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 \<not> ( ( ( A \<in> \<real> \<and> B = \<cpnf> ) \<or> ( A = \<cmnf> \<and> B \<in> \<real> ) ) )" by (rule MMI_ancoms)
   from S13 S26 have S27: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( \<not> ( ( A = \<cmnf> \<and> B = \<cpnf> ) ) \<and> \<not> ( ( ( A \<in> \<real> \<and> B = \<cpnf> ) \<or> 
     ( A = \<cmnf> \<and> B \<in> \<real> ) ) ) )" by (rule MMI_jca)
   have S28: "\<not> ( ( ( A = \<cmnf> \<and> B = \<cpnf> ) \<or> ( ( A \<in> \<real> \<and> B = \<cpnf> ) \<or> 
     ( A = \<cmnf> \<and> B \<in> \<real> ) ) ) ) \<longleftrightarrow>   
 ( \<not> ( ( A = \<cmnf> \<and> B = \<cpnf> ) ) \<and> \<not> ( ( ( A \<in> \<real> \<and> B = \<cpnf> ) \<or> 
     ( A = \<cmnf> \<and> B \<in> \<real> ) ) ) )" by (rule MMI_ioran)
   from S27 S28 have S29: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 \<not> ( ( ( A = \<cmnf> \<and> B = \<cpnf> ) \<or> ( ( A \<in> \<real> \<and> B = \<cpnf> ) \<or> 
     ( A = \<cmnf> \<and> B \<in> \<real> ) ) ) )" by (rule MMI_sylibr)
   have S30: "\<not> ( ( ( A = \<cmnf> \<and> B = \<cpnf> ) \<or> ( ( A \<in> \<real> \<and> B = \<cpnf> ) \<or> 
     ( A = \<cmnf> \<and> B \<in> \<real> ) ) ) ) \<longrightarrow>   
 ( ( ( A \<in> \<real> \<and> B \<in> \<real> ) \<and> A \<lsr> B ) \<longleftrightarrow>   
 ( ( ( A = \<cmnf> \<and> B = \<cpnf> ) \<or> ( ( A \<in> \<real> \<and> B = \<cpnf> ) \<or> 
     ( A = \<cmnf> \<and> B \<in> \<real> ) ) ) \<or> ( ( A \<in> \<real> \<and> B \<in> \<real> ) \<and> A \<lsr> B ) ) )" 
     by (rule MMI_biorf)
   from S29 S30 have S31: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( ( ( A \<in> \<real> \<and> B \<in> \<real> ) \<and> A \<lsr> B ) \<longleftrightarrow>   
 ( ( ( A = \<cmnf> \<and> B = \<cpnf> ) \<or> ( ( A \<in> \<real> \<and> B = \<cpnf> ) \<or> 
     ( A = \<cmnf> \<and> B \<in> \<real> ) ) ) \<or> ( ( A \<in> \<real> \<and> B \<in> \<real> ) \<and> A \<lsr> B ) ) )" 
     by (rule MMI_syl)
   from S5 S31 have S32: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( ( ( ( A = \<cmnf> \<and> B = \<cpnf> ) \<or> ( ( A \<in> \<real> \<and> B = \<cpnf> ) \<or> 
     ( A = \<cmnf> \<and> B \<in> \<real> ) ) ) \<or> ( ( A \<in> \<real> \<and> B \<in> \<real> ) \<and> A \<lsr> B ) ) \<longleftrightarrow>   
 A \<lsr> B )" by (rule MMI_bitr2d)
   have S33: "( ( ( ( A \<in> \<real> \<and> B \<in> \<real> ) \<and> A \<lsr> B ) \<or> 
     ( A = \<cmnf> \<and> B = \<cpnf> ) ) \<or> ( ( A \<in> \<real> \<and> B = \<cpnf> ) \<or> 
     ( A = \<cmnf> \<and> B \<in> \<real> ) ) ) \<longleftrightarrow>   
 ( ( ( A \<in> \<real> \<and> B \<in> \<real> ) \<and> A \<lsr> B ) \<or> ( ( A = \<cmnf> \<and> B = \<cpnf> ) \<or> 
     ( ( A \<in> \<real> \<and> B = \<cpnf> ) \<or> ( A = \<cmnf> \<and> B \<in> \<real> ) ) ) )" by (rule MMI_orass)
   have S34: "( ( ( A \<in> \<real> \<and> B \<in> \<real> ) \<and> A \<lsr> B ) \<or> ( ( A = \<cmnf> \<and> B = \<cpnf> ) \<or> 
     ( ( A \<in> \<real> \<and> B = \<cpnf> ) \<or> ( A = \<cmnf> \<and> B \<in> \<real> ) ) ) ) \<longleftrightarrow>   
 ( ( ( A = \<cmnf> \<and> B = \<cpnf> ) \<or> ( ( A \<in> \<real> \<and> B = \<cpnf> ) \<or> 
     ( A = \<cmnf> \<and> B \<in> \<real> ) ) ) \<or> ( ( A \<in> \<real> \<and> B \<in> \<real> ) \<and> A \<lsr> B ) )" 
     by (rule MMI_orcom)
   from S33 S34 have S35: "( ( ( ( A \<in> \<real> \<and> B \<in> \<real> ) \<and> A \<lsr> B ) \<or> 
     ( A = \<cmnf> \<and> B = \<cpnf> ) ) \<or> ( ( A \<in> \<real> \<and> B = \<cpnf> ) \<or> 
     ( A = \<cmnf> \<and> B \<in> \<real> ) ) ) \<longleftrightarrow>   
 ( ( ( A = \<cmnf> \<and> B = \<cpnf> ) \<or> ( ( A \<in> \<real> \<and> B = \<cpnf> ) \<or> 
     ( A = \<cmnf> \<and> B \<in> \<real> ) ) ) \<or> ( ( A \<in> \<real> \<and> B \<in> \<real> ) \<and> A \<lsr> B ) )" 
     by (rule MMI_bitr)
   from S32 S35 have S36: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( ( ( ( ( A \<in> \<real> \<and> B \<in> \<real> ) \<and> A \<lsr> B ) \<or> ( A = \<cmnf> \<and> B = \<cpnf> ) ) \<or> 
     ( ( A \<in> \<real> \<and> B = \<cpnf> ) \<or> ( A = \<cmnf> \<and> B \<in> \<real> ) ) ) \<longleftrightarrow>   
 A \<lsr> B )" by (rule MMI_syl5bb)
   from S4 S36 show "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow> ( A \<ls> B \<longleftrightarrow> A \<lsr> B )" 
     by (rule MMI_bitrd)
qed;

(*********** proven by hand from definition********
    note that MMIsar definition of \<lsq> (see the locale
    (is different than Metamath's, we may have to change it 
    if it leads problems.
    ******************************************************)

lemma (in MMIsar0) MMI_xrlenltt: 
   shows "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* ) \<longrightarrow>   
  ( A \<lsq> B \<longleftrightarrow> \<not> ( B \<ls> A ) )"
  using lsq_def by simp;


(*********229,230*******************************)

lemma (in MMIsar0) MMI_axlttri: 
   shows "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A \<ls> B \<longleftrightarrow> \<not> ( ( A = B \<or> B \<ls> A ) ) )"
proof -
   have S1: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A \<lsr> B \<longleftrightarrow> \<not> ( ( A = B \<or> B \<lsr> A ) ) )" by (rule MMI_pre_axlttri)
   have S2: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow> ( A \<ls> B \<longleftrightarrow> A \<lsr> B )" by (rule MMI_ltxrltt)
   have S3: "( B \<in> \<real> \<and> A \<in> \<real> ) \<longrightarrow> ( B \<ls> A \<longleftrightarrow> B \<lsr> A )" by (rule MMI_ltxrltt)
   from S3 have S4: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow> ( B \<ls> A \<longleftrightarrow> B \<lsr> A )" by (rule MMI_ancoms)
   from S4 have S5: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( ( A = B \<or> B \<ls> A ) \<longleftrightarrow>   
 ( A = B \<or> B \<lsr> A ) )" by (rule MMI_orbi2d)
   from S5 have S6: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( \<not> ( ( A = B \<or> B \<ls> A ) ) \<longleftrightarrow>   
 \<not> ( ( A = B \<or> B \<lsr> A ) ) )" by (rule MMI_negbid)
   from S1 S2 S6 show "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A \<ls> B \<longleftrightarrow> \<not> ( ( A = B \<or> B \<ls> A ) ) )" by (rule MMI_3bitr4d)
qed

lemma (in MMIsar0) MMI_axlttrn: 
   shows "( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( ( A \<ls> B \<and> B \<ls> C ) \<longrightarrow> A \<ls> C )"
proof -
   have S1: "( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( ( A \<lsr> B \<and> B \<lsr> C ) \<longrightarrow> A \<lsr> C )" by (rule MMI_pre_axlttrn)
   have S2: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow> ( A \<ls> B \<longleftrightarrow> A \<lsr> B )" by (rule MMI_ltxrltt)
   from S2 have S3: "( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( A \<ls> B \<longleftrightarrow> A \<lsr> B )" by (rule MMI_3adant3)
   have S4: "( B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow> ( B \<ls> C \<longleftrightarrow> B \<lsr> C )" by (rule MMI_ltxrltt)
   from S4 have S5: "( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( B \<ls> C \<longleftrightarrow> B \<lsr> C )" by (rule MMI_3adant1)
   from S3 S5 have S6: "( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( ( A \<ls> B \<and> B \<ls> C ) \<longleftrightarrow>   
 ( A \<lsr> B \<and> B \<lsr> C ) )" by (rule MMI_anbi12d)
   have S7: "( A \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow> ( A \<ls> C \<longleftrightarrow> A \<lsr> C )" by (rule MMI_ltxrltt)
   from S7 have S8: "( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( A \<ls> C \<longleftrightarrow> A \<lsr> C )" by (rule MMI_3adant2)
   from S1 S6 S8 show "( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( ( A \<ls> B \<and> B \<ls> C ) \<longrightarrow> A \<ls> C )" by (rule MMI_3imtr4d)
qed;

(***************231-235********************************)

lemma (in MMIsar0) MMI_axltadd: 
   shows "( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( A \<ls> B \<longrightarrow> ( C \<ca> A ) \<ls> ( C \<ca> B ) )"
proof -
   have S1: "( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( A \<lsr> B \<longrightarrow> ( C \<ca> A ) \<lsr> ( C \<ca> B ) )" by (rule MMI_pre_axltadd)
   have S2: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow> ( A \<ls> B \<longleftrightarrow> A \<lsr> B )" by (rule MMI_ltxrltt)
   from S2 have S3: "( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( A \<ls> B \<longleftrightarrow> A \<lsr> B )" by (rule MMI_3adant3)
   have S4: "( ( C \<ca> A ) \<in> \<real> \<and> ( C \<ca> B ) \<in> \<real> ) \<longrightarrow>   
 ( ( C \<ca> A ) \<ls> ( C \<ca> B ) \<longleftrightarrow>   
 ( C \<ca> A ) \<lsr> ( C \<ca> B ) )" by (rule MMI_ltxrltt)
   have S5: "( C \<in> \<real> \<and> A \<in> \<real> ) \<longrightarrow> ( C \<ca> A ) \<in> \<real>" by (rule MMI_axaddrcl)
   have S6: "( C \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow> ( C \<ca> B ) \<in> \<real>" by (rule MMI_axaddrcl)
   from S4 S5 S6 have S7: "( ( C \<in> \<real> \<and> A \<in> \<real> ) \<and> ( C \<in> \<real> \<and> B \<in> \<real> ) ) \<longrightarrow>   
 ( ( C \<ca> A ) \<ls> ( C \<ca> B ) \<longleftrightarrow>   
 ( C \<ca> A ) \<lsr> ( C \<ca> B ) )" by (rule MMI_syl2an)
   from S7 have S8: "( C \<in> \<real> \<and> A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( ( C \<ca> A ) \<ls> ( C \<ca> B ) \<longleftrightarrow>   
 ( C \<ca> A ) \<lsr> ( C \<ca> B ) )" by (rule MMI_3impdi)
   from S8 have S9: "( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( ( C \<ca> A ) \<ls> ( C \<ca> B ) \<longleftrightarrow>   
 ( C \<ca> A ) \<lsr> ( C \<ca> B ) )" by (rule MMI_3coml)
   from S1 S3 S9 show "( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( A \<ls> B \<longrightarrow> ( C \<ca> A ) \<ls> ( C \<ca> B ) )" by (rule MMI_3imtr4d)
qed

lemma (in MMIsar0) MMI_axmulgt0: 
   shows "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( ( \<zero> \<ls> A \<and> \<zero> \<ls> B ) \<longrightarrow> \<zero> \<ls> ( A \<cdot> B ) )"
proof -
   have S1: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( ( \<zero> \<lsr> A \<and> \<zero> \<lsr> B ) \<longrightarrow> \<zero> \<lsr> ( A \<cdot> B ) )" by (rule MMI_pre_axmulgt0)
   have S2: "\<zero> \<in> \<real>" by (rule MMI_0re)
   have S3: "( \<zero> \<in> \<real> \<and> A \<in> \<real> ) \<longrightarrow> ( \<zero> \<ls> A \<longleftrightarrow> \<zero> \<lsr> A )" by (rule MMI_ltxrltt)
   from S2 S3 have S4: "A \<in> \<real> \<longrightarrow> ( \<zero> \<ls> A \<longleftrightarrow> \<zero> \<lsr> A )" by (rule MMI_mpan)
   have S5: "\<zero> \<in> \<real>" by (rule MMI_0re)
   have S6: "( \<zero> \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow> ( \<zero> \<ls> B \<longleftrightarrow> \<zero> \<lsr> B )" by (rule MMI_ltxrltt)
   from S5 S6 have S7: "B \<in> \<real> \<longrightarrow> ( \<zero> \<ls> B \<longleftrightarrow> \<zero> \<lsr> B )" by (rule MMI_mpan)
   from S4 S7 have S8: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( ( \<zero> \<ls> A \<and> \<zero> \<ls> B ) \<longleftrightarrow>   
 ( \<zero> \<lsr> A \<and> \<zero> \<lsr> B ) )" by (rule MMI_bi2anan9)
   have S9: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow> ( A \<cdot> B ) \<in> \<real>" by (rule MMI_axmulrcl)
   have S10: "\<zero> \<in> \<real>" by (rule MMI_0re)
   have S11: "( \<zero> \<in> \<real> \<and> ( A \<cdot> B ) \<in> \<real> ) \<longrightarrow>   
 ( \<zero> \<ls> ( A \<cdot> B ) \<longleftrightarrow> \<zero> \<lsr> ( A \<cdot> B ) )" by (rule MMI_ltxrltt)
   from S10 S11 have S12: "( A \<cdot> B ) \<in> \<real> \<longrightarrow>   
 ( \<zero> \<ls> ( A \<cdot> B ) \<longleftrightarrow> \<zero> \<lsr> ( A \<cdot> B ) )" by (rule MMI_mpan)
   from S9 S12 have S13: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( \<zero> \<ls> ( A \<cdot> B ) \<longleftrightarrow> \<zero> \<lsr> ( A \<cdot> B ) )" by (rule MMI_syl)
   from S1 S8 S13 show "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( ( \<zero> \<ls> A \<and> \<zero> \<ls> B ) \<longrightarrow> \<zero> \<ls> ( A \<cdot> B ) )" by (rule MMI_3imtr4d)
qed

lemma (in MMIsar0) MMI_axsup: 
   shows "( ( A \<subseteq> \<real> \<and> A \<noteq> 0 \<and> ( \<exists> x \<in> \<real> . \<forall> y \<in> A . y \<ls> x ) ) \<longrightarrow>   
 ( \<exists> x \<in> \<real> . ( ( \<forall> y \<in> A . \<not> ( x \<ls> y ) ) \<and> 
  ( \<forall> y \<in> \<real> . ( y \<ls> x \<longrightarrow> ( \<exists> z \<in> A . y \<ls> z ) ) ) ) ) )"
proof -
  have S1: "( ( A \<subseteq> \<real> \<and> A \<noteq> 0 \<and> ( \<exists> x \<in> \<real> . \<forall> y \<in> A . y \<lsr> x ) ) \<longrightarrow>   
    ( \<exists> x \<in> \<real> . ( ( \<forall> y \<in> A . \<not> ( x \<lsr> y ) ) \<and> 
    ( \<forall> y \<in> \<real> . ( y \<lsr> x \<longrightarrow> ( \<exists> z \<in> A . y \<lsr> z ) ) ) ) ) )" 
    by (rule MMI_pre_axsup)
  from S1 have S2: 
    "( ( ( A \<subseteq> \<real> \<and> A \<noteq> 0 ) \<and> ( \<exists> x \<in> \<real> . \<forall> y \<in> A . y \<lsr> x ) ) \<longrightarrow>   
    ( \<exists> x \<in> \<real> . ( ( \<forall> y \<in> A . \<not> ( x \<lsr> y ) ) \<and> 
    ( \<forall> y \<in> \<real> . ( y \<lsr> x \<longrightarrow> ( \<exists> z \<in> A . y \<lsr> z ) ) ) ) ) )" 
    by (rule MMI_3expa)
  from S2 have S3: "( ( A \<subseteq> \<real> \<and> A \<noteq> 0 ) \<longrightarrow>   
    ( ( \<exists> x \<in> \<real> . \<forall> y \<in> A . y \<lsr> x ) \<longrightarrow>   
    ( \<exists> x \<in> \<real> . ( ( \<forall> y \<in> A . \<not> ( x \<lsr> y ) ) \<and> 
    ( \<forall> y \<in> \<real> . ( y \<lsr> x \<longrightarrow> ( \<exists> z \<in> A . y \<lsr> z ) ) ) ) ) ) )" 
    by (rule MMI_ex)
  { fix x
    { fix y
      have S4: "( y \<in> \<real> \<and> x \<in> \<real> ) \<longrightarrow> ( y \<ls> x \<longleftrightarrow> y \<lsr> x )" 
	by (rule MMI_ltxrltt)
      have S5: "( ( A \<subseteq> \<real> \<and> y \<in> A ) \<longrightarrow> y \<in> \<real> )" by (rule MMI_ssel2)
      from S4 S5 have S6: "( ( ( A \<subseteq> \<real> \<and> y \<in> A ) \<and> x \<in> \<real> ) \<longrightarrow>   
	( y \<ls> x \<longleftrightarrow> y \<lsr> x ) )" by (rule MMI_sylan)
      from S6 have "( ( ( A \<subseteq> \<real> \<and> x \<in> \<real> ) \<and> y \<in> A ) \<longrightarrow>   
	( y \<ls> x \<longleftrightarrow> y \<lsr> x ) )" by (rule MMI_an1rs)
    } then have S7: "\<forall>y. ( ( ( A \<subseteq> \<real> \<and> x \<in> \<real> ) \<and> y \<in> A ) \<longrightarrow>   
	( y \<ls> x \<longleftrightarrow> y \<lsr> x ) )" by simp;
    from S7 have  "( ( A \<subseteq> \<real> \<and> x \<in> \<real> ) \<longrightarrow>   
      ( ( \<forall> y \<in> A . y \<ls> x ) \<longleftrightarrow>   
      ( \<forall> y \<in> A . y \<lsr> x ) ) )" by (rule MMI_ralbidva);
  } then have S8: "\<forall> x. ( ( A \<subseteq> \<real> \<and> x \<in> \<real> ) \<longrightarrow>   
      ( ( \<forall> y \<in> A . y \<ls> x ) \<longleftrightarrow>   
      ( \<forall> y \<in> A . y \<lsr> x ) ) )" by simp
    from S8 have S9: "( A \<subseteq> \<real> \<longrightarrow>   
      ( ( \<exists> x \<in> \<real> . \<forall> y \<in> A . y \<ls> x ) \<longleftrightarrow>   
      ( \<exists> x \<in> \<real> . \<forall> y \<in> A . y \<lsr> x ) ) )" by (rule MMI_rexbidva);
   from S9 have S10: "( ( A \<subseteq> \<real> \<and> A \<noteq> 0 ) \<longrightarrow>   
 ( ( \<exists> x \<in> \<real> . \<forall> y \<in> A . y \<ls> x ) \<longleftrightarrow>   
 ( \<exists> x \<in> \<real> . \<forall> y \<in> A . y \<lsr> x ) ) )" by (rule MMI_adantr)
   { fix x
     { fix y 
       have S11: "( x \<in> \<real> \<and> y \<in> \<real> ) \<longrightarrow> ( x \<ls> y \<longleftrightarrow> x \<lsr> y )" by (rule MMI_ltxrltt)
       from S11 have S12: "( y \<in> \<real> \<and> x \<in> \<real> ) \<longrightarrow> ( x \<ls> y \<longleftrightarrow> x \<lsr> y )" 
	 by (rule MMI_ancoms)
       have S13: "( ( A \<subseteq> \<real> \<and> y \<in> A ) \<longrightarrow> y \<in> \<real> )" by (rule MMI_ssel2);
       from S12 S13 have S14: "( ( ( A \<subseteq> \<real> \<and> y \<in> A ) \<and> x \<in> \<real> ) \<longrightarrow>   
	 ( x \<ls> y \<longleftrightarrow> x \<lsr> y ) )" by (rule MMI_sylan)
       from S14 have S15: "( ( ( A \<subseteq> \<real> \<and> x \<in> \<real> ) \<and> y \<in> A ) \<longrightarrow>   
	 ( x \<ls> y \<longleftrightarrow> x \<lsr> y ) )" by (rule MMI_an1rs)
       from S15 have  "( ( ( A \<subseteq> \<real> \<and> x \<in> \<real> ) \<and> y \<in> A ) \<longrightarrow>   
	 ( \<not> ( x \<ls> y ) \<longleftrightarrow> \<not> ( x \<lsr> y ) ) )" by (rule MMI_negbid)
     } then have S16:  "\<forall> y. ( ( ( A \<subseteq> \<real> \<and> x \<in> \<real> ) \<and> y \<in> A ) \<longrightarrow>   
	 ( \<not> ( x \<ls> y ) \<longleftrightarrow> \<not> ( x \<lsr> y ) ) )" by simp;
     from S16 have S17: "( ( A \<subseteq> \<real> \<and> x \<in> \<real> ) \<longrightarrow>   
       ( ( \<forall> y \<in> A . \<not> ( x \<ls> y ) ) \<longleftrightarrow>   
       ( \<forall> y \<in> A . \<not> ( x \<lsr> y ) ) ) )" by (rule MMI_ralbidva);
     { fix y
       have S18: "( y \<in> \<real> \<and> x \<in> \<real> ) \<longrightarrow> ( y \<ls> x \<longleftrightarrow> y \<lsr> x )" 
	 by (rule MMI_ltxrltt);
       from S18 have S19: "( x \<in> \<real> \<and> y \<in> \<real> ) \<longrightarrow> ( y \<ls> x \<longleftrightarrow> y \<lsr> x )" 
	 by (rule MMI_ancoms)
       from S19 have S20: "( ( ( A \<subseteq> \<real> \<and> x \<in> \<real> ) \<and> y \<in> \<real> ) \<longrightarrow>   
	 ( y \<ls> x \<longleftrightarrow> y \<lsr> x ) )" by (rule MMI_adantll)
       { fix z
	 have S21: "( y \<in> \<real> \<and> z \<in> \<real> ) \<longrightarrow> ( y \<ls> z \<longleftrightarrow> y \<lsr> z )" by (rule MMI_ltxrltt)
	 from S21 have S22: "( z \<in> \<real> \<and> y \<in> \<real> ) \<longrightarrow> ( y \<ls> z \<longleftrightarrow> y \<lsr> z )" 
	   by (rule MMI_ancoms);
	 have S23: "( ( A \<subseteq> \<real> \<and> z \<in> A ) \<longrightarrow> z \<in> \<real> )" by (rule MMI_ssel2)
	 from S22 S23 have S24: "( ( ( A \<subseteq> \<real> \<and> z \<in> A ) \<and> y \<in> \<real> ) \<longrightarrow>   
	   ( y \<ls> z \<longleftrightarrow> y \<lsr> z ) )" by (rule MMI_sylan)
	 from S24 have S25: "( ( ( A \<subseteq> \<real> \<and> y \<in> \<real> ) \<and> z \<in> A ) \<longrightarrow>   
	   ( y \<ls> z \<longleftrightarrow> y \<lsr> z ) )" by (rule MMI_an1rs)
       } then have S25: "\<forall>z. ( ( ( A \<subseteq> \<real> \<and> y \<in> \<real> ) \<and> z \<in> A ) \<longrightarrow>   
	   ( y \<ls> z \<longleftrightarrow> y \<lsr> z ) )" by simp;
	 from S25 have S26: "( ( A \<subseteq> \<real> \<and> y \<in> \<real> ) \<longrightarrow>   
	 ( ( \<exists> z \<in> A . y \<ls> z ) \<longleftrightarrow>   
	 ( \<exists> z \<in> A . y \<lsr> z ) ) )" by (rule MMI_rexbidva);
	 from S26 have S27: "( ( ( A \<subseteq> \<real> \<and> x \<in> \<real> ) \<and> y \<in> \<real> ) \<longrightarrow>   
	   ( ( \<exists> z \<in> A . y \<ls> z ) \<longleftrightarrow>   
	   ( \<exists> z \<in> A . y \<lsr> z ) ) )" by (rule MMI_adantlr)
	 from S20 S27 have  "( ( ( A \<subseteq> \<real> \<and> x \<in> \<real> ) \<and> y \<in> \<real> ) \<longrightarrow>   
	   ( ( y \<ls> x \<longrightarrow> ( \<exists> z \<in> A . y \<ls> z ) ) \<longleftrightarrow>   
	   ( y \<lsr> x \<longrightarrow> ( \<exists> z \<in> A . y \<lsr> z ) ) ) )" by (rule MMI_imbi12d)
       } then have S28: "\<forall> y. ( ( ( A \<subseteq> \<real> \<and> x \<in> \<real> ) \<and> y \<in> \<real> ) \<longrightarrow>   
	   ( ( y \<ls> x \<longrightarrow> ( \<exists> z \<in> A . y \<ls> z ) ) \<longleftrightarrow>   
	   ( y \<lsr> x \<longrightarrow> ( \<exists> z \<in> A . y \<lsr> z ) ) ) )" by simp;
       from S28 have S29: "( ( A \<subseteq> \<real> \<and> x \<in> \<real> ) \<longrightarrow>   
     ( ( \<forall> y \<in> \<real> . ( y \<ls> x \<longrightarrow> ( \<exists> z \<in> A . y \<ls> z ) ) ) \<longleftrightarrow>   
	 ( \<forall> y \<in> \<real> . ( y \<lsr> x \<longrightarrow> ( \<exists> z \<in> A . y \<lsr> z ) ) ) ) )" 
	 by (rule MMI_ralbidva);
       from S17 S29 have  "( ( A \<subseteq> \<real> \<and> x \<in> \<real> ) \<longrightarrow>   
	 ( ( ( \<forall> y \<in> A . \<not> ( x \<ls> y ) ) \<and> 
	 ( \<forall> y \<in> \<real> . ( y \<ls> x \<longrightarrow> ( \<exists> z \<in> A . y \<ls> z ) ) ) ) \<longleftrightarrow>   
	 ( ( \<forall> y \<in> A . \<not> ( x \<lsr> y ) ) \<and> 
	 ( \<forall> y \<in> \<real> . ( y \<lsr> x \<longrightarrow> ( \<exists> z \<in> A . y \<lsr> z ) ) ) ) ) )" 
	 by (rule MMI_anbi12d)
     } then have S30: "\<forall> x. ( ( A \<subseteq> \<real> \<and> x \<in> \<real> ) \<longrightarrow>   
	 ( ( ( \<forall> y \<in> A . \<not> ( x \<ls> y ) ) \<and> 
	 ( \<forall> y \<in> \<real> . ( y \<ls> x \<longrightarrow> ( \<exists> z \<in> A . y \<ls> z ) ) ) ) \<longleftrightarrow>   
	 ( ( \<forall> y \<in> A . \<not> ( x \<lsr> y ) ) \<and> 
	 ( \<forall> y \<in> \<real> . ( y \<lsr> x \<longrightarrow> ( \<exists> z \<in> A . y \<lsr> z ) ) ) ) ) )" 
       by simp;
     from S30 have S31: "( A \<subseteq> \<real> \<longrightarrow>   
       ( ( \<exists> x \<in> \<real> . ( ( \<forall> y \<in> A . \<not> ( x \<ls> y ) ) \<and> 
       ( \<forall> y \<in> \<real> . ( y \<ls> x \<longrightarrow> ( \<exists> z \<in> A . y \<ls> z ) ) ) ) ) \<longleftrightarrow>   
       ( \<exists> x \<in> \<real> . ( ( \<forall> y \<in> A . \<not> ( x \<lsr> y ) ) \<and> 
       ( \<forall> y \<in> \<real> . ( y \<lsr> x \<longrightarrow> ( \<exists> z \<in> A . y \<lsr> z ) ) ) ) ) ) )" 
       by (rule MMI_rexbidva);
     from S31 have S32: "( ( A \<subseteq> \<real> \<and> A \<noteq> 0 ) \<longrightarrow>   
	 ( ( \<exists> x \<in> \<real> . ( ( \<forall> y \<in> A . \<not> ( x \<ls> y ) ) \<and> 
       ( \<forall> y \<in> \<real> . ( y \<ls> x \<longrightarrow> ( \<exists> z \<in> A . y \<ls> z ) ) ) ) ) \<longleftrightarrow>   
	 ( \<exists> x \<in> \<real> . ( ( \<forall> y \<in> A . \<not> ( x \<lsr> y ) ) \<and> 
       ( \<forall> y \<in> \<real> . ( y \<lsr> x \<longrightarrow> ( \<exists> z \<in> A . y \<lsr> z ) ) ) ) ) ) )" 
       by (rule MMI_adantr)
       from S3 S10 S32 have S33: "( ( A \<subseteq> \<real> \<and> A \<noteq> 0 ) \<longrightarrow>   
	 ( ( \<exists> x \<in> \<real> . \<forall> y \<in> A . y \<ls> x ) \<longrightarrow>   
	 ( \<exists> x \<in> \<real> . ( ( \<forall> y \<in> A . \<not> ( x \<ls> y ) ) \<and> 
	 ( \<forall> y \<in> \<real> . ( y \<ls> x \<longrightarrow> ( \<exists> z \<in> A . y \<ls> z ) ) ) ) ) ) )" 
	 by (rule MMI_3imtr4d)
       from S33 show 
	 "( ( A \<subseteq> \<real> \<and> A \<noteq> 0 \<and> ( \<exists> x \<in> \<real> . \<forall> y \<in> A . y \<ls> x ) ) \<longrightarrow>   
	 ( \<exists> x \<in> \<real> . ( ( \<forall> y \<in> A . \<not> ( x \<ls> y ) ) \<and> 
	 ( \<forall> y \<in> \<real> . ( y \<ls> x \<longrightarrow> ( \<exists> z \<in> A . y \<ls> z ) ) ) ) ) )" 
	 by (rule MMI_3impia)
qed;

lemma (in MMIsar0) MMI_lenltt: 
   shows "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A \<lsq> B \<longleftrightarrow> \<not> ( B \<ls> A ) )"
proof -
   have S1: "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( A \<lsq> B \<longleftrightarrow> \<not> ( B \<ls> A ) )" by (rule MMI_xrlenltt)
   have S2: "A \<in> \<real> \<longrightarrow> A \<in> \<real>\<^isup>*" by (rule MMI_rexrt)
   have S3: "B \<in> \<real> \<longrightarrow> B \<in> \<real>\<^isup>*" by (rule MMI_rexrt)
   from S1 S2 S3 show "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A \<lsq> B \<longleftrightarrow> \<not> ( B \<ls> A ) )" by (rule MMI_syl2an)
qed

lemma (in MMIsar0) MMI_ltnlet: 
   shows "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A \<ls> B \<longleftrightarrow> \<not> ( B \<lsq> A ) )"
proof -
   have S1: "( B \<in> \<real> \<and> A \<in> \<real> ) \<longrightarrow>   
 ( B \<lsq> A \<longleftrightarrow> \<not> ( A \<ls> B ) )" by (rule MMI_lenltt)
   from S1 have S2: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( B \<lsq> A \<longleftrightarrow> \<not> ( A \<ls> B ) )" by (rule MMI_ancoms)
   from S2 show "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A \<ls> B \<longleftrightarrow> \<not> ( B \<lsq> A ) )" by (rule MMI_con2bid)
qed;

(**********236*********************)

lemma (in MMIsar0) MMI_ltso: 
   shows "\<cltrrset> Orders \<real>"
proof -
  { fix x y z
    have S1: "( x \<in> \<real> \<and> y \<in> \<real> ) \<longrightarrow>   
      ( x \<ls> y \<longleftrightarrow> \<not> ( ( x = y \<or> y \<ls> x ) ) )" by (rule MMI_axlttri)
    from S1 have S2: "( x \<in> \<real> \<and> y \<in> \<real> \<and> z \<in> \<real> ) \<longrightarrow>   
      ( x \<ls> y \<longleftrightarrow> \<not> ( ( x = y \<or> y \<ls> x ) ) )" by (rule MMI_3adant3)
    have S3: "( x \<in> \<real> \<and> y \<in> \<real> \<and> z \<in> \<real> ) \<longrightarrow>   
      ( ( x \<ls> y \<and> y \<ls> z ) \<longrightarrow> x \<ls> z )" by (rule MMI_axlttrn)
    from S2 S3 have "( x \<in> \<real> \<and> y \<in> \<real> \<and> z \<in> \<real> ) \<longrightarrow>   
      ( ( x \<ls> y \<longleftrightarrow> \<not> ( ( x = y \<or> y \<ls> x ) ) ) \<and> 
      ( ( x \<ls> y \<and> y \<ls> z ) \<longrightarrow> x \<ls> z ) )" by (rule MMI_jca)
    then have 
      "( x \<in> \<real> \<and> y \<in> \<real> \<and> z \<in> \<real> ) \<longrightarrow>   
      ( ( \<langle>x, y\<rangle> \<in> \<cltrrset> \<longleftrightarrow> \<not> ( ( x = y \<or> \<langle>y,x\<rangle> \<in> \<cltrrset> ) ) ) \<and> 
      ( ( \<langle>x,y\<rangle> \<in> \<cltrrset> \<and> \<langle>y,z\<rangle> \<in> \<cltrrset> ) \<longrightarrow> \<langle>x, z\<rangle> \<in> \<cltrrset> ) )"
      using cltrr_def by simp;
  } then have S4: "\<forall>x y z. ( x \<in> \<real> \<and> y \<in> \<real> \<and> z \<in> \<real> ) \<longrightarrow>   
      ( ( \<langle>x, y\<rangle> \<in> \<cltrrset> \<longleftrightarrow> \<not> ( ( x = y \<or> \<langle>y,x\<rangle> \<in> \<cltrrset> ) ) ) \<and> 
      ( ( \<langle>x,y\<rangle> \<in> \<cltrrset> \<and> \<langle>y,z\<rangle> \<in> \<cltrrset> ) \<longrightarrow> \<langle>x, z\<rangle> \<in> \<cltrrset> ) )"
    by auto;
  from S4 show "\<cltrrset> Orders \<real>" by (rule MMI_so)
qed;

(*********237-240************************)

lemma (in MMIsar0) MMI_lttri2t: 
   shows "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( \<not> ( A = B ) \<longleftrightarrow> ( A \<ls> B \<or> B \<ls> A ) )"
proof -
   have S1: "\<cltrrset> Orders \<real>" by (rule MMI_ltso)
   have "( \<cltrrset> Orders \<real> \<and> ( A \<in> \<real> \<and> B \<in> \<real> ) ) \<longrightarrow>   
     ( A = B \<longleftrightarrow> \<not> ( ( \<langle>A, B\<rangle> \<in> \<cltrrset> \<or> \<langle>B,A \<rangle> \<in> \<cltrrset>) ) )"
     by (rule MMI_sotrieq);
   then have S2: "( \<cltrrset> Orders \<real> \<and> ( A \<in> \<real> \<and> B \<in> \<real> ) ) \<longrightarrow>   
     ( A = B \<longleftrightarrow> \<not> ( ( A \<ls> B \<or> B \<ls> A ) ) )" using cltrr_def
     by simp;
   from S1 S2 have S3: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
     ( A = B \<longleftrightarrow> \<not> ( ( A \<ls> B \<or> B \<ls> A ) ) )" by (rule MMI_mpan)
   from S3 have S4: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
     ( \<not> ( ( A \<ls> B \<or> B \<ls> A ) ) \<longleftrightarrow> A = B )" by (rule MMI_bicomd)
   from S4 show "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
     ( \<not> ( A = B ) \<longleftrightarrow> ( A \<ls> B \<or> B \<ls> A ) )" by (rule MMI_con1bid)
qed;

lemma (in MMIsar0) MMI_lttri3t: 
   shows "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A =   
 B \<longleftrightarrow> ( \<not> ( A \<ls> B ) \<and> \<not> ( B \<ls> A ) ) )"
proof -
  have S1: "\<cltrrset> Orders \<real>" by (rule MMI_ltso)
  have "( \<cltrrset> Orders \<real> \<and> ( A \<in> \<real> \<and> B \<in> \<real> ) ) \<longrightarrow>   
    ( A = B \<longleftrightarrow> ( \<not> ( \<langle>A, B\<rangle> \<in> \<cltrrset> ) \<and> \<not> ( \<langle>B,A\<rangle> \<in> \<cltrrset> ) ) )" 
    by (rule MMI_sotrieq2)
  then have S2: "( \<cltrrset> Orders \<real> \<and> ( A \<in> \<real> \<and> B \<in> \<real> ) ) \<longrightarrow>   
    ( A = B \<longleftrightarrow> ( \<not> ( A \<ls> B ) \<and> \<not> ( B \<ls> A ) ) )"  using cltrr_def
    by simp;
  from S1 S2 show "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
    ( A = B \<longleftrightarrow> ( \<not> ( A \<ls> B ) \<and> \<not> ( B \<ls> A ) ) )" by (rule MMI_mpan)
qed;

lemma (in MMIsar0) MMI_ltnet: 
   shows "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A \<ls> B \<longrightarrow> \<not> ( A = B ) )"
proof -
   have S1: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( \<not> ( A = B ) \<longleftrightarrow> ( A \<ls> B \<or> B \<ls> A ) )" by (rule MMI_lttri2t)
   have S2: "A \<ls> B \<longrightarrow> ( A \<ls> B \<or> B \<ls> A )" by (rule MMI_orc)
   from S1 S2 show "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A \<ls> B \<longrightarrow> \<not> ( A = B ) )" by (rule MMI_syl5bir)
qed

lemma (in MMIsar0) MMI_letri3t: 
   shows "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A = B \<longleftrightarrow> ( A \<lsq> B \<and> B \<lsq> A ) )"
proof -
   have S1: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A =   
 B \<longleftrightarrow> ( \<not> ( A \<ls> B ) \<and> \<not> ( B \<ls> A ) ) )" by (rule MMI_lttri3t)
   have S2: "( \<not> ( B \<ls> A ) \<and> \<not> ( A \<ls> B ) ) \<longleftrightarrow>   
 ( \<not> ( A \<ls> B ) \<and> \<not> ( B \<ls> A ) )" by (rule MMI_ancom)
   from S1 S2 have S3: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A =   
 B \<longleftrightarrow> ( \<not> ( B \<ls> A ) \<and> \<not> ( A \<ls> B ) ) )" by (rule MMI_syl6bbr)
   have S4: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A \<lsq> B \<longleftrightarrow> \<not> ( B \<ls> A ) )" by (rule MMI_lenltt)
   have S5: "( B \<in> \<real> \<and> A \<in> \<real> ) \<longrightarrow>   
 ( B \<lsq> A \<longleftrightarrow> \<not> ( A \<ls> B ) )" by (rule MMI_lenltt)
   from S5 have S6: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( B \<lsq> A \<longleftrightarrow> \<not> ( A \<ls> B ) )" by (rule MMI_ancoms)
   from S4 S6 have S7: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( ( A \<lsq> B \<and> B \<lsq> A ) \<longleftrightarrow>   
 ( \<not> ( B \<ls> A ) \<and> \<not> ( A \<ls> B ) ) )" by (rule MMI_anbi12d)
   from S3 S7 show "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A = B \<longleftrightarrow> ( A \<lsq> B \<and> B \<lsq> A ) )" by (rule MMI_bitr4d)
qed;

(************** 240-250********************************)

lemma (in MMIsar0) MMI_leloet: 
   shows "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A \<lsq> B \<longleftrightarrow> ( A \<ls> B \<or> A = B ) )"
proof -
   have S1: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A \<lsq> B \<longleftrightarrow> \<not> ( B \<ls> A ) )" by (rule MMI_lenltt)
   have S2: "( B \<in> \<real> \<and> A \<in> \<real> ) \<longrightarrow>   
 ( B \<ls> A \<longleftrightarrow> \<not> ( ( B = A \<or> A \<ls> B ) ) )" by (rule MMI_axlttri)
   from S2 have S3: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( B \<ls> A \<longleftrightarrow> \<not> ( ( B = A \<or> A \<ls> B ) ) )" by (rule MMI_ancoms)
   from S3 have S4: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( ( B = A \<or> A \<ls> B ) \<longleftrightarrow> \<not> ( B \<ls> A ) )" by (rule MMI_con2bid)
   have S5: "B = A \<longleftrightarrow> A = B" by (rule MMI_eqcom)
   from S5 have S6: "( B = A \<or> A \<ls> B ) \<longleftrightarrow> ( A = B \<or> A \<ls> B )" by (rule MMI_orbi1i)
   have S7: "( A = B \<or> A \<ls> B ) \<longleftrightarrow> ( A \<ls> B \<or> A = B )" by (rule MMI_orcom)
   from S6 S7 have S8: "( B = A \<or> A \<ls> B ) \<longleftrightarrow> ( A \<ls> B \<or> A = B )" by (rule MMI_bitr)
   from S4 S8 have S9: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( \<not> ( B \<ls> A ) \<longleftrightarrow> ( A \<ls> B \<or> A = B ) )" by (rule MMI_syl5rbbr)
   from S1 S9 show "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A \<lsq> B \<longleftrightarrow> ( A \<ls> B \<or> A = B ) )" by (rule MMI_bitrd)
qed

lemma (in MMIsar0) MMI_eqleltt: 
   shows "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A = B \<longleftrightarrow> ( A \<lsq> B \<and> \<not> ( A \<ls> B ) ) )"
proof -
   have S1: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A = B \<longleftrightarrow> ( A \<lsq> B \<and> B \<lsq> A ) )" by (rule MMI_letri3t)
   have S2: "( B \<in> \<real> \<and> A \<in> \<real> ) \<longrightarrow>   
 ( B \<lsq> A \<longleftrightarrow> \<not> ( A \<ls> B ) )" by (rule MMI_lenltt)
   from S2 have S3: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( B \<lsq> A \<longleftrightarrow> \<not> ( A \<ls> B ) )" by (rule MMI_ancoms)
   from S3 have S4: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( ( A \<lsq> B \<and> B \<lsq> A ) \<longleftrightarrow>   
 ( A \<lsq> B \<and> \<not> ( A \<ls> B ) ) )" by (rule MMI_anbi2d)
   from S1 S4 show "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A = B \<longleftrightarrow> ( A \<lsq> B \<and> \<not> ( A \<ls> B ) ) )" by (rule MMI_bitrd)
qed

lemma (in MMIsar0) MMI_ltlet: 
   shows "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow> ( A \<ls> B \<longrightarrow> A \<lsq> B )"
proof -
   have S1: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A \<lsq> B \<longleftrightarrow> ( A \<ls> B \<or> A = B ) )" by (rule MMI_leloet)
   have S2: "A \<ls> B \<longrightarrow> ( A \<ls> B \<or> A = B )" by (rule MMI_orc)
   from S1 S2 show "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow> ( A \<ls> B \<longrightarrow> A \<lsq> B )" by (rule MMI_syl5bir)
qed

lemma (in MMIsar0) MMI_leltnet: 
   shows "( A \<in> \<real> \<and> B \<in> \<real> \<and> A \<lsq> B ) \<longrightarrow>   
 ( A \<ls> B \<longleftrightarrow> \<not> ( A = B ) )"
proof -
   have S1: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A =   
 B \<longleftrightarrow> ( \<not> ( A \<ls> B ) \<and> \<not> ( B \<ls> A ) ) )" by (rule MMI_lttri3t)
   have S2: "( \<not> ( A \<ls> B ) \<and> \<not> ( B \<ls> A ) ) \<longrightarrow>   
 \<not> ( A \<ls> B )" by (rule MMI_pm3_26)
   from S1 S2 have S3: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A = B \<longrightarrow> \<not> ( A \<ls> B ) )" by (rule MMI_syl6bi)
   from S3 have S4: "( ( A \<in> \<real> \<and> B \<in> \<real> ) \<and> A \<lsq> B ) \<longrightarrow>   
 ( A = B \<longrightarrow> \<not> ( A \<ls> B ) )" by (rule MMI_adantr)
   have S5: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A \<lsq> B \<longleftrightarrow> ( A \<ls> B \<or> A = B ) )" by (rule MMI_leloet)
   from S5 have S6: "( ( A \<in> \<real> \<and> B \<in> \<real> ) \<and> A \<lsq> B ) \<longrightarrow>   
 ( A \<ls> B \<or> A = B )" by (rule MMI_biimpa)
   from S6 have S7: "( ( A \<in> \<real> \<and> B \<in> \<real> ) \<and> A \<lsq> B ) \<longrightarrow>   
 ( \<not> ( A \<ls> B ) \<longrightarrow> A = B )" by (rule MMI_ord)
   from S4 S7 have S8: "( ( A \<in> \<real> \<and> B \<in> \<real> ) \<and> A \<lsq> B ) \<longrightarrow>   
 ( A = B \<longleftrightarrow> \<not> ( A \<ls> B ) )" by (rule MMI_impbid)
   from S8 have S9: "( ( A \<in> \<real> \<and> B \<in> \<real> ) \<and> A \<lsq> B ) \<longrightarrow>   
 ( A \<ls> B \<longleftrightarrow> \<not> ( A = B ) )" by (rule MMI_con2bid)
   from S9 show "( A \<in> \<real> \<and> B \<in> \<real> \<and> A \<lsq> B ) \<longrightarrow>   
 ( A \<ls> B \<longleftrightarrow> \<not> ( A = B ) )" by (rule MMI_3impa)
qed

lemma (in MMIsar0) MMI_ltlent: 
   shows "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A \<ls> B \<longleftrightarrow> ( A \<lsq> B \<and> \<not> ( A = B ) ) )"
proof -
   have S1: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow> ( A \<ls> B \<longrightarrow> A \<lsq> B )" by (rule MMI_ltlet)
   have S2: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A \<ls> B \<longrightarrow> \<not> ( A = B ) )" by (rule MMI_ltnet)
   from S1 S2 have S3: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A \<ls> B \<longrightarrow> ( A \<lsq> B \<and> \<not> ( A = B ) ) )" by (rule MMI_jcad)
   have S4: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A \<lsq> B \<longleftrightarrow> ( A \<ls> B \<or> A = B ) )" by (rule MMI_leloet)
   have S5: "A \<ls> B \<longrightarrow> ( \<not> ( A = B ) \<longrightarrow> A \<ls> B )" by (rule MMI_ax_1)
   have S6: "A = B \<longrightarrow> ( \<not> ( A = B ) \<longrightarrow> A \<ls> B )" by (rule MMI_pm2_24)
   from S5 S6 have S7: "( A \<ls> B \<or> A =   
 B ) \<longrightarrow> ( \<not> ( A = B ) \<longrightarrow> A \<ls> B )" by (rule MMI_jaoi)
   from S4 S7 have S8: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A \<lsq> B \<longrightarrow> ( \<not> ( A = B ) \<longrightarrow> A \<ls> B ) )" by (rule MMI_syl6bi)
   from S8 have S9: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( ( A \<lsq> B \<and> \<not> ( A = B ) ) \<longrightarrow> A \<ls> B )" by (rule MMI_imp3a)
   from S3 S9 show "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A \<ls> B \<longleftrightarrow> ( A \<lsq> B \<and> \<not> ( A = B ) ) )" by (rule MMI_impbid)
qed

lemma (in MMIsar0) MMI_lelttrt: 
   shows "( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( ( A \<lsq> B \<and> B \<ls> C ) \<longrightarrow> A \<ls> C )"
proof -
   have S1: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A \<lsq> B \<longleftrightarrow> ( A \<ls> B \<or> A = B ) )" by (rule MMI_leloet)
   from S1 have S2: "( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( A \<lsq> B \<longleftrightarrow> ( A \<ls> B \<or> A = B ) )" by (rule MMI_3adant3)
   have S3: "( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( ( A \<ls> B \<and> B \<ls> C ) \<longrightarrow> A \<ls> C )" by (rule MMI_axlttrn)
   from S3 have S4: "( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( A \<ls> B \<longrightarrow> ( B \<ls> C \<longrightarrow> A \<ls> C ) )" by (rule MMI_exp3a)
   have S5: "A = B \<longrightarrow> ( A \<ls> C \<longleftrightarrow> B \<ls> C )" by (rule MMI_breq1)
   from S5 have S6: "A = B \<longrightarrow> ( B \<ls> C \<longrightarrow> A \<ls> C )" by (rule MMI_biimprd)
   from S6 have S7: "( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( A = B \<longrightarrow> ( B \<ls> C \<longrightarrow> A \<ls> C ) )" by (rule MMI_a1i)
   from S4 S7 have S8: "( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( ( A \<ls> B \<or> A = B ) \<longrightarrow>   
 ( B \<ls> C \<longrightarrow> A \<ls> C ) )" by (rule MMI_jaod)
   from S2 S8 have S9: "( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( A \<lsq> B \<longrightarrow> ( B \<ls> C \<longrightarrow> A \<ls> C ) )" by (rule MMI_sylbid)
   from S9 show "( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( ( A \<lsq> B \<and> B \<ls> C ) \<longrightarrow> A \<ls> C )" by (rule MMI_imp3a)
qed

lemma (in MMIsar0) MMI_ltletrt: 
   shows "( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( ( A \<ls> B \<and> B \<lsq> C ) \<longrightarrow> A \<ls> C )"
proof -
   have S1: "( B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( B \<lsq> C \<longleftrightarrow> ( B \<ls> C \<or> B = C ) )" by (rule MMI_leloet)
   from S1 have S2: "( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( B \<lsq> C \<longleftrightarrow> ( B \<ls> C \<or> B = C ) )" by (rule MMI_3adant1)
   have S3: "( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( ( A \<ls> B \<and> B \<ls> C ) \<longrightarrow> A \<ls> C )" by (rule MMI_axlttrn)
   from S3 have S4: "( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( A \<ls> B \<longrightarrow> ( B \<ls> C \<longrightarrow> A \<ls> C ) )" by (rule MMI_exp3a)
   from S4 have S5: "( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( B \<ls> C \<longrightarrow> ( A \<ls> B \<longrightarrow> A \<ls> C ) )" by (rule MMI_com23)
   have S6: "B = C \<longrightarrow> ( A \<ls> B \<longleftrightarrow> A \<ls> C )" by (rule MMI_breq2)
   from S6 have S7: "B = C \<longrightarrow> ( A \<ls> B \<longrightarrow> A \<ls> C )" by (rule MMI_biimpd)
   from S7 have S8: "( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( B = C \<longrightarrow> ( A \<ls> B \<longrightarrow> A \<ls> C ) )" by (rule MMI_a1i)
   from S5 S8 have S9: "( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( ( B \<ls> C \<or> B = C ) \<longrightarrow>   
 ( A \<ls> B \<longrightarrow> A \<ls> C ) )" by (rule MMI_jaod)
   from S2 S9 have S10: "( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( B \<lsq> C \<longrightarrow> ( A \<ls> B \<longrightarrow> A \<ls> C ) )" by (rule MMI_sylbid)
   from S10 have S11: "( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( A \<ls> B \<longrightarrow> ( B \<lsq> C \<longrightarrow> A \<ls> C ) )" by (rule MMI_com23)
   from S11 show "( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( ( A \<ls> B \<and> B \<lsq> C ) \<longrightarrow> A \<ls> C )" by (rule MMI_imp3a)
qed

lemma (in MMIsar0) MMI_letrt: 
   shows "( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( ( A \<lsq> B \<and> B \<lsq> C ) \<longrightarrow> A \<lsq> C )"
proof -
   have S1: "( B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( B \<lsq> C \<longleftrightarrow> ( B \<ls> C \<or> B = C ) )" by (rule MMI_leloet)
   from S1 have S2: "( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( B \<lsq> C \<longleftrightarrow> ( B \<ls> C \<or> B = C ) )" by (rule MMI_3adant1)
   from S2 have S3: "( ( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<and> A \<lsq> B ) \<longrightarrow>   
 ( B \<lsq> C \<longleftrightarrow> ( B \<ls> C \<or> B = C ) )" by (rule MMI_adantr)
   have S4: "( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( ( A \<lsq> B \<and> B \<ls> C ) \<longrightarrow> A \<ls> C )" by (rule MMI_lelttrt)
   have S5: "( A \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow> ( A \<ls> C \<longrightarrow> A \<lsq> C )" by (rule MMI_ltlet)
   from S5 have S6: "( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( A \<ls> C \<longrightarrow> A \<lsq> C )" by (rule MMI_3adant2)
   from S4 S6 have S7: "( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( ( A \<lsq> B \<and> B \<ls> C ) \<longrightarrow> A \<lsq> C )" by (rule MMI_syld)
   from S7 have S8: "( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( A \<lsq> B \<longrightarrow> ( B \<ls> C \<longrightarrow> A \<lsq> C ) )" by (rule MMI_exp3a)
   from S8 have S9: "( ( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<and> A \<lsq> B ) \<longrightarrow>   
 ( B \<ls> C \<longrightarrow> A \<lsq> C )" by (rule MMI_imp)
   have S10: "B = C \<longrightarrow> ( A \<lsq> B \<longleftrightarrow> A \<lsq> C )" by (rule MMI_breq2)
   from S10 have S11: "A \<lsq> B \<longrightarrow> ( B = C \<longrightarrow> A \<lsq> C )" by (rule MMI_biimpcd)
   from S11 have S12: "( ( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<and> A \<lsq> B ) \<longrightarrow>   
 ( B = C \<longrightarrow> A \<lsq> C )" by (rule MMI_adantl)
   from S9 S12 have S13: "( ( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<and> A \<lsq> B ) \<longrightarrow>   
 ( ( B \<ls> C \<or> B = C ) \<longrightarrow> A \<lsq> C )" by (rule MMI_jaod)
   from S3 S13 have S14: "( ( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<and> A \<lsq> B ) \<longrightarrow>   
 ( B \<lsq> C \<longrightarrow> A \<lsq> C )" by (rule MMI_sylbid)
   from S14 have S15: "( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( A \<lsq> B \<longrightarrow> ( B \<lsq> C \<longrightarrow> A \<lsq> C ) )" by (rule MMI_ex)
   from S15 show "( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( ( A \<lsq> B \<and> B \<lsq> C ) \<longrightarrow> A \<lsq> C )" by (rule MMI_imp3a)
qed

lemma (in MMIsar0) MMI_letrd: assumes A1: "\<phi> \<longrightarrow> A \<in> \<real>" and
    A2: "\<phi> \<longrightarrow> B \<in> \<real>" and
    A3: "\<phi> \<longrightarrow> C \<in> \<real>" and
    A4: "\<phi> \<longrightarrow> A \<lsq> B" and
    A5: "\<phi> \<longrightarrow> B \<lsq> C"   
   shows "\<phi> \<longrightarrow> A \<lsq> C"
proof -
   from A4 have S1: "\<phi> \<longrightarrow> A \<lsq> B".
   from A5 have S2: "\<phi> \<longrightarrow> B \<lsq> C".
   have S3: "( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( ( A \<lsq> B \<and> B \<lsq> C ) \<longrightarrow> A \<lsq> C )" by (rule MMI_letrt)
   from A1 have S4: "\<phi> \<longrightarrow> A \<in> \<real>".
   from A2 have S5: "\<phi> \<longrightarrow> B \<in> \<real>".
   from A3 have S6: "\<phi> \<longrightarrow> C \<in> \<real>".
   from S3 S4 S5 S6 have S7: "\<phi> \<longrightarrow> ( ( A \<lsq> B \<and> B \<lsq> C ) \<longrightarrow> A \<lsq> C )" 
     by (rule MMI_syl3anc)
   from S1 S2 S7 show "\<phi> \<longrightarrow> A \<lsq> C" by (rule MMI_mp2and)
qed

lemma (in MMIsar0) MMI_lelttrd: assumes A1: "\<phi> \<longrightarrow> A \<in> \<real>" and
    A2: "\<phi> \<longrightarrow> B \<in> \<real>" and
    A3: "\<phi> \<longrightarrow> C \<in> \<real>" and
    A4: "\<phi> \<longrightarrow> A \<lsq> B" and
    A5: "\<phi> \<longrightarrow> B \<ls> C"   
   shows "\<phi> \<longrightarrow> A \<ls> C"
proof -
   from A4 have S1: "\<phi> \<longrightarrow> A \<lsq> B".
   from A5 have S2: "\<phi> \<longrightarrow> B \<ls> C".
   have S3: "( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( ( A \<lsq> B \<and> B \<ls> C ) \<longrightarrow> A \<ls> C )" by (rule MMI_lelttrt)
   from A1 have S4: "\<phi> \<longrightarrow> A \<in> \<real>".
   from A2 have S5: "\<phi> \<longrightarrow> B \<in> \<real>".
   from A3 have S6: "\<phi> \<longrightarrow> C \<in> \<real>".
   from S3 S4 S5 S6 have S7: "\<phi> \<longrightarrow> ( ( A \<lsq> B \<and> B \<ls> C ) \<longrightarrow> A \<ls> C )" 
     by (rule MMI_syl3anc)
   from S1 S2 S7 show "\<phi> \<longrightarrow> A \<ls> C" by (rule MMI_mp2and)
qed;

(***************251-260********************************)


lemma (in MMIsar0) MMI_ltletrd: assumes A1: "\<phi> \<longrightarrow> A \<in> \<real>" and
    A2: "\<phi> \<longrightarrow> B \<in> \<real>" and
    A3: "\<phi> \<longrightarrow> C \<in> \<real>" and
    A4: "\<phi> \<longrightarrow> A \<ls> B" and
    A5: "\<phi> \<longrightarrow> B \<lsq> C"   
   shows "\<phi> \<longrightarrow> A \<ls> C"
proof -
   from A4 have S1: "\<phi> \<longrightarrow> A \<ls> B".
   from A5 have S2: "\<phi> \<longrightarrow> B \<lsq> C".
   have S3: "( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( ( A \<ls> B \<and> B \<lsq> C ) \<longrightarrow> A \<ls> C )" by (rule MMI_ltletrt)
   from A1 have S4: "\<phi> \<longrightarrow> A \<in> \<real>".
   from A2 have S5: "\<phi> \<longrightarrow> B \<in> \<real>".
   from A3 have S6: "\<phi> \<longrightarrow> C \<in> \<real>".
   from S3 S4 S5 S6 have S7: "\<phi> \<longrightarrow> ( ( A \<ls> B \<and> B \<lsq> C ) \<longrightarrow> A \<ls> C )" by (rule MMI_syl3anc)
   from S1 S2 S7 show "\<phi> \<longrightarrow> A \<ls> C" by (rule MMI_mp2and)
qed

lemma (in MMIsar0) MMI_lttrd: assumes A1: "\<phi> \<longrightarrow> A \<in> \<real>" and
    A2: "\<phi> \<longrightarrow> B \<in> \<real>" and
    A3: "\<phi> \<longrightarrow> C \<in> \<real>" and
    A4: "\<phi> \<longrightarrow> A \<ls> B" and
    A5: "\<phi> \<longrightarrow> B \<ls> C"   
   shows "\<phi> \<longrightarrow> A \<ls> C"
proof -
   from A4 have S1: "\<phi> \<longrightarrow> A \<ls> B".
   from A5 have S2: "\<phi> \<longrightarrow> B \<ls> C".
   have S3: "( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( ( A \<ls> B \<and> B \<ls> C ) \<longrightarrow> A \<ls> C )" by (rule MMI_axlttrn)
   from A1 have S4: "\<phi> \<longrightarrow> A \<in> \<real>".
   from A2 have S5: "\<phi> \<longrightarrow> B \<in> \<real>".
   from A3 have S6: "\<phi> \<longrightarrow> C \<in> \<real>".
   from S3 S4 S5 S6 have S7: "\<phi> \<longrightarrow> ( ( A \<ls> B \<and> B \<ls> C ) \<longrightarrow> A \<ls> C )" by (rule MMI_syl3anc)
   from S1 S2 S7 show "\<phi> \<longrightarrow> A \<ls> C" by (rule MMI_mp2and)
qed

lemma (in MMIsar0) MMI_ltnrt: 
   shows "A \<in> \<real> \<longrightarrow> \<not> ( A \<ls> A )"
proof -
   have S1: "\<cltrrset> Orders \<real>" by (rule MMI_ltso)
   have "( \<cltrrset> Orders \<real> \<and> A \<in> \<real> ) \<longrightarrow> \<not> ( \<langle>A,A\<rangle> \<in> \<cltrrset> )" 
     by (rule MMI_sonr)
   then have S2: "( \<cltrrset> Orders \<real> \<and> A \<in> \<real> ) \<longrightarrow> \<not> ( A \<ls> A )" 
     using cltrr_def by simp;
   from S1 S2 show "A \<in> \<real> \<longrightarrow> \<not> ( A \<ls> A )" by (rule MMI_mpan)
qed;

lemma (in MMIsar0) MMI_leidt: 
   shows "A \<in> \<real> \<longrightarrow> A \<lsq> A"
proof -
   have S1: "A = A" by (rule MMI_eqid)
   from S1 have S2: "\<not> ( A \<ls> A ) \<longrightarrow> A = A" by (rule MMI_a1i)
   from S2 have S3: "A \<ls> A \<or> A = A" by (rule MMI_orri)
   have S4: "( A \<in> \<real> \<and> A \<in> \<real> ) \<longrightarrow>   
 ( A \<lsq> A \<longleftrightarrow> ( A \<ls> A \<or> A = A ) )" by (rule MMI_leloet)
   from S3 S4 have S5: "( A \<in> \<real> \<and> A \<in> \<real> ) \<longrightarrow> A \<lsq> A" by (rule MMI_mpbiri)
   from S5 show "A \<in> \<real> \<longrightarrow> A \<lsq> A" by (rule MMI_anidms)
qed

lemma (in MMIsar0) MMI_ltnsymt: 
   shows "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A \<ls> B \<longrightarrow> \<not> ( B \<ls> A ) )"
proof -
   have S1: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A \<ls> B \<longleftrightarrow> \<not> ( ( A = B \<or> B \<ls> A ) ) )" by (rule MMI_axlttri)
   have S2: "\<not> ( ( A = B \<or> B \<ls> A ) ) \<longrightarrow> \<not> ( B \<ls> A )" by (rule MMI_pm2_46)
   from S1 S2 show "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A \<ls> B \<longrightarrow> \<not> ( B \<ls> A ) )" by (rule MMI_syl6bi)
qed

lemma (in MMIsar0) MMI_ltnsym2t: 
   shows "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 \<not> ( ( A \<ls> B \<and> B \<ls> A ) )"
proof -
   have S1: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A \<ls> B \<longrightarrow> \<not> ( B \<ls> A ) )" by (rule MMI_ltnsymt)
   have S2: "( A \<ls> B \<longrightarrow>   
 \<not> ( B \<ls> A ) ) \<longleftrightarrow>   
 \<not> ( ( A \<ls> B \<and> B \<ls> A ) )" by (rule MMI_imnan)
   from S1 S2 show "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 \<not> ( ( A \<ls> B \<and> B \<ls> A ) )" by (rule MMI_sylib)
qed

lemma (in MMIsar0) MMI_elxr: 
   shows "A \<in> \<real>\<^isup>* \<longleftrightarrow> ( A \<in> \<real> \<or> A = \<cpnf> \<or> A = \<cmnf> )"
proof -
   have S1: "\<real>\<^isup>* = ( \<real> \<union> { \<cpnf> , \<cmnf> } )" by (rule MMI_df_xr)
   from S1 have S2: "A \<in> \<real>\<^isup>* \<longleftrightarrow> A \<in> ( \<real> \<union> { \<cpnf> , \<cmnf> } )" by (rule MMI_eleq2i)
   have S3: "A \<in> ( \<real> \<union> { \<cpnf> , \<cmnf> } ) \<longleftrightarrow>   
 ( A \<in> \<real> \<or> A \<in> { \<cpnf> , \<cmnf> } )" by (rule MMI_elun)
   have S4: "\<cpnf> \<in> \<real>\<^isup>*" by (rule MMI_pnfxr)
   from S4 have S5: "\<cpnf> isASet" by (rule MMI_elisseti)
   have S6: "\<cmnf> \<in> \<real>\<^isup>*" by (rule MMI_mnfxr)
   from S6 have S7: "\<cmnf> isASet" by (rule MMI_elisseti)
   from S5 S7 have S8: "A \<in> { \<cpnf> , \<cmnf> } \<longleftrightarrow> ( A = \<cpnf> \<or> A = \<cmnf> )"
     by (rule MMI_elpr2)
   from S8 have S9: "( A \<in> \<real> \<or> A \<in> { \<cpnf> , \<cmnf> } ) \<longleftrightarrow>   
 ( A \<in> \<real> \<or> ( A = \<cpnf> \<or> A = \<cmnf> ) )" by (rule MMI_orbi2i)
   have S10: "( A \<in> \<real> \<or> A =   
 \<cpnf> \<or> A =   
 \<cmnf> ) \<longleftrightarrow> ( A \<in> \<real> \<or> ( A = \<cpnf> \<or> A = \<cmnf> ) )" by (rule MMI_3orass)
   from S9 S10 have S11: "( A \<in> \<real> \<or> A \<in> { \<cpnf> , \<cmnf> } ) \<longleftrightarrow>   
 ( A \<in> \<real> \<or> A = \<cpnf> \<or> A = \<cmnf> )" by (rule MMI_bitr4)
   from S2 S3 S11 show "A \<in> \<real>\<^isup>* \<longleftrightarrow> ( A \<in> \<real> \<or> A = \<cpnf> \<or> A = \<cmnf> )" 
     by (rule MMI_3bitr)
qed

lemma (in MMIsar0) MMI_pnfnemnf: 
   shows "\<cpnf> \<noteq> \<cmnf>"
proof -
   have S1: "\<not> ( \<complex> \<in> \<complex> )" by (rule MMI_eirr)
   have S2: "\<complex> isASet" by (rule MMI_axcnex)
   from S2 have S3: "\<complex> \<in> { \<complex> }" by (rule MMI_snid)
   have S4: "\<complex> = { \<complex> } \<longrightarrow> ( \<complex> \<in> \<complex> \<longleftrightarrow> \<complex> \<in> { \<complex> } )" by (rule MMI_eleq2)
   from S3 S4 have S5: "\<complex> = { \<complex> } \<longrightarrow> \<complex> \<in> \<complex>" by (rule MMI_mpbiri)
   from S1 S5 have S6: "\<not> ( \<complex> = { \<complex> } )" by (rule MMI_mto)
   have S7: "\<cpnf> = \<complex>" by (rule MMI_df_pnf)
   have S8: "\<cmnf> = { \<complex> }" by (rule MMI_df_mnf)
   from S7 S8 have S9: "\<cpnf> = \<cmnf> \<longleftrightarrow> \<complex> = { \<complex> }" by (rule MMI_eqeq12i)
   from S6 S9 have S10: "\<not> ( \<cpnf> = \<cmnf> )" by (rule MMI_mtbir)
   have S11: "\<cpnf> \<noteq> \<cmnf> \<longleftrightarrow> \<not> ( \<cpnf> = \<cmnf> )" by (rule MMI_df_ne)
   from S10 S11 show "\<cpnf> \<noteq> \<cmnf>" by (rule MMI_mpbir)
qed

lemma (in MMIsar0) MMI_renepnft: 
   shows "A \<in> \<real> \<longrightarrow> A \<noteq> \<cpnf>"
proof -
   have S1: "\<cpnf> \<notin> \<real>" by (rule MMI_pnfnre)
   have S2: "\<cpnf> \<notin> \<real> \<longleftrightarrow> \<not> ( \<cpnf> \<in> \<real> )" by (rule MMI_df_nel)
   from S1 S2 have S3: "\<not> ( \<cpnf> \<in> \<real> )" by (rule MMI_mpbi)
   have S4: "( A \<in> \<real> \<and> \<not> ( \<cpnf> \<in> \<real> ) ) \<longrightarrow> \<not> ( A = \<cpnf> )" 
     by (rule MMI_nelneq)
   from S3 S4 have S5: "A \<in> \<real> \<longrightarrow> \<not> ( A = \<cpnf> )" by (rule MMI_mpan2)
   have S6: "A \<noteq> \<cpnf> \<longleftrightarrow> \<not> ( A = \<cpnf> )" by (rule MMI_df_ne)
   from S5 S6 show "A \<in> \<real> \<longrightarrow> A \<noteq> \<cpnf>" by (rule MMI_sylibr)
qed

lemma (in MMIsar0) MMI_renemnft: 
   shows "A \<in> \<real> \<longrightarrow> A \<noteq> \<cmnf>"
proof -
   have S1: "\<cmnf> \<notin> \<real>" by (rule MMI_minfnre)
   have S2: "\<cmnf> \<notin> \<real> \<longleftrightarrow> \<not> ( \<cmnf> \<in> \<real> )" by (rule MMI_df_nel)
   from S1 S2 have S3: "\<not> ( \<cmnf> \<in> \<real> )" by (rule MMI_mpbi)
   have S4: "( A \<in> \<real> \<and> \<not> ( \<cmnf> \<in> \<real> ) ) \<longrightarrow> \<not> ( A = \<cmnf> )" 
     by (rule MMI_nelneq)
   from S3 S4 have S5: "A \<in> \<real> \<longrightarrow> \<not> ( A = \<cmnf> )" by (rule MMI_mpan2)
   have S6: "A \<noteq> \<cmnf> \<longleftrightarrow> \<not> ( A = \<cmnf> )" by (rule MMI_df_ne)
   from S5 S6 show "A \<in> \<real> \<longrightarrow> A \<noteq> \<cmnf>" by (rule MMI_sylibr)
qed;

(**********************261-270***********************)

lemma (in MMIsar0) MMI_renfdisj: 
   shows "( \<real> \<inter> { \<cpnf> , \<cmnf> } ) = 0"
proof -
   have S1: "{ \<cpnf> , \<cmnf> } = ( { \<cpnf> } \<union> { \<cmnf> } )" by (rule MMI_df_pr)
   from S1 have S2: "( \<real> \<inter> { \<cpnf> , \<cmnf> } ) =   
 ( \<real> \<inter> ( { \<cpnf> } \<union> { \<cmnf> } ) )" by (rule MMI_ineq2i)
   have S3: "\<cpnf> = \<cpnf>" by (rule MMI_eqid)
   have S4: "\<cpnf> \<in> \<real> \<longrightarrow> \<cpnf> \<noteq> \<cpnf>" by (rule MMI_renepnft)
   have S5: "\<cpnf> \<noteq> \<cpnf> \<longleftrightarrow> \<not> ( \<cpnf> = \<cpnf> )" by (rule MMI_df_ne)
   from S4 S5 have S6: "\<cpnf> \<in> \<real> \<longrightarrow> \<not> ( \<cpnf> = \<cpnf> )" by (rule MMI_sylib)
   from S3 S6 have S7: "\<not> ( \<cpnf> \<in> \<real> )" by (rule MMI_mt2)
   have S8: "( \<real> \<inter> { \<cpnf> } ) = 0 \<longleftrightarrow> \<not> ( \<cpnf> \<in> \<real> )" by (rule MMI_disjsn)
   from S7 S8 have S9: "( \<real> \<inter> { \<cpnf> } ) = 0" by (rule MMI_mpbir)
   have S10: "\<cmnf> = \<cmnf>" by (rule MMI_eqid)
   have S11: "\<cmnf> \<in> \<real> \<longrightarrow> \<cmnf> \<noteq> \<cmnf>" by (rule MMI_renemnft)
   have S12: "\<cmnf> \<noteq> \<cmnf> \<longleftrightarrow> \<not> ( \<cmnf> = \<cmnf> )" by (rule MMI_df_ne)
   from S11 S12 have S13: "\<cmnf> \<in> \<real> \<longrightarrow> \<not> ( \<cmnf> = \<cmnf> )" by (rule MMI_sylib)
   from S10 S13 have S14: "\<not> ( \<cmnf> \<in> \<real> )" by (rule MMI_mt2)
   have S15: "( \<real> \<inter> { \<cmnf> } ) = 0 \<longleftrightarrow> \<not> ( \<cmnf> \<in> \<real> )" by (rule MMI_disjsn)
   from S14 S15 have S16: "( \<real> \<inter> { \<cmnf> } ) = 0" by (rule MMI_mpbir)
   from S9 S16 have S17: "( \<real> \<inter> { \<cpnf> } ) = 0 \<and> ( \<real> \<inter> { \<cmnf> } ) = 0" by (rule MMI_pm3_2i)
   have S18: "( ( \<real> \<inter> { \<cpnf> } ) =   
 0 \<and> ( \<real> \<inter> { \<cmnf> } ) =   
 0 ) \<longleftrightarrow> ( \<real> \<inter> ( { \<cpnf> } \<union> { \<cmnf> } ) ) = 0" by (rule MMI_undisj2)
   from S17 S18 have S19: "( \<real> \<inter> ( { \<cpnf> } \<union> { \<cmnf> } ) ) = 0" by (rule MMI_mpbi)
   from S2 S19 show "( \<real> \<inter> { \<cpnf> , \<cmnf> } ) = 0" by (rule MMI_eqtr)
qed;

lemma (in MMIsar0) MMI_ssxr: 
   shows "( A \<subseteq> \<real>\<^isup>* \<longrightarrow> ( A \<subseteq> \<real> \<or> \<cpnf> \<in> A \<or> \<cmnf> \<in> A ) )"
proof -
   have S1: "( ( A \<inter> { \<cpnf> , \<cmnf> } ) =   
 0 \<longrightarrow>   
 ( A \<subseteq> ( { \<cpnf> , \<cmnf> } \<union> \<real> ) \<longleftrightarrow> A \<subseteq> \<real> ) )" by (rule MMI_disjssun)
   have S2: "\<real>\<^isup>* = ( \<real> \<union> { \<cpnf> , \<cmnf> } )" by (rule MMI_df_xr)
   have S3: "( \<real> \<union> { \<cpnf> , \<cmnf> } ) = ( { \<cpnf> , \<cmnf> } \<union> \<real> )" by (rule MMI_uncom)
   from S2 S3 have S4: "\<real>\<^isup>* = ( { \<cpnf> , \<cmnf> } \<union> \<real> )" by (rule MMI_eqtr)
   from S4 have S5: "( A \<subseteq> \<real>\<^isup>* \<longleftrightarrow> A \<subseteq> ( { \<cpnf> , \<cmnf> } \<union> \<real> ) )" by (rule MMI_sseq2i)
   from S1 S5 have S6: "( ( A \<inter> { \<cpnf> , \<cmnf> } ) =   
 0 \<longrightarrow> ( A \<subseteq> \<real>\<^isup>* \<longleftrightarrow> A \<subseteq> \<real> ) )" by (rule MMI_syl5bb)
   from S6 have S7: "( A \<subseteq> \<real>\<^isup>* \<longrightarrow>   
 ( ( A \<inter> { \<cpnf> , \<cmnf> } ) = 0 \<longrightarrow> A \<subseteq> \<real> ) )" by (rule MMI_biimpcd)
   have S8: "( A \<inter> { \<cpnf> , \<cmnf> } ) =   
 0 \<longleftrightarrow> ( \<forall> x \<in> A . \<not> ( x \<in> { \<cpnf> , \<cmnf> } ) )" by (rule MMI_disj)
   from S7 S8 have S9: "( A \<subseteq> \<real>\<^isup>* \<longrightarrow>   
 ( ( \<forall> x \<in> A . \<not> ( x \<in> { \<cpnf> , \<cmnf> } ) ) \<longrightarrow>   
 A \<subseteq> \<real> ) )" by (rule MMI_syl5ibr)
   from S9 have S10: "( A \<subseteq> \<real>\<^isup>* \<longrightarrow>   
 ( \<not> ( A \<subseteq> \<real> ) \<longrightarrow>   
 \<not> ( ( \<forall> x \<in> A . \<not> ( x \<in> { \<cpnf> , \<cmnf> } ) ) ) ) )" by (rule MMI_con3d)
   have S11: "( \<exists> x \<in> A . x \<in> { \<cpnf> , \<cmnf> } ) \<longleftrightarrow>   
     \<not> ( ( \<forall> x \<in> A . \<not> ( x \<in> { \<cpnf> , \<cmnf> } ) ) )" by (rule MMI_dfrex2)
   { fix x
     have S12: "x isASet" by (rule MMI_visset);
     from S12 have 
       "x \<in> { \<cpnf> , \<cmnf> } \<longleftrightarrow> ( x = \<cpnf> \<or> x = \<cmnf> )" 
       by (rule MMI_elpr)
   } then have S13: 
       "\<forall>x. x \<in> { \<cpnf> , \<cmnf> } \<longleftrightarrow> ( x = \<cpnf> \<or> x = \<cmnf> )"  
     by simp;
   from S13 have S14: "( \<exists> x \<in> A . x \<in> { \<cpnf> , \<cmnf> } ) \<longleftrightarrow>   
     ( \<exists> x \<in> A . ( x = \<cpnf> \<or> x = \<cmnf> ) )" by (rule MMI_rexbii);
   from S11 S14 have S15: 
     "\<not> ( ( \<forall> x \<in> A . \<not> ( x \<in> { \<cpnf> , \<cmnf> } ) ) ) \<longleftrightarrow>   
     ( \<exists> x \<in> A . ( x = \<cpnf> \<or> x = \<cmnf> ) )" by (rule MMI_bitr3)
   have S16: "( \<exists> x \<in> A . ( x = \<cpnf> \<or> x = \<cmnf> ) ) \<longleftrightarrow>   
 ( ( \<exists> x \<in> A . x = \<cpnf> \<or> ( \<exists> x \<in> A . x = \<cmnf> ) ) )" 
     by (rule MMI_r19_43)
   have S17: "( \<exists> x \<in> A . x =   
 \<cpnf> ) \<longleftrightarrow> ( \<exists> x . ( x \<in> A \<and> x = \<cpnf> ) )" by (rule MMI_df_rex)
   have S18: "( \<exists> x . ( x \<in> A \<and> x = \<cpnf> ) ) \<longleftrightarrow>   
 ( \<exists> x . ( x = \<cpnf> \<and> x \<in> A ) )" by (rule MMI_exancom)
   have S19: "\<cpnf> \<in> \<real>\<^isup>*" by (rule MMI_pnfxr)
   from S19 have S20: "\<cpnf> isASet" by (rule MMI_elisseti)
   { fix x
     have  "x = \<cpnf> \<longrightarrow> ( x \<in> A \<longleftrightarrow> \<cpnf> \<in> A )" by (rule MMI_eleq1)
   } then have S21: "\<forall> x. x = \<cpnf> \<longrightarrow> ( x \<in> A \<longleftrightarrow> \<cpnf> \<in> A )"
     by simp
   from S20 S21 have S22: "( \<exists> x . ( x = \<cpnf> \<and> x \<in> A ) ) \<longleftrightarrow> \<cpnf> \<in> A" 
     by (rule MMI_ceqsexv);
   from S17 S18 S22 have S23: "( \<exists> x \<in> A . x = \<cpnf> ) \<longleftrightarrow> \<cpnf> \<in> A" 
     by (rule MMI_3bitr)
   have S24: "( \<exists> x \<in> A . x =   
 \<cmnf> ) \<longleftrightarrow> ( \<exists> x . ( x \<in> A \<and> x = \<cmnf> ) )" by (rule MMI_df_rex)
   have S25: "( \<exists> x . ( x \<in> A \<and> x = \<cmnf> ) ) \<longleftrightarrow>   
 ( \<exists> x . ( x = \<cmnf> \<and> x \<in> A ) )" by (rule MMI_exancom)
   have S26: "\<cmnf> \<in> \<real>\<^isup>*" by (rule MMI_mnfxr)
   from S26 have S27: "\<cmnf> isASet" by (rule MMI_elisseti)
   { fix x 
     have "x = \<cmnf> \<longrightarrow> ( x \<in> A \<longleftrightarrow> \<cmnf> \<in> A )" by (rule MMI_eleq1)
   } then have S28: "\<forall>x. x = \<cmnf> \<longrightarrow> ( x \<in> A \<longleftrightarrow> \<cmnf> \<in> A )"
     by simp
   from S27 S28 have S29: "( \<exists> x . ( x = \<cmnf> \<and> x \<in> A ) ) \<longleftrightarrow> \<cmnf> \<in> A" 
     by (rule MMI_ceqsexv);
   from S24 S25 S29 have S30: "( \<exists> x \<in> A . x = \<cmnf> ) \<longleftrightarrow> \<cmnf> \<in> A" 
     by (rule MMI_3bitr)
   from S23 S30 have S31: 
     "( ( \<exists> x \<in> A . x = \<cpnf> \<or> ( \<exists> x \<in> A . x = \<cmnf> ) ) ) \<longleftrightarrow>   
     ( \<cpnf> \<in> A \<or> \<cmnf> \<in> A )" 
     by auto; (* by (rule MMI_orbi12i), but I cuould'n get it to work *)
   from S15 S16 S31 have S32: 
     "\<not> ( ( \<forall> x \<in> A . \<not> ( x \<in> { \<cpnf> , \<cmnf> } ) ) ) \<longleftrightarrow>   
     ( \<cpnf> \<in> A \<or> \<cmnf> \<in> A )" by (rule MMI_3bitr)
   from S10 S32 have S33: "( A \<subseteq> \<real>\<^isup>* \<longrightarrow>   
 ( \<not> ( A \<subseteq> \<real> ) \<longrightarrow> ( \<cpnf> \<in> A \<or> \<cmnf> \<in> A ) ) )" by (rule MMI_syl6ib)
   from S33 have S34: "( A \<subseteq> \<real>\<^isup>* \<longrightarrow>   
 ( A \<subseteq> \<real> \<or> ( \<cpnf> \<in> A \<or> \<cmnf> \<in> A ) ) )" by (rule MMI_orrd)
   have S35: "( ( A \<subseteq> \<real> \<or> \<cpnf> \<in> A \<or> \<cmnf> \<in> A ) \<longleftrightarrow>   
 ( A \<subseteq> \<real> \<or> ( \<cpnf> \<in> A \<or> \<cmnf> \<in> A ) ) )" by (rule MMI_3orass)
   from S34 S35 show "( A \<subseteq> \<real>\<^isup>* \<longrightarrow> ( A \<subseteq> \<real> \<or> \<cpnf> \<in> A \<or> \<cmnf> \<in> A ) )" by (rule MMI_sylibr)
qed

lemma (in MMIsar0) MMI_xrltnrt: 
   shows "A \<in> \<real>\<^isup>* \<longrightarrow> \<not> ( A \<ls> A )"
proof -
   have S1: "A \<in> \<real>\<^isup>* \<longleftrightarrow> ( A \<in> \<real> \<or> A = \<cpnf> \<or> A = \<cmnf> )" by (rule MMI_elxr)
   have S2: "A \<in> \<real> \<longrightarrow> \<not> ( A \<ls> A )" by (rule MMI_ltnrt)
   have S3: "\<cpnf> \<notin> \<real>" by (rule MMI_pnfnre)
   have S4: "\<cpnf> \<notin> \<real> \<longleftrightarrow> \<not> ( \<cpnf> \<in> \<real> )" by (rule MMI_df_nel)
   from S3 S4 have S5: "\<not> ( \<cpnf> \<in> \<real> )" by (rule MMI_mpbi)
   from S5 have S6: "\<not> ( ( \<cpnf> \<in> \<real> \<and> \<cpnf> \<in> \<real> ) )" by (rule MMI_intnan)
   from S6 have S7: "\<not> ( ( ( \<cpnf> \<in> \<real> \<and> \<cpnf> \<in> \<real> ) \<and> \<cpnf> \<lsr> \<cpnf> ) )" by (rule MMI_intnanr)
   have S8: "\<cpnf> \<noteq> \<cmnf>" by (rule MMI_pnfnemnf)
   have S9: "\<cpnf> \<noteq> \<cmnf> \<longleftrightarrow> \<not> ( \<cpnf> = \<cmnf> )" by (rule MMI_df_ne)
   from S8 S9 have S10: "\<not> ( \<cpnf> = \<cmnf> )" by (rule MMI_mpbi)
   from S10 have S11: "\<not> ( ( \<cpnf> = \<cmnf> \<and> \<cpnf> = \<cpnf> ) )" by (rule MMI_intnanr)
   from S7 S11 have S12: "\<not> ( ( ( ( \<cpnf> \<in> \<real> \<and> \<cpnf> \<in> \<real> ) \<and> \<cpnf> \<lsr> \<cpnf> ) \<or> ( \<cpnf> = \<cmnf> \<and> \<cpnf> = \<cpnf> ) ) )" by (rule MMI_pm3_2ni)
   from S5 have S13: "\<not> ( \<cpnf> \<in> \<real> )" .
   from S13 have S14: "\<not> ( ( \<cpnf> \<in> \<real> \<and> \<cpnf> = \<cpnf> ) )" by (rule MMI_intnanr)
   from S5 have S15: "\<not> ( \<cpnf> \<in> \<real> )" .
   from S15 have S16: "\<not> ( ( \<cpnf> = \<cmnf> \<and> \<cpnf> \<in> \<real> ) )" by (rule MMI_intnan)
   from S14 S16 have S17: "\<not> ( ( ( \<cpnf> \<in> \<real> \<and> \<cpnf> = \<cpnf> ) \<or> ( \<cpnf> = \<cmnf> \<and> \<cpnf> \<in> \<real> ) ) )" by (rule MMI_pm3_2ni)
   from S12 S17 have S18: "\<not> ( ( ( ( ( \<cpnf> \<in> \<real> \<and> \<cpnf> \<in> \<real> ) \<and> \<cpnf> \<lsr> \<cpnf> ) \<or> ( \<cpnf> = \<cmnf> \<and> \<cpnf> = \<cpnf> ) ) \<or> ( ( \<cpnf> \<in> \<real> \<and> \<cpnf> = \<cpnf> ) \<or> ( \<cpnf> = \<cmnf> \<and> \<cpnf> \<in> \<real> ) ) ) )" by (rule MMI_pm3_2ni)
   have S19: "\<cpnf> \<in> \<real>\<^isup>*" by (rule MMI_pnfxr)
   have S20: "\<cpnf> \<in> \<real>\<^isup>*" by (rule MMI_pnfxr)
   have S21: "( \<cpnf> \<in> \<real>\<^isup>* \<and> \<cpnf> \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( \<cpnf> \<ls> \<cpnf> \<longleftrightarrow>   
 ( ( ( ( \<cpnf> \<in> \<real> \<and> \<cpnf> \<in> \<real> ) \<and> \<cpnf> \<lsr> \<cpnf> ) \<or> ( \<cpnf> = \<cmnf> \<and> \<cpnf> = \<cpnf> ) ) \<or> ( ( \<cpnf> \<in> \<real> \<and> \<cpnf> = \<cpnf> ) \<or> ( \<cpnf> = \<cmnf> \<and> \<cpnf> \<in> \<real> ) ) ) )" by (rule MMI_ltxrt)
   from S19 S20 S21 have S22: "\<cpnf> \<ls> \<cpnf> \<longleftrightarrow>   
 ( ( ( ( \<cpnf> \<in> \<real> \<and> \<cpnf> \<in> \<real> ) \<and> \<cpnf> \<lsr> \<cpnf> ) \<or> ( \<cpnf> = \<cmnf> \<and> \<cpnf> = \<cpnf> ) ) \<or> ( ( \<cpnf> \<in> \<real> \<and> \<cpnf> = \<cpnf> ) \<or> ( \<cpnf> = \<cmnf> \<and> \<cpnf> \<in> \<real> ) ) )" by (rule MMI_mp2an)
   from S18 S22 have S23: "\<not> ( \<cpnf> \<ls> \<cpnf> )" by (rule MMI_mtbir)
   have S24: "( A = \<cpnf> \<and> A = \<cpnf> ) \<longrightarrow> ( A \<ls> A \<longleftrightarrow> \<cpnf> \<ls> \<cpnf> )" by (rule MMI_breq12)
   from S24 have S25: "A = \<cpnf> \<longrightarrow> ( A \<ls> A \<longleftrightarrow> \<cpnf> \<ls> \<cpnf> )" by (rule MMI_anidms)
   from S23 S25 have S26: "A = \<cpnf> \<longrightarrow> \<not> ( A \<ls> A )" by (rule MMI_mtbiri)
   have S27: "\<cmnf> \<notin> \<real>" by (rule MMI_minfnre)
   have S28: "\<cmnf> \<notin> \<real> \<longleftrightarrow> \<not> ( \<cmnf> \<in> \<real> )" by (rule MMI_df_nel)
   from S27 S28 have S29: "\<not> ( \<cmnf> \<in> \<real> )" by (rule MMI_mpbi)
   from S29 have S30: "\<not> ( ( \<cmnf> \<in> \<real> \<and> \<cmnf> \<in> \<real> ) )" by (rule MMI_intnan)
   from S30 have S31: "\<not> ( ( ( \<cmnf> \<in> \<real> \<and> \<cmnf> \<in> \<real> ) \<and> \<cmnf> \<lsr> \<cmnf> ) )" by (rule MMI_intnanr)
   have S32: "\<cpnf> \<noteq> \<cmnf>" by (rule MMI_pnfnemnf)
   have S33: "\<cpnf> \<noteq> \<cmnf> \<longleftrightarrow> \<cmnf> \<noteq> \<cpnf>" by (rule MMI_necom)
   from S32 S33 have S34: "\<cmnf> \<noteq> \<cpnf>" by (rule MMI_mpbi)
   have S35: "\<cmnf> \<noteq> \<cpnf> \<longleftrightarrow> \<not> ( \<cmnf> = \<cpnf> )" by (rule MMI_df_ne)
   from S34 S35 have S36: "\<not> ( \<cmnf> = \<cpnf> )" by (rule MMI_mpbi)
   from S36 have S37: "\<not> ( ( \<cmnf> = \<cmnf> \<and> \<cmnf> = \<cpnf> ) )" by (rule MMI_intnan)
   from S31 S37 have S38: "\<not> ( ( ( ( \<cmnf> \<in> \<real> \<and> \<cmnf> \<in> \<real> ) \<and> \<cmnf> \<lsr> \<cmnf> ) \<or> ( \<cmnf> = \<cmnf> \<and> \<cmnf> = \<cpnf> ) ) )" by (rule MMI_pm3_2ni)
   from S29 have S39: "\<not> ( \<cmnf> \<in> \<real> )" .
   from S39 have S40: "\<not> ( ( \<cmnf> \<in> \<real> \<and> \<cmnf> = \<cpnf> ) )" by (rule MMI_intnanr)
   from S29 have S41: "\<not> ( \<cmnf> \<in> \<real> )" .
   from S41 have S42: "\<not> ( ( \<cmnf> = \<cmnf> \<and> \<cmnf> \<in> \<real> ) )" by (rule MMI_intnan)
   from S40 S42 have S43: "\<not> ( ( ( \<cmnf> \<in> \<real> \<and> \<cmnf> = \<cpnf> ) \<or> ( \<cmnf> = \<cmnf> \<and> \<cmnf> \<in> \<real> ) ) )" by (rule MMI_pm3_2ni)
   from S38 S43 have S44: "\<not> ( ( ( ( ( \<cmnf> \<in> \<real> \<and> \<cmnf> \<in> \<real> ) \<and> \<cmnf> \<lsr> \<cmnf> ) \<or> ( \<cmnf> = \<cmnf> \<and> \<cmnf> = \<cpnf> ) ) \<or> ( ( \<cmnf> \<in> \<real> \<and> \<cmnf> = \<cpnf> ) \<or> ( \<cmnf> = \<cmnf> \<and> \<cmnf> \<in> \<real> ) ) ) )" by (rule MMI_pm3_2ni)
   have S45: "\<cmnf> \<in> \<real>\<^isup>*" by (rule MMI_mnfxr)
   have S46: "\<cmnf> \<in> \<real>\<^isup>*" by (rule MMI_mnfxr)
   have S47: "( \<cmnf> \<in> \<real>\<^isup>* \<and> \<cmnf> \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( \<cmnf> \<ls> \<cmnf> \<longleftrightarrow>   
 ( ( ( ( \<cmnf> \<in> \<real> \<and> \<cmnf> \<in> \<real> ) \<and> \<cmnf> \<lsr> \<cmnf> ) \<or> ( \<cmnf> = \<cmnf> \<and> \<cmnf> = \<cpnf> ) ) \<or> ( ( \<cmnf> \<in> \<real> \<and> \<cmnf> = \<cpnf> ) \<or> ( \<cmnf> = \<cmnf> \<and> \<cmnf> \<in> \<real> ) ) ) )" by (rule MMI_ltxrt)
   from S45 S46 S47 have S48: "\<cmnf> \<ls> \<cmnf> \<longleftrightarrow>   
 ( ( ( ( \<cmnf> \<in> \<real> \<and> \<cmnf> \<in> \<real> ) \<and> \<cmnf> \<lsr> \<cmnf> ) \<or> ( \<cmnf> = \<cmnf> \<and> \<cmnf> = \<cpnf> ) ) \<or> ( ( \<cmnf> \<in> \<real> \<and> \<cmnf> = \<cpnf> ) \<or> ( \<cmnf> = \<cmnf> \<and> \<cmnf> \<in> \<real> ) ) )" by (rule MMI_mp2an)
   from S44 S48 have S49: "\<not> ( \<cmnf> \<ls> \<cmnf> )" by (rule MMI_mtbir)
   have S50: "( A = \<cmnf> \<and> A = \<cmnf> ) \<longrightarrow> ( A \<ls> A \<longleftrightarrow> \<cmnf> \<ls> \<cmnf> )" by (rule MMI_breq12)
   from S50 have S51: "A = \<cmnf> \<longrightarrow> ( A \<ls> A \<longleftrightarrow> \<cmnf> \<ls> \<cmnf> )" by (rule MMI_anidms)
   from S49 S51 have S52: "A = \<cmnf> \<longrightarrow> \<not> ( A \<ls> A )" by (rule MMI_mtbiri)
   from S2 S26 S52 have S53: "( A \<in> \<real> \<or> A =   
 \<cpnf> \<or> A = \<cmnf> ) \<longrightarrow> \<not> ( A \<ls> A )" by (rule MMI_3jaoi)
   from S1 S53 show "A \<in> \<real>\<^isup>* \<longrightarrow> \<not> ( A \<ls> A )" by (rule MMI_sylbi)
qed

lemma (in MMIsar0) MMI_ltpnft: 
   shows "A \<in> \<real> \<longrightarrow> A \<ls> \<cpnf>"
proof -
   have S1: "\<cpnf> = \<cpnf>" by (rule MMI_eqid)
   from S1 have S2: "A \<in> \<real> \<longrightarrow> ( A \<in> \<real> \<and> \<cpnf> = \<cpnf> )" by (rule MMI_jctr)
   have S3: "( A \<in> \<real> \<and> \<cpnf> =   
 \<cpnf> ) \<longrightarrow>   
 ( ( A \<in> \<real> \<and> \<cpnf> = \<cpnf> ) \<or> ( A = \<cmnf> \<and> \<cpnf> \<in> \<real> ) )" by (rule MMI_orc)
   have S4: "( ( A \<in> \<real> \<and> \<cpnf> = \<cpnf> ) \<or> ( A = \<cmnf> \<and> \<cpnf> \<in> \<real> ) ) \<longrightarrow>   
 ( ( ( ( A \<in> \<real> \<and> \<cpnf> \<in> \<real> ) \<and> A \<lsr> \<cpnf> ) \<or> ( A = \<cmnf> \<and> \<cpnf> = \<cpnf> ) ) \<or> ( ( A \<in> \<real> \<and> \<cpnf> = \<cpnf> ) \<or> ( A = \<cmnf> \<and> \<cpnf> \<in> \<real> ) ) )" by (rule MMI_olc)
   from S2 S3 S4 have S5: "A \<in> \<real> \<longrightarrow>   
 ( ( ( ( A \<in> \<real> \<and> \<cpnf> \<in> \<real> ) \<and> A \<lsr> \<cpnf> ) \<or> ( A = \<cmnf> \<and> \<cpnf> = \<cpnf> ) ) \<or> ( ( A \<in> \<real> \<and> \<cpnf> = \<cpnf> ) \<or> ( A = \<cmnf> \<and> \<cpnf> \<in> \<real> ) ) )" by (rule MMI_3syl)
   have S6: "A \<in> \<real> \<longrightarrow> A \<in> \<real>\<^isup>*" by (rule MMI_rexrt)
   have S7: "\<cpnf> \<in> \<real>\<^isup>*" by (rule MMI_pnfxr)
   have S8: "( A \<in> \<real>\<^isup>* \<and> \<cpnf> \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( A \<ls> \<cpnf> \<longleftrightarrow>   
 ( ( ( ( A \<in> \<real> \<and> \<cpnf> \<in> \<real> ) \<and> A \<lsr> \<cpnf> ) \<or> ( A = \<cmnf> \<and> \<cpnf> = \<cpnf> ) ) \<or> ( ( A \<in> \<real> \<and> \<cpnf> = \<cpnf> ) \<or> ( A = \<cmnf> \<and> \<cpnf> \<in> \<real> ) ) ) )" by (rule MMI_ltxrt)
   from S7 S8 have S9: "A \<in> \<real>\<^isup>* \<longrightarrow>   
 ( A \<ls> \<cpnf> \<longleftrightarrow>   
 ( ( ( ( A \<in> \<real> \<and> \<cpnf> \<in> \<real> ) \<and> A \<lsr> \<cpnf> ) \<or> ( A = \<cmnf> \<and> \<cpnf> = \<cpnf> ) ) \<or> ( ( A \<in> \<real> \<and> \<cpnf> = \<cpnf> ) \<or> ( A = \<cmnf> \<and> \<cpnf> \<in> \<real> ) ) ) )" by (rule MMI_mpan2)
   from S6 S9 have S10: "A \<in> \<real> \<longrightarrow>   
 ( A \<ls> \<cpnf> \<longleftrightarrow>   
 ( ( ( ( A \<in> \<real> \<and> \<cpnf> \<in> \<real> ) \<and> A \<lsr> \<cpnf> ) \<or> ( A = \<cmnf> \<and> \<cpnf> = \<cpnf> ) ) \<or> ( ( A \<in> \<real> \<and> \<cpnf> = \<cpnf> ) \<or> ( A = \<cmnf> \<and> \<cpnf> \<in> \<real> ) ) ) )" by (rule MMI_syl)
   from S5 S10 show "A \<in> \<real> \<longrightarrow> A \<ls> \<cpnf>" by (rule MMI_mpbird)
qed

lemma (in MMIsar0) MMI_mnfltt: 
   shows "A \<in> \<real> \<longrightarrow> \<cmnf> \<ls> A"
proof -
   have S1: "\<cmnf> = \<cmnf>" by (rule MMI_eqid)
   from S1 have S2: "A \<in> \<real> \<longrightarrow> ( \<cmnf> = \<cmnf> \<and> A \<in> \<real> )" by (rule MMI_jctl)
   have S3: "( \<cmnf> =   
 \<cmnf> \<and> A \<in> \<real> ) \<longrightarrow>   
 ( ( \<cmnf> \<in> \<real> \<and> A = \<cpnf> ) \<or> ( \<cmnf> = \<cmnf> \<and> A \<in> \<real> ) )" by (rule MMI_olc)
   have S4: "( ( \<cmnf> \<in> \<real> \<and> A = \<cpnf> ) \<or> ( \<cmnf> = \<cmnf> \<and> A \<in> \<real> ) ) \<longrightarrow>   
 ( ( ( ( \<cmnf> \<in> \<real> \<and> A \<in> \<real> ) \<and> \<cmnf> \<lsr> A ) \<or> ( \<cmnf> = \<cmnf> \<and> A = \<cpnf> ) ) \<or> ( ( \<cmnf> \<in> \<real> \<and> A = \<cpnf> ) \<or> ( \<cmnf> = \<cmnf> \<and> A \<in> \<real> ) ) )" by (rule MMI_olc)
   from S2 S3 S4 have S5: "A \<in> \<real> \<longrightarrow>   
 ( ( ( ( \<cmnf> \<in> \<real> \<and> A \<in> \<real> ) \<and> \<cmnf> \<lsr> A ) \<or> ( \<cmnf> = \<cmnf> \<and> A = \<cpnf> ) ) \<or> ( ( \<cmnf> \<in> \<real> \<and> A = \<cpnf> ) \<or> ( \<cmnf> = \<cmnf> \<and> A \<in> \<real> ) ) )" by (rule MMI_3syl)
   have S6: "A \<in> \<real> \<longrightarrow> A \<in> \<real>\<^isup>*" by (rule MMI_rexrt)
   have S7: "\<cmnf> \<in> \<real>\<^isup>*" by (rule MMI_mnfxr)
   have S8: "( \<cmnf> \<in> \<real>\<^isup>* \<and> A \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( \<cmnf> \<ls> A \<longleftrightarrow>   
 ( ( ( ( \<cmnf> \<in> \<real> \<and> A \<in> \<real> ) \<and> \<cmnf> \<lsr> A ) \<or> ( \<cmnf> = \<cmnf> \<and> A = \<cpnf> ) ) \<or> ( ( \<cmnf> \<in> \<real> \<and> A = \<cpnf> ) \<or> ( \<cmnf> = \<cmnf> \<and> A \<in> \<real> ) ) ) )" by (rule MMI_ltxrt)
   from S7 S8 have S9: "A \<in> \<real>\<^isup>* \<longrightarrow>   
 ( \<cmnf> \<ls> A \<longleftrightarrow>   
 ( ( ( ( \<cmnf> \<in> \<real> \<and> A \<in> \<real> ) \<and> \<cmnf> \<lsr> A ) \<or> ( \<cmnf> = \<cmnf> \<and> A = \<cpnf> ) ) \<or> ( ( \<cmnf> \<in> \<real> \<and> A = \<cpnf> ) \<or> ( \<cmnf> = \<cmnf> \<and> A \<in> \<real> ) ) ) )" by (rule MMI_mpan)
   from S6 S9 have S10: "A \<in> \<real> \<longrightarrow>   
 ( \<cmnf> \<ls> A \<longleftrightarrow>   
 ( ( ( ( \<cmnf> \<in> \<real> \<and> A \<in> \<real> ) \<and> \<cmnf> \<lsr> A ) \<or> ( \<cmnf> = \<cmnf> \<and> A = \<cpnf> ) ) \<or> ( ( \<cmnf> \<in> \<real> \<and> A = \<cpnf> ) \<or> ( \<cmnf> = \<cmnf> \<and> A \<in> \<real> ) ) ) )" by (rule MMI_syl)
   from S5 S10 show "A \<in> \<real> \<longrightarrow> \<cmnf> \<ls> A" by (rule MMI_mpbird)
qed

lemma (in MMIsar0) MMI_mnfltpnf: 
   shows "\<cmnf> \<ls> \<cpnf>"
proof -
   have S1: "\<cmnf> = \<cmnf>" by (rule MMI_eqid)
   have S2: "\<cpnf> = \<cpnf>" by (rule MMI_eqid)
   have S3: "( \<cmnf> =   
 \<cmnf> \<and> \<cpnf> =   
 \<cpnf> ) \<longrightarrow>   
 ( ( ( \<cmnf> \<in> \<real> \<and> \<cpnf> \<in> \<real> ) \<and> \<cmnf> \<lsr> \<cpnf> ) \<or> ( \<cmnf> = \<cmnf> \<and> \<cpnf> = \<cpnf> ) )" by (rule MMI_olc)
   from S1 S2 S3 have S4: "( ( \<cmnf> \<in> \<real> \<and> \<cpnf> \<in> \<real> ) \<and> \<cmnf> \<lsr> \<cpnf> ) \<or> ( \<cmnf> =   
 \<cmnf> \<and> \<cpnf> = \<cpnf> )" by (rule MMI_mp2an)
   have S5: "( ( ( \<cmnf> \<in> \<real> \<and> \<cpnf> \<in> \<real> ) \<and> \<cmnf> \<lsr> \<cpnf> ) \<or> ( \<cmnf> = \<cmnf> \<and> \<cpnf> = \<cpnf> ) ) \<longrightarrow>   
 ( ( ( ( \<cmnf> \<in> \<real> \<and> \<cpnf> \<in> \<real> ) \<and> \<cmnf> \<lsr> \<cpnf> ) \<or> ( \<cmnf> = \<cmnf> \<and> \<cpnf> = \<cpnf> ) ) \<or> ( ( \<cmnf> \<in> \<real> \<and> \<cpnf> = \<cpnf> ) \<or> ( \<cmnf> = \<cmnf> \<and> \<cpnf> \<in> \<real> ) ) )" by (rule MMI_orc)
   from S4 S5 have S6: "( ( ( \<cmnf> \<in> \<real> \<and> \<cpnf> \<in> \<real> ) \<and> \<cmnf> \<lsr> \<cpnf> ) \<or> ( \<cmnf> = \<cmnf> \<and> \<cpnf> = \<cpnf> ) ) \<or> ( ( \<cmnf> \<in> \<real> \<and> \<cpnf> = \<cpnf> ) \<or> ( \<cmnf> = \<cmnf> \<and> \<cpnf> \<in> \<real> ) )" by (rule MMI_ax_mp)
   have S7: "\<cmnf> \<in> \<real>\<^isup>*" by (rule MMI_mnfxr)
   have S8: "\<cpnf> \<in> \<real>\<^isup>*" by (rule MMI_pnfxr)
   have S9: "( \<cmnf> \<in> \<real>\<^isup>* \<and> \<cpnf> \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( \<cmnf> \<ls> \<cpnf> \<longleftrightarrow>   
 ( ( ( ( \<cmnf> \<in> \<real> \<and> \<cpnf> \<in> \<real> ) \<and> \<cmnf> \<lsr> \<cpnf> ) \<or> ( \<cmnf> = \<cmnf> \<and> \<cpnf> = \<cpnf> ) ) \<or> ( ( \<cmnf> \<in> \<real> \<and> \<cpnf> = \<cpnf> ) \<or> ( \<cmnf> = \<cmnf> \<and> \<cpnf> \<in> \<real> ) ) ) )" by (rule MMI_ltxrt)
   from S7 S8 S9 have S10: "\<cmnf> \<ls> \<cpnf> \<longleftrightarrow>   
 ( ( ( ( \<cmnf> \<in> \<real> \<and> \<cpnf> \<in> \<real> ) \<and> \<cmnf> \<lsr> \<cpnf> ) \<or> ( \<cmnf> = \<cmnf> \<and> \<cpnf> = \<cpnf> ) ) \<or> ( ( \<cmnf> \<in> \<real> \<and> \<cpnf> = \<cpnf> ) \<or> ( \<cmnf> = \<cmnf> \<and> \<cpnf> \<in> \<real> ) ) )" by (rule MMI_mp2an)
   from S6 S10 show "\<cmnf> \<ls> \<cpnf>" by (rule MMI_mpbir)
qed

lemma (in MMIsar0) MMI_mnfltxrt: 
   shows "( A \<in> \<real> \<or> A = \<cpnf> ) \<longrightarrow> \<cmnf> \<ls> A"
proof -
   have S1: "A \<in> \<real> \<longrightarrow> \<cmnf> \<ls> A" by (rule MMI_mnfltt)
   have S2: "\<cmnf> \<ls> \<cpnf>" by (rule MMI_mnfltpnf)
   have S3: "A = \<cpnf> \<longrightarrow> ( \<cmnf> \<ls> A \<longleftrightarrow> \<cmnf> \<ls> \<cpnf> )" by (rule MMI_breq2)
   from S2 S3 have S4: "A = \<cpnf> \<longrightarrow> \<cmnf> \<ls> A" by (rule MMI_mpbiri)
   from S1 S4 show "( A \<in> \<real> \<or> A = \<cpnf> ) \<longrightarrow> \<cmnf> \<ls> A" by (rule MMI_jaoi)
qed

lemma (in MMIsar0) MMI_pnfnltt: 
   shows "A \<in> \<real>\<^isup>* \<longrightarrow> \<not> ( \<cpnf> \<ls> A )"
proof -
   have S1: "\<cpnf> \<notin> \<real>" by (rule MMI_pnfnre)
   have S2: "\<cpnf> \<notin> \<real> \<longleftrightarrow> \<not> ( \<cpnf> \<in> \<real> )" by (rule MMI_df_nel)
   from S1 S2 have S3: "\<not> ( \<cpnf> \<in> \<real> )" by (rule MMI_mpbi)
   from S3 have S4: "\<not> ( ( \<cpnf> \<in> \<real> \<and> A \<in> \<real> ) )" by (rule MMI_intnanr)
   from S4 have S5: "\<not> ( ( ( \<cpnf> \<in> \<real> \<and> A \<in> \<real> ) \<and> \<cpnf> \<lsr> A ) )" by (rule MMI_intnanr)
   have S6: "\<cpnf> \<noteq> \<cmnf>" by (rule MMI_pnfnemnf)
   have S7: "\<cpnf> \<noteq> \<cmnf> \<longleftrightarrow> \<not> ( \<cpnf> = \<cmnf> )" by (rule MMI_df_ne)
   from S6 S7 have S8: "\<not> ( \<cpnf> = \<cmnf> )" by (rule MMI_mpbi)
   from S8 have S9: "\<not> ( ( \<cpnf> = \<cmnf> \<and> A = \<cpnf> ) )" by (rule MMI_intnanr)
   from S5 S9 have S10: "\<not> ( ( ( ( \<cpnf> \<in> \<real> \<and> A \<in> \<real> ) \<and> \<cpnf> \<lsr> A ) \<or> ( \<cpnf> = \<cmnf> \<and> A = \<cpnf> ) ) )" by (rule MMI_pm3_2ni)
   from S3 have S11: "\<not> ( \<cpnf> \<in> \<real> )" .
   from S11 have S12: "\<not> ( ( \<cpnf> \<in> \<real> \<and> A = \<cpnf> ) )" by (rule MMI_intnanr)
   from S8 have S13: "\<not> ( \<cpnf> = \<cmnf> )" .
   from S13 have S14: "\<not> ( ( \<cpnf> = \<cmnf> \<and> A \<in> \<real> ) )" by (rule MMI_intnanr)
   from S12 S14 have S15: "\<not> ( ( ( \<cpnf> \<in> \<real> \<and> A = \<cpnf> ) \<or> ( \<cpnf> = \<cmnf> \<and> A \<in> \<real> ) ) )" by (rule MMI_pm3_2ni)
   from S10 S15 have S16: "\<not> ( ( ( ( ( \<cpnf> \<in> \<real> \<and> A \<in> \<real> ) \<and> \<cpnf> \<lsr> A ) \<or> ( \<cpnf> = \<cmnf> \<and> A = \<cpnf> ) ) \<or> ( ( \<cpnf> \<in> \<real> \<and> A = \<cpnf> ) \<or> ( \<cpnf> = \<cmnf> \<and> A \<in> \<real> ) ) ) )" by (rule MMI_pm3_2ni)
   have S17: "\<cpnf> \<in> \<real>\<^isup>*" by (rule MMI_pnfxr)
   have S18: "( \<cpnf> \<in> \<real>\<^isup>* \<and> A \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( \<cpnf> \<ls> A \<longleftrightarrow>   
 ( ( ( ( \<cpnf> \<in> \<real> \<and> A \<in> \<real> ) \<and> \<cpnf> \<lsr> A ) \<or> ( \<cpnf> = \<cmnf> \<and> A = \<cpnf> ) ) \<or> ( ( \<cpnf> \<in> \<real> \<and> A = \<cpnf> ) \<or> ( \<cpnf> = \<cmnf> \<and> A \<in> \<real> ) ) ) )" by (rule MMI_ltxrt)
   from S17 S18 have S19: "A \<in> \<real>\<^isup>* \<longrightarrow>   
 ( \<cpnf> \<ls> A \<longleftrightarrow>   
 ( ( ( ( \<cpnf> \<in> \<real> \<and> A \<in> \<real> ) \<and> \<cpnf> \<lsr> A ) \<or> ( \<cpnf> = \<cmnf> \<and> A = \<cpnf> ) ) \<or> ( ( \<cpnf> \<in> \<real> \<and> A = \<cpnf> ) \<or> ( \<cpnf> = \<cmnf> \<and> A \<in> \<real> ) ) ) )" by (rule MMI_mpan)
   from S16 S19 show "A \<in> \<real>\<^isup>* \<longrightarrow> \<not> ( \<cpnf> \<ls> A )" by (rule MMI_mtbiri)
qed

lemma (in MMIsar0) MMI_nltmnft: 
   shows "A \<in> \<real>\<^isup>* \<longrightarrow> \<not> ( A \<ls> \<cmnf> )"
proof -
   have S1: "\<cmnf> \<notin> \<real>" by (rule MMI_minfnre)
   have S2: "\<cmnf> \<notin> \<real> \<longleftrightarrow> \<not> ( \<cmnf> \<in> \<real> )" by (rule MMI_df_nel)
   from S1 S2 have S3: "\<not> ( \<cmnf> \<in> \<real> )" by (rule MMI_mpbi)
   from S3 have S4: "\<not> ( ( A \<in> \<real> \<and> \<cmnf> \<in> \<real> ) )" by (rule MMI_intnan)
   from S4 have S5: "\<not> ( ( ( A \<in> \<real> \<and> \<cmnf> \<in> \<real> ) \<and> A \<lsr> \<cmnf> ) )" by (rule MMI_intnanr)
   have S6: "\<cpnf> \<noteq> \<cmnf>" by (rule MMI_pnfnemnf)
   have S7: "\<cpnf> \<noteq> \<cmnf> \<longleftrightarrow> \<cmnf> \<noteq> \<cpnf>" by (rule MMI_necom)
   from S6 S7 have S8: "\<cmnf> \<noteq> \<cpnf>" by (rule MMI_mpbi)
   have S9: "\<cmnf> \<noteq> \<cpnf> \<longleftrightarrow> \<not> ( \<cmnf> = \<cpnf> )" by (rule MMI_df_ne)
   from S8 S9 have S10: "\<not> ( \<cmnf> = \<cpnf> )" by (rule MMI_mpbi)
   from S10 have S11: "\<not> ( ( A = \<cmnf> \<and> \<cmnf> = \<cpnf> ) )" by (rule MMI_intnan)
   from S5 S11 have S12: "\<not> ( ( ( ( A \<in> \<real> \<and> \<cmnf> \<in> \<real> ) \<and> A \<lsr> \<cmnf> ) \<or> ( A = \<cmnf> \<and> \<cmnf> = \<cpnf> ) ) )" by (rule MMI_pm3_2ni)
   from S10 have S13: "\<not> ( \<cmnf> = \<cpnf> )" .
   from S13 have S14: "\<not> ( ( A \<in> \<real> \<and> \<cmnf> = \<cpnf> ) )" by (rule MMI_intnan)
   from S3 have S15: "\<not> ( \<cmnf> \<in> \<real> )" .
   from S15 have S16: "\<not> ( ( A = \<cmnf> \<and> \<cmnf> \<in> \<real> ) )" by (rule MMI_intnan)
   from S14 S16 have S17: "\<not> ( ( ( A \<in> \<real> \<and> \<cmnf> = \<cpnf> ) \<or> ( A = \<cmnf> \<and> \<cmnf> \<in> \<real> ) ) )" by (rule MMI_pm3_2ni)
   from S12 S17 have S18: "\<not> ( ( ( ( ( A \<in> \<real> \<and> \<cmnf> \<in> \<real> ) \<and> A \<lsr> \<cmnf> ) \<or> ( A = \<cmnf> \<and> \<cmnf> = \<cpnf> ) ) \<or> ( ( A \<in> \<real> \<and> \<cmnf> = \<cpnf> ) \<or> ( A = \<cmnf> \<and> \<cmnf> \<in> \<real> ) ) ) )" by (rule MMI_pm3_2ni)
   have S19: "\<cmnf> \<in> \<real>\<^isup>*" by (rule MMI_mnfxr)
   have S20: "( A \<in> \<real>\<^isup>* \<and> \<cmnf> \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( A \<ls> \<cmnf> \<longleftrightarrow>   
 ( ( ( ( A \<in> \<real> \<and> \<cmnf> \<in> \<real> ) \<and> A \<lsr> \<cmnf> ) \<or> ( A = \<cmnf> \<and> \<cmnf> = \<cpnf> ) ) \<or> ( ( A \<in> \<real> \<and> \<cmnf> = \<cpnf> ) \<or> ( A = \<cmnf> \<and> \<cmnf> \<in> \<real> ) ) ) )" by (rule MMI_ltxrt)
   from S19 S20 have S21: "A \<in> \<real>\<^isup>* \<longrightarrow>   
 ( A \<ls> \<cmnf> \<longleftrightarrow>   
 ( ( ( ( A \<in> \<real> \<and> \<cmnf> \<in> \<real> ) \<and> A \<lsr> \<cmnf> ) \<or> ( A = \<cmnf> \<and> \<cmnf> = \<cpnf> ) ) \<or> ( ( A \<in> \<real> \<and> \<cmnf> = \<cpnf> ) \<or> ( A = \<cmnf> \<and> \<cmnf> \<in> \<real> ) ) ) )" by (rule MMI_mpan2)
   from S18 S21 show "A \<in> \<real>\<^isup>* \<longrightarrow> \<not> ( A \<ls> \<cmnf> )" by (rule MMI_mtbiri)
qed

lemma (in MMIsar0) MMI_pnfget: 
   shows "A \<in> \<real>\<^isup>* \<longrightarrow> A \<lsq> \<cpnf>"
proof -
   have S1: "A \<in> \<real>\<^isup>* \<longrightarrow> \<not> ( \<cpnf> \<ls> A )" by (rule MMI_pnfnltt)
   have S2: "\<cpnf> \<in> \<real>\<^isup>*" by (rule MMI_pnfxr)
   have S3: "( A \<in> \<real>\<^isup>* \<and> \<cpnf> \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( A \<lsq> \<cpnf> \<longleftrightarrow> \<not> ( \<cpnf> \<ls> A ) )" by (rule MMI_xrlenltt)
   from S2 S3 have S4: "A \<in> \<real>\<^isup>* \<longrightarrow> ( A \<lsq> \<cpnf> \<longleftrightarrow> \<not> ( \<cpnf> \<ls> A ) )" by (rule MMI_mpan2)
   from S1 S4 show "A \<in> \<real>\<^isup>* \<longrightarrow> A \<lsq> \<cpnf>" by (rule MMI_mpbird)
qed;

(***********271-280*********************************)

lemma (in MMIsar0) MMI_mnflet: 
   shows "A \<in> \<real>\<^isup>* \<longrightarrow> \<cmnf> \<lsq> A"
proof -
   have S1: "A \<in> \<real>\<^isup>* \<longrightarrow> \<not> ( A \<ls> \<cmnf> )" by (rule MMI_nltmnft)
   have S2: "\<cmnf> \<in> \<real>\<^isup>*" by (rule MMI_mnfxr)
   have S3: "( \<cmnf> \<in> \<real>\<^isup>* \<and> A \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( \<cmnf> \<lsq> A \<longleftrightarrow> \<not> ( A \<ls> \<cmnf> ) )" by (rule MMI_xrlenltt)
   from S2 S3 have S4: "A \<in> \<real>\<^isup>* \<longrightarrow> ( \<cmnf> \<lsq> A \<longleftrightarrow> \<not> ( A \<ls> \<cmnf> ) )" by (rule MMI_mpan)
   from S1 S4 show "A \<in> \<real>\<^isup>* \<longrightarrow> \<cmnf> \<lsq> A" by (rule MMI_mpbird)
qed

lemma (in MMIsar0) MMI_xrltnsymt: 
   shows "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( A \<ls> B \<longrightarrow> \<not> ( B \<ls> A ) )"
proof -
   have S1: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A \<ls> B \<longrightarrow> \<not> ( B \<ls> A ) )" by (rule MMI_ltnsymt)
   have S2: "A \<in> \<real> \<longrightarrow> A \<in> \<real>\<^isup>*" by (rule MMI_rexrt)
   have S3: "A \<in> \<real>\<^isup>* \<longrightarrow> \<not> ( \<cpnf> \<ls> A )" by (rule MMI_pnfnltt)
   from S2 S3 have S4: "A \<in> \<real> \<longrightarrow> \<not> ( \<cpnf> \<ls> A )" by (rule MMI_syl)
   from S4 have S5: "( A \<in> \<real> \<and> B = \<cpnf> ) \<longrightarrow> \<not> ( \<cpnf> \<ls> A )" by (rule MMI_adantr)
   have S6: "B = \<cpnf> \<longrightarrow> ( B \<ls> A \<longleftrightarrow> \<cpnf> \<ls> A )" by (rule MMI_breq1)
   from S6 have S7: "( A \<in> \<real> \<and> B = \<cpnf> ) \<longrightarrow> ( B \<ls> A \<longleftrightarrow> \<cpnf> \<ls> A )" by (rule MMI_adantl)
   from S5 S7 have S8: "( A \<in> \<real> \<and> B = \<cpnf> ) \<longrightarrow> \<not> ( B \<ls> A )" by (rule MMI_mtbird)
   from S8 have S9: "( A \<in> \<real> \<and> B =   
 \<cpnf> ) \<longrightarrow> ( A \<ls> B \<longrightarrow> \<not> ( B \<ls> A ) )" by (rule MMI_a1d)
   from S2 have S10: "A \<in> \<real> \<longrightarrow> A \<in> \<real>\<^isup>*" .
   have S11: "A \<in> \<real>\<^isup>* \<longrightarrow> \<not> ( A \<ls> \<cmnf> )" by (rule MMI_nltmnft)
   from S10 S11 have S12: "A \<in> \<real> \<longrightarrow> \<not> ( A \<ls> \<cmnf> )" by (rule MMI_syl)
   from S12 have S13: "( A \<in> \<real> \<and> B = \<cmnf> ) \<longrightarrow> \<not> ( A \<ls> \<cmnf> )" by (rule MMI_adantr)
   have S14: "B = \<cmnf> \<longrightarrow> ( A \<ls> B \<longleftrightarrow> A \<ls> \<cmnf> )" by (rule MMI_breq2)
   from S14 have S15: "( A \<in> \<real> \<and> B = \<cmnf> ) \<longrightarrow> ( A \<ls> B \<longleftrightarrow> A \<ls> \<cmnf> )" by (rule MMI_adantl)
   from S13 S15 have S16: "( A \<in> \<real> \<and> B = \<cmnf> ) \<longrightarrow> \<not> ( A \<ls> B )" by (rule MMI_mtbird)
   from S16 have S17: "( A \<in> \<real> \<and> B =   
 \<cmnf> ) \<longrightarrow> ( A \<ls> B \<longrightarrow> \<not> ( B \<ls> A ) )" by (rule MMI_pm2_21d)
   from S1 S9 S17 have S18: "( A \<in> \<real> \<and> ( B \<in> \<real> \<or> B = \<cpnf> \<or> B = \<cmnf> ) ) \<longrightarrow>   
 ( A \<ls> B \<longrightarrow> \<not> ( B \<ls> A ) )" by (rule MMI_3jaodan)
   have S19: "B \<in> \<real>\<^isup>* \<longrightarrow> \<not> ( \<cpnf> \<ls> B )" by (rule MMI_pnfnltt)
   from S19 have S20: "( A = \<cpnf> \<and> B \<in> \<real>\<^isup>* ) \<longrightarrow> \<not> ( \<cpnf> \<ls> B )" by (rule MMI_adantl)
   have S21: "A = \<cpnf> \<longrightarrow> ( A \<ls> B \<longleftrightarrow> \<cpnf> \<ls> B )" by (rule MMI_breq1)
   from S21 have S22: "( A = \<cpnf> \<and> B \<in> \<real>\<^isup>* ) \<longrightarrow> ( A \<ls> B \<longleftrightarrow> \<cpnf> \<ls> B )" by (rule MMI_adantr)
   from S20 S22 have S23: "( A = \<cpnf> \<and> B \<in> \<real>\<^isup>* ) \<longrightarrow> \<not> ( A \<ls> B )" by (rule MMI_mtbird)
   from S23 have S24: "( A =   
 \<cpnf> \<and> B \<in> \<real>\<^isup>* ) \<longrightarrow> ( A \<ls> B \<longrightarrow> \<not> ( B \<ls> A ) )" by (rule MMI_pm2_21d)
   have S25: "B \<in> \<real>\<^isup>* \<longleftrightarrow> ( B \<in> \<real> \<or> B = \<cpnf> \<or> B = \<cmnf> )" by (rule MMI_elxr)
   from S24 S25 have S26: "( A =   
 \<cpnf> \<and> ( B \<in> \<real> \<or> B =   
 \<cpnf> \<or> B =   
 \<cmnf> ) ) \<longrightarrow> ( A \<ls> B \<longrightarrow> \<not> ( B \<ls> A ) )" by (rule MMI_sylan2br)
   have S27: "B \<in> \<real> \<longrightarrow> B \<in> \<real>\<^isup>*" by (rule MMI_rexrt)
   have S28: "B \<in> \<real>\<^isup>* \<longrightarrow> \<not> ( B \<ls> \<cmnf> )" by (rule MMI_nltmnft)
   from S27 S28 have S29: "B \<in> \<real> \<longrightarrow> \<not> ( B \<ls> \<cmnf> )" by (rule MMI_syl)
   from S29 have S30: "( A = \<cmnf> \<and> B \<in> \<real> ) \<longrightarrow> \<not> ( B \<ls> \<cmnf> )" by (rule MMI_adantl)
   have S31: "A = \<cmnf> \<longrightarrow> ( B \<ls> A \<longleftrightarrow> B \<ls> \<cmnf> )" by (rule MMI_breq2)
   from S31 have S32: "( A = \<cmnf> \<and> B \<in> \<real> ) \<longrightarrow> ( B \<ls> A \<longleftrightarrow> B \<ls> \<cmnf> )" by (rule MMI_adantr)
   from S30 S32 have S33: "( A = \<cmnf> \<and> B \<in> \<real> ) \<longrightarrow> \<not> ( B \<ls> A )" by (rule MMI_mtbird)
   from S33 have S34: "( A =   
 \<cmnf> \<and> B \<in> \<real> ) \<longrightarrow> ( A \<ls> B \<longrightarrow> \<not> ( B \<ls> A ) )" by (rule MMI_a1d)
   have S35: "\<cmnf> \<in> \<real>\<^isup>*" by (rule MMI_mnfxr)
   have S36: "\<cmnf> \<in> \<real>\<^isup>* \<longrightarrow> \<not> ( \<cpnf> \<ls> \<cmnf> )" by (rule MMI_pnfnltt)
   from S35 S36 have S37: "\<not> ( \<cpnf> \<ls> \<cmnf> )" by (rule MMI_ax_mp)
   have S38: "( B = \<cpnf> \<and> A = \<cmnf> ) \<longrightarrow> ( B \<ls> A \<longleftrightarrow> \<cpnf> \<ls> \<cmnf> )" by (rule MMI_breq12)
   from S37 S38 have S39: "( B = \<cpnf> \<and> A = \<cmnf> ) \<longrightarrow> \<not> ( B \<ls> A )" by (rule MMI_mtbiri)
   from S39 have S40: "( A = \<cmnf> \<and> B = \<cpnf> ) \<longrightarrow> \<not> ( B \<ls> A )" by (rule MMI_ancoms)
   from S40 have S41: "( A =   
 \<cmnf> \<and> B = \<cpnf> ) \<longrightarrow> ( A \<ls> B \<longrightarrow> \<not> ( B \<ls> A ) )" by (rule MMI_a1d)
   have S42: "\<cmnf> \<in> \<real>\<^isup>*" by (rule MMI_mnfxr)
   have S43: "\<cmnf> \<in> \<real>\<^isup>* \<longrightarrow> \<not> ( \<cmnf> \<ls> \<cmnf> )" by (rule MMI_xrltnrt)
   from S42 S43 have S44: "\<not> ( \<cmnf> \<ls> \<cmnf> )" by (rule MMI_ax_mp)
   have S45: "( A = \<cmnf> \<and> B = \<cmnf> ) \<longrightarrow> ( A \<ls> B \<longleftrightarrow> \<cmnf> \<ls> \<cmnf> )" by (rule MMI_breq12)
   from S44 S45 have S46: "( A = \<cmnf> \<and> B = \<cmnf> ) \<longrightarrow> \<not> ( A \<ls> B )" by (rule MMI_mtbiri)
   from S46 have S47: "( A =   
 \<cmnf> \<and> B = \<cmnf> ) \<longrightarrow> ( A \<ls> B \<longrightarrow> \<not> ( B \<ls> A ) )" by (rule MMI_pm2_21d)
   from S34 S41 S47 have S48: "( A =   
 \<cmnf> \<and> ( B \<in> \<real> \<or> B =   
 \<cpnf> \<or> B =   
 \<cmnf> ) ) \<longrightarrow> ( A \<ls> B \<longrightarrow> \<not> ( B \<ls> A ) )" by (rule MMI_3jaodan)
   from S18 S26 S48 have S49: "( ( A \<in> \<real> \<or> A = \<cpnf> \<or> A = \<cmnf> ) \<and> ( B \<in> \<real> \<or> B = \<cpnf> \<or> B = \<cmnf> ) ) \<longrightarrow>   
 ( A \<ls> B \<longrightarrow> \<not> ( B \<ls> A ) )" by (rule MMI_3jaoian)
   have S50: "A \<in> \<real>\<^isup>* \<longleftrightarrow> ( A \<in> \<real> \<or> A = \<cpnf> \<or> A = \<cmnf> )" by (rule MMI_elxr)
   from S25 have S51: "B \<in> \<real>\<^isup>* \<longleftrightarrow> ( B \<in> \<real> \<or> B = \<cpnf> \<or> B = \<cmnf> )" .
   from S49 S50 S51 show "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( A \<ls> B \<longrightarrow> \<not> ( B \<ls> A ) )" by (rule MMI_syl2anb)
qed

lemma (in MMIsar0) MMI_xrlttrit: 
   shows "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( A \<ls> B \<longleftrightarrow> \<not> ( ( A = B \<or> B \<ls> A ) ) )"
proof -
   have S1: "A \<in> \<real>\<^isup>* \<longrightarrow> \<not> ( A \<ls> A )" by (rule MMI_xrltnrt)
   from S1 have S2: "( A \<in> \<real>\<^isup>* \<and> A = B ) \<longrightarrow> \<not> ( A \<ls> A )" by (rule MMI_adantr)
   have S3: "A = B \<longrightarrow> ( A \<ls> A \<longleftrightarrow> A \<ls> B )" by (rule MMI_breq2)
   from S3 have S4: "( A \<in> \<real>\<^isup>* \<and> A = B ) \<longrightarrow> ( A \<ls> A \<longleftrightarrow> A \<ls> B )" by (rule MMI_adantl)
   from S2 S4 have S5: "( A \<in> \<real>\<^isup>* \<and> A = B ) \<longrightarrow> \<not> ( A \<ls> B )" by (rule MMI_mtbid)
   from S5 have S6: "A \<in> \<real>\<^isup>* \<longrightarrow> ( A = B \<longrightarrow> \<not> ( A \<ls> B ) )" by (rule MMI_ex)
   from S6 have S7: "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( A = B \<longrightarrow> \<not> ( A \<ls> B ) )" by (rule MMI_adantr)
   have S8: "( B \<in> \<real>\<^isup>* \<and> A \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( B \<ls> A \<longrightarrow> \<not> ( A \<ls> B ) )" by (rule MMI_xrltnsymt)
   from S8 have S9: "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( B \<ls> A \<longrightarrow> \<not> ( A \<ls> B ) )" by (rule MMI_ancoms)
   from S7 S9 have S10: "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( ( A = B \<or> B \<ls> A ) \<longrightarrow> \<not> ( A \<ls> B ) )" by (rule MMI_jaod)
   have S11: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A \<ls> B \<longleftrightarrow> \<not> ( ( A = B \<or> B \<ls> A ) ) )" by (rule MMI_axlttri)
   from S11 have S12: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( \<not> ( ( A = B \<or> B \<ls> A ) ) \<longrightarrow> A \<ls> B )" by (rule MMI_biimprd)
   from S12 have S13: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( \<not> ( A \<ls> B ) \<longrightarrow> ( A = B \<or> B \<ls> A ) )" by (rule MMI_con1d)
   have S14: "A \<in> \<real> \<longrightarrow> A \<ls> \<cpnf>" by (rule MMI_ltpnft)
   from S14 have S15: "( A \<in> \<real> \<and> B = \<cpnf> ) \<longrightarrow> A \<ls> \<cpnf>" by (rule MMI_adantr)
   have S16: "B = \<cpnf> \<longrightarrow> ( A \<ls> B \<longleftrightarrow> A \<ls> \<cpnf> )" by (rule MMI_breq2)
   from S16 have S17: "( A \<in> \<real> \<and> B = \<cpnf> ) \<longrightarrow> ( A \<ls> B \<longleftrightarrow> A \<ls> \<cpnf> )" by (rule MMI_adantl)
   from S15 S17 have S18: "( A \<in> \<real> \<and> B = \<cpnf> ) \<longrightarrow> A \<ls> B" by (rule MMI_mpbird)
   from S18 have S19: "( A \<in> \<real> \<and> B =   
 \<cpnf> ) \<longrightarrow>   
 ( \<not> ( A \<ls> B ) \<longrightarrow> ( A = B \<or> B \<ls> A ) )" by (rule MMI_pm2_21nd)
   have S20: "A \<in> \<real> \<longrightarrow> \<cmnf> \<ls> A" by (rule MMI_mnfltt)
   from S20 have S21: "( A \<in> \<real> \<and> B = \<cmnf> ) \<longrightarrow> \<cmnf> \<ls> A" by (rule MMI_adantr)
   have S22: "B = \<cmnf> \<longrightarrow> ( B \<ls> A \<longleftrightarrow> \<cmnf> \<ls> A )" by (rule MMI_breq1)
   from S22 have S23: "( A \<in> \<real> \<and> B = \<cmnf> ) \<longrightarrow> ( B \<ls> A \<longleftrightarrow> \<cmnf> \<ls> A )" by (rule MMI_adantl)
   from S21 S23 have S24: "( A \<in> \<real> \<and> B = \<cmnf> ) \<longrightarrow> B \<ls> A" by (rule MMI_mpbird)
   have S25: "B \<ls> A \<longrightarrow> ( A = B \<or> B \<ls> A )" by (rule MMI_olc)
   from S24 S25 have S26: "( A \<in> \<real> \<and> B = \<cmnf> ) \<longrightarrow> ( A = B \<or> B \<ls> A )" by (rule MMI_syl)
   from S26 have S27: "( A \<in> \<real> \<and> B =   
 \<cmnf> ) \<longrightarrow>   
 ( \<not> ( A \<ls> B ) \<longrightarrow> ( A = B \<or> B \<ls> A ) )" by (rule MMI_a1d)
   from S13 S19 S27 have S28: "( A \<in> \<real> \<and> ( B \<in> \<real> \<or> B = \<cpnf> \<or> B = \<cmnf> ) ) \<longrightarrow>   
 ( \<not> ( A \<ls> B ) \<longrightarrow> ( A = B \<or> B \<ls> A ) )" by (rule MMI_3jaodan)
   have S29: "B \<in> \<real> \<longrightarrow> B \<ls> \<cpnf>" by (rule MMI_ltpnft)
   from S29 have S30: "( A = \<cpnf> \<and> B \<in> \<real> ) \<longrightarrow> B \<ls> \<cpnf>" by (rule MMI_adantl)
   have S31: "A = \<cpnf> \<longrightarrow> ( B \<ls> A \<longleftrightarrow> B \<ls> \<cpnf> )" by (rule MMI_breq2)
   from S31 have S32: "( A = \<cpnf> \<and> B \<in> \<real> ) \<longrightarrow> ( B \<ls> A \<longleftrightarrow> B \<ls> \<cpnf> )" by (rule MMI_adantr)
   from S30 S32 have S33: "( A = \<cpnf> \<and> B \<in> \<real> ) \<longrightarrow> B \<ls> A" by (rule MMI_mpbird)
   from S25 have S34: "B \<ls> A \<longrightarrow> ( A = B \<or> B \<ls> A )" .
   from S33 S34 have S35: "( A = \<cpnf> \<and> B \<in> \<real> ) \<longrightarrow> ( A = B \<or> B \<ls> A )" by (rule MMI_syl)
   from S35 have S36: "( A =   
 \<cpnf> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( \<not> ( A \<ls> B ) \<longrightarrow> ( A = B \<or> B \<ls> A ) )" by (rule MMI_a1d)
   have S37: "( A = \<cpnf> \<and> B = \<cpnf> ) \<longrightarrow> A = B" by (rule MMI_eqtr3t)
   have S38: "A = B \<longrightarrow> ( A = B \<or> B \<ls> A )" by (rule MMI_orc)
   from S37 S38 have S39: "( A = \<cpnf> \<and> B = \<cpnf> ) \<longrightarrow> ( A = B \<or> B \<ls> A )" by (rule MMI_syl)
   from S39 have S40: "( A =   
 \<cpnf> \<and> B =   
 \<cpnf> ) \<longrightarrow>   
 ( \<not> ( A \<ls> B ) \<longrightarrow> ( A = B \<or> B \<ls> A ) )" by (rule MMI_a1d)
   have S41: "\<cmnf> \<ls> \<cpnf>" by (rule MMI_mnfltpnf)
   have S42: "( B = \<cmnf> \<and> A = \<cpnf> ) \<longrightarrow> ( B \<ls> A \<longleftrightarrow> \<cmnf> \<ls> \<cpnf> )" by (rule MMI_breq12)
   from S41 S42 have S43: "( B = \<cmnf> \<and> A = \<cpnf> ) \<longrightarrow> B \<ls> A" by (rule MMI_mpbiri)
   from S43 have S44: "( A = \<cpnf> \<and> B = \<cmnf> ) \<longrightarrow> B \<ls> A" by (rule MMI_ancoms)
   from S25 have S45: "B \<ls> A \<longrightarrow> ( A = B \<or> B \<ls> A )" .
   from S44 S45 have S46: "( A = \<cpnf> \<and> B = \<cmnf> ) \<longrightarrow> ( A = B \<or> B \<ls> A )" by (rule MMI_syl)
   from S46 have S47: "( A =   
 \<cpnf> \<and> B =   
 \<cmnf> ) \<longrightarrow>   
 ( \<not> ( A \<ls> B ) \<longrightarrow> ( A = B \<or> B \<ls> A ) )" by (rule MMI_a1d)
   from S36 S40 S47 have S48: "( A =   
 \<cpnf> \<and> ( B \<in> \<real> \<or> B =   
 \<cpnf> \<or> B =   
 \<cmnf> ) ) \<longrightarrow>   
 ( \<not> ( A \<ls> B ) \<longrightarrow> ( A = B \<or> B \<ls> A ) )" by (rule MMI_3jaodan)
   have S49: "B \<in> \<real> \<longrightarrow> \<cmnf> \<ls> B" by (rule MMI_mnfltt)
   from S49 have S50: "( A = \<cmnf> \<and> B \<in> \<real> ) \<longrightarrow> \<cmnf> \<ls> B" by (rule MMI_adantl)
   have S51: "A = \<cmnf> \<longrightarrow> ( A \<ls> B \<longleftrightarrow> \<cmnf> \<ls> B )" by (rule MMI_breq1)
   from S51 have S52: "( A = \<cmnf> \<and> B \<in> \<real> ) \<longrightarrow> ( A \<ls> B \<longleftrightarrow> \<cmnf> \<ls> B )" by (rule MMI_adantr)
   from S50 S52 have S53: "( A = \<cmnf> \<and> B \<in> \<real> ) \<longrightarrow> A \<ls> B" by (rule MMI_mpbird)
   from S53 have S54: "( A =   
 \<cmnf> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( \<not> ( A \<ls> B ) \<longrightarrow> ( A = B \<or> B \<ls> A ) )" by (rule MMI_pm2_21nd)
   have S55: "\<cmnf> \<ls> \<cpnf>" by (rule MMI_mnfltpnf)
   have S56: "( A = \<cmnf> \<and> B = \<cpnf> ) \<longrightarrow> ( A \<ls> B \<longleftrightarrow> \<cmnf> \<ls> \<cpnf> )" by (rule MMI_breq12)
   from S55 S56 have S57: "( A = \<cmnf> \<and> B = \<cpnf> ) \<longrightarrow> A \<ls> B" by (rule MMI_mpbiri)
   from S57 have S58: "( A =   
 \<cmnf> \<and> B =   
 \<cpnf> ) \<longrightarrow>   
 ( \<not> ( A \<ls> B ) \<longrightarrow> ( A = B \<or> B \<ls> A ) )" by (rule MMI_pm2_21nd)
   have S59: "( A = \<cmnf> \<and> B = \<cmnf> ) \<longrightarrow> A = B" by (rule MMI_eqtr3t)
   from S38 have S60: "A = B \<longrightarrow> ( A = B \<or> B \<ls> A )" .
   from S59 S60 have S61: "( A = \<cmnf> \<and> B = \<cmnf> ) \<longrightarrow> ( A = B \<or> B \<ls> A )" by (rule MMI_syl)
   from S61 have S62: "( A =   
 \<cmnf> \<and> B =   
 \<cmnf> ) \<longrightarrow>   
 ( \<not> ( A \<ls> B ) \<longrightarrow> ( A = B \<or> B \<ls> A ) )" by (rule MMI_a1d)
   from S54 S58 S62 have S63: "( A =   
 \<cmnf> \<and> ( B \<in> \<real> \<or> B =   
 \<cpnf> \<or> B =   
 \<cmnf> ) ) \<longrightarrow>   
 ( \<not> ( A \<ls> B ) \<longrightarrow> ( A = B \<or> B \<ls> A ) )" by (rule MMI_3jaodan)
   from S28 S48 S63 have S64: "( ( A \<in> \<real> \<or> A = \<cpnf> \<or> A = \<cmnf> ) \<and> ( B \<in> \<real> \<or> B = \<cpnf> \<or> B = \<cmnf> ) ) \<longrightarrow>   
 ( \<not> ( A \<ls> B ) \<longrightarrow> ( A = B \<or> B \<ls> A ) )" by (rule MMI_3jaoian)
   have S65: "A \<in> \<real>\<^isup>* \<longleftrightarrow> ( A \<in> \<real> \<or> A = \<cpnf> \<or> A = \<cmnf> )" by (rule MMI_elxr)
   have S66: "B \<in> \<real>\<^isup>* \<longleftrightarrow> ( B \<in> \<real> \<or> B = \<cpnf> \<or> B = \<cmnf> )" by (rule MMI_elxr)
   from S64 S65 S66 have S67: "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( \<not> ( A \<ls> B ) \<longrightarrow> ( A = B \<or> B \<ls> A ) )" by (rule MMI_syl2anb)
   from S10 S67 have S68: "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( ( A = B \<or> B \<ls> A ) \<longleftrightarrow> \<not> ( A \<ls> B ) )" by (rule MMI_impbid)
   from S68 show "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( A \<ls> B \<longleftrightarrow> \<not> ( ( A = B \<or> B \<ls> A ) ) )" by (rule MMI_con2bid)
qed

lemma (in MMIsar0) MMI_xrlttrt: 
   shows "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* \<and> C \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( ( A \<ls> B \<and> B \<ls> C ) \<longrightarrow> A \<ls> C )"
proof -
   have S1: "( A \<in> \<real> \<and> B \<in> \<real> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( ( A \<ls> B \<and> B \<ls> C ) \<longrightarrow> A \<ls> C )" by (rule MMI_axlttrn)
   from S1 have S2: "( ( A \<in> \<real> \<and> B \<in> \<real> ) \<and> C \<in> \<real> ) \<longrightarrow>   
 ( ( A \<ls> B \<and> B \<ls> C ) \<longrightarrow> A \<ls> C )" by (rule MMI_3expa)
   from S2 have S3: "( ( A \<in> \<real> \<and> C \<in> \<real> ) \<and> B \<in> \<real> ) \<longrightarrow>   
 ( ( A \<ls> B \<and> B \<ls> C ) \<longrightarrow> A \<ls> C )" by (rule MMI_an1rs)
   have S4: "C \<in> \<real> \<longrightarrow> C \<in> \<real>\<^isup>*" by (rule MMI_rexrt)
   have S5: "C \<in> \<real>\<^isup>* \<longrightarrow> \<not> ( \<cpnf> \<ls> C )" by (rule MMI_pnfnltt)
   from S4 S5 have S6: "C \<in> \<real> \<longrightarrow> \<not> ( \<cpnf> \<ls> C )" by (rule MMI_syl)
   from S6 have S7: "( C \<in> \<real> \<and> B = \<cpnf> ) \<longrightarrow> \<not> ( \<cpnf> \<ls> C )" by (rule MMI_adantr)
   have S8: "B = \<cpnf> \<longrightarrow> ( B \<ls> C \<longleftrightarrow> \<cpnf> \<ls> C )" by (rule MMI_breq1)
   from S8 have S9: "( C \<in> \<real> \<and> B = \<cpnf> ) \<longrightarrow> ( B \<ls> C \<longleftrightarrow> \<cpnf> \<ls> C )" by (rule MMI_adantl)
   from S7 S9 have S10: "( C \<in> \<real> \<and> B = \<cpnf> ) \<longrightarrow> \<not> ( B \<ls> C )" by (rule MMI_mtbird)
   from S10 have S11: "( C \<in> \<real> \<and> B = \<cpnf> ) \<longrightarrow> ( B \<ls> C \<longrightarrow> A \<ls> C )" by (rule MMI_pm2_21d)
   from S11 have S12: "( ( A \<in> \<real> \<and> C \<in> \<real> ) \<and> B =   
 \<cpnf> ) \<longrightarrow> ( B \<ls> C \<longrightarrow> A \<ls> C )" by (rule MMI_adantll)
   from S12 have S13: "( ( A \<in> \<real> \<and> C \<in> \<real> ) \<and> B =   
 \<cpnf> ) \<longrightarrow> ( ( A \<ls> B \<and> B \<ls> C ) \<longrightarrow> A \<ls> C )" by (rule MMI_adantld)
   have S14: "A \<in> \<real> \<longrightarrow> A \<in> \<real>\<^isup>*" by (rule MMI_rexrt)
   have S15: "A \<in> \<real>\<^isup>* \<longrightarrow> \<not> ( A \<ls> \<cmnf> )" by (rule MMI_nltmnft)
   from S14 S15 have S16: "A \<in> \<real> \<longrightarrow> \<not> ( A \<ls> \<cmnf> )" by (rule MMI_syl)
   from S16 have S17: "( A \<in> \<real> \<and> B = \<cmnf> ) \<longrightarrow> \<not> ( A \<ls> \<cmnf> )" by (rule MMI_adantr)
   have S18: "B = \<cmnf> \<longrightarrow> ( A \<ls> B \<longleftrightarrow> A \<ls> \<cmnf> )" by (rule MMI_breq2)
   from S18 have S19: "( A \<in> \<real> \<and> B = \<cmnf> ) \<longrightarrow> ( A \<ls> B \<longleftrightarrow> A \<ls> \<cmnf> )" by (rule MMI_adantl)
   from S17 S19 have S20: "( A \<in> \<real> \<and> B = \<cmnf> ) \<longrightarrow> \<not> ( A \<ls> B )" by (rule MMI_mtbird)
   from S20 have S21: "( A \<in> \<real> \<and> B = \<cmnf> ) \<longrightarrow> ( A \<ls> B \<longrightarrow> A \<ls> C )" by (rule MMI_pm2_21d)
   from S21 have S22: "( ( A \<in> \<real> \<and> C \<in> \<real> ) \<and> B =   
 \<cmnf> ) \<longrightarrow> ( A \<ls> B \<longrightarrow> A \<ls> C )" by (rule MMI_adantlr)
   from S22 have S23: "( ( A \<in> \<real> \<and> C \<in> \<real> ) \<and> B =   
 \<cmnf> ) \<longrightarrow> ( ( A \<ls> B \<and> B \<ls> C ) \<longrightarrow> A \<ls> C )" by (rule MMI_adantrd)
   from S3 S13 S23 have S24: "( ( A \<in> \<real> \<and> C \<in> \<real> ) \<and> ( B \<in> \<real> \<or> B = \<cpnf> \<or> B = \<cmnf> ) ) \<longrightarrow>   
 ( ( A \<ls> B \<and> B \<ls> C ) \<longrightarrow> A \<ls> C )" by (rule MMI_3jaodan)
   have S25: "B \<in> \<real>\<^isup>* \<longleftrightarrow> ( B \<in> \<real> \<or> B = \<cpnf> \<or> B = \<cmnf> )" by (rule MMI_elxr)
   from S24 S25 have S26: "( ( A \<in> \<real> \<and> C \<in> \<real> ) \<and> B \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( ( A \<ls> B \<and> B \<ls> C ) \<longrightarrow> A \<ls> C )" by (rule MMI_sylan2b)
   from S26 have S27: "( ( A \<in> \<real> \<and> B \<in> \<real>\<^isup>* ) \<and> C \<in> \<real> ) \<longrightarrow>   
 ( ( A \<ls> B \<and> B \<ls> C ) \<longrightarrow> A \<ls> C )" by (rule MMI_an1rs)
   have S28: "A \<in> \<real> \<longrightarrow> A \<ls> \<cpnf>" by (rule MMI_ltpnft)
   from S28 have S29: "( A \<in> \<real> \<and> C = \<cpnf> ) \<longrightarrow> A \<ls> \<cpnf>" by (rule MMI_adantr)
   have S30: "C = \<cpnf> \<longrightarrow> ( A \<ls> C \<longleftrightarrow> A \<ls> \<cpnf> )" by (rule MMI_breq2)
   from S30 have S31: "( A \<in> \<real> \<and> C = \<cpnf> ) \<longrightarrow> ( A \<ls> C \<longleftrightarrow> A \<ls> \<cpnf> )" by (rule MMI_adantl)
   from S29 S31 have S32: "( A \<in> \<real> \<and> C = \<cpnf> ) \<longrightarrow> A \<ls> C" by (rule MMI_mpbird)
   from S32 have S33: "( ( A \<in> \<real> \<and> B \<in> \<real>\<^isup>* ) \<and> C = \<cpnf> ) \<longrightarrow> A \<ls> C" by (rule MMI_adantlr)
   from S33 have S34: "( ( A \<in> \<real> \<and> B \<in> \<real>\<^isup>* ) \<and> C =   
 \<cpnf> ) \<longrightarrow> ( ( A \<ls> B \<and> B \<ls> C ) \<longrightarrow> A \<ls> C )" by (rule MMI_a1d)
   have S35: "B \<in> \<real>\<^isup>* \<longrightarrow> \<not> ( B \<ls> \<cmnf> )" by (rule MMI_nltmnft)
   from S35 have S36: "( B \<in> \<real>\<^isup>* \<and> C = \<cmnf> ) \<longrightarrow> \<not> ( B \<ls> \<cmnf> )" by (rule MMI_adantr)
   have S37: "C = \<cmnf> \<longrightarrow> ( B \<ls> C \<longleftrightarrow> B \<ls> \<cmnf> )" by (rule MMI_breq2)
   from S37 have S38: "( B \<in> \<real>\<^isup>* \<and> C = \<cmnf> ) \<longrightarrow> ( B \<ls> C \<longleftrightarrow> B \<ls> \<cmnf> )" by (rule MMI_adantl)
   from S36 S38 have S39: "( B \<in> \<real>\<^isup>* \<and> C = \<cmnf> ) \<longrightarrow> \<not> ( B \<ls> C )" by (rule MMI_mtbird)
   from S39 have S40: "( B \<in> \<real>\<^isup>* \<and> C = \<cmnf> ) \<longrightarrow> ( B \<ls> C \<longrightarrow> A \<ls> C )" by (rule MMI_pm2_21d)
   from S40 have S41: "( B \<in> \<real>\<^isup>* \<and> C =   
 \<cmnf> ) \<longrightarrow> ( ( A \<ls> B \<and> B \<ls> C ) \<longrightarrow> A \<ls> C )" by (rule MMI_adantld)
   from S41 have S42: "( ( A \<in> \<real> \<and> B \<in> \<real>\<^isup>* ) \<and> C =   
 \<cmnf> ) \<longrightarrow> ( ( A \<ls> B \<and> B \<ls> C ) \<longrightarrow> A \<ls> C )" by (rule MMI_adantll)
   from S27 S34 S42 have S43: "( ( A \<in> \<real> \<and> B \<in> \<real>\<^isup>* ) \<and> ( C \<in> \<real> \<or> C = \<cpnf> \<or> C = \<cmnf> ) ) \<longrightarrow>   
 ( ( A \<ls> B \<and> B \<ls> C ) \<longrightarrow> A \<ls> C )" by (rule MMI_3jaodan)
   from S43 have S44: "( A \<in> \<real> \<and> ( B \<in> \<real>\<^isup>* \<and> ( C \<in> \<real> \<or> C = \<cpnf> \<or> C = \<cmnf> ) ) ) \<longrightarrow>   
 ( ( A \<ls> B \<and> B \<ls> C ) \<longrightarrow> A \<ls> C )" by (rule MMI_anasss)
   have S45: "B \<in> \<real>\<^isup>* \<longrightarrow> \<not> ( \<cpnf> \<ls> B )" by (rule MMI_pnfnltt)
   from S45 have S46: "( A = \<cpnf> \<and> B \<in> \<real>\<^isup>* ) \<longrightarrow> \<not> ( \<cpnf> \<ls> B )" by (rule MMI_adantl)
   have S47: "A = \<cpnf> \<longrightarrow> ( A \<ls> B \<longleftrightarrow> \<cpnf> \<ls> B )" 
     by (rule MMI_breq1)
   from S47 have S48: "( A = \<cpnf> \<and> B \<in> \<real>\<^isup>* ) \<longrightarrow> ( A \<ls> B \<longleftrightarrow> \<cpnf> \<ls> B )" by (rule MMI_adantr)
   from S46 S48 have S49: "( A = \<cpnf> \<and> B \<in> \<real>\<^isup>* ) \<longrightarrow> \<not> ( A \<ls> B )" 
     by (rule MMI_mtbird)
   from S49 have S50: "( A = \<cpnf> \<and> B \<in> \<real>\<^isup>* ) \<longrightarrow> ( A \<ls> B \<longrightarrow> A \<ls> C )" 
     by (rule MMI_pm2_21d)
   from S50 have S51: "( A =   
 \<cpnf> \<and> B \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( ( A \<ls> B \<and> B \<ls> C ) \<longrightarrow> A \<ls> C )" by (rule MMI_adantrd)
   from S51 have S52: "( A =   
 \<cpnf> \<and> ( B \<in> \<real>\<^isup>* \<and> ( C \<in> \<real> \<or> C = \<cpnf> \<or> C = \<cmnf> ) ) ) \<longrightarrow>   
 ( ( A \<ls> B \<and> B \<ls> C ) \<longrightarrow> A \<ls> C )" by (rule MMI_adantrr)
   have S53: "C \<in> \<real> \<longrightarrow> \<cmnf> \<ls> C" by (rule MMI_mnfltt)
   from S53 have S54: "( A = \<cmnf> \<and> C \<in> \<real> ) \<longrightarrow> \<cmnf> \<ls> C" 
     by (rule MMI_adantl)
   have S55: "A = \<cmnf> \<longrightarrow> ( A \<ls> C \<longleftrightarrow> \<cmnf> \<ls> C )" 
     by (rule MMI_breq1)
   from S55 have S56: "( A = \<cmnf> \<and> C \<in> \<real> ) \<longrightarrow> ( A \<ls> C \<longleftrightarrow> \<cmnf> \<ls> C )" by (rule MMI_adantr)
   from S54 S56 have S57: "( A = \<cmnf> \<and> C \<in> \<real> ) \<longrightarrow> A \<ls> C" 
     by (rule MMI_mpbird)
   from S57 have S58: "( A =   
 \<cmnf> \<and> C \<in> \<real> ) \<longrightarrow>   
 ( ( A \<ls> B \<and> B \<ls> C ) \<longrightarrow> A \<ls> C )" by (rule MMI_a1d)
   from S58 have S59: "( ( A = \<cmnf> \<and> B \<in> \<real>\<^isup>* ) \<and> C \<in> \<real> ) \<longrightarrow>   
 ( ( A \<ls> B \<and> B \<ls> C ) \<longrightarrow> A \<ls> C )" by (rule MMI_adantlr)
   have S60: "\<cmnf> \<ls> \<cpnf>" by (rule MMI_mnfltpnf)
   have S61: 
     "( A = \<cmnf> \<and> C = \<cpnf> ) \<longrightarrow> ( A \<ls> C \<longleftrightarrow> \<cmnf> \<ls> \<cpnf> )" 
     by (rule MMI_breq12)
   from S60 S61 have S62: "( A = \<cmnf> \<and> C = \<cpnf> ) \<longrightarrow> A \<ls> C" 
     by (rule MMI_mpbiri)
   from S62 have S63: "( A =   
 \<cmnf> \<and> C =   
 \<cpnf> ) \<longrightarrow> ( ( A \<ls> B \<and> B \<ls> C ) \<longrightarrow> A \<ls> C )" by (rule MMI_a1d)
   from S63 have S64: "( ( A = \<cmnf> \<and> B \<in> \<real>\<^isup>* ) \<and> C =   
 \<cpnf> ) \<longrightarrow> ( ( A \<ls> B \<and> B \<ls> C ) \<longrightarrow> A \<ls> C )" by (rule MMI_adantlr)
   from S41 have S65: "( B \<in> \<real>\<^isup>* \<and> C =   
 \<cmnf> ) \<longrightarrow> ( ( A \<ls> B \<and> B \<ls> C ) \<longrightarrow> A \<ls> C )" .
   from S65 have S66: "( ( A = \<cmnf> \<and> B \<in> \<real>\<^isup>* ) \<and> C =   
 \<cmnf> ) \<longrightarrow> ( ( A \<ls> B \<and> B \<ls> C ) \<longrightarrow> A \<ls> C )" by (rule MMI_adantll)
   from S59 S64 S66 have S67: 
     "( ( A = \<cmnf> \<and> B \<in> \<real>\<^isup>* ) \<and> ( C \<in> \<real> \<or> C = \<cpnf> \<or> C = \<cmnf> ) ) \<longrightarrow> 
      ( ( A \<ls> B \<and> B \<ls> C ) \<longrightarrow> A \<ls> C )" by (rule MMI_3jaodan)
   from S67 have S68: "( A =   
 \<cmnf> \<and> ( B \<in> \<real>\<^isup>* \<and> ( C \<in> \<real> \<or> C = \<cpnf> \<or> C = \<cmnf> ) ) ) \<longrightarrow>   
 ( ( A \<ls> B \<and> B \<ls> C ) \<longrightarrow> A \<ls> C )" by (rule MMI_anasss)
   from S44 S52 S68 have S69: "( ( A \<in> \<real> \<or> A = \<cpnf> \<or> A = \<cmnf> ) \<and> ( B \<in> \<real>\<^isup>* \<and> ( C \<in> \<real> \<or> C = \<cpnf> \<or> C = \<cmnf> ) ) ) \<longrightarrow>   
 ( ( A \<ls> B \<and> B \<ls> C ) \<longrightarrow> A \<ls> C )" by (rule MMI_3jaoian)
   from S69 have S70: "( ( A \<in> \<real> \<or> A = \<cpnf> \<or> A = \<cmnf> ) \<and> B \<in> \<real>\<^isup>* \<and> ( C \<in> \<real> \<or> C = \<cpnf> \<or> C = \<cmnf> ) ) \<longrightarrow>   
 ( ( A \<ls> B \<and> B \<ls> C ) \<longrightarrow> A \<ls> C )" by (rule MMI_3impb)
   have S71: "C \<in> \<real>\<^isup>* \<longleftrightarrow> ( C \<in> \<real> \<or> C = \<cpnf> \<or> C = \<cmnf> )" by (rule MMI_elxr)
   from S70 S71 have S72: "( ( A \<in> \<real> \<or> A = \<cpnf> \<or> A = \<cmnf> ) \<and> B \<in> \<real>\<^isup>* \<and> C \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( ( A \<ls> B \<and> B \<ls> C ) \<longrightarrow> A \<ls> C )" by (rule MMI_syl3an3b)
   have S73: "A \<in> \<real>\<^isup>* \<longleftrightarrow> ( A \<in> \<real> \<or> A = \<cpnf> \<or> A = \<cmnf> )" 
     by (rule MMI_elxr)
   from S72 S73 show "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* \<and> C \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( ( A \<ls> B \<and> B \<ls> C ) \<longrightarrow> A \<ls> C )" by (rule MMI_syl3an1b)
qed

lemma (in MMIsar0) MMI_xrltso: 
   shows "\<cltrrset> Orders \<real>\<^isup>*"
proof -
  { fix x y z
    have S1: "( x \<in> \<real>\<^isup>* \<and> y \<in> \<real>\<^isup>* ) \<longrightarrow>   
      ( x \<ls> y \<longleftrightarrow> \<not> ( ( x = y \<or> y \<ls> x ) ) )" by (rule MMI_xrlttrit)
    from S1 have S2: "( x \<in> \<real>\<^isup>* \<and> y \<in> \<real>\<^isup>* \<and> z \<in> \<real>\<^isup>* ) \<longrightarrow>   
      ( x \<ls> y \<longleftrightarrow> \<not> ( ( x = y \<or> y \<ls> x ) ) )" by (rule MMI_3adant3)
    have S3: "( x \<in> \<real>\<^isup>* \<and> y \<in> \<real>\<^isup>* \<and> z \<in> \<real>\<^isup>* ) \<longrightarrow>   
      ( ( x \<ls> y \<and> y \<ls> z ) \<longrightarrow> x \<ls> z )" by (rule MMI_xrlttrt)
    from S2 S3 have S4: 
      "( x \<in> \<real>\<^isup>* \<and> y \<in> \<real>\<^isup>* \<and> z \<in> \<real>\<^isup>* ) \<longrightarrow>   ( ( x \<ls> y \<longleftrightarrow> 
      \<not> ( ( x = y \<or> y \<ls> x ) ) ) \<and> ( ( x \<ls> y \<and> y \<ls> z ) \<longrightarrow> 
      x \<ls> z ) )" by (rule MMI_jca)
    then have  "x \<in> \<real>\<^isup>*  \<and> y \<in> \<real>\<^isup>* \<and> z \<in> \<real>\<^isup>*  \<longrightarrow>   
      ( ( \<langle>x,y\<rangle> \<in> \<cltrrset> \<longleftrightarrow> \<not> ( ( x = y \<or> \<langle>y, x\<rangle> \<in> \<cltrrset> ) ) ) \<and> 
      ( ( \<langle>x, y\<rangle> \<in> \<cltrrset>  \<and> \<langle>y, z\<rangle> \<in> \<cltrrset> ) \<longrightarrow> 
      \<langle>x, z\<rangle> \<in> \<cltrrset> ) )"
      using cltrr_def by simp;
  } then have "\<forall>x y z. ( x \<in> \<real>\<^isup>*  \<and> y \<in> \<real>\<^isup>* \<and> z \<in> \<real>\<^isup>* ) \<longrightarrow>   
      ( ( \<langle>x,y\<rangle> \<in> \<cltrrset> \<longleftrightarrow> \<not> ( ( x = y \<or> \<langle>y, x\<rangle> \<in> \<cltrrset> ) ) ) \<and> 
      ( ( \<langle>x, y\<rangle> \<in> \<cltrrset>  \<and> \<langle>y, z\<rangle> \<in> \<cltrrset> ) \<longrightarrow> 
      \<langle>x, z\<rangle> \<in> \<cltrrset> ) )" by auto;
  thus "\<cltrrset> Orders \<real>\<^isup>*" by (rule MMI_so)
qed;

lemma (in MMIsar0) MMI_xrlttri3t: 
   shows "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* ) \<longrightarrow>   
  ( A = B \<longleftrightarrow> ( \<not> ( A \<ls> B ) \<and> \<not> ( B \<ls> A ) ) )"
proof -
   have S1: "\<cltrrset> Orders \<real>\<^isup>*" by (rule MMI_xrltso)
   have "( \<cltrrset> Orders \<real>\<^isup>* \<and> ( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* ) ) \<longrightarrow>   
     ( A = B \<longleftrightarrow> ( \<not> ( \<langle>A,B\<rangle> \<in> \<cltrrset>  ) \<and> \<not> ( \<langle>B, A\<rangle> \<in> \<cltrrset> ) ) )" 
     by (rule MMI_sotrieq2);
   then have S2: "( \<cltrrset> Orders \<real>\<^isup>* \<and> ( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* ) ) \<longrightarrow>   
     ( A = B \<longleftrightarrow> ( \<not> ( A \<ls> B ) \<and> \<not> ( B \<ls> A ) ) )" 
     using cltrr_def by simp;
   from S1 S2 show "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* ) \<longrightarrow>   
     ( A =   
     B \<longleftrightarrow> ( \<not> ( A \<ls> B ) \<and> \<not> ( B \<ls> A ) ) )" by (rule MMI_mpan)
qed;

lemma (in MMIsar0) MMI_xrleloet: 
   shows "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* ) \<longrightarrow>   
  ( A \<lsq> B \<longleftrightarrow> ( A \<ls> B \<or> A = B ) )"
proof -
   have S1: "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( A \<lsq> B \<longleftrightarrow> \<not> ( B \<ls> A ) )" by (rule MMI_xrlenltt)
   have S2: "( B \<in> \<real>\<^isup>* \<and> A \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( B \<ls> A \<longleftrightarrow> \<not> ( ( B = A \<or> A \<ls> B ) ) )" by (rule MMI_xrlttrit)
   from S2 have S3: "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( B \<ls> A \<longleftrightarrow> \<not> ( ( B = A \<or> A \<ls> B ) ) )" by (rule MMI_ancoms)
   from S3 have S4: "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( ( B = A \<or> A \<ls> B ) \<longleftrightarrow> \<not> ( B \<ls> A ) )" by (rule MMI_con2bid)
   have S5: "B = A \<longleftrightarrow> A = B" by (rule MMI_eqcom)
   from S5 have S6: "( B = A \<or> A \<ls> B ) \<longleftrightarrow> ( A = B \<or> A \<ls> B )" by (rule MMI_orbi1i)
   have S7: "( A = B \<or> A \<ls> B ) \<longleftrightarrow> ( A \<ls> B \<or> A = B )" by (rule MMI_orcom)
   from S6 S7 have S8: "( B = A \<or> A \<ls> B ) \<longleftrightarrow> ( A \<ls> B \<or> A = B )" by (rule MMI_bitr)
   from S4 S8 have S9: "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( \<not> ( B \<ls> A ) \<longleftrightarrow> ( A \<ls> B \<or> A = B ) )" by (rule MMI_syl5rbbr)
   from S1 S9 show "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( A \<lsq> B \<longleftrightarrow> ( A \<ls> B \<or> A = B ) )" by (rule MMI_bitrd)
qed

lemma (in MMIsar0) MMI_xrleltnet: 
   shows "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* \<and> A \<lsq> B ) \<longrightarrow>   
 ( A \<ls> B \<longleftrightarrow> \<not> ( A = B ) )"
proof -
   have S1: "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( A =   
 B \<longleftrightarrow> ( \<not> ( A \<ls> B ) \<and> \<not> ( B \<ls> A ) ) )" by (rule MMI_xrlttri3t)
   have S2: "( \<not> ( A \<ls> B ) \<and> \<not> ( B \<ls> A ) ) \<longrightarrow>   
 \<not> ( A \<ls> B )" by (rule MMI_pm3_26)
   from S1 S2 have S3: "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( A = B \<longrightarrow> \<not> ( A \<ls> B ) )" by (rule MMI_syl6bi)
   from S3 have S4: "( ( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* ) \<and> A \<lsq> B ) \<longrightarrow>   
 ( A = B \<longrightarrow> \<not> ( A \<ls> B ) )" by (rule MMI_adantr)
   have S5: "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( A \<lsq> B \<longleftrightarrow> ( A \<ls> B \<or> A = B ) )" by (rule MMI_xrleloet)
   from S5 have S6: "( ( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* ) \<and> A \<lsq> B ) \<longrightarrow>   
 ( A \<ls> B \<or> A = B )" by (rule MMI_biimpa)
   from S6 have S7: "( ( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* ) \<and> A \<lsq> B ) \<longrightarrow>   
 ( \<not> ( A \<ls> B ) \<longrightarrow> A = B )" by (rule MMI_ord)
   from S4 S7 have S8: "( ( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* ) \<and> A \<lsq> B ) \<longrightarrow>   
 ( A = B \<longleftrightarrow> \<not> ( A \<ls> B ) )" by (rule MMI_impbid)
   from S8 have S9: "( ( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* ) \<and> A \<lsq> B ) \<longrightarrow>   
 ( A \<ls> B \<longleftrightarrow> \<not> ( A = B ) )" by (rule MMI_con2bid)
   from S9 show "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* \<and> A \<lsq> B ) \<longrightarrow>   
 ( A \<ls> B \<longleftrightarrow> \<not> ( A = B ) )" by (rule MMI_3impa)
qed

lemma (in MMIsar0) MMI_xrltlet: 
   shows "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* ) \<longrightarrow> ( A \<ls> B \<longrightarrow> A \<lsq> B )"
proof -
   have S1: "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( A \<lsq> B \<longleftrightarrow> ( A \<ls> B \<or> A = B ) )" by (rule MMI_xrleloet)
   have S2: "A \<ls> B \<longrightarrow> ( A \<ls> B \<or> A = B )" by (rule MMI_orc)
   from S1 S2 show "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* ) \<longrightarrow> ( A \<ls> B \<longrightarrow> A \<lsq> B )" by (rule MMI_syl5bir)
qed

lemma (in MMIsar0) MMI_xrlelttrt: 
   shows "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* \<and> C \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( ( A \<lsq> B \<and> B \<ls> C ) \<longrightarrow> A \<ls> C )"
proof -
   have S1: "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( A \<lsq> B \<longleftrightarrow> ( A \<ls> B \<or> A = B ) )" by (rule MMI_xrleloet)
   from S1 have S2: "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* \<and> C \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( A \<lsq> B \<longleftrightarrow> ( A \<ls> B \<or> A = B ) )" by (rule MMI_3adant3)
   have S3: "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* \<and> C \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( ( A \<ls> B \<and> B \<ls> C ) \<longrightarrow> A \<ls> C )" by (rule MMI_xrlttrt)
   from S3 have S4: "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* \<and> C \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( A \<ls> B \<longrightarrow> ( B \<ls> C \<longrightarrow> A \<ls> C ) )" by (rule MMI_exp3a)
   have S5: "A = B \<longrightarrow> ( A \<ls> C \<longleftrightarrow> B \<ls> C )" by (rule MMI_breq1)
   from S5 have S6: "A = B \<longrightarrow> ( B \<ls> C \<longrightarrow> A \<ls> C )" by (rule MMI_biimprd)
   from S6 have S7: "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* \<and> C \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( A = B \<longrightarrow> ( B \<ls> C \<longrightarrow> A \<ls> C ) )" by (rule MMI_a1i)
   from S4 S7 have S8: "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* \<and> C \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( ( A \<ls> B \<or> A = B ) \<longrightarrow>   
 ( B \<ls> C \<longrightarrow> A \<ls> C ) )" by (rule MMI_jaod)
   from S2 S8 have S9: "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* \<and> C \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( A \<lsq> B \<longrightarrow> ( B \<ls> C \<longrightarrow> A \<ls> C ) )" by (rule MMI_sylbid)
   from S9 show "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* \<and> C \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( ( A \<lsq> B \<and> B \<ls> C ) \<longrightarrow> A \<ls> C )" by (rule MMI_imp3a)
qed;

(**************** 281-290 ***********************)

lemma (in MMIsar0) MMI_xrltletrt: 
   shows "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* \<and> C \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( ( A \<ls> B \<and> B \<lsq> C ) \<longrightarrow> A \<ls> C )"
proof -
   have S1: "( B \<in> \<real>\<^isup>* \<and> C \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( B \<lsq> C \<longleftrightarrow> ( B \<ls> C \<or> B = C ) )" by (rule MMI_xrleloet)
   from S1 have S2: "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* \<and> C \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( B \<lsq> C \<longleftrightarrow> ( B \<ls> C \<or> B = C ) )" by (rule MMI_3adant1)
   have S3: "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* \<and> C \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( ( A \<ls> B \<and> B \<ls> C ) \<longrightarrow> A \<ls> C )" by (rule MMI_xrlttrt)
   from S3 have S4: "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* \<and> C \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( A \<ls> B \<longrightarrow> ( B \<ls> C \<longrightarrow> A \<ls> C ) )" by (rule MMI_exp3a)
   from S4 have S5: "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* \<and> C \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( B \<ls> C \<longrightarrow> ( A \<ls> B \<longrightarrow> A \<ls> C ) )" by (rule MMI_com23)
   have S6: "B = C \<longrightarrow> ( A \<ls> B \<longleftrightarrow> A \<ls> C )" by (rule MMI_breq2)
   from S6 have S7: "B = C \<longrightarrow> ( A \<ls> B \<longrightarrow> A \<ls> C )" by (rule MMI_biimpd)
   from S7 have S8: "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* \<and> C \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( B = C \<longrightarrow> ( A \<ls> B \<longrightarrow> A \<ls> C ) )" by (rule MMI_a1i)
   from S5 S8 have S9: "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* \<and> C \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( ( B \<ls> C \<or> B = C ) \<longrightarrow>   
 ( A \<ls> B \<longrightarrow> A \<ls> C ) )" by (rule MMI_jaod)
   from S2 S9 have S10: "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* \<and> C \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( B \<lsq> C \<longrightarrow> ( A \<ls> B \<longrightarrow> A \<ls> C ) )" by (rule MMI_sylbid)
   from S10 have S11: "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* \<and> C \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( A \<ls> B \<longrightarrow> ( B \<lsq> C \<longrightarrow> A \<ls> C ) )" by (rule MMI_com23)
   from S11 show "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* \<and> C \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( ( A \<ls> B \<and> B \<lsq> C ) \<longrightarrow> A \<ls> C )" by (rule MMI_imp3a)
qed

lemma (in MMIsar0) MMI_xrletrt: 
   shows "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* \<and> C \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( ( A \<lsq> B \<and> B \<lsq> C ) \<longrightarrow> A \<lsq> C )"
proof -
   have S1: "( B \<in> \<real>\<^isup>* \<and> C \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( B \<lsq> C \<longleftrightarrow> ( B \<ls> C \<or> B = C ) )" by (rule MMI_xrleloet)
   from S1 have S2: "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* \<and> C \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( B \<lsq> C \<longleftrightarrow> ( B \<ls> C \<or> B = C ) )" by (rule MMI_3adant1)
   from S2 have S3: "( ( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* \<and> C \<in> \<real>\<^isup>* ) \<and> A \<lsq> B ) \<longrightarrow>   
 ( B \<lsq> C \<longleftrightarrow> ( B \<ls> C \<or> B = C ) )" by (rule MMI_adantr)
   have S4: "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* \<and> C \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( ( A \<lsq> B \<and> B \<ls> C ) \<longrightarrow> A \<ls> C )" by (rule MMI_xrlelttrt)
   have S5: "( A \<in> \<real>\<^isup>* \<and> C \<in> \<real>\<^isup>* ) \<longrightarrow> ( A \<ls> C \<longrightarrow> A \<lsq> C )" 
     by (rule MMI_xrltlet)
   from S5 have S6: "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* \<and> C \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( A \<ls> C \<longrightarrow> A \<lsq> C )" by (rule MMI_3adant2)
   from S4 S6 have S7: "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* \<and> C \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( ( A \<lsq> B \<and> B \<ls> C ) \<longrightarrow> A \<lsq> C )" by (rule MMI_syld)
   from S7 have S8: "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* \<and> C \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( A \<lsq> B \<longrightarrow> ( B \<ls> C \<longrightarrow> A \<lsq> C ) )" by (rule MMI_exp3a)
   from S8 have S9: "( ( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* \<and> C \<in> \<real>\<^isup>* ) \<and> A \<lsq> B ) \<longrightarrow>   
 ( B \<ls> C \<longrightarrow> A \<lsq> C )" by (rule MMI_imp)
   have S10: "B = C \<longrightarrow> ( A \<lsq> B \<longleftrightarrow> A \<lsq> C )" by (rule MMI_breq2)
   from S10 have S11: "A \<lsq> B \<longrightarrow> ( B = C \<longrightarrow> A \<lsq> C )" 
     by (rule MMI_biimpcd)
   from S11 have S12: "( ( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* \<and> C \<in> \<real>\<^isup>* ) \<and> A \<lsq> B ) \<longrightarrow>   
 ( B = C \<longrightarrow> A \<lsq> C )" by (rule MMI_adantl)
   from S9 S12 have S13: "( ( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* \<and> C \<in> \<real>\<^isup>* ) \<and> A \<lsq> B ) \<longrightarrow>   
 ( ( B \<ls> C \<or> B = C ) \<longrightarrow> A \<lsq> C )" by (rule MMI_jaod)
   from S3 S13 have S14: "( ( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* \<and> C \<in> \<real>\<^isup>* ) \<and> A \<lsq> B ) \<longrightarrow>   
 ( B \<lsq> C \<longrightarrow> A \<lsq> C )" by (rule MMI_sylbid)
   from S14 have S15: "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* \<and> C \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( A \<lsq> B \<longrightarrow> ( B \<lsq> C \<longrightarrow> A \<lsq> C ) )" by (rule MMI_ex)
   from S15 show "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* \<and> C \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( ( A \<lsq> B \<and> B \<lsq> C ) \<longrightarrow> A \<lsq> C )" by (rule MMI_imp3a)
qed

lemma (in MMIsar0) MMI_xrltnet: 
   shows "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( A \<ls> B \<longrightarrow> \<not> ( A = B ) )"
proof -
   have S1: "\<cltrrset> Orders \<real>\<^isup>*" by (rule MMI_xrltso)
   have  "( \<cltrrset> Orders \<real>\<^isup>* \<and> ( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* ) ) \<longrightarrow>   
     ( A = B \<longleftrightarrow> \<not> ( ( \<langle>A, B\<rangle> \<in> \<cltrrset> \<or> \<langle>B,A\<rangle> \<in> \<cltrrset> ) ) )" 
     by (rule MMI_sotrieq);
   then have S2: "( \<cltrrset> Orders \<real>\<^isup>* \<and> ( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* ) ) \<longrightarrow>   
     ( A = B \<longleftrightarrow> \<not> ( ( A \<ls> B \<or> B \<ls> A ) ) )" 
     using cltrr_def by simp;
   from S1 S2 have S3: "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* ) \<longrightarrow>   
     ( A = B \<longleftrightarrow> \<not> ( ( A \<ls> B \<or> B \<ls> A ) ) )" by (rule MMI_mpan)
   from S3 have S4: "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( ( A \<ls> B \<or> B \<ls> A ) \<longleftrightarrow> \<not> ( A = B ) )" by (rule MMI_con2bid)
   have S5: "A \<ls> B \<longrightarrow> ( A \<ls> B \<or> B \<ls> A )" by (rule MMI_orc)
   from S4 S5 show "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( A \<ls> B \<longrightarrow> \<not> ( A = B ) )" by (rule MMI_syl5bi)
qed;

lemma (in MMIsar0) MMI_nltpnftt: 
   shows "A \<in> \<real>\<^isup>* \<longrightarrow> ( A = \<cpnf> \<longleftrightarrow> \<not> ( A \<ls> \<cpnf> ) )"
proof -
   have S1: "\<cpnf> \<in> \<real>\<^isup>*" by (rule MMI_pnfxr)
   have S2: "\<cpnf> \<in> \<real>\<^isup>* \<longrightarrow> \<not> ( \<cpnf> \<ls> \<cpnf> )" by (rule MMI_xrltnrt)
   from S1 S2 have S3: "\<not> ( \<cpnf> \<ls> \<cpnf> )" by (rule MMI_ax_mp)
   have S4: "A = \<cpnf> \<longrightarrow> ( A \<ls> \<cpnf> \<longleftrightarrow> \<cpnf> \<ls> \<cpnf> )" by (rule MMI_breq1)
   from S3 S4 have S5: "A = \<cpnf> \<longrightarrow> \<not> ( A \<ls> \<cpnf> )" by (rule MMI_mtbiri)
   from S5 have S6: "A \<in> \<real>\<^isup>* \<longrightarrow> ( A = \<cpnf> \<longrightarrow> \<not> ( A \<ls> \<cpnf> ) )" by (rule MMI_a1i)
   have S7: "A \<in> \<real>\<^isup>* \<longrightarrow> A \<lsq> \<cpnf>" by (rule MMI_pnfget)
   have S8: "\<cpnf> \<in> \<real>\<^isup>*" by (rule MMI_pnfxr)
   have S9: "( A \<in> \<real>\<^isup>* \<and> \<cpnf> \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( A \<lsq> \<cpnf> \<longleftrightarrow> ( A \<ls> \<cpnf> \<or> A = \<cpnf> ) )" by (rule MMI_xrleloet)
   from S8 S9 have S10: "A \<in> \<real>\<^isup>* \<longrightarrow> ( A \<lsq> \<cpnf> \<longleftrightarrow> ( A \<ls> \<cpnf> \<or> A = \<cpnf> ) )" by (rule MMI_mpan2)
   from S7 S10 have S11: "A \<in> \<real>\<^isup>* \<longrightarrow> ( A \<ls> \<cpnf> \<or> A = \<cpnf> )" by (rule MMI_mpbid)
   from S11 have S12: "A \<in> \<real>\<^isup>* \<longrightarrow> ( \<not> ( A \<ls> \<cpnf> ) \<longrightarrow> A = \<cpnf> )" by (rule MMI_ord)
   from S6 S12 show "A \<in> \<real>\<^isup>* \<longrightarrow> ( A = \<cpnf> \<longleftrightarrow> \<not> ( A \<ls> \<cpnf> ) )" by (rule MMI_impbid)
qed

lemma (in MMIsar0) MMI_ngtmnftt: 
   shows "A \<in> \<real>\<^isup>* \<longrightarrow> ( A = \<cmnf> \<longleftrightarrow> \<not> ( \<cmnf> \<ls> A ) )"
proof -
   have S1: "\<cmnf> \<in> \<real>\<^isup>*" by (rule MMI_mnfxr)
   have S2: "\<cmnf> \<in> \<real>\<^isup>* \<longrightarrow> \<not> ( \<cmnf> \<ls> \<cmnf> )" by (rule MMI_xrltnrt)
   from S1 S2 have S3: "\<not> ( \<cmnf> \<ls> \<cmnf> )" by (rule MMI_ax_mp)
   have S4: "A = \<cmnf> \<longrightarrow> ( \<cmnf> \<ls> A \<longleftrightarrow> \<cmnf> \<ls> \<cmnf> )" by (rule MMI_breq2)
   from S3 S4 have S5: "A = \<cmnf> \<longrightarrow> \<not> ( \<cmnf> \<ls> A )" by (rule MMI_mtbiri)
   from S5 have S6: "A \<in> \<real>\<^isup>* \<longrightarrow> ( A = \<cmnf> \<longrightarrow> \<not> ( \<cmnf> \<ls> A ) )" by (rule MMI_a1i)
   have S7: "A \<in> \<real>\<^isup>* \<longrightarrow> \<cmnf> \<lsq> A" by (rule MMI_mnflet)
   have S8: "\<cmnf> \<in> \<real>\<^isup>*" by (rule MMI_mnfxr)
   have S9: "( \<cmnf> \<in> \<real>\<^isup>* \<and> A \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( \<cmnf> \<lsq> A \<longleftrightarrow> ( \<cmnf> \<ls> A \<or> \<cmnf> = A ) )" by (rule MMI_xrleloet)
   from S8 S9 have S10: "A \<in> \<real>\<^isup>* \<longrightarrow> ( \<cmnf> \<lsq> A \<longleftrightarrow> ( \<cmnf> \<ls> A \<or> \<cmnf> = A ) )" by (rule MMI_mpan)
   from S7 S10 have S11: "A \<in> \<real>\<^isup>* \<longrightarrow> ( \<cmnf> \<ls> A \<or> \<cmnf> = A )" by (rule MMI_mpbid)
   from S11 have S12: "A \<in> \<real>\<^isup>* \<longrightarrow> ( \<not> ( \<cmnf> \<ls> A ) \<longrightarrow> \<cmnf> = A )" by (rule MMI_ord)
   have S13: "\<cmnf> = A \<longleftrightarrow> A = \<cmnf>" by (rule MMI_eqcom)
   from S12 S13 have S14: "A \<in> \<real>\<^isup>* \<longrightarrow> ( \<not> ( \<cmnf> \<ls> A ) \<longrightarrow> A = \<cmnf> )" by (rule MMI_syl6ib)
   from S6 S14 show "A \<in> \<real>\<^isup>* \<longrightarrow> ( A = \<cmnf> \<longleftrightarrow> \<not> ( \<cmnf> \<ls> A ) )" by (rule MMI_impbid)
qed

lemma (in MMIsar0) MMI_xrrebndt: 
   shows "A \<in> \<real>\<^isup>* \<longrightarrow> ( A \<in> \<real> \<longleftrightarrow> ( \<cmnf> \<ls> A \<and> A \<ls> \<cpnf> ) )"
proof -
   have S1: "A \<in> \<real> \<longrightarrow> \<cmnf> \<ls> A" by (rule MMI_mnfltt)
   have S2: "A \<in> \<real> \<longrightarrow> A \<ls> \<cpnf>" by (rule MMI_ltpnft)
   from S1 S2 have S3: "A \<in> \<real> \<longrightarrow> ( \<cmnf> \<ls> A \<and> A \<ls> \<cpnf> )" 
     by (rule MMI_jca)
   from S3 have S4: "A \<in> \<real>\<^isup>* \<longrightarrow> ( A \<in> \<real> \<longrightarrow> ( \<cmnf> \<ls> A \<and> A \<ls> \<cpnf> ) )" 
     by (rule MMI_a1i)
   have S5: "A \<in> \<real>\<^isup>* \<longrightarrow> ( A = \<cpnf> \<longleftrightarrow> \<not> ( A \<ls> \<cpnf> ) )" 
     by (rule MMI_nltpnftt)
   have S6: "A \<in> \<real>\<^isup>* \<longrightarrow> ( A = \<cmnf> \<longleftrightarrow> \<not> ( \<cmnf> \<ls> A ) )" 
     by (rule MMI_ngtmnftt)
   from S5 S6 have S7: "A \<in> \<real>\<^isup>* \<longrightarrow>   
     ( ( A = \<cpnf> \<or> A = \<cmnf> ) \<longleftrightarrow>   
     ( \<not> ( A \<ls> \<cpnf>) \<or> \<not> ( \<cmnf> \<ls> A ) ) )" by (rule MMI_orbi12d);
   have S8: "\<not> ( ( \<cmnf> \<ls> A \<and> A \<ls> \<cpnf> ) ) \<longleftrightarrow>   
     ( \<not> ( \<cmnf> \<ls> A ) \<or> \<not> ( A \<ls> \<cpnf> ) )" by (rule MMI_ianor);
   have S9: "( \<not> ( \<cmnf> \<ls> A ) \<or> \<not> ( A \<ls> \<cpnf> ) ) \<longleftrightarrow>   
     ( \<not> ( A \<ls> \<cpnf> ) \<or> \<not> ( \<cmnf> \<ls> A ) )" by (rule MMI_orcom);
   from S8 S9 have S10: "( \<not> ( A \<ls> \<cpnf> ) \<or> \<not> ( \<cmnf> \<ls> A ) ) \<longleftrightarrow>   
     \<not> ( ( \<cmnf> \<ls> A ) \<and> A \<ls> \<cpnf> )" by (rule MMI_bitr2);
   from S7 S10 have S11: "A \<in> \<real>\<^isup>* \<longrightarrow>   
 ( ( A = \<cpnf> \<or> A = \<cmnf> ) \<longleftrightarrow>   
 \<not> ( ( \<cmnf> \<ls> A \<and> A \<ls> \<cpnf> ) ) )" by (rule MMI_syl6bb)
   from S11 have S12: "A \<in> \<real>\<^isup>* \<longrightarrow>   
 ( ( \<cmnf> \<ls> A \<and> A \<ls> \<cpnf> ) \<longleftrightarrow>   
 \<not> ( ( A = \<cpnf> \<or> A = \<cmnf> ) ) )" by (rule MMI_con2bid)
   have S13: "A \<in> \<real>\<^isup>* \<longleftrightarrow> ( A \<in> \<real> \<or> A = \<cpnf> \<or> A = \<cmnf> )" by (rule MMI_elxr)
   from S13 have S14: "A \<in> \<real>\<^isup>* \<longrightarrow> ( A \<in> \<real> \<or> A = \<cpnf> \<or> A = \<cmnf> )" by (rule MMI_biimp)
   have S15: "( A \<in> \<real> \<or> A =   
 \<cpnf> \<or> A =   
 \<cmnf> ) \<longleftrightarrow> ( A \<in> \<real> \<or> ( A = \<cpnf> \<or> A = \<cmnf> ) )" by (rule MMI_3orass)
   have S16: "( A \<in> \<real> \<or> ( A = \<cpnf> \<or> A = \<cmnf> ) ) \<longleftrightarrow>   
 ( ( A = \<cpnf> \<or> A = \<cmnf> ) \<or> A \<in> \<real> )" by (rule MMI_orcom)
   from S15 S16 have S17: "( A \<in> \<real> \<or> A =   
 \<cpnf> \<or> A =   
 \<cmnf> ) \<longleftrightarrow> ( ( A = \<cpnf> \<or> A = \<cmnf> ) \<or> A \<in> \<real> )" by (rule MMI_bitr)
   from S14 S17 have S18: "A \<in> \<real>\<^isup>* \<longrightarrow> ( ( A = \<cpnf> \<or> A = \<cmnf> ) \<or> A \<in> \<real> )" by (rule MMI_sylib)
   from S18 have S19: "A \<in> \<real>\<^isup>* \<longrightarrow>   
 ( \<not> ( ( A = \<cpnf> \<or> A = \<cmnf> ) ) \<longrightarrow> A \<in> \<real> )" by (rule MMI_ord)
   from S12 S19 have S20: "A \<in> \<real>\<^isup>* \<longrightarrow> ( ( \<cmnf> \<ls> A \<and> A \<ls> \<cpnf> ) \<longrightarrow> A \<in> \<real> )" by (rule MMI_sylbid)
   from S4 S20 show "A \<in> \<real>\<^isup>* \<longrightarrow> ( A \<in> \<real> \<longleftrightarrow> ( \<cmnf> \<ls> A \<and> A \<ls> \<cpnf> ) )" by (rule MMI_impbid)
qed

lemma (in MMIsar0) MMI_xrret: 
   shows "( ( A \<in> \<real>\<^isup>* \<and> B \<in> \<real> ) \<and> ( \<cmnf> \<ls> A \<and> A \<lsq> B ) ) \<longrightarrow>   
 A \<in> \<real>"
proof -
   have S1: "( \<cmnf> \<ls> A \<and> A \<lsq> B ) \<longrightarrow> \<cmnf> \<ls> A" by (rule MMI_pm3_26)
   from S1 have S2: "( ( A \<in> \<real>\<^isup>* \<and> B \<in> \<real> ) \<and> ( \<cmnf> \<ls> A \<and> A \<lsq> B ) ) \<longrightarrow>   
 \<cmnf> \<ls> A" by (rule MMI_adantl)
   have S3: "B \<in> \<real> \<longrightarrow> B \<ls> \<cpnf>" by (rule MMI_ltpnft)
   from S3 have S4: "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real> ) \<longrightarrow> B \<ls> \<cpnf>" by (rule MMI_adantl)
   have S5: "\<cpnf> \<in> \<real>\<^isup>*" by (rule MMI_pnfxr)
   have S6: "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* \<and> \<cpnf> \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( ( A \<lsq> B \<and> B \<ls> \<cpnf> ) \<longrightarrow> A \<ls> \<cpnf> )" by (rule MMI_xrlelttrt)
   from S5 S6 have S7: "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real>\<^isup>* ) \<longrightarrow>   
 ( ( A \<lsq> B \<and> B \<ls> \<cpnf> ) \<longrightarrow> A \<ls> \<cpnf> )" by (rule MMI_mp3an3)
   have S8: "B \<in> \<real> \<longrightarrow> B \<in> \<real>\<^isup>*" by (rule MMI_rexrt)
   from S7 S8 have S9: "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real> ) \<longrightarrow>   
 ( ( A \<lsq> B \<and> B \<ls> \<cpnf> ) \<longrightarrow> A \<ls> \<cpnf> )" by (rule MMI_sylan2)
   from S4 S9 have S10: "( A \<in> \<real>\<^isup>* \<and> B \<in> \<real> ) \<longrightarrow> ( A \<lsq> B \<longrightarrow> A \<ls> \<cpnf> )" by (rule MMI_mpan2d)
   from S10 have S11: "( ( A \<in> \<real>\<^isup>* \<and> B \<in> \<real> ) \<and> A \<lsq> B ) \<longrightarrow> A \<ls> \<cpnf>" by (rule MMI_imp)
   from S11 have S12: "( ( A \<in> \<real>\<^isup>* \<and> B \<in> \<real> ) \<and> ( \<cmnf> \<ls> A \<and> A \<lsq> B ) ) \<longrightarrow>   
 A \<ls> \<cpnf>" by (rule MMI_adantrl)
   from S2 S12 have S13: "( ( A \<in> \<real>\<^isup>* \<and> B \<in> \<real> ) \<and> ( \<cmnf> \<ls> A \<and> A \<lsq> B ) ) \<longrightarrow>   
 ( \<cmnf> \<ls> A \<and> A \<ls> \<cpnf> )" by (rule MMI_jca)
   have S14: "A \<in> \<real>\<^isup>* \<longrightarrow> ( A \<in> \<real> \<longleftrightarrow> ( \<cmnf> \<ls> A \<and> A \<ls> \<cpnf> ) )" by (rule MMI_xrrebndt)
   from S14 have S15: "( ( A \<in> \<real>\<^isup>* \<and> B \<in> \<real> ) \<and> ( \<cmnf> \<ls> A \<and> A \<lsq> B ) ) \<longrightarrow>   
 ( A \<in> \<real> \<longleftrightarrow> ( \<cmnf> \<ls> A \<and> A \<ls> \<cpnf> ) )" by (rule MMI_ad2antrr)
   from S13 S15 show "( ( A \<in> \<real>\<^isup>* \<and> B \<in> \<real> ) \<and> ( \<cmnf> \<ls> A \<and> A \<lsq> B ) ) \<longrightarrow>   
 A \<in> \<real>" by (rule MMI_mpbird)
qed

lemma (in MMIsar0) MMI_eqlet: 
   shows "( A \<in> \<real> \<and> A = B ) \<longrightarrow> A \<lsq> B"
proof -
   have S1: "A = B \<longrightarrow> ( A \<lsq> A \<longleftrightarrow> A \<lsq> B )" by (rule MMI_breq2)
   from S1 have S2: "( A \<lsq> A \<and> A = B ) \<longrightarrow> A \<lsq> B" by (rule MMI_biimpac)
   have S3: "A \<in> \<real> \<longrightarrow> A \<lsq> A" by (rule MMI_leidt)
   from S2 S3 show "( A \<in> \<real> \<and> A = B ) \<longrightarrow> A \<lsq> B" by (rule MMI_sylan)
qed

lemma (in MMIsar0) MMI_lttri2: assumes A1: "A \<in> \<real>" and
    A2: "B \<in> \<real>"   
   shows "\<not> ( A = B ) \<longleftrightarrow> ( A \<ls> B \<or> B \<ls> A )"
proof -
   from A1 have S1: "A \<in> \<real>".
   from A2 have S2: "B \<in> \<real>".
   have S3: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( \<not> ( A = B ) \<longleftrightarrow> ( A \<ls> B \<or> B \<ls> A ) )" by (rule MMI_lttri2t)
   from S1 S2 S3 show "\<not> ( A = B ) \<longleftrightarrow> ( A \<ls> B \<or> B \<ls> A )" by (rule MMI_mp2an)
qed

lemma (in MMIsar0) MMI_lttri3: assumes A1: "A \<in> \<real>" and
    A2: "B \<in> \<real>"   
   shows "A = B \<longleftrightarrow> ( \<not> ( A \<ls> B ) \<and> \<not> ( B \<ls> A ) )"
proof -
   from A1 have S1: "A \<in> \<real>".
   from A2 have S2: "B \<in> \<real>".
   have S3: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A = B \<longleftrightarrow> ( \<not> ( A \<ls> B ) \<and> \<not> ( B \<ls> A ) ) )" by (rule MMI_lttri3t)
   from S1 S2 S3 show "A = B \<longleftrightarrow> ( \<not> ( A \<ls> B ) \<and> \<not> ( B \<ls> A ) )" 
     by (rule MMI_mp2an)
qed;

(*****************290-300*****************************)
lemma (in MMIsar0) MMI_letri3: assumes A1: "A \<in> \<real>" and
    A2: "B \<in> \<real>"   
   shows "A = B \<longleftrightarrow> ( A \<lsq> B \<and> B \<lsq> A )"
proof -
   from A1 have S1: "A \<in> \<real>".
   from A2 have S2: "B \<in> \<real>".
   have S3: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A = B \<longleftrightarrow> ( A \<lsq> B \<and> B \<lsq> A ) )" by (rule MMI_letri3t)
   from S1 S2 S3 show "A = B \<longleftrightarrow> ( A \<lsq> B \<and> B \<lsq> A )" by (rule MMI_mp2an)
qed

lemma (in MMIsar0) MMI_leloe: assumes A1: "A \<in> \<real>" and
    A2: "B \<in> \<real>"   
   shows "A \<lsq> B \<longleftrightarrow> ( A \<ls> B \<or> A = B )"
proof -
   from A1 have S1: "A \<in> \<real>".
   from A2 have S2: "B \<in> \<real>".
   have S3: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A \<lsq> B \<longleftrightarrow> ( A \<ls> B \<or> A = B ) )" by (rule MMI_leloet)
   from S1 S2 S3 show "A \<lsq> B \<longleftrightarrow> ( A \<ls> B \<or> A = B )" by (rule MMI_mp2an)
qed

lemma (in MMIsar0) MMI_ltlen: assumes A1: "A \<in> \<real>" and
    A2: "B \<in> \<real>"   
   shows "A \<ls> B \<longleftrightarrow> ( A \<lsq> B \<and> \<not> ( A = B ) )"
proof -
   from A1 have S1: "A \<in> \<real>".
   from A2 have S2: "B \<in> \<real>".
   have S3: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A \<ls> B \<longleftrightarrow> ( A \<lsq> B \<and> \<not> ( A = B ) ) )" by (rule MMI_ltlent)
   from S1 S2 S3 show "A \<ls> B \<longleftrightarrow> ( A \<lsq> B \<and> \<not> ( A = B ) )" by (rule MMI_mp2an)
qed

lemma (in MMIsar0) MMI_ltnsym: assumes A1: "A \<in> \<real>" and
    A2: "B \<in> \<real>"   
   shows "A \<ls> B \<longrightarrow> \<not> ( B \<ls> A )"
proof -
   from A1 have S1: "A \<in> \<real>".
   from A2 have S2: "B \<in> \<real>".
   have S3: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A \<ls> B \<longrightarrow> \<not> ( B \<ls> A ) )" by (rule MMI_ltnsymt)
   from S1 S2 S3 show "A \<ls> B \<longrightarrow> \<not> ( B \<ls> A )" by (rule MMI_mp2an)
qed

lemma (in MMIsar0) MMI_lenlt: assumes A1: "A \<in> \<real>" and
    A2: "B \<in> \<real>"   
   shows "A \<lsq> B \<longleftrightarrow> \<not> ( B \<ls> A )"
proof -
   from A1 have S1: "A \<in> \<real>".
   from A2 have S2: "B \<in> \<real>".
   have S3: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A \<lsq> B \<longleftrightarrow> \<not> ( B \<ls> A ) )" by (rule MMI_lenltt)
   from S1 S2 S3 show "A \<lsq> B \<longleftrightarrow> \<not> ( B \<ls> A )" by (rule MMI_mp2an)
qed

lemma (in MMIsar0) MMI_ltnle: assumes A1: "A \<in> \<real>" and
    A2: "B \<in> \<real>"   
   shows "A \<ls> B \<longleftrightarrow> \<not> ( B \<lsq> A )"
proof -
   from A2 have S1: "B \<in> \<real>".
   from A1 have S2: "A \<in> \<real>".
   from S1 S2 have S3: "B \<lsq> A \<longleftrightarrow> \<not> ( A \<ls> B )" by (rule MMI_lenlt)
   from S3 show "A \<ls> B \<longleftrightarrow> \<not> ( B \<lsq> A )" by (rule MMI_con2bii)
qed

lemma (in MMIsar0) MMI_ltle: assumes A1: "A \<in> \<real>" and
    A2: "B \<in> \<real>"   
   shows "A \<ls> B \<longrightarrow> A \<lsq> B"
proof -
   from A1 have S1: "A \<in> \<real>".
   from A2 have S2: "B \<in> \<real>".
   have S3: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow> ( A \<ls> B \<longrightarrow> A \<lsq> B )" 
     by (rule MMI_ltlet)
   from S1 S2 S3 show "A \<ls> B \<longrightarrow> A \<lsq> B" by (rule MMI_mp2an)
qed

lemma (in MMIsar0) MMI_ltlei: assumes A1: "A \<in> \<real>" and
    A2: "B \<in> \<real>" and
    A3: "A \<ls> B"   
   shows "A \<lsq> B"
proof -
   from A3 have S1: "A \<ls> B".
   from A1 have S2: "A \<in> \<real>".
   from A2 have S3: "B \<in> \<real>".
   from S2 S3 have S4: "A \<ls> B \<longrightarrow> A \<lsq> B" by (rule MMI_ltle)
   from S1 S4 show "A \<lsq> B" by (rule MMI_ax_mp)
qed;

lemma (in MMIsar0) MMI_eqle: assumes A1: "A \<in> \<real>" and
    A2: "B \<in> \<real>"   
   shows "A = B \<longrightarrow> A \<lsq> B"
proof -
   from A1 have S1: "A \<in> \<real>".
   from A2 have S2: "B \<in> \<real>".
   from S1 S2 have S3: "A = B \<longleftrightarrow> ( A \<lsq> B \<and> B \<lsq> A )" 
     by (rule MMI_letri3)
   from S3 show "A = B \<longrightarrow> A \<lsq> B" by (rule MMI_pm3_26bd)
qed

lemma (in MMIsar0) MMI_ltne: assumes A1: "A \<in> \<real>" and
    A2: "B \<in> \<real>"   
   shows "A \<ls> B \<longrightarrow> \<not> ( A = B )"
proof -
   from A1 have S1: "A \<in> \<real>".
   from A2 have S2: "B \<in> \<real>".
   have S3: "( A \<in> \<real> \<and> B \<in> \<real> ) \<longrightarrow>   
 ( A \<ls> B \<longrightarrow> \<not> ( A = B ) )" by (rule MMI_ltnet)
   from S1 S2 S3 show "A \<ls> B \<longrightarrow> \<not> ( A = B )" by (rule MMI_mp2an)
qed;



end
