{- 
	This file is part of isar2html - a tool for rendering IsarMathLib 
	theories in DHTML.
    Copyright (C) 2008, 2009  Slawomir Kolodynski

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
-}

module Main
   where

import IMLP_datatypes
import Utils
import IMLParser
import ProcessThys
import Export2Html


-- | removes comments - the text between (* and *)
remComments :: String -> String
remComments = tail . (appBetween (\s -> "") "(*" "*)") . (' ':)
 
main = do
   rml   <- readFile "ROOT.ML"
   templ <- readFile "isar2html_template.html"
   names <- return $ map extractTheoryName (nonemptylines $ remComments rml)
   templ <- readFile "isar2html_template.html"
   thstxt <- readFiles $ map ("../IsarMathLib/" ++) names
   kb <- return $ processTheories $ parseTheories $ zip names thstxt
   putStrLn $ "number of propositions: " ++ (show $ length $ filter isProposition $ kbformalitems kb)
   putStrLn $ "number of definitions: " ++ (show $ length $ filter isDefinition $ kbformalitems kb)
   thrsExported <- return $ exportTheories templ kb
   writeFiles thrsExported
   --writeFile "formalmath.html" (fillWiki thrsExported wikitempl) 
   

-- | extract a name of the theory to load from a line in 
-- the ROOT.ML file
extractTheoryName :: String -> String
extractTheoryName = (++ ".thy") . takeWhile (/= '\"') . drop 9


