/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015-2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __database_aspect_h__

#include "global_common.h"
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <limits.h>

struct database_aspect
{
  char                                  m_tag[31+1];
  char                                  m_driver[31+1];
  char                                  m_dbname[255+1];
  char                                  m_host[63+1];     /* HOST_NAME_MAX or _POSIX_HOST_NAME_MAX */
  char                                  m_hostaddr[47+1]; /* INET6_ADDRSTRLEN  */
  char                                  m_port[7+1];      /* 1...65535 */
  char                                  m_username[31+1];
  char                                  m_prompt_password;
  char*                                 m_password; /* not stored to disk */
};

extern void
database_aspect_assign(
  struct database_aspect *const         o_aspect);

extern void
database_aspect_clear(
  struct database_aspect *const         o_aspect);

extern void
database_aspect_discharge(
  struct database_aspect *const         io_aspect);

extern void
database_aspect_password_delete(
  struct database_aspect *const         io_aspect);

extern void
database_aspect_password_fill(
  int*const                             o_cancel,
  struct database_aspect *const         io_aspect);

extern void
database_aspect_password_prompt(
  int*const                             o_cancel,
  char**                                o_password);

extern int
database_aspect_read(
  GError**                              o_error,
  struct database_aspect *const         io_aspect,
  struct xml *const                     i_xml);

extern int
database_aspect_write(
  GError**                              o_error,
  FILE*const                            io_fp,
  struct database_aspect const*const    i_aspect);

extern int
database_aspect_property(
  struct database_aspect *const         io_aspect);

#define __database_aspect_h__
#endif
