/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "geom_ellipse.h"

extern void
geom_ellipse_get_bbox(
  struct geom_rect *const               o_bbox,
  struct geom_ellipse const*const       i_ellipse)
{

  (*o_bbox).m_pos_x= (*i_ellipse).m_center_x - ((*i_ellipse).m_len_x / 2.0);
  (*o_bbox).m_pos_y= (*i_ellipse).m_center_y - ((*i_ellipse).m_len_y / 2.0);
  (*o_bbox).m_len_x= (*i_ellipse).m_len_x;
  (*o_bbox).m_len_y= (*i_ellipse).m_len_y;

  return;
}

extern int
geom_ellipse_contains_point(
  struct geom_ellipse const*const       i_ellipse,
  double                                i_event_x,
  double                                i_event_y)
{
  double                                l_height;
  double                                l_hit;
  double                                l_axis_x;
  double                                l_axis_y;
  double                                l_width;
  
  l_axis_x= i_event_x - (*i_ellipse).m_center_x;
  l_axis_x= l_axis_x * l_axis_x;
  
  l_axis_y= i_event_y - (*i_ellipse).m_center_y;
  l_axis_y= l_axis_y * l_axis_y;
  
  l_height= (*i_ellipse).m_len_x / 2.0;
  l_height= l_height * l_height;

  l_width= (*i_ellipse).m_len_y / 2.0;
  l_width= l_width * l_width;
  
  l_hit= (l_axis_x / l_height) + (l_axis_y / l_width);

  return (l_hit <= 1.0);
}
