/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include <unicode/dcfmtsym.h>
#include <unicode/decimfmt.h>
#include <unicode/fmtable.h>
#include <unicode/locid.h>
#include <unicode/numfmt.h>
#include <unicode/rbnf.h>
#include <unicode/uclean.h>
#include <unicode/unistr.h>
#include <unicode/ustring.h>
#include <unicode/utypes.h>
#include <string>
#include <stdio.h>
#include "icu.h"

extern "C" int
icu_double_to_textual(
  char**                                o_text,
  double const                          i_number,
  char const*                           i_locale)
{
  int                                   l_exit= 0;
  Locale*                               l_locale= 0;
  RuleBasedNumberFormat*                l_rule= 0;
  size_t                                l_size= 0;
  UErrorCode                            l_status= U_ZERO_ERROR;
  std::string                           l_str;
  UnicodeString                         l_unistr;
  char const*                           l_tmp_locale;

  (*o_text)= 0;

  do
  {

    if (i_locale)
    {
      l_tmp_locale= i_locale;
    }
    else
    {
      l_tmp_locale= setlocale(LC_MONETARY, 0);
    }

    l_locale= new Locale(l_tmp_locale);

    l_rule= new RuleBasedNumberFormat(URBNF_SPELLOUT, (*l_locale), l_status);

    if (U_FAILURE(l_status))
    {
      l_exit= -1;
      break;
    }



    l_unistr.remove();
/*
    (*l_rule).setMaximumFractionDigits(2);
    (*l_rule).format(i_number, l_unistr);
*/
    {
      char text[256];
      double integral,fraction;
      fraction= modf(i_number, &integral);
      snprintf(text, sizeof(text), "%d.%d00000", (int)integral, (int)(fraction*100.0));
      double n= strtod(text, 0);
      (*l_rule).format(n, l_unistr);
    }
    l_unistr.toUTF8String(l_str);

    l_size= l_str.length();
    (*o_text)= (char*)malloc(1+l_size);
    memset(*o_text, 0, 1+l_size);
    memcpy(*o_text, l_str.c_str(), l_size);

  }while(0);

  if (l_locale)
  {
    delete l_locale;
  }

  if (l_rule)
  {
    delete l_rule;
  }

  return l_exit;
}

