/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015-2016, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "item_circle.h"

extern void
item_circle_assign(
  struct item_circle*const              o_circle,
  struct item_method*const              o_method)
{

  memset(o_circle, 0, sizeof(*o_circle));

  (*o_circle).m_len_x= 30.0;
  (*o_circle).m_len_y= 30.0;
  (*o_circle).m_border.m_active= 1;
  (*o_circle).m_border.m_style= line_style_solid;
  (*o_circle).m_border.m_thickness= 1.0;
  (*o_circle).m_border.m_color.alpha= 1.0;
  (*o_circle).m_fill.m_color.alpha= 1.0;

  ITEM_METHOD_ASSIGN(o_method, circle);

  return;
}

extern void
item_circle_discharge(
  struct item_circle*const              io_circle)
{

  memset(io_circle, 0, sizeof(*io_circle));

  return;
}

extern void
item_circle_draw(
  struct item_circle*const              i_circle,
  struct item_draw_context const*const  i_ctx)
{

  do
  {

    if ((*i_circle).m_fill.m_active)
    {
      cairo_save((*i_ctx).m_cr);

      cairo_set_source_rgba(
        (*i_ctx).m_cr,
        (*i_circle).m_fill.m_color.red,
        (*i_circle).m_fill.m_color.green,
        (*i_circle).m_fill.m_color.blue,
        (*i_circle).m_fill.m_color.alpha);

      cairo_translate(
        (*i_ctx).m_cr,
        (*i_circle).m_center_x,
        (*i_circle).m_center_y);

      cairo_scale(
        (*i_ctx).m_cr,
        ((*i_circle).m_len_x/2),
        ((*i_circle).m_len_y/2));

      cairo_arc((*i_ctx).m_cr, 0.0, 0.0, 1.0, 0.0, 2*G_PI);
      cairo_fill((*i_ctx).m_cr);
      cairo_restore((*i_ctx).m_cr);
    }

    if ((*i_circle).m_border.m_active)
    {
      cairo_save((*i_ctx).m_cr);

      cairo_translate(
        (*i_ctx).m_cr,
        (*i_circle).m_center_x,
        (*i_circle).m_center_y);

      cairo_scale(
        (*i_ctx).m_cr,
        ((*i_circle).m_len_x/2),
        ((*i_circle).m_len_y/2));

      cairo_arc((*i_ctx).m_cr, 0.0, 0.0, 1.0, 0.0, 2*G_PI);
      cairo_restore((*i_ctx).m_cr);

      cairo_set_source_rgba(
        (*i_ctx).m_cr,
        (*i_circle).m_border.m_color.red,
        (*i_circle).m_border.m_color.green,
        (*i_circle).m_border.m_color.blue,
        (*i_circle).m_border.m_color.alpha);

      item_common_cairo_dash_set((*i_ctx).m_cr, (*i_circle).m_border.m_style);
      cairo_set_line_width((*i_ctx).m_cr, (*i_circle).m_border.m_thickness);
      cairo_stroke((*i_ctx).m_cr);
    }

    if (0 == (*i_ctx).m_selected)
    {
      if ((*i_ctx).m_option.m_highlight &&
        (item_draw_design == (*i_ctx).m_option.m_type))
      {
        cairo_save((*i_ctx).m_cr);
        cairo_translate(
          (*i_ctx).m_cr,
          (*i_circle).m_center_x,
          (*i_circle).m_center_y);
        cairo_scale(
          (*i_ctx).m_cr,
          ((*i_circle).m_len_x/2),
          ((*i_circle).m_len_y/2));
        cairo_arc((*i_ctx).m_cr, 0.0, 0.0, 1.0, 0.0, 2*G_PI);
        cairo_restore((*i_ctx).m_cr);
        cairo_set_source_rgb((*i_ctx).m_cr, 0.50, 0.50, 0.00);
        item_common_cairo_dash_set((*i_ctx).m_cr, line_style_solid);
        cairo_set_line_width((*i_ctx).m_cr, 1.0);
        cairo_stroke((*i_ctx).m_cr);
      }
      break;
    }

    item_common_circle_draw_grips((*i_ctx).m_cr, (struct geom_ellipse*)i_circle);

  }while(0);

  return;
}

extern void
item_circle_get_bbox(
  struct geom_rect*const                o_bbox,
  void const*const                      i_object)
{
  /* _mjo: TODO return bbox */
  return;
}

extern void
item_circle_in_event(
  enum event_type*const                 o_type,
  struct item_circle const*const        i_circle,
  struct item_in_event const*const      i_ctx)
{

  item_common_circle_in_event(o_type, i_ctx, (struct geom_ellipse*)i_circle);

  return;
}

extern void
item_circle_move(
  struct item_circle*const              io_circle,
  struct geom_point const*const         i_event)
{

  item_common_circle_move((struct geom_ellipse*)io_circle, i_event);

  return;
}

extern void
item_circle_normalize(
  struct item_circle*const              io_circle,
  double const                          i_bound_width,
  double const                          i_bound_height)
{

  if (0 > (*io_circle).m_len_x)
  {
    (*io_circle).m_len_x*= -1.0;
  }

  if (0 > (*io_circle).m_len_y)
  {
    (*io_circle).m_len_y*= -1.0;
  }

  return;
}

extern int
item_circle_read(
  GError**                              o_error,
  struct item_circle*const              io_circle,
  struct xml *const                     i_xml)
{
  GError*                               l_error;
  int                                   l_exit;
  int                                   l_found;
  GList*                                l_node;
  enum element_tag_type                 l_type;
  char const*                           l_value;
  struct xml*                           l_xml;

  l_error= 0;
  l_exit= 0;

  l_node= (*i_xml).m_children;

  do
  {

    if (0 == l_node)
    {
      break;
    }

    l_xml= (struct xml*)(*l_node).data;

    item_common_lookup(&l_found, &l_type, (*l_xml).m_tag);
    g_strstrip((*l_xml).m_string->str);
    l_value= (*l_xml).m_string->str;

    if (l_found)
    {
      switch(l_type)
      {
        case element_tag_center_x:
          (*io_circle).m_center_x= xml_convert_double(l_value);
          break;
        case element_tag_center_y:
          (*io_circle).m_center_y= xml_convert_double(l_value);
          break;
        case element_tag_len_x:
          (*io_circle).m_len_x= xml_convert_double(l_value);
          break;
        case element_tag_len_y:
          (*io_circle).m_len_y= xml_convert_double(l_value);
          break;
        case element_tag_border:
          l_exit= item_common_read_border_attr(&l_error, &(*io_circle).m_border, l_xml);
          break;
        case element_tag_fill:
          l_exit= item_common_read_fill(&l_error, &(*io_circle).m_fill, l_xml);
          break;
        case element_tag_ellipse:
          l_value= xml_lookup_attribute_value(l_xml, "on");
          (*io_circle).m_ellipse= xml_convert_boolean(l_value);
          break;
        default:
          break;
      }
    }

    l_node= (*l_node).next;

  }while(1);

  if (l_error)
  {
    g_propagate_error(o_error, l_error);
  }

  return l_exit;
}

extern void
item_circle_resize(
  struct item_circle*const              io_circle,
  struct item_resize_event const*const  i_ctx)
{

  item_common_circle_resize(
    (struct geom_ellipse*)io_circle, 
    i_ctx, 
    (*io_circle).m_ellipse);

  return;
}

extern int
item_circle_write(
  GError**                              o_error,
  FILE*const                            io_fp,
  struct item_circle const*const        i_circle)
{
  char                                  l_buf[G_ASCII_DTOSTR_BUF_SIZE+1];
  int                                   l_exit;

  l_exit= 0;

  fprintf(io_fp, "\t\t\t<item name=\"circle\">\n");
  fprintf(io_fp, "\t\t\t\t<center_x>%s</center_x>\n", g_ascii_dtostr(l_buf, sizeof(l_buf), (*i_circle).m_center_x));
  fprintf(io_fp, "\t\t\t\t<center_y>%s</center_y>\n", g_ascii_dtostr(l_buf, sizeof(l_buf), (*i_circle).m_center_y));
  fprintf(io_fp, "\t\t\t\t<len_x>%s</len_x>\n", g_ascii_dtostr(l_buf, sizeof(l_buf), (*i_circle).m_len_x));
  fprintf(io_fp, "\t\t\t\t<len_y>%s</len_y>\n", g_ascii_dtostr(l_buf, sizeof(l_buf), (*i_circle).m_len_y));
  item_common_write_border_attr(o_error, io_fp, &(*i_circle).m_border);
  item_common_write_fill(o_error, io_fp, &(*i_circle).m_fill);
  fprintf(io_fp, "\t\t\t\t<ellipse on=\"%s\"/>\n", ((*i_circle).m_ellipse ? "true" : "false"));
  fprintf(io_fp, "\t\t\t</item>\n");

  return l_exit;
}
