/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2015-2016, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "item_ftext.h"
#include "database_field.h"
#include "mainw.h"

struct ftext_dialog
{
  GtkEntry*                             m_color_entry;
  GtkButton*                            m_color_button;
  GtkEntry*                             m_font_entry;
  GtkButton*                            m_font_button; 
  GtkCheckButton*                       m_border_checkbutton;
  GtkComboBoxText*                      m_border_style_comboboxtext;
  GtkSpinButton*                        m_border_thickness_spinbutton;
  GtkEntry*                             m_border_color_entry;
  GtkButton*                            m_border_color_button;
  GtkCheckButton*                       m_fill_color_checkbutton;
  GtkEntry*                             m_fill_color_entry;
  GtkButton*                            m_fill_color_button; 
  GtkEntry*                             m_field_entry;
  GtkButton*                            m_field_button;
  GtkCheckButton*                       m_autowrap_checkbutton;
  GtkComboBoxText*                      m_wrapmode_comboboxtext;
};

static void
item_ftext_field_button_cb(
  GtkWidget *                           i_widget,
  gpointer                              i_data)
{
  struct ftext_dialog*                  l_ftext;
  char*                                 l_attribute;

  l_attribute= 0;

  l_ftext= (struct ftext_dialog*)i_data;

  database_field_property(
    &l_attribute, 
    &(*g_mainw).m_report.m_aspect,
    &(*g_mainw).m_report.m_query);

  if (l_attribute)
  {
    gtk_entry_set_text((*l_ftext).m_field_entry, l_attribute);
  }

  if (l_attribute)
  {
    g_free(l_attribute);
  }

  return;
}

static void
item_ftext_color_button_cb(
  GtkWidget *                           i_widget,
  gpointer                              i_data)
{
  GdkRGBA                               l_color;
  GtkWidget*                            l_dialog;
  int                                   l_exit;
  struct ftext_dialog*                  l_ftext;
  gchar*                                l_rgba;
  gchar const*                          l_text;

  l_dialog= 0;
  memset(&l_color, 0, sizeof(l_color));

  do
  {

    l_ftext= (struct ftext_dialog*)i_data;

    l_dialog= gtk_color_chooser_dialog_new("Border Color", get_main_window());

    l_text= gtk_entry_get_text((*l_ftext).m_color_entry);
    gdk_rgba_parse(&l_color, l_text);
    gtk_color_chooser_set_rgba(GTK_COLOR_CHOOSER(l_dialog), &l_color);

    gtk_window_set_modal((GtkWindow*)l_dialog, 1);
    l_exit= gtk_dialog_run(GTK_DIALOG(l_dialog));

    if (GTK_RESPONSE_OK != l_exit)
    {
      break;
    }

    gtk_color_chooser_get_rgba(GTK_COLOR_CHOOSER(l_dialog), &l_color);

    l_rgba= gdk_rgba_to_string(&l_color);
    gtk_entry_set_text((*l_ftext).m_color_entry, l_rgba);
    g_free(l_rgba);

  }while(0);

  if (l_dialog)
  {
    gtk_widget_destroy((GtkWidget*)l_dialog);
  }
  
  return;
}

static void
item_ftext_border_color_button_cb(
  GtkWidget *                           i_widget,
  gpointer                              i_data)
{
  GdkRGBA                               l_color;
  GtkWidget*                            l_dialog;
  int                                   l_exit;
  struct ftext_dialog*                  l_ftext;
  gchar*                                l_rgba;
  gchar const*                          l_text;

  l_dialog= 0;
  memset(&l_color, 0, sizeof(l_color));

  do
  {

    l_ftext= (struct ftext_dialog*)i_data;

    l_dialog= gtk_color_chooser_dialog_new("Border Color", get_main_window());

    l_text= gtk_entry_get_text((*l_ftext).m_color_entry);
    gdk_rgba_parse(&l_color, l_text);
    gtk_color_chooser_set_rgba(GTK_COLOR_CHOOSER(l_dialog), &l_color);

    gtk_window_set_modal((GtkWindow*)l_dialog, 1);
    l_exit= gtk_dialog_run(GTK_DIALOG(l_dialog));

    if (GTK_RESPONSE_OK != l_exit)
    {
      break;
    }

    gtk_color_chooser_get_rgba(GTK_COLOR_CHOOSER(l_dialog), &l_color);

    l_rgba= gdk_rgba_to_string(&l_color);
    gtk_entry_set_text((*l_ftext).m_border_color_entry, l_rgba);
    g_free(l_rgba);

  }while(0);

  if (l_dialog)
  {
    gtk_widget_destroy((GtkWidget*)l_dialog);
  }
  
  return;
}

static void
item_ftext_fill_color_button_cb(
  GtkWidget *                           i_widget,
  gpointer                              i_data)
{
  GdkRGBA                               l_color;
  GtkWidget*                            l_dialog;
  int                                   l_exit;
  struct ftext_dialog*                  l_ftext;
  gchar*                                l_rgba;
  gchar const*                          l_text;

  l_dialog= 0;
  memset(&l_color, 0, sizeof(l_color));

  do
  {

    l_ftext= (struct ftext_dialog*)i_data;

    l_dialog= gtk_color_chooser_dialog_new("Fill Color", get_main_window());
    gtk_color_chooser_set_use_alpha(GTK_COLOR_CHOOSER(l_dialog), 1);

    l_text= gtk_entry_get_text((*l_ftext).m_color_entry);
    gdk_rgba_parse(&l_color, l_text);
    gtk_color_chooser_set_rgba(GTK_COLOR_CHOOSER(l_dialog), &l_color);

    gtk_window_set_modal((GtkWindow*)l_dialog, 1);
    l_exit= gtk_dialog_run(GTK_DIALOG(l_dialog));

    if (GTK_RESPONSE_OK != l_exit)
    {
      break;
    }

    gtk_color_chooser_get_rgba(GTK_COLOR_CHOOSER(l_dialog), &l_color);

    l_rgba= gdk_rgba_to_string(&l_color);
    gtk_entry_set_text((*l_ftext).m_fill_color_entry, l_rgba);
    g_free(l_rgba);

  }while(0);

  if (l_dialog)
  {
    gtk_widget_destroy((GtkWidget*)l_dialog);
  }
  
  return;
}

static void
item_ftext_font_button_cb(
  GtkWidget *                           i_widget,
  gpointer                              i_data)
{
  GtkWidget*                            l_dialog;
  int                                   l_exit;
  struct ftext_dialog*                  l_ftext;
  gchar*                                l_font;
  gchar const*                          l_text;

  l_dialog= 0;
  l_exit= 0;
  l_font= 0;

  do
  {

    l_ftext= (struct ftext_dialog*)i_data;

    l_text= gtk_entry_get_text(GTK_ENTRY((*l_ftext).m_font_entry));

    l_dialog= gtk_font_chooser_dialog_new("Font", get_main_window());

    gtk_font_chooser_set_font(GTK_FONT_CHOOSER(l_dialog), l_text);

    gtk_window_set_modal((GtkWindow*)l_dialog, 1);
    l_exit= gtk_dialog_run(GTK_DIALOG(l_dialog));

    if (GTK_RESPONSE_OK != l_exit)
    {
      break;
    }

    l_font= gtk_font_chooser_get_font(GTK_FONT_CHOOSER(l_dialog));
    gtk_entry_set_text(
      (GTK_ENTRY((*l_ftext).m_font_entry)),
      l_font);

  }while(0);

  if (l_font)
  {
    g_free(l_font);
  }

  if (l_dialog)
  {
    gtk_widget_destroy((GtkWidget*)l_dialog);
  }

  return;
}

static void
item_ftext_bind(
  struct ftext_dialog*const             o_ftext,
  GtkBuilder*const                      i_builder)
{

  memset(o_ftext, 0, sizeof(*o_ftext));

  do
  {

    (*o_ftext).m_color_entry=
      GTK_ENTRY(gtk_builder_get_object(i_builder, "color_entry"));

    (*o_ftext).m_color_button=
      GTK_BUTTON(gtk_builder_get_object(i_builder, "color_button"));

    g_signal_connect(
      (*o_ftext).m_color_button,
      "clicked",
      G_CALLBACK(item_ftext_color_button_cb),
      o_ftext);

    (*o_ftext).m_font_entry=
      GTK_ENTRY(gtk_builder_get_object(i_builder, "font_entry"));

    (*o_ftext).m_font_button=
      GTK_BUTTON(gtk_builder_get_object(i_builder, "font_button"));

    g_signal_connect(
      (*o_ftext).m_font_button,
      "clicked",
      G_CALLBACK(item_ftext_font_button_cb),
      o_ftext);

    (*o_ftext).m_border_checkbutton=
      GTK_CHECK_BUTTON(gtk_builder_get_object(i_builder, "border_checkbutton"));

    (*o_ftext).m_border_style_comboboxtext=
      GTK_COMBO_BOX_TEXT(gtk_builder_get_object(i_builder, "border_style_comboboxtext"));

    (*o_ftext).m_border_thickness_spinbutton=
      GTK_SPIN_BUTTON(gtk_builder_get_object(i_builder, "border_thickness_spinbutton"));

    (*o_ftext).m_border_color_entry=
      GTK_ENTRY(gtk_builder_get_object(i_builder, "border_color_entry"));

    (*o_ftext).m_border_color_button=
      GTK_BUTTON(gtk_builder_get_object(i_builder, "border_color_button"));

    g_signal_connect(
      (*o_ftext).m_border_color_button,
      "clicked",
      G_CALLBACK(item_ftext_border_color_button_cb),
      o_ftext);

    (*o_ftext).m_fill_color_checkbutton=
      GTK_CHECK_BUTTON(gtk_builder_get_object(i_builder, "fill_color_checkbutton"));

    (*o_ftext).m_fill_color_button=
      GTK_BUTTON(gtk_builder_get_object(i_builder, "fill_color_button"));

    g_signal_connect(
      (*o_ftext).m_fill_color_button,
      "clicked",
      G_CALLBACK(item_ftext_fill_color_button_cb),
      o_ftext);

    (*o_ftext).m_fill_color_entry=
      GTK_ENTRY(gtk_builder_get_object(i_builder, "fill_color_entry"));

    (*o_ftext).m_field_entry=
      GTK_ENTRY(gtk_builder_get_object(i_builder, "field_entry"));

    (*o_ftext).m_field_button=
      GTK_BUTTON(gtk_builder_get_object(i_builder, "field_button"));

    g_signal_connect(
      (*o_ftext).m_field_button,
      "clicked",
      G_CALLBACK(item_ftext_field_button_cb),
      o_ftext);

    (*o_ftext).m_autowrap_checkbutton=
      GTK_CHECK_BUTTON(gtk_builder_get_object(i_builder, "autowrap_checkbutton"));

    (*o_ftext).m_wrapmode_comboboxtext=
      GTK_COMBO_BOX_TEXT(gtk_builder_get_object(i_builder, "wrapmode_comboboxtext"));

  }while(0);

  return;
}

static void
item_ftext_set_values(
  struct ftext_dialog*const             i_ftextd,
  struct item_ftext const*const         i_ftext)
{
  gchar*                                l_color;
  gchar*                                l_font;

  l_color= gdk_rgba_to_string(&(*i_ftext).m_color);
  gtk_entry_set_text((*i_ftextd).m_color_entry, l_color);
  g_free(l_color);
  l_color= 0;

  l_font= pango_font_description_to_string((*i_ftext).m_font);
  gtk_entry_set_text((*i_ftextd).m_font_entry, l_font);
  g_free(l_font);

  gtk_toggle_button_set_active(
    GTK_TOGGLE_BUTTON((*i_ftextd).m_border_checkbutton),
    (*i_ftext).m_border.m_active);

  gtk_combo_box_set_active(
      GTK_COMBO_BOX((*i_ftextd).m_border_style_comboboxtext), 
      (*i_ftext).m_border.m_style);

  gtk_spin_button_set_value(
    GTK_SPIN_BUTTON((*i_ftextd).m_border_thickness_spinbutton),
    (*i_ftext).m_border.m_thickness);

  l_color= gdk_rgba_to_string(&(*i_ftext).m_border.m_color);
  gtk_entry_set_text((*i_ftextd).m_border_color_entry, l_color);
  g_free(l_color);
  l_color= 0;

  gtk_toggle_button_set_active(
    GTK_TOGGLE_BUTTON((*i_ftextd).m_fill_color_checkbutton),
    (*i_ftext).m_fill.m_active);

  l_color= gdk_rgba_to_string(&(*i_ftext).m_fill.m_color);
  gtk_entry_set_text((*i_ftextd).m_fill_color_entry, l_color);
  g_free(l_color);
  l_color= 0;

  gtk_toggle_button_set_active(
    GTK_TOGGLE_BUTTON((*i_ftextd).m_autowrap_checkbutton),
    (*i_ftext).m_autowrap);

  gtk_combo_box_set_active(
      GTK_COMBO_BOX((*i_ftextd).m_wrapmode_comboboxtext), 
      (*i_ftext).m_wrapmode);

  gtk_entry_set_text((*i_ftextd).m_field_entry, (*i_ftext).m_tag);

  return;
}

static void
item_ftext_copy_values(
  struct item_ftext *const              io_ftext,
  struct ftext_dialog const*const       i_ftextd)
{
  gchar const*                          l_text;
  gint                                  l_rc;

  l_text= gtk_entry_get_text(GTK_ENTRY((*i_ftextd).m_color_entry));
  gdk_rgba_parse(&(*io_ftext).m_color, l_text);

  l_text= gtk_entry_get_text(GTK_ENTRY((*i_ftextd).m_font_entry));
  if ((*io_ftext).m_font)
  {
    pango_font_description_free((*io_ftext).m_font);
  }
  (*io_ftext).m_font= pango_font_description_from_string(l_text);

  (*io_ftext).m_border.m_active=
    gtk_toggle_button_get_active(
      GTK_TOGGLE_BUTTON((*i_ftextd).m_border_checkbutton));

  l_rc = gtk_combo_box_get_active(
    GTK_COMBO_BOX((*i_ftextd).m_border_style_comboboxtext));

  if ((0 <= l_rc) && (LINE_STYLE_SLOTS > l_rc))
  {
    (*io_ftext).m_border.m_style= (enum line_style_type)l_rc;
  }
  else
  {
    (*io_ftext).m_border.m_style= line_style_solid;
  }

  (*io_ftext).m_border.m_thickness= gtk_spin_button_get_value(
    GTK_SPIN_BUTTON((*i_ftextd).m_border_thickness_spinbutton));

  l_text= gtk_entry_get_text(GTK_ENTRY((*i_ftextd).m_border_color_entry));
  gdk_rgba_parse(&(*io_ftext).m_border.m_color, l_text);

  (*io_ftext).m_fill.m_active=
    gtk_toggle_button_get_active(
      GTK_TOGGLE_BUTTON((*i_ftextd).m_fill_color_checkbutton));

  l_text= gtk_entry_get_text(GTK_ENTRY((*i_ftextd).m_fill_color_entry));
  gdk_rgba_parse(&(*io_ftext).m_fill.m_color, l_text);

  (*io_ftext).m_autowrap=
    gtk_toggle_button_get_active(
      GTK_TOGGLE_BUTTON((*i_ftextd).m_autowrap_checkbutton));

  (*io_ftext).m_wrapmode= (PangoWrapMode)gtk_combo_box_get_active(
    GTK_COMBO_BOX((*i_ftextd).m_wrapmode_comboboxtext));

  l_text= gtk_entry_get_text(GTK_ENTRY((*i_ftextd).m_field_entry));
  memset((*io_ftext).m_tag, 0, sizeof((*io_ftext).m_tag));
  strncpy((*io_ftext).m_tag, l_text, sizeof((*io_ftext).m_tag)-1);
  g_strstrip((*io_ftext).m_tag);

  return;
}

extern int
item_ftext_property(
  struct item_ftext*const               io_ftext)
{
  GtkBox*                               l_box;
  GtkBuilder*                           l_builder;
  GtkDialog*                            l_dialog;
  GtkGrid*                              l_grid;
  GError*                               l_error;
  int                                   l_exit;
  struct ftext_dialog                   l_ftext;
  int                                   l_rc;

  l_builder= 0;
  l_grid= 0;
  l_dialog= 0;
  l_error= 0;
  l_exit= 0;

  do
  {

    l_builder= gtk_builder_new();

    l_rc= wrap_gtk_builder_add_from_file(l_builder, "ftext.glade", &l_error);

    if (0 == l_rc)
    {
      l_exit= -1;
      break;
    }
  
    l_grid= GTK_GRID(gtk_builder_get_object(l_builder, "ftext_grid"));

    if (0 == l_grid)
    {
      l_error= g_error_new(
        GENERAL,
        GENERIC,
        "Unable to find dialog object: 'ftext_grid'");
      l_exit= -1;
      break;
    }

    item_ftext_bind(&l_ftext, l_builder);

    item_ftext_set_values(&l_ftext, io_ftext);

    l_dialog= GTK_DIALOG(gtk_dialog_new_with_buttons(
      "Field Edit",
      get_main_window(),
      GTK_DIALOG_MODAL,
      "Ok",
      GTK_RESPONSE_OK,
      "Cancel",
      GTK_RESPONSE_CANCEL,
      NULL));

    l_box= GTK_BOX(gtk_dialog_get_content_area(GTK_DIALOG(l_dialog)));

    gtk_box_pack_start(GTK_BOX(l_box), GTK_WIDGET(l_grid), 1, 1,0);

    gtk_widget_show(GTK_WIDGET(l_grid));

    gtk_widget_show_all(GTK_WIDGET(l_dialog));
    gtk_window_set_modal(GTK_WINDOW(l_dialog), 1);
    l_exit= gtk_dialog_run(l_dialog);

    if (GTK_RESPONSE_OK != l_exit)
    {
      break;
    }

    item_ftext_copy_values(io_ftext, &l_ftext);

  }while(0);

  if (l_builder)
  {
    g_object_unref(l_builder);
  }

  if (l_error)
  {
    _error_log(l_error);
    _error_display_prompt(l_error);
  }

  g_clear_error(&l_error);

  if (l_grid)
  {
    gtk_widget_destroy((GtkWidget*)l_dialog);
  }

  return l_exit;
}

