/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2015-2016, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "label_paper.h"

struct page_setup_dialog
{
  GtkSpinButton*                 m_page_width_spinbutton;
  GtkSpinButton*                 m_page_height_spinbutton;
  GtkSpinButton*                 m_top_margin_spinbutton;
  GtkSpinButton*                 m_left_margin_spinbutton;
  GtkSpinButton*                 m_horizontal_pitch_spinbutton;
  GtkSpinButton*                 m_vertical_pitch_spinbutton;
  GtkSpinButton*                 m_label_width_spinbutton;
  GtkSpinButton*                 m_label_height_spinbutton;
  GtkSpinButton*                 m_columns_spinbutton;
  GtkSpinButton*                 m_rows_spinbutton;
};

extern int
label_page_setup_bind(
  struct page_setup_dialog*const        io_pd,
  GtkBuilder*const                      i_builder)
{
  int                                   l_exit;

  l_exit= 0;

  do
  {

    (*io_pd).m_page_width_spinbutton= GTK_SPIN_BUTTON(
      gtk_builder_get_object(i_builder, "page_width_spinbutton"));

    (*io_pd).m_page_height_spinbutton= GTK_SPIN_BUTTON(
      gtk_builder_get_object(i_builder, "page_height_spinbutton"));

    (*io_pd).m_top_margin_spinbutton= GTK_SPIN_BUTTON(
      gtk_builder_get_object(i_builder, "top_margin_spinbutton"));

    (*io_pd).m_left_margin_spinbutton= GTK_SPIN_BUTTON(
      gtk_builder_get_object(i_builder, "left_margin_spinbutton"));

    (*io_pd).m_horizontal_pitch_spinbutton= GTK_SPIN_BUTTON(
      gtk_builder_get_object(i_builder, "horizontal_pitch_spinbutton"));

    (*io_pd).m_vertical_pitch_spinbutton= GTK_SPIN_BUTTON(
      gtk_builder_get_object(i_builder, "vertical_pitch_spinbutton"));

    (*io_pd).m_label_width_spinbutton= GTK_SPIN_BUTTON(
      gtk_builder_get_object(i_builder, "label_width_spinbutton"));

    (*io_pd).m_label_height_spinbutton= GTK_SPIN_BUTTON(
      gtk_builder_get_object(i_builder, "label_height_spinbutton"));

    (*io_pd).m_columns_spinbutton= GTK_SPIN_BUTTON(
      gtk_builder_get_object(i_builder, "columns_spinbutton"));

    (*io_pd).m_rows_spinbutton= GTK_SPIN_BUTTON(
      gtk_builder_get_object(i_builder, "rows_spinbutton"));

  }while(0);

  return l_exit;
}

static void
label_page_setup_set_values(
  struct page_setup_dialog*const        io_pd,
  struct label_paper const*const        i_paper)
{

  gtk_spin_button_set_value(
    GTK_SPIN_BUTTON((*io_pd).m_page_width_spinbutton),
    (*i_paper).m_page_width/POINTS_PER_INCH);

  gtk_spin_button_set_value(
    GTK_SPIN_BUTTON((*io_pd).m_page_height_spinbutton),
    (*i_paper).m_page_height/POINTS_PER_INCH);

  gtk_spin_button_set_value(
    GTK_SPIN_BUTTON((*io_pd).m_top_margin_spinbutton),
    (*i_paper).m_top_margin/POINTS_PER_INCH);

  gtk_spin_button_set_value(
    GTK_SPIN_BUTTON((*io_pd).m_left_margin_spinbutton),
    (*i_paper).m_left_margin/POINTS_PER_INCH);

  gtk_spin_button_set_value(
    GTK_SPIN_BUTTON((*io_pd).m_horizontal_pitch_spinbutton),
    (*i_paper).m_horizontal_pitch/POINTS_PER_INCH);

  gtk_spin_button_set_value(
    GTK_SPIN_BUTTON((*io_pd).m_vertical_pitch_spinbutton),
    (*i_paper).m_vertical_pitch/POINTS_PER_INCH);

  gtk_spin_button_set_value(
    GTK_SPIN_BUTTON((*io_pd).m_label_width_spinbutton),
    (*i_paper).m_label_width/POINTS_PER_INCH);

  gtk_spin_button_set_value(
    GTK_SPIN_BUTTON((*io_pd).m_label_height_spinbutton),
    (*i_paper).m_label_height/POINTS_PER_INCH);

  gtk_spin_button_set_value(
    GTK_SPIN_BUTTON((*io_pd).m_columns_spinbutton),
    (*i_paper).m_columns);

  gtk_spin_button_set_value(
    GTK_SPIN_BUTTON((*io_pd).m_rows_spinbutton),
    (*i_paper).m_rows);

  return;
}

static void
label_setup_copy_values(
  struct label_paper *const             io_paper,
  struct page_setup_dialog const*const  i_pd)
{

  (*io_paper).m_page_width= POINTS_PER_INCH * gtk_spin_button_get_value(
    GTK_SPIN_BUTTON((*i_pd).m_page_width_spinbutton));

  (*io_paper).m_page_height= POINTS_PER_INCH * gtk_spin_button_get_value(
    GTK_SPIN_BUTTON((*i_pd).m_page_height_spinbutton));

  (*io_paper).m_top_margin= POINTS_PER_INCH * gtk_spin_button_get_value(
    GTK_SPIN_BUTTON((*i_pd).m_top_margin_spinbutton));

  (*io_paper).m_left_margin= POINTS_PER_INCH * gtk_spin_button_get_value(
    GTK_SPIN_BUTTON((*i_pd).m_left_margin_spinbutton));

  (*io_paper).m_horizontal_pitch= POINTS_PER_INCH * gtk_spin_button_get_value(
    GTK_SPIN_BUTTON((*i_pd).m_horizontal_pitch_spinbutton));

  (*io_paper).m_vertical_pitch= POINTS_PER_INCH * gtk_spin_button_get_value(
    GTK_SPIN_BUTTON((*i_pd).m_vertical_pitch_spinbutton));

  (*io_paper).m_label_width= POINTS_PER_INCH * gtk_spin_button_get_value(
    GTK_SPIN_BUTTON((*i_pd).m_label_width_spinbutton));

  (*io_paper).m_label_height= POINTS_PER_INCH * gtk_spin_button_get_value(
    GTK_SPIN_BUTTON((*i_pd).m_label_height_spinbutton));

  (*io_paper).m_columns= gtk_spin_button_get_value(
    GTK_SPIN_BUTTON((*i_pd).m_columns_spinbutton));

  (*io_paper).m_rows= gtk_spin_button_get_value(
    GTK_SPIN_BUTTON((*i_pd).m_rows_spinbutton));

  return;
}

extern int
label_page_setup_property(
  struct label_paper*const              io_paper)
{
  struct page_setup_dialog              l_pd;
  GtkBuilder*                           l_builder;
  GtkDialog*                            l_dialog;
  GError*                               l_error;
  int                                   l_exit;
  int                                   l_rc;

  l_builder= 0;
  l_dialog= 0;
  l_error= 0;
  l_exit= 0;
  memset(&l_pd, 0, sizeof(l_pd));

  do
  {

    l_builder= gtk_builder_new();

    l_rc= wrap_gtk_builder_add_from_file(
      l_builder,
      "label_page_setup.glade",
      &l_error);

    if (0 == l_rc)
    {
      l_exit= -1;
      break;
    }

    l_dialog= (GtkDialog*)gtk_builder_get_object(l_builder, "label_page_setup_dialog");

    if (0 == l_dialog)
    {
      l_error= g_error_new(
        GENERAL,
        GENERIC,
        "Unable to find dialog object: 'label_page_setup_dialog'");
      l_exit= -1;
      break;
    }

    label_page_setup_bind(&l_pd, l_builder);
    label_page_setup_set_values(&l_pd, io_paper);

    gtk_window_set_transient_for(GTK_WINDOW(l_dialog), get_main_window());
    gtk_widget_show_all(GTK_WIDGET(l_dialog));
    gtk_window_set_modal(GTK_WINDOW(l_dialog), 1);

    gtk_widget_grab_focus(gtk_dialog_get_widget_for_response(
      GTK_DIALOG(l_dialog), GTK_RESPONSE_OK));

    l_exit= gtk_dialog_run(l_dialog);

    if (GTK_RESPONSE_OK != l_exit) 
    {
      break;
    }

    label_setup_copy_values(io_paper, &l_pd);

  }while(0);

  if (l_builder)
  {
    g_object_unref(l_builder);
  }

  if (l_error)
  {
    _error_log(l_error);
    _error_display_prompt(l_error);
  }

  g_clear_error(&l_error);

  if (l_dialog)
  {
    gtk_widget_destroy(GTK_WIDGET(l_dialog));
  }

  return l_exit;
}
